#declare Tiles =
object {
  difference {
    plane { -y 0 }
    #ifdef ( HighQuality )
    box { < -1, -1, -1 >, < 13, 1, -0.97 > }
    box { < -1, -1, 0 >, < 13, 1, .03 > }
    box { < -1, -1, 1 >, < 13, 1, 1.03 > }
    box { < -1, -1, 2 >, < 13, 1, 2.03 > }
    box { < -1, -1, 3 >, < 13, 1, 3.03 > }
    box { < -1, -1, 4 >, < 13, 1, 4.03 > }
    box { < -1, -1, 5 >, < 13, 1, 5.03 > }
    box { < -1, -1, 6 >, < 13, 1, 6.03 > }
    box { < -1, -1, 7 >, < 13, 1, 7.03 > }
    box { < -1, -1, 8 >, < 13, 1, 8.03 > }
    box { < -1, -1, 9 >, < 13, 1, 9.03 > }
    box { < -1, -1, 10 >, < 13, 1, 10.03 > }
    box { < -1, -1, 11 >, < 13, 1, 11.03 > }
    box { < -1, -1, 12 >, < 13, 1, 12.03 > }
    box { < -1, -1, 13 >, < 13, 1, 13.03 > }
    box { < -1, -1, 14 >, < 13, 1, 14.03 > }
    box { < -1, -1, 15 >, < 13, 1, 15.03 > }
    box { < 0, -1, 0 >, < .03, 1, 20 > }
    box { < 1, -1, 0 >, < 1.03, 1, 20 > }
    box { < 2, -1, 0 >, < 2.03, 1, 20 > }
    box { < 3, -1, -1 >, < 3.03, 1, 20 > }
    box { < 4, -1, -2 >, < 4.03, 1, 20 > }
    box { < 5, -1, -1 >, < 5.03, 1, 20 > }
    box { < 6, -1, -1 >, < 6.03, 1, 20 > }
    box { < 7, -1, -1 >, < 7.03, 1, 20 > }
    box { < 8, -1, 0 >, < 8.03, 1, 20 > }
    box { < 9, -1, 0 >, < 9.03, 1, 20 > }
    #end
    //holes for lights here
    box { < 7.029, -0.1, -4.971 >, < 8.001, 1, -3.999 > }
    box { < 7.029, -0.1, -1.971 >, < 8.001, 1, -0.999 > }
    box { < 7.029, -0.1, 1.029 >, < 8.001, 1, 2.001 > }
    box { < 4.029, -0.1, -4.971 >, < 5.001, 1, -3.999 > }
    box { < 4.029, -0.1, -1.971 >, < 5.001, 1, -0.999 > }
    box { < 4.029, -0.1, 1.029 >, < 5.001, 1, 2.001 > }
    //holes for fake lights here
    box { < 4.029, -0.1, 6.029 >, < 5.001, 1, 7.001 > }
    box { < 4.029, -0.1, 9.029 >, < 5.001, 1, 10.001 > }
  }
  texture {
    #ifdef ( HighQuality )
    pigment {
      bozo
      color_map {
        [ 0.03 color rgb < 0.8 0.77 0.75 > ]
        [ 0.05 color rgb 1 ]
        [ 0.99 color rgb 1 ]
        [ 0.99 color rgb 0.1 ]
      }  
      scale .01
    }
    #else
    pigment { color rgb 1 }
    #end
  }
}

#declare CielingBars =
object {
  difference {
    plane { -y, -0.015 }
    //holes for lights here
    box { < 7.029, -0.1, -4.971 >, < 8.001, 1, -3.999 > }
    box { < 7.029, -0.1, -1.971 >, < 8.001, 1, -0.999 > }
    box { < 7.029, -0.1, 1.029 >, < 8.001, 1, 2.001 > }
    box { < 4.029, -0.1, -4.971 >, < 5.001, 1, -3.999 > }
    box { < 4.029, -0.1, -1.971 >, < 5.001, 1, -0.999 > }
    box { < 4.029, -0.1, 1.029 >, < 5.001, 1, 2.001 > }
    //holes for fake lights here
    box { < 4.029, -0.1, 6.029 >, < 5.001, 1, 7.001 > }
    box { < 4.029, -0.1, 9.029 >, < 5.001, 1, 10.001 > }
  }  
  texture {
    pigment { color rgb 0.8 }
    finish {
      ambient 0
      diffuse 1
      specular .7
      roughness .01
    }
  }  
}  

#declare LightGrateHole =
intersection {
  cylinder { < 0, 0, -3 >, < 0, 0, 3 >, 2.7 scale < 1, 8, 1 > }
  cylinder { < -3, 0, 0 >, < 3, 0, 0 >, 2.7 scale < 1, 8, 1 > }
}

#declare LightGrate =
object {
  difference {
    //box { < 1.44, 0, 1.44 >, < 23.28, 3, 23.28 > }
    //box { < 0.72, 0, 0.72 >, < 24, 3, 24 > }
    box { < 1.08, 0, 1.08 >, < 23.64, 3, 23.64 > }
    intersection { LightGrateHole translate < 4.17, 0, 4.17 > }
    intersection { LightGrateHole translate < 9.63, 0, 4.17 > }
    intersection { LightGrateHole translate < 15.09, 0, 4.17 > }
    intersection { LightGrateHole translate < 20.55, 0, 4.17 > }
    intersection { LightGrateHole translate < 4.17, 0, 9.63 > }
    intersection { LightGrateHole translate < 9.63, 0, 9.63 > }
    intersection { LightGrateHole translate < 15.09, 0, 9.63 > }
    intersection { LightGrateHole translate < 20.55, 0, 9.63 > }
    intersection { LightGrateHole translate < 4.17, 0, 15.09 > }
    intersection { LightGrateHole translate < 9.63, 0, 15.09 > }
    intersection { LightGrateHole translate < 15.09, 0, 15.09 > }
    intersection { LightGrateHole translate < 20.55, 0, 15.09 > }
    intersection { LightGrateHole translate < 4.17, 0, 20.55 > }
    intersection { LightGrateHole translate < 9.63, 0, 20.55 > }
    intersection { LightGrateHole translate < 15.09, 0, 20.55 > }
    intersection { LightGrateHole translate < 20.55, 0, 20.55 > }
  }
  texture {
    pigment { color rgb 0.8 }
    finish {
      ambient 0
      diffuse 0
      reflection 0.9
    }
  } 
  bounded_by { box { < 0.71, -0.01, 0.71 >, < 24.01, 3.01, 24.01 > } }
}

#declare LightHousing =
object {
  difference {
    box { < 1.09, 1, 1.09 >, < 23.63, 6, 23.63 > }
    superellipsoid { < 0.01, 0.1 > rotate 90*x scale < 12, 5, 12 > translate < 13, 0, 12 > }
  }
  texture {
    pigment { rgb 0.8 }
    finish { ambient 1 diffuse 0 }
  }
}

#declare FakeLights =
object {
  union {
    cylinder { < 4.17, 4, 0.72 >, < 4.17, 4, 24 >, 1 }
    cylinder { < 9.63, 4, 0.72 >, < 9.63, 4, 24 >, 1 }
    cylinder { < 15.09, 4, 0.72 >, < 15.09, 4, 24 >, 1 }
    cylinder { < 20.55, 4, 0.72 >, < 20.55, 4, 24 >, 1 }
  }
  texture {
    pigment { color rgb 1 }
    finish { ambient 1 diffuse 0 }
  }
  no_shadow
}   

#declare LightFixture =
object {
  union {
    object { LightGrate }
    object { FakeLights }
    object { LightHousing }
  }
  bounded_by { box { < 0, 0, 0 >, < 24.01, 10, 24.01 > } }
}