#declare Floor =
object {
  plane { y, 0 }
  texture {
    pigment {
      image_map { gif "carpet.gif" } scale 2 rotate 90*x
    }
  #ifdef ( HighQuality )  
    normal {
      granite
      bump_size 0.1
      scale 0.1
    }    
  }
  texture {
    pigment {
      bozo
      color_map {
        [ 0.6 color rgbf 1 ]		//maybe not such a big fade area
        [ 0.9 color rgbf < 0.5, 0.5, 0.5, 0.70 > ] //play w/it a little
      }
    }
    scale 8 //use maybe 4 or 5 on the actual floor
  }
  texture {
    pigment {
      bozo
      color_map {
        [ 0.4 color rgbf 1 ]		//maybe not such a big fade area
        [ 0.99 color rgbf < 0.4, 0.4, 0.4, 0.80 > ] //play w/it a little
      }
    }
    scale < 40, 1, 7 >
  #end  
  }
}

#declare NorvilleName =
object {
  difference {
    #ifdef ( HighQuality )
    merge {
      superellipsoid { < 0.5, 0.01 > translate < 1, 1, 0 > }
      superellipsoid { < 0.5, 0.01 > translate < 9, 1, 0 > }
      box { < 1, 0, -1 >, < 9, 2, 1 > }
    }
    #else
    box { < 1, 0, -1 >, < 10, 2, 1 > }
    #end
    plane { -z, 0 pigment { color rgb < 0.7, 0.68, 0.65 > } }
    plane { z, -0.21 }
    #ifdef ( HighQuality )
    text { ttf "c:\windows\fonts\arial.ttf" "Norville Barnes" 1, 0
      translate < 1.75, 0.6667, -0.01 >
      pigment { rgb 1 }
    }  
    #end
  }
  texture {
    pigment { color rgbf < 0.8, 0.8, 0.8, 0.999 > }
    finish {
      ambient 0
      diffuse 1
      specular 0.5
      roughness 0.03
    }
  }
  interior{ior 1.5}
  bounded_by { box { < -0.01, -0.01, -0.21 >, < 10.01, 2.01, 0.01 > } }
}

#declare MattName =
object {
  difference {
    #ifdef ( HighQuality )
    merge {
      superellipsoid { < 0.5, 0.01 > translate < 1, 1, 0 > }
      superellipsoid { < 0.5, 0.01 > translate < 9, 1, 0 > }
      box { < 1, 0, -1 >, < 9, 2, 1 > }
    }
    #else
    box { < 1, 0, -1 >, < 10, 2, 1 > }
    #end
    plane { -z, 0 pigment { color rgb < 0.7, 0.68, 0.65 > } }
    plane { z, -0.21 }
    #ifdef ( HighQuality )
    text { ttf "c:\windows\fonts\arial.ttf" "Matthew Welch" 1, 0
      translate < 1.65, 0.6667, -0.01 >
      pigment { rgb 1 }
    }
    #end  
  }
  texture {
    pigment { color rgbf < 0.8, 0.8, 0.8, 0.999 > }
    finish {
      ambient 0
      diffuse 1
      specular 0.5
      roughness 0.03
    }
  }
  interior{ior 1.5}
  bounded_by { box { < -0.01, -0.01, -0.21 >, < 10.01, 2.01, 0.01 > } }
}

#declare DeskSurface =
object {
  difference {
    union {
      box { < 0.5, 28, -20 >, < 48, 29.25, -2 > }
      cylinder { < 0.5, 28.625, -20 >, < 48, 28.625, -20 >, 0.625 }
    }
    box { < 0.6, 29.24, -19.375 >, < 48, 29.26, -19.374 > }    
  }
  texture {
    pigment { color rgb < 0.79, 0.74, 0.71 > }
    finish {
      ambient 0
      diffuse 1
      specular 0.7
      roughness 0.01
    }
  }
}

#declare DrawerHandle =
union {
  cylinder { < 0, 0, -1 >, < 0, 0, 5 >, 0.75 }
  cylinder { < 9.5, 0, -1 >, < 9.5, 0, 5 >, 0.75 }
  box { < 0, -0.75, -1 >, < 9.5, 0.75, 5 > }
  scale < 1, 0.5, 1 >
  rotate -60*x
}

#declare Drawers =
object {
  difference {
    superellipsoid { < 0.2, 0.2 > scale < 7.5, 20, 10 > translate < 9, 13, -10 > }
    plane { -y, -26 }
    box { < 0, -0.1, -18.5 >, < 15.1, 25, -18.3 > }
    box { < 0, 24.8, -20.1 >, < 15.1, 25, -18.4 > }
    box { < 0, 18.8, -20.1 >, < 15.1, 19, -18.4 > }
    box { < 0, 12.8, -20.1 >, < 15.1, 13, -18.4 > }    
    union { DrawerHandle translate < 4.25, 23, -20 > }
    union { DrawerHandle translate < 4.25, 17, -20 > }
    union { DrawerHandle translate < 4.25, 11, -20 > }
  }
  texture {
    pigment { color rgb 0.2 }
    finish {
      ambient 0
      diffuse 1
      specular 0.8
      roughness .01
    }  
  }
}
