#declare BlackMetal =
texture {
  pigment { color rgb 0.2 }
  finish {
    ambient 0
    diffuse 1
    specular 1
    roughness .03
  }  
}

#declare BaseboardMetal =
texture {
  pigment { color rgb 0.2 }
  finish {
    ambient 0
    diffuse 1
    specular 1
    roughness .03
  }  
}

#declare Panel1Finish =
finish {
  ambient 0
  diffuse 1
}

#declare Panel1Normal =
normal { granite bump_size .03 scale .3 }
                         
#declare Pane12Texture =
texture {
  pigment { color rgb < 0.79, 0.74, 0.71 > }
  finish {
    ambient 0
    diffuse 1
    specular .7
    roughness .01
  }
}  
                         
#declare CornerTexture =
texture {
  pigment { color rgb < 0.79, 0.74, 0.71 > }
  finish {
    ambient 0
    diffuse 1
    specular .7
    roughness .005
  }
  #ifdef ( HighQuality )
  normal { granite bump_size .02 scale .15 }
  #end
}  
                         
#declare Wall4Base =
object {
  box { < 0, 0, -1 > < 48, 70, 1 > }
  texture { BlackMetal }
}

#declare Wall4Panel1 =
object {
  #ifdef ( HighQuality )
  superellipsoid { < 0.03, 0.1 > scale < 23.5, 8, .5 > }
  #else
  box { -1 1 scale < 23.5, 8, .5 > }
  #end
  texture {
//    pigment { color rgb < 0.55, 0.52, 0.5 > }
//    pigment { color rgb < 0.81, 0.73, 0.68 > }
    pigment { color rgb < 0.79, 0.74, 0.71 > }
    finish { Panel1Finish }
    #ifdef ( HighQuality )
    normal { Panel1Normal }
    #end
  }
}

#declare Wall4Panel2 =
object {
  #ifdef ( HighQuality )
  superellipsoid { < 0.03, 0.1 > scale < 23.5, 8, .5 > }
  #else
  box { -1 1 scale < 23.5, 8, .5 > }
  #end
  texture { Pane12Texture }
}

#declare Wall4Baseboard =
object {
  box { -1 1 scale < 23.5, 3, .5 > }
  texture { BaseboardMetal }
}

#declare Wall4 =
object {
  union {
    object { Wall4Base }
    object { Wall4Panel1 translate < 24, 62, -1 > }
    object { Wall4Panel1 translate < 24, 46, -1 > }
    object { Wall4Panel1 translate < 24, 30, -1 > pigment { color rgb < 0.2, 0.23, 0.2 > } }
    object { Wall4Panel2 translate < 24, 14, -1 > }
    object { Wall4Baseboard translate < 24, 3, -1 > }
  }
  bounded_by { box { < -0.1, -0.1, -1.6 >, < 48.1, 70.1, 1.6 > } }  
}

#declare CornerPlastic =
object {
  difference {
    cylinder { < 0, 3, 0 >, < 0, 70, 0 >, 3 }
    plane { z 0 }
    plane { x 0 }
  }
  texture { CornerTexture }  
}

#declare CornerBase =
object {
  difference {
    cylinder { 0, 4*y, 2.5 }
    plane { z 0 }
    plane { x 0 }
  }  
  texture { BlackMetal }
}

#declare CornerPiece =
object {
  union {
    object { CornerBase }
    object { CornerPlastic }
  }  
}

#declare EndPiece =
object {
  union {
    box { < -1, 0, 0 >, < 1, 70, 0.75 > }
    #ifdef ( HighQuality )
    difference {
      superellipsoid { < 0.03, 0.1 > scale < 1.5, 35, .5 > }
      plane { z 0 }
      translate < 0, 35, 0.5 >
    }
    #else  
    box { < -1.5, 0, 0.5 >, < 1.5, 70, 1 > }
    #end
  }
  texture { BlackMetal }
}
