#declare hskull =
blob{
threshold 0.5
sphere{0,1,2 scale <1.2,1.5,1.5> } // back skull

sphere{0,1,2 scale <1.2,1.5,1>
       translate <0,-0.5,0.5> }  // front skull

cylinder {<0,-0.3,1>,<0,-1,1>,0.7,3 } //jaw
// sphere  {<0,-0.6,1>,0.7,4 }

cylinder {<0.8,-0.8,1>,<0.8,-1,-1>,0.7,-2} // cutout for jaw
cylinder {<-0.8,-0.8,1>,<-0.8,-1,-1>,0.7,-2 }
cylinder {<0.7,-0.6,1>,<0.7,-0.8,-1>,0.3,-2 }//cutout for jaw
cylinder {<-0.7,-0.6,1>,<-0.7,-0.8,-1>,0.3,-2 }
cylinder {<-2,-0.75,0.2>,<2,-0.75,0.2>,0.5,-1.5 } 
cylinder {<0,-4.7,-1>,<-0,-4.7,1>,4.2,-80 }
cylinder {<0,-1.15,1>,<0,-1.5,-1>,0.5,-6 }
cylinder {<-2,-0.3,1.4>,<2,-0.3,1.4>,0.45,-1.5 }

cylinder {<-1,1,0.2>,<-1,-1,0.2>,0.6,-1.5 } // cutout side
cylinder {<1,1,0.2>,<1,-1,0.2>,0.6,-1.5 }

sphere {0,0.3,-2 scale <1.2,1,1>               // eye socket
        translate <0.5,0.3,1> pigment{LightGldnrod3 }}
cylinder {0,<-0.5,0,-1>,0.27,-1.8
          translate <0.5,0.3,1>}
sphere {0,0.3,-2 scale <1.2,1,1>
        translate <-0.5,0.3,1> pigment{LightGldnrod3 }}
cylinder {0,<0.5,0,-1>,0.27,-1.8
          translate <-0.5,0.3,1>}

sphere {0,0.2,-5 scale <0.8,2,3>    // nose socket
        translate <0,0,1.4> pigment{LightGldnrod3 }}
sphere {0,0.2,80 scale <0.2,2,1>    // nose bone
        translate <0,0,1.1>}
}

// ****************************************************************

#declare tooth = 
 cone{ 0,0.03,-0.2*y,0.05 scale <0.5,1,1>}

#declare corntooth =
 union{ 
  cone{ 0,0.03,-0.19*y,0.05} 
  cone{ -0.19*y,0.05,-0.22*y,0.03}
  scale <0.7,1,1.2>	
 }

#declare munchie =
union{
 cone{0,0.03,-0.2*y,0.05
      translate <0,0,0.03> }
 cone{0,0.03,-0.2*y,0.05
      translate <0,0,-0.03> }
}

// ****************************************************************

##declare MYSKULL = object{
 union{
  object{hskull}
  #declare i = 0;
  #while (i < 4)
    object{ tooth 
    #if ((i=1)|(i=2))
     scale <1.2,1.2,1>
     translate <0,0.02,0>
    #end
    translate <0.42,-0.7,0> 
    rotate <0,12*i - 108,0>
    translate <0,0,1>
    pigment{NavajoWhite} 
    finish{specular 0.4
           roughness 0.01
           reflection 0.2
           ambient 0.2
           diffuse 0.6} 
   }
   #declare i = i + 1;
  #end

  object{corntooth
    translate <0.42,-0.7,0>
    rotate <0,-120,0>
    translate <0,0,1>
    pigment{NavajoWhite} 
    finish{specular 0.4
           roughness 0.01
           reflection 0.2
           ambient 0.2
           diffuse 0.6} 
   }

  object{corntooth
    translate <0.42,-0.7,0>
    rotate <0,-60,0>
    translate <0,0,0.95>
    pigment{NavajoWhite} 
    finish{specular 0.4
           roughness 0.01
           reflection 0.2
           ambient 0.2
           diffuse 0.6} 
   }  

  object{munchie
    translate <0.42,-0.7,0>
    rotate <0,-36,0>
    translate <0,0,0.95>
    pigment{NavajoWhite} 
    finish{specular 0.4
           roughness 0.01
           reflection 0.2
           ambient 0.2
           diffuse 0.6} 
   }  

  object{munchie
    translate <0.42,-0.7,0>
    rotate <0,-144,0>
    translate <0,0,0.95>
    pigment{NavajoWhite} 
    finish{specular 0.4
           roughness 0.01
           reflection 0.2
           ambient 0.2
           diffuse 0.6} 
   }  

 }
}

