#declare vertebra = 
blob{
 threshold 0.5
 cylinder {<0,0.5,0>,<0,-0.5,0>,0.5,2 }
 sphere {<0,0.8,0>,0.8,-20 }
 sphere {<0,-0.8,0>,0.8,-20 }

 cylinder {<-0.25,0.5,0.25>,<-0.5,-0.5,0.25>,0.4,2 }
 sphere {<-0.25,0.8,0.25>,0.8,-20 }
 sphere {<-0.25,-0.8,0.25>,0.8,-20 }

 cylinder {<-0.25,0.5,-0.25>,<-0.5,-0.5,-0.25>,0.4,2 }
 sphere {<-0.25,0.8,-0.25>,0.8,-20 }
 sphere {<-0.25,-0.8,-0.25>,0.8,-20 }

 cylinder {<-0.75,0.15,0>,<-0.75,-0.15,0>,0.5,2 }
 cylinder {<-0.75,0.25,0>,<-0.75,-0.25,0>,0.25,-2 }
 sphere {<-0.75,0.4,0>,0.5,-2 }
 sphere {<-0.75,-0.4,0>,0.5,-0.5 }

 cylinder {<-0.6,0.1,0>,<-0.6,-0.1,0>,0.25,1.5 }
 
 sphere {0,0.5,2 
         scale <0.2,0.5,0.8> 
         translate <0,0,0.85> 
         rotate<0,-45,0> 
         translate <-0.3,0,0> }
 sphere {0,0.5,2 
         scale <0.2,0.5,0.8> 
         translate <0,0,0.85> 
         rotate<0,-135,0>  
         translate <-0.3,0,0> }
 sphere {0,0.5,2 
         scale <0.2,0.5,0.5> 
         translate <0,0,0.85> 
         rotate<0,-90,0>  
         translate <-0.3,0,0> }
}

#declare spine = object{
 union{
#declare i = 0;
#while (i<20)

#declare xpos = (pi/10)*i;
#declare ypos = cos(xpos)*0.5;
#declare rota = atan2(sin(xpos),1)/pi*180;


object{vertebra
       rotate <0,0,rota>
       translate <ypos,xpos*1.8,0>
       texture{pigment{PeachPuff4}
               finish{ambient 0.15 
                      diffuse 0.65
                      specular 0.05 
                      roughness 0.05 
                      reflection 0.05 }
                      normal{crackle scale 0.3 turbulence 0.4 bump_size 0.5}}
       scale (1 - i*0.025)}
 #declare i = i + 1;
#end

 }
}