/////////// Brick Walls ////////////////
#declare T_Mortar = texture {
    pigment {Gray}
    #if (Simple_Textures = 0)
        normal {granite}
        finish {
            roughness 2
            diffuse .4
            }
    #end
    }

#declare Brick_Width = .5;
#declare Brick_Height = .25;
#declare Brick_Depth = .25;
#declare Mortar_Width = 0.025;
#declare Block_Width = 16*Inch;
#declare Block_Height = 8*Inch;
#declare Block_Depth = 8*Inch;

#declare T_Brick = texture {
    pigment { rgb <0.882,0.812,0.376> }
    #if (Simple_Textures = 0)
        normal { granite }
    #end
    }

#declare T_Block = texture {
//    pigment { rgb <0.816,0.812,0.427> }
    pigment { Gray90 }
    #if (Simple_Textures = 0)
        normal { granite scale 5 }
    #end
    }

#macro MakeBrick(brickW,brickH,brickD,T_brick,varience)
    #local RotVary = 1; // degrees
    #local RotY = -RotVary/2+RotVary*rand(RWall);
    #local bW = brickW-varience+rand(RWall)*varience;
    #local bH = brickH-varience+rand(RWall)*varience;
    #local bD = brickD-varience+rand(RWall)*varience;
    box {<0,0,0>, <bW,bH,bD> 
        texture {T_brick translate <rand(RWall),rand(RWall),rand(RWall)>}
        translate <-bW/2,0,0>
        rotate <0,RotY,0>
        translate <bW/2,0,0>
        }
#end

#macro MakeBrickWall(brW,brH,brD,T_br,motW,T_mot,wallW,wallH,wallD)
    #local SetWidth = brW + motW;
    #local SetHeight = brH + motW;
    #local Row0StartX = -SetWidth/2;
    #local Row1StartX = 0;
    #local RowFlag = 0;
    #local curWidth = Row0StartX;
    #local curHeight = 0;
    #local Jiggle = motW/6;

    #if (Simple_Walls = 1)
        #local tm = texture {T_br}
    #else
        #local tm = texture {T_mot}
    #end
    
    union {
        // Wall Base
        box {<0,0,motW>, <wallW,wallH,wallD> texture {tm}} // should look like mortar
        #if (Simple_Walls = 0)
            // place bricks
            #while (curHeight < wallH) // not tall enough
                #while (curWidth < wallW)// not wide enough
                    object {
                        MakeBrick(brW,brH,brD,T_br,Jiggle)
                        translate <curWidth,curHeight,0>
                        }
                    #local curWidth = curWidth + SetWidth;
                #end
                #local curHeight = curHeight + SetHeight;
                #if (RowFlag)
                    #local curWidth = Row1StartX;
                    #local RowFlag = 0;
                #else
                    #local curWidth = Row0StartX;
                    #local RowFlag = 1;
                #end
            #end
        #end
        // clip excess
        clipped_by{box {<0,0,-.1>,<wallW,wallH,wallD>}}
        bounded_by{ clipped_by }
        }
#end
