// Persistence of Vision Ray Tracer Include File
//          File: closedSpiralNotebook.inc
//       Version: 3.1g
//   Description: A closed spiral notebook
//       Created: 10/31/1999 
// Last Modified: 10/31/1999 
//        Author: Heather Cousineau  

// origin: front, bottom, left
//   size: 9" x 11.1" x 2"


   #local pages = union {
      #local ctr = 0;
      #local forRandSeed = 10000;
      
      #while(ctr < 100)
         #local xRand   = (rand(seed(forRandSeed))-.5)/100;
         #local zRand   = (rand(seed(forRandSeed+1))-.5)/100;
      
         object{
            paper(0,1,1,0,"none") 
            translate <xRand,ctr*.001,zRand>
         }
         #local ctr = ctr + 1; 
         #local forRandSeed = forRandSeed + 3;
      #end 
   }// union pages
   
   #local cover = union {
      object{
         #local coverPage = merge{ 
               sphere{<(3/8)*inch,0, 1.25*inch>,(5/32)*inch  pigment {Clear}}
               sphere{<(3/8)*inch,0,  5.5*inch>,(5/32)*inch  pigment {Clear}}
               sphere{<(3/8)*inch,0, 9.75*inch>,(5/32)*inch  pigment {Clear}}
            box{0,<8.5*inch,.001,11*inch> 
               texture { 
                    material_map{gif "coolnotebook.gif" map_type 0 interpolate 2 
                       texture { pigment {Black} }
                       texture { T_Gold_3A }
                       texture { pigment {BlueViolet} normal{crackle .1 scale .07}} 
                    } // material_map
                  scale <8.5*inch, 11*inch, 1>
                  rotate 90*x 
              }//texture        
            }//box
         }//merge
         object{coverPage}
         scale 1.1
         translate (.101)*y
      }
   
   
      object{               
         paper(0,0,1,0,"none")
         pigment {Sienna}    
         scale 1.1
         translate (-.001)*y}
   }//union
   
   #local spiral = union {
      #local ctr = 0;
      #local tVar = 0;
         #while (tVar < 76*11*inch)
            sphere{<sin(tVar)/12,cos(tVar)/12,ctr> .007 texture{T_Silver_2B}}
            #local tVar = tVar + .01;
            #local ctr = ctr + 1/7200;
         #end 
      translate .5*inch*y 
   }// union spiral        
   
#declare closedSpiralNotebook =
union {
   object{pages scale .5}
   object{spiral scale .5} 
   object{cover scale .5}            
   translate <inch,inch,.1>
}  
   

   
