// Door Include File for Horror Round of IRTC 1999
///////////// Door ///////////////

#debug "Using Door.inc"

#declare Show_Mesh = 0;
#declare Show_Glass = 0;
#declare Door_Width = 30*Inch;
#declare Door_Height = 7;
#declare Door_Depth = 2*Inch;

#declare T_DoorFrame = texture {
    pigment {Gray50}
    finish {Dull}
    }

#declare Door_Frame = difference {
    box {<-1*Inch,0,-0.5*Inch>, <Door_Width+1*Inch,Door_Height+1*Inch,Wall_Thickness+.5*Inch>}
    box {<0.01,.01,-1*Inch>, <Door_Width-0.01,Door_Height-0.01,Wall_Thickness+1*Inch>}
    texture {T_DoorFrame}
    }


#declare Door_Window_Margin = 3*Inch;
#declare Door_Window_Width = Door_Width-Door_Window_Margin*2;
#declare Door_Window_Height = Door_Window_Width;

#declare Door_Window_Cutout = box {<0,0,-1*Inch>, <Door_Window_Width,Door_Window_Height,Door_Depth+1*Inch>}

#declare T_Door_Window_Frame = texture {
    pigment {Gray50}
    finish {F_MetalB}
    }

#declare meshrad = 0.01*Inch;
#declare WireX = union {
    cylinder {<0,0,0>, <Door_Window_Width,Door_Window_Height,0>, meshrad texture {T_Silver_3A}}
    cylinder {<0,Door_Window_Height,0>, <Door_Window_Width,0,0>, meshrad texture {T_Silver_3A}}
    }
    
#declare Wire_Mesh = union {
    #local xpos = -Door_Window_Width;
    #while (xpos < Door_Window_Width*2)
        object {WireX translate <xpos,0,0>}
        #local xpos = xpos + 1*Inch;
    #end
    clipped_by { box {<0,0,-.1*Inch>,<Door_Window_Width,Door_Window_Height,.1*Inch>}}
    bounded_by { clipped_by }
    }
    
#declare Door_Window = union {
    #local xyoffset = 0.5*Inch;
    #local zoffset = 0.125*Inch/2;
    #local glassthick = 0.25*Inch;
    difference {
        box {<-xyoffset,-xyoffset,-zoffset>, <Door_Window_Width+xyoffset,Door_Window_Height+xyoffset,Door_Depth+zoffset>}
        box {<xyoffset,xyoffset,-zoffset-.1>, <Door_Window_Width-xyoffset,Door_Window_Height-xyoffset,Door_Depth+zoffset+.1>}
        texture {T_Door_Window_Frame}
        }
    // window glass
    #if (Show_Glass = 1)
    box {<0,0,0>, <Door_Window_Width,Door_Window_Height,glassthick>
        texture {T_Glass1}
        interior {I_Glass}
        translate z*(Door_Depth/2-glassthick/2)
        }
    #end
    // wire mesh
    #if (Show_Mesh = 1)
    object {Wire_Mesh translate z*Door_Depth/2}
    #end
    }

//#declare T_CR_Door = texture { T_Wood3 rotate <90,0,0> }
#declare T_CR_Door = texture { DMFWood6 rotate <90,0,0> }

#declare T_Kick_Plate = texture {
    T_Silver_3A
    normal { dents }
    }

#declare Kick_Plate = box {<1*Inch,0.5*Inch,-Inch/16>, <Door_Width-1*Inch,1,0> texture {T_Kick_Plate}}

#declare T_Knob_Plate = texture {
    T_Brass_4C
    normal { dents }
    scale Inch*2
    }

#declare Knob_Plate_Width = 4*Inch;
#declare Knob_Plate_Height = 10*Inch;
#declare Knob_Plate = box {<0,0,-Inch/16>, <Knob_Plate_Width,Knob_Plate_Height,0> texture {T_Knob_Plate}}

#declare KnobLockRad = Inch/2;
#declare KnobLockLen = 1*Inch;
#declare T_Knob_Lock = texture { T_Silver_1A }
#declare Knob_Lock = difference {
    cylinder {<0,0,0>, <0,0,KnobLockLen>, KnobLockRad}
    // keyhole
    box {<-Inch/32,-Inch/4,-Inch/10>, <Inch/32,Inch/4,Inch/2>}
    sphere {<0,-Inch/4+Inch/16,0>, Inch/16}
    texture {T_Knob_Lock}
    }

#declare T_Knob = texture { 
    T_Silver_1A 
    normal {dents}
    scale Inch/2
    }
#declare Knob = union {
    // use a flattened sphere for knob proper
    difference {
        sphere {<0,0,0>, 1*Inch scale <1.25,1.25,2/3>}
        cylinder {<0,0,0>, <0,0,-3*Inch>, KnobLockRad}
        texture {T_Knob}
        }
    // cut out a hole for lock
    // put in knob lock
    object {Knob_Lock translate <0,0,-1*Inch*2/3+Inch/16>}
    // cylinder to connect knob to door
    cylinder {<0,0,0>, <0,0,3*Inch>, 3/8*Inch texture {T_Knob}}
    translate <0,0,-2*Inch>
    }

#declare Knob_Assembly = union {
    object {Knob_Plate}
    object {Knob translate <Knob_Plate_Width/2,Knob_Plate_Height-2*Inch,0>}
//    object {Lock}
    translate <-Knob_Plate_Width,-Knob_Plate_Height,0>
    }

#declare CR_Door = union {
    #local winVpos = Door_Height-Door_Window_Margin-Door_Window_Height;
    #local winpos = <Door_Window_Margin,winVpos,0>;
    difference {
        box {<0,0,0>, <Door_Width,Door_Height,Door_Depth>}
        object {Door_Window_Cutout translate winpos}
        texture {T_CR_Door}
        }
    // door window
    object {Door_Window translate winpos}
    // door kick plate
    object {Kick_Plate translate <0,0,0>}
    // door knob assembly
    object {Knob_Assembly translate <Door_Width - 3*Inch,Door_Height/2,0>}
    // door lock
    }
