// Persistence of Vision Ray Tracer Include File
//          File: gymbag.inc
//       Version: 3.1g
//   Description: an open gym bag
//       Created: 10/29/1999 
// Last Modified: 10/29/1999 
//        Author: Heather Cousineau, Copyright 1999, all rights reserved.  

// fits in: box{<-.5,0,-1>,<.5,1,1>} 
//    size: 1 x 1 x 2
//  origin: bottom center of the bag
// example: object{gymBag1} for on the floor
// example: object{gymBag2} for standing in a locker



#include "gymBagBicubicPatches.inc"  // This is the messy file 
                  // with all the bicubic patches from sPatch!
#include "metals.inc"                  
                  
// ----- TEXTURES ----- 
#local zipperColor = rgb <.91,.95,.91>;
#declare zipperTexture = texture {                  
   pigment {
      gradient z  
         color_map {     
                           [0     zipperColor] [.01   rgbf 1]
            [0.015 rgbf 1] [0.025 zipperColor] [0.035 rgbf 1]
            [0.04  rgbf 1] [0.05  zipperColor] [0.06  rgbf 1]
            [0.065 rgbf 1] [0.075 zipperColor] [0.085 rgbf 1]
            [0.09  rgbf 1] [0.1   zipperColor] [0.11  rgbf 1]
            [0.115 rgbf 1] [0.125 zipperColor] [0.135 rgbf 1]
            [0.14  rgbf 1] [0.15  zipperColor] [0.16  rgbf 1]
            [0.165 rgbf 1] [0.175 zipperColor] [0.185 rgbf 1] //Don't worry, 
            [0.19  rgbf 1] [0.2   zipperColor] [0.21  rgbf 1] //I created a 
            [0.215 rgbf 1] [0.225 zipperColor] [0.235 rgbf 1] //program to 
            [0.24  rgbf 1] [0.25  zipperColor] [0.26  rgbf 1] //come up with 
            [0.265 rgbf 1] [0.275 zipperColor] [0.285 rgbf 1] //these values 
            [0.29  rgbf 1] [0.3   zipperColor] [0.31  rgbf 1] //for me!
            [0.315 rgbf 1] [0.325 zipperColor] [0.335 rgbf 1]
            [0.34  rgbf 1] [0.35  zipperColor] [0.36  rgbf 1]
            [0.365 rgbf 1] [0.375 zipperColor] [0.385 rgbf 1]
            [0.39  rgbf 1] [0.4   zipperColor] [0.41  rgbf 1]
            [0.415 rgbf 1] [0.425 zipperColor] [0.435 rgbf 1]
            [0.44  rgbf 1] [0.45  zipperColor] [0.46  rgbf 1]
            [0.465 rgbf 1] [0.475 zipperColor] [0.485 rgbf 1]
            [0.49  rgbf 1] [0.5   zipperColor] [0.51  rgbf 1]
            [0.515 rgbf 1] [0.525 zipperColor] [0.535 rgbf 1]
            [0.54  rgbf 1] [0.55  zipperColor] [0.56  rgbf 1]
            [0.565 rgbf 1] [0.575 zipperColor] [0.585 rgbf 1]
            [0.59  rgbf 1] [0.6   zipperColor] [0.61  rgbf 1]
            [0.615 rgbf 1] [0.625 zipperColor] [0.635 rgbf 1]
            [0.64  rgbf 1] [0.65  zipperColor] [0.66  rgbf 1]
            [0.665 rgbf 1] [0.675 zipperColor] [0.685 rgbf 1]
            [0.69  rgbf 1] [0.7   zipperColor] [0.71  rgbf 1]
            [0.715 rgbf 1] [0.725 zipperColor] [0.735 rgbf 1]
            [0.74  rgbf 1] [0.75  zipperColor] [0.76  rgbf 1]
            [0.765 rgbf 1] [0.775 zipperColor] [0.785 rgbf 1]
            [0.79  rgbf 1] [0.8   zipperColor] [0.81  rgbf 1]
            [0.815 rgbf 1] [0.825 zipperColor] [0.835 rgbf 1]
            [0.84  rgbf 1] [0.85  zipperColor] [0.86  rgbf 1]
            [0.865 rgbf 1] [0.875 zipperColor] [0.885 rgbf 1]
            [0.89  rgbf 1] [0.9   zipperColor] [0.91  rgbf 1]
            [0.915 rgbf 1] [0.925 zipperColor] [0.935 rgbf 1]
            [0.94  rgbf 1] [0.95  zipperColor] [0.96  rgbf 1]
            [0.965 rgbf 1] [0.975 zipperColor] [0.985 rgbf 1]   
      }//color_map 
     scale <1,.5,1>   
   }//pigment    
}//texture      

#declare bagTexture1 = texture{
   pigment{Scarlet}
   normal{
      spotted .2  
      scale .2  
   }//normal    
   normal{
      crackle .1  
      scale .01  
   }//normal    
   finish{
      specular .1
   }//finish
}//texture   

#declare bagTexture2 = texture{
   pigment{SteelBlue}
   normal{
      spotted .2  
      scale .2  
   }//normal    
   normal{
      crackle .1  
      scale .01  
   }//normal    
   finish{
      specular .1
   }//finish
}//texture                   



// ----- NRA CREST -----
#declare NRAcrest =
superellipsoid{<1,.2> 
   texture {pigment {Blue}}
   texture{
       pigment{
         image_map { gif "nra.gif" map_type 3 interpolate 2 once }
         rotate <0,0,0> // lay X-Y image map down onto X-Z height field plane
         translate <-.5,-.50>   
         scale 2
       }//pigment 
         normal{
            spotted .2  
            scale .2  
         }//normal    
         normal{
            crackle .1  
            scale .01  
         }//normal   
         finish{
            specular .1
         }//finish 
   }//texture
   scale <.25,.25,.1>         
   rotate <0,80,20>
   translate <.4,.5,0>
}//superellipsoid


// ----- OBJECTS ------
#declare gymBag1 = union{
   object {bag        texture {bagTexture1} }   
   object {NRAcrest}  //has texture
   object {zipper     texture {zipperTexture}}  
   object {zipperPull texture {T_Silver_5D}}
   object {handle     texture {bagTexture1}}
   object {cloth4     texture {pigment {CadetBlue}     normal{crackle .1 scale .01}}}  // top right
   object {cloth6     texture {pigment {Scarlet}       normal{crackle .1 scale .01}}}  // top left
   object {cloth8     texture {pigment {CornflowerBlue} normal{crackle .1 scale .01}}}  //very top
}//gymBag   

#declare gymBag2 = union{
   object {bag         texture {bagTexture2} }   
   //object {NRAcrest}   //has texture
   object {zipper      texture {zipperTexture}}  
   object {zipperPull2 texture {T_Silver_5D}}
   object {handle      texture {bagTexture2}}
   object {cloth4      texture {pigment {CadetBlue}      normal{crackle .1 scale .01}}}  // top right
   object {cloth6      texture {pigment {Scarlet}        normal{crackle .1 scale .01}}}  // top left
   object {cloth8      texture {pigment {CornflowerBlue} normal{crackle .1 scale .01}}}  //very top 
   object {backCloth   texture {pigment {BlueViolet}     normal{crackle .1 scale .01}}}  //very top 
}//gymBag2        

