// Persistence of Vision Ray Tracer Include File
// File: hinge.inc
// Vers: 3.1
// Desc: Provides a Hinge macro for generating hinges 
// Date: 9/21/99 
// Auth: Ray Benjamin, copyright 1999, all rights reserved
//
// Parameters:
//
//  HingeLen - length of hinge, note: hinges are vertical, HingeLen is y component
//  HingeRad - radius of hinge
//  HingeDiv - number of sections in the hinge, not including the end caps
//  HingeTex - texture to be applied to the hinge.
//
// Delivered object has origin at bottom center
//

#ifndef (Hinge_Macro_Inc)
#declare Hinge_Macro_Inc = 1;

// Constants
#ifndef (Inch)
    #declare Inch = 1/12;
#end
/////////////// Hinge //////////////////////    
#macro MakeHinge(HingeLen,HingeRad,HingeDiv,HingeTex)
    union {
    #local PinRad = HingeRad/2;
    #local HingeEndLen = PinRad*2;
    #local HingeGap = Inch/16;
    #local TotalGap = HingeGap*(HingeDiv+1);
    #local HingeSecLen = (HingeLen-HingeEndLen*2-TotalGap)/HingeDiv;
    // end caps
    cylinder {<0,0,0>, <0,HingeEndLen,0>, HingeRad}
    cylinder {<0,0,0>, <0,HingeEndLen,0>, HingeRad translate <0,HingeLen-HingeEndLen>}
    // pin
    cylinder {<0,Inch/10,0>, <0,HingeLen-Inch/10,0>, PinRad}
    // Hinge Sections
    #local ct = 0;
    #local ypos = HingeEndLen + HingeGap;
    #while (ct < HingeDiv)
        cylinder{<0,0,0>, <0,HingeSecLen,0>, HingeRad
            translate <0,ypos+(HingeSecLen+HingeGap)*(ct),0>
            }
        #local ct = ct + 1;
    #end
    texture {HingeTex}
    }    
#end

#end // ifndef