// Persistence of Vision Ray Tracer Scene Description File
// File: horror.pov
// Vers: 3.1g
// Desc: HighSchool
// Date: 9/5/1999 
// Auth: Ray Benjamin and Heather Cousineau

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
// Don't have all of the following included at once, it'll cost memory and time
// to parse!

#include "CONSTS.INC"   // Various constants and alias definitions
#include "FINISH.INC"   // Some basic finishes
#include "GLASS.INC"    // Glass textures
#include "GOLDS.INC"    // Gold textures
#include "METALS.INC"   // Metallic pigments, finishes, and textures

// Macros includes
//#include "book.inc" // Heather Cousineau's book macro

// Globals
#version 3.1;

global_settings
{
  assumed_gamma 1.0
  ambient_light .5
}

#declare Inch = 1/12;   // scaling
#declare Foot = 1;

// Random Seeds
#declare RWall = seed(129);

// scene control variables

#declare Simple_Walls = 0;
#declare Simple_Textures = 0;
#declare Show_Glass = 1;

#include "lights.inc"

///////////////////////////
// Scene Definitions     //
///////////////////////////

///////// Make a few books that are scattered around ////////

/*
#declare Book1 = union {
    openBook (15, 150,          // numPgs,      degreesOpen,
  	    	 2,  2,   		    //windStrength, chaosOfWind,    
	   		 .25, .25,  	//thickOfCover, roundOfCover,
	   		 1, 1,       	//heightOfBook, widthOfBook
	   		 pigment{White},//pagesTexture             
	   		 //frontCoverTexture, backCoverTexture, bindingCoverTexture)
	   		 pigment{Yellow},     pigment{Blue},    pigment{Red})
    }	   		 
*/

//////////////////////////
// Hall
//////////////////////////

#declare HW_Width = 12;
#declare HW_Length = 100;
#declare HW_Height = 10;

#declare T_Wall = texture {
    pigment {White}
    }
        
#include "classroom.inc"


#declare T_Terrazzo = texture {
    pigment {
        crackle
        color_map {
            [0.0 White]
            [0.6 Orange]
            [0.7 Tan]
            [0.8 Yellow]
            [0.9 Gray10]
            [1.0 Tan]
            }
        turbulence 0.3
        }
    scale .063
    }
    
#declare T_Scuffs = texture {
    pigment {
        granite
        color_map {
            [0.0 White]
            [0.08 White]
            [0.08 color rgbt <1,1,1,1>]
            [0.8 color rgbt <1,1,1,1>]
            [0.92 Black]
            [1.0 Gray10]
            }
        turbulence 1
        scale 8
        }
    }

#declare T_Floor_Terrazzo =
    texture { T_Terrazzo }
    texture { T_Scuffs }

#declare T_Hall_Floor = texture {
    T_Floor_Terrazzo
    }

// Guide lines on the floor 
#declare vertspace = 6;
#declare letterscale = 1/5;
#declare letterht = .0001;
#declare upy = 0.002;


#declare TXT_Library = union {
    #local P_Library = pigment {color rgb <.2,.2,1>}
    #local vertspace = 6;
    union {
        object {char_L}
        object {char_I translate -vertspace*y}
        object {char_B translate -vertspace*2*y}
        object {char_R translate -vertspace*3*y}
        object {char_A translate -vertspace*4*y}
        object {char_R translate -vertspace*5*y}
        object {char_Y translate -vertspace*6*y}
        translate <0,7*vertspace,0>
        scale <letterscale,letterscale,letterht>   // set to 1 foot high letters
        rotate 90*x // rotate to put on floor
        translate upy*y
        pigment {White}
        }
    box {<0,0,0>, <1,.001,16> pigment {P_Library} translate -5/10*x}
    // curve going into the Library
    difference {
        cylinder {<0,0,0>, <0,.0015,0>, 3}
        cylinder {<0,-.1,0>, <0,.1,0>, 2 }
        clipped_by {
            plane {-z,0}
            plane {x,0}
            }
        bounded_by { clipped_by }
        pigment {P_Library}
        translate <2.5,0,16>
        }
    box {<0,0,0>, <4,.001,1> pigment {P_Library} translate <2,0,18>}
    }

#declare TXT_Auditorium = union {
    #local vertspace = 6;
    union {
        object {char_A}
        object {char_U translate -vertspace*y}
        object {char_D translate -vertspace*2*y}
        object {char_I translate -vertspace*3*y}
        object {char_T translate -vertspace*4*y}
        object {char_O translate -vertspace*5*y}
        object {char_R translate -vertspace*6*y}
        object {char_I translate -vertspace*7*y}
        object {char_U translate -vertspace*8*y}
        object {char_M translate -vertspace*9*y}
        translate <0,9*vertspace,0>
        scale <letterscale,letterscale,letterht>   // set to 1 foot high letters
        rotate 90*x // rotate to put on floor
        translate upy*y
        pigment {White}
        }
    box {<0,0,-10>, <1,.001,65> pigment {Tan} translate -5/10*x}
    // curve going off to the right
    difference {
        cylinder {<0,0,0>, <0,.0015,0>, 3}
        cylinder {<0,-.1,0>, <0,.1,0>, 2 }
        clipped_by {
            plane {-z,0}
            plane {x,0}
            }
        bounded_by { clipped_by }
        pigment {Tan}
        translate <2.5,0,65>
        }
    box {<0,0,0>, <4,.001,1> pigment {Tan} translate <2,0,65>}
    }

#declare P_Office = pigment { color rgb <1,.2,.2> }

#declare TXT_Office = union {
    #local vertspace = 6;
    union {
        object {char_O}
        object {char_F translate -vertspace*y}
        object {char_F translate -vertspace*2*y}
        object {char_I translate -vertspace*3*y}
        object {char_C translate -vertspace*4*y}
        object {char_E translate -vertspace*5*y}
        translate <0,6*vertspace,0>
        scale <letterscale,letterscale,letterht>   // set to 1 foot high letters
        rotate 90*x // rotate to put on floor
        translate upy*y
        pigment {White}
        }
    box {<0,0,-10>, <1,.001,55> pigment {P_Office} translate -5/10*x}
    // curve going off to the right
    difference {
        cylinder {<0,0,0>, <0,.0015,0>, 3}
        cylinder {<0,-.1,0>, <0,.1,0>, 2 }
        clipped_by {
            plane {-z,0}
            plane {-x,0}
            }
        bounded_by { clipped_by }
        pigment {P_Office}
        translate <-2.5,0,55>
        }
    box {<0,0,0>, <-4,.001,1> pigment {P_Office} translate <-2,0,55>}
    }

#declare Hall_Floor = union {
    box {<0,-1*Inch,0>, <HW_Width,0,HW_Length> texture {T_Hall_Floor}}
    object {TXT_Library translate <HW_Width/2,.0001,30>}
    object {TXT_Auditorium translate <HW_Width/2+1.5,.0001,25>}
    object {TXT_Office translate <HW_Width/2-1.5,.0001,40>}
    box {<0,-1*Inch,0>, <HW_Width,.0025,HW_Length> texture {T_Scuffs}}
    }

#declare T_Hall_Ceiling = texture {
    pigment {White}
    }

#declare Hall_Ceiling = union {
    box {<0,0,0>, <HW_Width,1,HW_Length> texture {T_Hall_Ceiling}}
    }

#declare T_Structural_Frame = 
    texture { pigment {White}}
    texture {T_Scuffs}
    
#declare T_ExitFrame =    
    texture { pigment {White}}
    texture {T_Scuffs rotate 90*y}

#declare FrameVert = box {<0,0,0>, <1,HW_Height,1>}    
#declare Structural_Frame = union {
    union {
        object {FrameVert}
        object {FrameVert translate <HW_Width-1,0,0>}
        box {<0,0,0>, <HW_Width,2,1> translate <0,HW_Height-2,0>}
        texture {T_Structural_Frame}
        }
    object {Security_Light translate <HW_Width/2,HW_Height-1.75,0>}
    translate <0,0,-0.5>
    }

#declare Exit_Frame = union {
    object {Structural_Frame texture {T_ExitFrame}}
    object {Exit_Sign translate <HW_Width/2,HW_Height-1.25,-0.5>}
    }

#declare HallWay = union {
    // right side of hall
    object {ClassRoom rotate y*90 translate <HW_Width,0,CR_Width>}
    object {Library rotate y*90 translate <HW_Width,0,CR_Width*2>}
    object {ClassRoom rotate y*90 translate <HW_Width,0,CR_Width*3>}
    // left side of hall
    object {ClassRoom rotate y*-90 translate <0,0,0>}
    object {ClassRoom301 rotate y*-90 translate <0,0,CR_Width>}
    object {ClassRoom rotate y*-90 translate <0,0,CR_Width*2>}
    // end of hall
    object {ClassRoom translate <-CR_Width/3,0,CR_Width*3+HW_Width>}
    // rest of hall
    object {Structural_Frame translate z*CR_Width}
    object {Structural_Frame translate z*CR_Width*2}
    object {Exit_Frame translate z*CR_Width*3}
    object {Hall_Ceiling translate <0,HW_Height,0>}
    object {Hall_Floor translate <0,0,0>}
    translate <-(HW_Width/2),0,0>
    }

// Build Scene
object {Hall_Light translate <0,HW_Height,-20>}
object {Hall_Light translate <0,HW_Height,0>}
object {Hall_Light translate <0,HW_Height,20>}
object {Hall_Light translate <0,HW_Height,40>}
object {Hall_Light translate <0,HW_Height,60>}
object {HallWay translate <0,0,-30>}
//object {Book1 rotate <0,45,0> translate <2,0,5>}

#include "swat.inc"
#include "rifle.inc"

#declare gun = object {
    rifle(pigment{Brown},1,1,1)
    }

#declare SwatGuy = union {
    object {poser_object scale 6/.801 rotate 140*y}
    object {gun scale 3 rotate 180*z rotate <-95,0,5> translate <3*Inch,4.5,-3*Inch>}
    }

object {SwatGuy rotate <0,-130,0> translate <-6.5,0,11.8>}    

// Puts all the clutter on the floor //hmc
#include "floorclutter.inc"
//object {floorClutter}

// Cameras
// look down hall cam
//camera { location 0 look_at <0,0,1> angle 50 translate <0,5,-10> }
// look at fire ext.
//camera { location 0 look_at <0,0,1> angle 50 rotate <0,-20,0> translate <0,5,-10> }
// look at Frame corner
//camera { location 0 look_at <0,0,1> rotate <-3,30,0> translate <0,5,-10> }
// look at wall cam
//camera { location 0 look_at <0,0,1> rotate <0,-90,0> translate <0,5,-15> }

// Top View Cam
// create a regular point light source
//light_source { 0*x White translate <0, 400, -20>}
//camera { location 0 look_at <0,-1,0> translate <0,200,60>}

// Library Cam
//camera { location 0 look_at <0,0,1> rotate -40*y angle 50 translate <20,4,10> }

// Look at room 301 for placing SWAT guy
//camera { location 0 look_at <0,0,1> rotate -90*y translate <0,5,10.5> }

// Final Cam - still experimenting
camera { location 0 look_at <0,0,1> rotate 25*y angle 50 translate <-4,2,-3> }





