#include "colors.inc"      
        

// --- TEMPORARY ---
//camera{location <15,2,0> look_at 0*z}           
//background { color rgb 0 }
//light_source{<10,10,-10>,1 White}  
//plane{y,-3 pigment {Red}}  
//openBook (10, 2, 2, .25, .25, pigment{White}, pigment {Blue})
// --- TEMPORARY ---  

// All the stuff in the TEMPORARY section can be deleted. 
// The scene elements are just there to make it easy to test
// out the different settings with the book

// I also left an example up there, to give an idea
// of the general settings.  

#macro openBook (numPgs, windStrength, chaosOfWind, 
						thickOfCover, roundOfCover, 
						pagesTexture, coverTexture)

	#declare book_cover_texture = texture{coverTexture}   
	#declare book_pages_texture = texture{pagesTexture}
	
	// randomness for the pages
	#declare thetaRnd = (rand(seed(1))-.5)/10;
	#declare tipRnd   = (rand(seed(2))-.5);  
	#declare tipRnd2   = (rand(seed(2))-.5);
	
	// A whole bunch of Variables           
	#declare wind = windStrength;
	
	#declare numPages = numPgs; 
	#declare numPages = numPages -1; // adjusts for off-by-one problem
	#declare page = 0;   
	#declare rim = 0; 
	#declare t1V = 0; #declare t1Vend = pi;
	#declare t2V = 0; #declare t2Vend = pi;
	#declare t3V = 0; #declare t3Vend = pi;   
	#declare adj = abs(wind/numPages);
	#declare chaosOfWind = chaosOfWind;      
	
	#declare thick = thickOfCover; // how thick the cover is
	#declare jutt  = roundOfCover;  // how far out the edges go
	#declare lS    =  6;  // .5 the width of the book
	#declare rS    =  .5; // .5 the width of the binding
	#declare mL    =  (lS-rS)/3;
	#declare mR    =  2*(lS-rS)/3;      
	
	// The pages
	#declare flying_pages = union
	{
		#while (page <= numPages)  
			#declare y1V =  1*sin(t1V);
			#declare z1V =  1*cos(t1V); 
			#declare y2V =  4*sin(t2V);
			#declare z2V =  4*cos(t2V); 
			#declare y3V =  5*sin(t3V);
			#declare z3V =  5*cos(t3V);   
			#declare tipRnd    = (rand(seed(2))-.5)*chaosOfWind;  
			#declare tipRnd2   = (rand(seed(3))-.5)*chaosOfWind;
			
		   bicubic_patch
			{
			  type 1 // patch_type (0..1)
			  flatness 0 // flatness value (lower = flatter)
			  u_steps 3  v_steps 3 
			  // back     			nBack        nFront     front
			  <0,0,rim>   			<1,0,rim>   <2,0,rim>   <3,0,rim>    // Rim  (0)
			  <0,y1V,z1V> 			<1,y1V,z1V> <2,y1V,z1V> <3,y1V,z1V>  // nRim (1)
			  <0,y2V,z2V> 			<1,y2V,z2V> <2,y2V,z2V> <3,y2V,z2V>  // nEnd (2)
			  <0,y3V,z3V+tipRnd2><1,y3V,z3V> <2,y3V,z3V> <3,y3V,z3V+tipRnd>  // end  (3) 
			  texture {book_pages_texture }
			}
			
			#declare page = page + 1;
	
			#declare t1V = t1V + t1Vend/numPages;	
			#if(wind = 0 )												// if the wind is 0, 
				#declare t2V = t2V + t2Vend/numPages;        // then, don't adjust
				#else													   // adjust it.
					#declare t2V = t2V + t2Vend/numPages*adj;	
					#end
			#declare t3V = t3V + t3Vend/numPages;	
		   #declare adj = adj + adj/numPages+thetaRnd;
			#declare rim = rim +.1;
		#end           
	}         
	// --------------- COVER ----(variables set above)-----------------------------------------------
	#declare thick = -thick   
	// --------- Right Part ---------       
	#declare right_part = union
	{
		bicubic_patch // top
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
		  // back     nBack        nFront     front
		  <0,0,rS> <1,0,rS> <2,0,rS> <3,0,rS>  // Rim  (0)
		  <0,0,mR> <1,0,mR> <2,0,mR> <3,0,mR>  // nRim (1)
		  <0,0,mL> <1,0,mL> <2,0,mL> <3,0,mL>  // nEnd (2)
		  <0,0,lS> <1,0,lS> <2,0,lS> <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		}
		bicubic_patch // bottom
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack  		 nFront  	front
		  <0,thick,rS> <1,thick,rS> <2,thick,rS> <3,thick,rS>  // Rim  (0)
		  <0,thick,mR> <1,thick,mR> <2,thick,mR> <3,thick,mR>  // nRim (1)
		  <0,thick,mL> <1,thick,mL> <2,thick,mL> <3,thick,mL>  // nEnd (2)
		  <0,thick,lS> <1,thick,lS> <2,thick,lS> <3,thick,lS>  // end  (3) 
		  texture {book_cover_texture }
		}    
		bicubic_patch // far side
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack   			nFront  		front
		  <0,thick,rS> <-jutt,thick,rS> <-jutt,0,rS> <0,0,rS>  // Rim  (0)
		  <0,thick,mR> <-jutt,thick,mR> <-jutt,0,mR> <0,0,mR>  // nRim (1)
		  <0,thick,mL> <-jutt,thick,mL> <-jutt,0,mL> <0,0,mL>  // nEnd (2)
		  <0,thick,lS> <-jutt,thick,lS> <-jutt,0,lS> <0,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		} 
		bicubic_patch // near side
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack   			 nFront  	  front
		  <3,thick,rS> <3+jutt,thick,rS> <3+jutt,0,rS> <3,0,rS>  // Rim  (0)
		  <3,thick,mR> <3+jutt,thick,mR> <3+jutt,0,mR> <3,0,mR>  // nRim (1)
		  <3,thick,mL> <3+jutt,thick,mL> <3+jutt,0,mL> <3,0,mL>  // nEnd (2)
		  <3,thick,lS> <3+jutt,thick,lS> <3+jutt,0,lS> <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		}      
		bicubic_patch // right side 
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
		  // back     nBack        nFront     front
		  <0,thick,lS>      <1,thick,lS>      <2,thick,lS>      <3,thick,lS>  // Rim  (0)
		  <0,thick,lS+jutt> <1,thick,lS+jutt> <2,thick,lS+jutt> <3,thick,lS+jutt>  // nRim (1)
		  <0,0,lS+jutt>     <1,0,lS+jutt>     <2,0,lS+jutt>     <3,0,lS+jutt>  // nEnd (2)
		  <0,0,lS>          <1,0,lS>          <2,0,lS>          <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		} 
	}
	// --------- Left Part ---------  
	#declare lS    = -lS+.5;
	#declare mL    = -mL+.5;
	#declare mR    = -mR+.5;
	#declare rS    = -rS+.5; 
	#declare yAdj  = .5;
	#declare yAdj2 = 2*(yAdj/3);
	#declare yAdj3 = (yAdj/3);
	
	
	#declare left_part = union
	{
		bicubic_patch // top
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
		  // back     nBack        nFront     front
		  <0,yAdj,rS> 		<1,yAdj,rS> 	<2,yAdj,rS> 	<3,yAdj,rS>  // Rim  (0)
		  <0,yAdj2,mR> 	<1,yAdj2,mR> 	<2,yAdj2,mR> 	<3,yAdj2,mR>  // nRim (1)
		  <0,+yAdj3,mL>	<1,+yAdj3,mL>	<2,+yAdj3,mL>	<3,+yAdj3,mL>  // nEnd (2)
		  <0,0,lS> <1,0,lS> <2,0,lS> <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		}
		bicubic_patch // bottom
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack  		 nFront  	front
		  <0,thick+yAdj,rS>  <1,thick+yAdj,rS>  <2,thick+yAdj,rS>  <3,thick+yAdj,rS>  // Rim  (0)
		  <0,thick+yAdj2,mR> <1,thick+yAdj2,mR> <2,thick+yAdj2,mR> <3,thick,mR>  // nRim (1)
		  <0,thick+yAdj3,mL> <1,thick+yAdj3,mL> <2,thick+yAdj3,mL> <3,thick+yAdj3,mL>  // nEnd (2)
		  <0,thick,lS> 		<1,thick,lS> 		 <2,thick,lS> 		  <3,thick,lS>  // end  (3) 
		  texture {book_cover_texture }
		}    
		bicubic_patch // far side
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack   			nFront  		front
		  <0,thick+yAdj,rS>  <-jutt,thick+yAdj,rS>  <-jutt,+yAdj,rS>  <0,+yAdj,rS>   // Rim  (0)
		  <0,thick+yAdj2,mR> <-jutt,thick+yAdj2,mR> <-jutt,+yAdj2,mR> <0,+yAdj2,mR>  // nRim (1)
		  <0,thick+yAdj3,mL> <-jutt,thick+yAdj3,mL> <-jutt,+yAdj3,mL> <0,+yAdj3,mL>  // nEnd (2)
		  <0,thick,lS> 		<-jutt,thick,lS>		  <-jutt,0,lS> 	  <0,0,lS>  	  // end  (3) 
		  texture {book_cover_texture}
		} 
		bicubic_patch // near side
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack   			 nFront  	  front
		  <3,thick+yAdj,rS> <3+jutt,thick+yAdj,rS> <3+jutt,+yAdj,rS> <3,+yAdj,rS>  // Rim  (0)
		  <3,thick+yAdj2,mR> <3+jutt,thick+yAdj2,mR> <3+jutt,+yAdj2,mR> <3,+yAdj2,mR>  // nRim (1)
		  <3,thick+yAdj3,mL> <3+jutt,thick+yAdj3,mL> <3+jutt,+yAdj3,mL> <3,+yAdj3,mL>  // nEnd (2)
		  <3,thick,lS> <3+jutt,thick,lS> <3+jutt,0,lS> <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		}      
		bicubic_patch // right side 
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
		  // back     nBack        nFront     front
		  <0,thick,lS>      <1,thick,lS>      <2,thick,lS>      <3,thick,lS>  // Rim  (0)
		  <0,thick,lS+jutt> <1,thick,lS+jutt> <2,thick,lS+jutt> <3,thick,lS+jutt>  // nRim (1)
		  <0,0,lS+jutt>     <1,0,lS+jutt>     <2,0,lS+jutt>     <3,0,lS+jutt>  // nEnd (2)
		  <0,0,lS>          <1,0,lS>          <2,0,lS>          <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		} 
	}  
	// -------- Binding ----------
	#declare lS    = lS-.5;
	#declare mL    = mL-.5;
	#declare mR    = mR-.5;
	#declare rS    = rS-.5;
	
	#declare lS    = rS;
	#declare mL    = (rS+lS)/3;
	#declare mR    = -(rS+lS)/35;
	#declare rS    = -rS;
	#declare dip = .5;       
	
	#declare binding = union
	{
		bicubic_patch // top
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
		  // back     nBack        nFront     front
		  <0,0,rS> 		<1,0,rS> 	<2,0,rS> 	<3,0,rS>  // Rim  (0)
		  <0,-dip,mR> 	<1,-dip,mR> <2,-dip,mR> <3,-dip,mR>  // nRim (1)
		  <0,-dip,mL> 	<1,-dip,mL> <2,-dip,mL> <3,-dip,mL>  // nEnd (2)
		  <0,0,lS> 		<1,0,lS> 	<2,0,lS> 	<3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		}
		bicubic_patch // bottom
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack  		 nFront  	front
		  <0,thick,rS> 	 <1,thick,rS> 		<2,thick,rS> 		<3,thick,rS>  // Rim  (0)
		  <0,thick-dip,mR> <1,thick-dip,mR> <2,thick-dip,mR>  <3,thick-dip,mR>  // nRim (1)
		  <0,thick-dip,mL> <1,thick-dip,mL> <2,thick-dip,mL>  <3,thick-dip,mL>  // nEnd (2)
		  <0,thick,lS> 	 <1,thick,lS> 		<2,thick,lS> 		<3,thick,lS>  // end  (3) 
		  texture {book_cover_texture }
		}    
		bicubic_patch // far side
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack   			nFront  		front
		  <0,thick,rS> 	 <-jutt,thick,rS> 	 <-jutt,0,rS> 		<0,0,rS>  // Rim  (0)
		  <0,thick-dip,mR> <-jutt,thick-dip,mR> <-jutt,-dip,mR>  <0,-dip,mR>  // nRim (1)
		  <0,thick-dip,mL> <-jutt,thick-dip,mL> <-jutt,-dip,mL>  <0,-dip,mL>  // nEnd (2)
		  <0,thick,lS> 	 <-jutt,thick,lS> 	 <-jutt,0,lS> 		<0,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		} 
		bicubic_patch // near side
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
	  // back    		nBack   			 nFront  	  front
		  <3,thick,rS> 	 <3+jutt,thick,rS> 	  <3+jutt,0,rS> 	 <3,0,rS>  // Rim  (0)
		  <3,thick-dip,mR> <3+jutt,thick-dip,mR> <3+jutt,-dip,mR> <3,-dip,mR>  // nRim (1)
		  <3,thick-dip,mL> <3+jutt,thick-dip,mL> <3+jutt,-dip,mL> <3,-dip,mL>  // nEnd (2)
		  <3,thick,lS> 	 <3+jutt,thick,lS> 	  <3+jutt,0,lS> 	 <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		}      
		bicubic_patch // right side 
		{
		  type 1 // patch_type (0..1)
		  flatness 0 // flatness value (lower = flatter)
		  u_steps 3  v_steps 3 
		  // back     nBack        nFront     front
		  <0,thick,lS>          <1,thick,lS>          <2,thick,lS>          <3,thick,lS>  // Rim  (0)
		  <0,thick-dip,lS+jutt> <1,thick-dip,lS+jutt> <2,thick-dip,lS+jutt> <3,thick-dip,lS+jutt>  // nRim (1)
		  <0,-dip,lS+jutt>      <1,-dip,lS+jutt>      <2,-dip,lS+jutt>      <3,-dip,lS+jutt>  // nEnd (2)
		  <0,0,lS>              <1,0,lS>              <2,0,lS>              <3,0,lS>  // end  (3) 
		  texture {book_cover_texture}
		} 
	}
	
	
	
	object {right_part}
	object {left_part}
	object {binding rotate 45*x translate <0,.2,.2>}
	object {flying_pages}

#end