// Persistence of Vision Ray Tracer Include File
//          File: paper.inc
//       Version: 3.1g
//   Description: paper
//       Created: 10/28/1999 
// Last Modified: 10/28/1999 
//        Author: Heather Cousineau, Copyright 1999, all rights reserved.         

//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
//                                PAPER MACRO                                  //
// This macro create a piece of paper.                                         //
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
//											  VARIABLES											    //
// crumpled - 0 = flat                                                         //
//            1 = crumpled                                                     //
//                                                                             //
// lined    - 0 = plain                                                        //
//            1 = lined                                                        //
//                                                                             //
// holes    - 0 = no holes                                                     //
//            1 = has 3 holes for a 3-ring binder (flat only)                  //
//                                                                             //
// havePic  - 0 = no picture (still need put put something in the pic spot)    //
//            1 = use a picture                                                //
//                                                                             //
// pic      - String of filename to use for the picture, * must be gif         //
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
//                            SCALING AND CENTER									    //
// Flat paper:     size: 8.5" x .001 x 11"                                     //  
//               center: front, lower, left corner                             //
// Crumpled paper  size: 7.2"^3                                                //
//               center: origin                                                // 
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
//											  EXAMPLES                                    //   
// paper(crumpled, lined, holes, havePic, pic)                                 //
// Crumpled, lined piece of paper:                                             //
//    paper(1,1,0,0,"none")                                                    //
// Flat, plain, 3-hole-punched, piece of paper:                                //
//    paper(0,0,1,0,"none")                                                    //
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
// Aslo includes texture: ruledPaperTexture                                    // 
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\

#ifndef(foot)
   #declare foot = 1;
#end
#declare inch = (1/12)*foot;

   // --- Texture for lined paper ---
   #local redLine =
      texture{
         pigment {
            gradient x
            color_map {
               [0     red 1] [.01   rgbf  1] 
            }//color_map                    
         translate -.3*x
         }//pigment    
      }//texture
   
   #local blueLines =   
      texture{
         pigment {
            gradient z
            color_map {
                               [0     blue 1] [.01   rgbf  1] 
               [.045  rgbf  1] [.05   blue 1] [.055  rgbf  1] 
               [.095  rgbf  1] [.1    blue 1] [.105  rgbf  1] 
               [.145  rgbf  1] [.15   blue 1] [.155  rgbf  1]  
               [.195  rgbf  1] [.2    blue 1] [.205  rgbf  1] 
               [.245  rgbf  1] [.25   blue 1] [.255  rgbf  1]
               [.295  rgbf  1] [.3    blue 1] [.305  rgbf  1] 
               [.345  rgbf  1] [.35   blue 1] [.355  rgbf  1]
               [.395  rgbf  1] [.4    blue 1] [.405  rgbf  1] 
               [.445  rgbf  1] [.45   blue 1] [.455  rgbf  1]         
               [.495  rgbf  1] [.5    blue 1] [.505  rgbf  1] 
               [.545  rgbf  1] [.55   blue 1] [.555  rgbf  1]         
               [.595  rgbf  1] [.6    blue 1] [.605  rgbf  1] 
               [.645  rgbf  1] [.65   blue 1] [.655  rgbf  1]
               [1     rgbf  1]
            }//color_map 
         translate -.25*z     
         }//pigment       
      }//texture
      
   #declare linedPaperTexture = 
      texture {redLine}
      texture {blueLines}

#declare ruledPaperTexture =
texture{pigment{rgb 1}}
texture{linedPaperTexture}   



#macro paper(crumpled, lined, holes, havePic, pic)

   
   // --- Flat Paper ---   
   #declare flatPaper =
   merge{ 
      #if(holes=1)
         sphere{<(3/8)*inch,0, 1.25*inch>,(5/32)*inch  pigment {Clear}}
         sphere{<(3/8)*inch,0,  5.5*inch>,(5/32)*inch  pigment {Clear}}
         sphere{<(3/8)*inch,0, 9.75*inch>,(5/32)*inch  pigment {Clear}}
      #end 
      box{0,<8.5*inch,.001,11*inch> }
   }//merge    
   
   
   
   // --- Crumpled Paper ---
   // File generated by sPatch, Copyright 1996-1998 by Mike Clifton
   
   #declare crumpledPaper =
   union {
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.037, 0.086, 0.163> <-0.096, 0.120, 0.185> <-0.000, -0.023, 0.292> <-0.010, -0.060, 0.353> 
   		<0.015, 0.065, 0.039> <-0.044, 0.099, 0.061> <0.022, -0.095, 0.153> <0.012, -0.132, 0.214> 
   		<0.251, -0.134, 0.237> <0.165, -0.186, 0.161> <0.102, -0.193, -0.070> <-0.009, -0.160, -0.023> 
   		<0.287, -0.232, 0.150> <0.201, -0.285, 0.074> <0.149, -0.155, -0.216> <0.037, -0.122, -0.169> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.037, 0.086, 0.163> <0.015, 0.065, 0.039> <0.251, -0.134, 0.237> <0.287, -0.232, 0.150> 
   		<0.097, 0.009, 0.114> <0.149, -0.012, -0.010> <0.308, -0.099, 0.287> <0.344, -0.197, 0.200> 
   		<0.243, -0.166, 0.200> <0.299, -0.107, 0.131> <0.331, -0.094, 0.167> <0.288, -0.047, 0.082> 
   		<0.363, -0.274, 0.216> <0.419, -0.215, 0.147> <0.331, -0.015, 0.139> <0.288, 0.032, 0.054> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.037, 0.086, 0.163> <-0.090, 0.107, 0.292> <0.081, -0.093, 0.414> <0.131, -0.170, 0.521> 
   		<-0.096, 0.120, 0.185> <-0.150, 0.141, 0.314> <0.030, 0.042, 0.528> <0.080, -0.035, 0.635> 
   		<-0.000, -0.023, 0.292> <-0.025, 0.056, 0.443> <0.008, 0.068, 0.592> <-0.022, 0.192, 0.708> 
   		<-0.010, -0.060, 0.353> <-0.034, 0.019, 0.504> <-0.078, 0.228, 0.624> <-0.108, 0.352, 0.740> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.037, 0.086, 0.163> <0.097, 0.009, 0.114> <0.243, -0.166, 0.200> <0.363, -0.274, 0.216> 
   		<-0.090, 0.107, 0.292> <0.044, 0.030, 0.243> <0.196, -0.216, 0.258> <0.316, -0.324, 0.274> 
   		<0.081, -0.093, 0.414> <0.100, -0.144, 0.371> <0.185, -0.203, 0.340> <0.172, -0.205, 0.272> 
   		<0.131, -0.170, 0.521> <0.150, -0.221, 0.479> <0.103, -0.174, 0.364> <0.091, -0.176, 0.296> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.287, -0.232, 0.150> <0.201, -0.285, 0.074> <0.149, -0.155, -0.216> <0.037, -0.122, -0.169> 
   		<0.312, -0.303, 0.087> <0.227, -0.356, 0.011> <0.168, -0.139, -0.276> <0.056, -0.106, -0.229> 
   		<0.082, -0.133, 0.077> <0.055, -0.079, 0.075> <0.088, 0.100, -0.055> <0.074, 0.041, -0.062> 
   		<0.028, -0.091, 0.007> <0.000, -0.036, 0.005> <0.145, 0.115, -0.083> <0.131, 0.056, -0.089> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.287, -0.232, 0.150> <0.312, -0.303, 0.087> <0.082, -0.133, 0.077> <0.028, -0.091, 0.007> 
   		<0.344, -0.197, 0.200> <0.370, -0.268, 0.138> <0.110, -0.189, 0.079> <0.056, -0.146, 0.010> 
   		<0.288, -0.047, 0.082> <0.262, -0.019, 0.032> <0.197, -0.062, -0.028> <0.158, -0.103, -0.056> 
   		<0.288, 0.032, 0.054> <0.263, 0.060, 0.003> <0.253, -0.068, -0.054> <0.213, -0.108, -0.082> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.028, -0.091, 0.007> <-0.013, -0.059, -0.044> <0.008, -0.033, -0.151> <-0.001, -0.008, -0.218> 
   		<0.056, -0.146, 0.010> <0.015, -0.115, -0.042> <-0.029, -0.090, -0.121> <-0.037, -0.066, -0.189> 
   		<0.158, -0.103, -0.056> <0.113, -0.148, -0.087> <0.073, -0.130, -0.144> <0.016, -0.170, -0.160> 
   		<0.213, -0.108, -0.082> <0.169, -0.153, -0.114> <0.081, -0.200, -0.119> <0.024, -0.239, -0.135> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.028, -0.091, 0.007> <0.000, -0.036, 0.005> <0.145, 0.115, -0.083> <0.131, 0.056, -0.089> 
   		<-0.013, -0.059, -0.044> <-0.040, -0.005, -0.047> <0.196, 0.129, -0.108> <0.183, 0.069, -0.115> 
   		<0.008, -0.033, -0.151> <0.029, 0.001, -0.168> <0.137, -0.025, -0.194> <0.116, -0.055, -0.170> 
   		<-0.001, -0.008, -0.218> <0.021, 0.026, -0.235> <0.131, -0.073, -0.228> <0.110, -0.103, -0.204> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.131, 0.056, -0.089> <0.074, 0.041, -0.062> <0.056, -0.106, -0.229> <0.037, -0.122, -0.169> 
   		<0.094, -0.105, -0.108> <0.037, -0.120, -0.080> <-0.080, -0.065, -0.171> <-0.099, -0.081, -0.111> 
   		<0.070, -0.435, -0.138> <0.061, -0.427, 0.013> <0.001, -0.257, 0.108> <-0.007, -0.181, 0.238> 
   		<-0.058, -0.463, -0.035> <-0.067, -0.455, 0.115> <-0.110, -0.188, 0.190> <-0.117, -0.112, 0.320> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.131, 0.056, -0.089> <0.094, -0.105, -0.108> <0.070, -0.435, -0.138> <-0.058, -0.463, -0.035> 
   		<0.183, 0.069, -0.115> <0.146, -0.092, -0.133> <0.077, -0.441, -0.239> <-0.051, -0.468, -0.137> 
   		<0.116, -0.055, -0.170> <0.085, -0.101, -0.134> <-0.031, -0.263, -0.126> <-0.080, -0.233, -0.093> 
   		<0.110, -0.103, -0.204> <0.078, -0.148, -0.169> <-0.040, -0.164, -0.151> <-0.089, -0.135, -0.118> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<0.037, -0.122, -0.169> <-0.009, -0.160, -0.023> <0.012, -0.132, 0.214> <-0.010, -0.060, 0.353> 
   		<-0.099, -0.081, -0.111> <-0.146, -0.119, 0.035> <0.005, -0.164, 0.266> <-0.018, -0.092, 0.405> 
   		<-0.007, -0.181, 0.238> <-0.010, -0.149, 0.292> <-0.042, -0.190, 0.460> <-0.036, -0.143, 0.501> 
   		<-0.117, -0.112, 0.320> <-0.121, -0.080, 0.374> <-0.097, -0.181, 0.485> <-0.091, -0.134, 0.525> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.010, -0.060, 0.353> <-0.034, 0.019, 0.504> <-0.078, 0.228, 0.624> <-0.108, 0.352, 0.740> 
   		<-0.018, -0.092, 0.405> <-0.042, -0.013, 0.556> <-0.107, 0.281, 0.634> <-0.136, 0.404, 0.750> 
   		<-0.036, -0.143, 0.501> <-0.025, -0.063, 0.569> <-0.052, 0.153, 0.605> <-0.047, 0.257, 0.626> 
   		<-0.091, -0.134, 0.525> <-0.081, -0.054, 0.593> <-0.080, 0.108, 0.575> <-0.075, 0.212, 0.597> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.091, -0.134, 0.525> <-0.081, -0.054, 0.593> <-0.080, 0.108, 0.575> <-0.075, 0.212, 0.597> 
   		<-0.194, -0.116, 0.570> <-0.183, -0.036, 0.638> <-0.139, 0.013, 0.513> <-0.134, 0.117, 0.535> 
   		<-0.335, -0.032, 0.535> <-0.327, -0.057, 0.564> <-0.301, 0.040, 0.527> <-0.280, 0.016, 0.505> 
   		<-0.439, 0.012, 0.540> <-0.432, -0.013, 0.569> <-0.389, -0.044, 0.488> <-0.368, -0.068, 0.466> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.091, -0.134, 0.525> <-0.194, -0.116, 0.570> <-0.335, -0.032, 0.535> <-0.439, 0.012, 0.540> 
   		<-0.097, -0.181, 0.485> <-0.200, -0.164, 0.529> <-0.357, 0.045, 0.449> <-0.462, 0.088, 0.454> 
   		<-0.121, -0.080, 0.374> <-0.218, -0.019, 0.446> <-0.410, 0.097, 0.323> <-0.507, 0.184, 0.283> 
   		<-0.117, -0.112, 0.320> <-0.215, -0.050, 0.392> <-0.344, 0.092, 0.227> <-0.441, 0.179, 0.187> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.117, -0.112, 0.320> <-0.215, -0.050, 0.392> <-0.344, 0.092, 0.227> <-0.441, 0.179, 0.187> 
   		<-0.110, -0.188, 0.190> <-0.207, -0.127, 0.263> <-0.289, 0.087, 0.146> <-0.386, 0.174, 0.106> 
   		<-0.067, -0.455, 0.115> <-0.184, -0.479, 0.208> <-0.214, -0.122, 0.158> <-0.250, 0.014, 0.215> 
   		<-0.058, -0.463, -0.035> <-0.175, -0.487, 0.058> <-0.140, -0.145, 0.098> <-0.175, -0.009, 0.155> 
   	}
   	bicubic_patch {
   		type 1
   		flatness 0
   		u_steps 3
   		v_steps 3
   		<-0.058, -0.463, -0.035> <-0.175, -0.487, 0.058> <-0.140, -0.145, 0.098> <-0.175, -0.009, 0.155> 
   		<-0.051, -0.468, -0.137> <-0.168, -0.493, -0.043> <-0.096, -0.159, 0.063> <-0.132, -0.023, 0.120> 
   		<-0.080, -0.233, -0.093> <-0.157, -0.186, -0.042> <-0.183, 0.005, 0.028> <-0.235, 0.082, 0.076> 
   		<-0.089, -0.135, -0.118> <-0.166, -0.088, -0.067> <-0.209, 0.045, -0.006> <-0.260, 0.122, 0.042> 
   	} 
   }     
   
#if(crumpled = 0) object{flatPaper     #end
#if(crumpled = 1) object{crumpledPaper #end
   texture{pigment{rgb 1}}      
   
      #if(havePic = 1)
         texture{
            pigment{
               image_map{gif pic map_type 0 interpolate 2}
               scale <8.5*inch, 11*inch, 1>
               rotate 90*x
            }//pigment
         }//texture
      #end

      #if(lined = 1)
         #if(crumpled = 0)
            texture{linedPaperTexture translate <.4,0,.4>} 
         #else
            texture{linedPaperTexture} 
         #end
      #end
}

#end   

