#declare cam = off;
#declare lig = off;
#if (cam)
  camera {  //  Camera Camera01
    location  <    -10.710,     -18.240,       2.340>
    direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
    sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
    up        <        0.0,         0.0,         1.0> // Where Z is up
    right     <    1.33333,         0.0,         0.0> // Aspect ratio
    look_at   <     -0.060,       4.250,       3.170>
  }
#end

// *******  L I G H T S *******

#if (lig)
  light_source { <5000,-6000,5000> color rgb <1,0.9,0.7> }
  light_source { <-10,-18,2.3> color rgb <1,0.9,0.7>*0.1 }
  light_source { <-10,38,2.3> color rgb <0.4,0.3,0.1>*0.5 }
#end

// ********  TEXTURES  *******

#include "bear.inc"


// ********  OBJECTS  *******

#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.206267, -1.322029, 8.251853>, <2.383679, -1.206316, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <2.206267, -1.130577, 8.835227>, <2.206267, -1.214612, 8.579162>, <2.164215, -1.041883, 7.943302>, <2.334808, -0.833248, 7.943302>, 
      <2.336214, -0.893775, 9.072532>, <2.147993, -0.752751, 9.072532>, <2.308890, -0.640707, 8.470823>, <2.308890, -0.714044, 8.247358>, 
      <2.554273, -0.627091, 9.072532>, <2.366052, -0.486067, 9.072532>, <2.308890, -0.555197, 8.731382>, <2.308890, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.206267, -1.322029, 8.251853>, <2.383679, -1.206316, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <2.206267, -1.130577, 8.835227>, <2.206267, -1.214612, 8.579162>, <2.571900, -1.347340, 7.943302>, <2.742494, -1.138705, 7.943302>, 
      <2.336214, -0.893775, 9.072532>, <2.555678, -1.058208, 9.072532>, <2.799655, -0.984065, 8.545010>, <2.799655, -1.069575, 8.284453>, 
      <2.554273, -0.627091, 9.072532>, <2.773737, -0.791524, 9.072532>, <2.799655, -0.910728, 8.768475>, <2.799655, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.206267, -1.130577, 8.835227>, <2.336214, -0.893775, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.277354, 8.835227>, <2.555678, -1.058208, 9.072532>, <2.773737, -0.791524, 9.072532>, 
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.277354, 8.835227>, <2.644706, -1.100229, 8.768475>, <2.799655, -0.910728, 8.768475>, 
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.384770, 8.507918>, <2.644706, -1.185739, 8.507918>, <2.799655, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.206267, -1.322029, 8.251853>, <2.383679, -1.206316, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.468805, 8.251853>, <2.571900, -1.347340, 7.943302>, <2.742494, -1.138705, 7.943302>, 
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.468805, 8.251853>, <2.644706, -1.259075, 8.284453>, <2.799655, -1.069575, 8.284453>, 
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.384770, 8.507918>, <2.644706, -1.185739, 8.507918>, <2.799655, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.206267, -1.322029, 8.251853>, <2.383679, -1.206316, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <2.206267, -1.237994, 8.507918>, <2.017311, -1.180454, 8.251853>, <2.164215, -1.041883, 7.943302>, <2.334808, -0.833248, 7.943302>, 
      <2.206267, -1.237994, 8.507918>, <2.017311, -1.180454, 8.251853>, <2.159433, -0.896829, 8.247358>, <2.308890, -0.714044, 8.247358>, 
      <2.206267, -1.237994, 8.507918>, <2.017311, -1.096419, 8.507918>, <2.159433, -0.811319, 8.507918>, <2.308890, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.017311, -1.096419, 8.507918>, <2.159433, -0.811319, 8.507918>, <2.308890, -0.628534, 8.507918>, 
      <2.402166, -1.384770, 8.507918>, <2.213209, -1.243195, 8.507918>, <2.159433, -0.896829, 8.247358>, <2.308890, -0.714044, 8.247358>, 
      <2.644706, -1.185739, 8.507918>, <2.644706, -1.259075, 8.284453>, <2.523029, -0.974272, 7.943302>, <2.334808, -0.833248, 7.943302>, 
      <2.799655, -0.996238, 8.507918>, <2.799655, -1.069575, 8.284453>, <2.742494, -1.138705, 7.943302>, <2.554273, -0.997681, 7.943302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.206267, -1.130577, 8.835227>, <2.336214, -0.893775, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <2.206267, -1.237994, 8.507918>, <2.017311, -0.989003, 8.835227>, <2.147993, -0.752751, 9.072532>, <2.366052, -0.486067, 9.072532>, 
      <2.206267, -1.237994, 8.507918>, <2.017311, -0.989003, 8.835227>, <2.159433, -0.737983, 8.731382>, <2.308890, -0.555197, 8.731382>, 
      <2.206267, -1.237994, 8.507918>, <2.017311, -1.096419, 8.507918>, <2.159433, -0.811319, 8.507918>, <2.308890, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.206267, -1.237994, 8.507918>, <2.402166, -1.384770, 8.507918>, <2.644706, -1.185739, 8.507918>, <2.799655, -0.996238, 8.507918>, 
      <2.017311, -1.096419, 8.507918>, <2.213209, -1.243195, 8.507918>, <2.644706, -1.100229, 8.768475>, <2.799655, -0.910728, 8.768475>, 
      <2.159433, -0.811319, 8.507918>, <2.159433, -0.737983, 8.731382>, <2.585516, -0.650500, 9.072532>, <2.773737, -0.791524, 9.072532>, 
      <2.308890, -0.628534, 8.507918>, <2.308890, -0.555197, 8.731382>, <2.366052, -0.486067, 9.072532>, <2.554273, -0.627091, 9.072532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.302744, 8.763981>, <2.724866, -0.418457, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <2.902277, -0.494195, 8.180608>, <2.902277, -0.410160, 8.436671>, <2.944330, -0.582890, 9.072532>, <2.773737, -0.791524, 9.072532>, 
      <2.772331, -0.730997, 7.943302>, <2.960552, -0.872021, 7.943302>, <2.799655, -0.984065, 8.545010>, <2.799655, -0.910728, 8.768475>, 
      <2.554273, -0.997681, 7.943302>, <2.742494, -1.138705, 7.943302>, <2.799655, -1.069575, 8.284453>, <2.799655, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.302744, 8.763981>, <2.724866, -0.418457, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <2.902277, -0.494195, 8.180608>, <2.902277, -0.410160, 8.436671>, <2.536645, -0.277433, 9.072532>, <2.366052, -0.486067, 9.072532>, 
      <2.772331, -0.730997, 7.943302>, <2.552867, -0.566564, 7.943302>, <2.308890, -0.640707, 8.470823>, <2.308890, -0.555197, 8.731382>, 
      <2.554273, -0.997681, 7.943302>, <2.334808, -0.833248, 7.943302>, <2.308890, -0.714044, 8.247358>, <2.308890, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.494195, 8.180608>, <2.772331, -0.730997, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <2.706379, -0.240003, 8.507918>, <2.706379, -0.347419, 8.180608>, <2.601737, -0.939632, 7.943302>, <2.383679, -1.206316, 7.943302>, 
      <2.463838, -0.439034, 8.507918>, <2.314381, -0.621819, 8.507918>, <2.017311, -1.180454, 8.251853>, <2.206267, -1.322029, 8.251853>, 
      <2.308890, -0.628534, 8.507918>, <2.159433, -0.811319, 8.507918>, <2.017311, -1.096419, 8.507918>, <2.206267, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.240003, 8.507918>, <2.463838, -0.439034, 8.507918>, <2.308890, -0.628534, 8.507918>, 
      <2.902277, -0.302744, 8.763981>, <2.706379, -0.155968, 8.763981>, <2.314381, -0.621819, 8.507918>, <2.159433, -0.811319, 8.507918>, 
      <2.724866, -0.418457, 9.072532>, <2.506807, -0.685141, 9.072532>, <2.017311, -0.989003, 8.835227>, <2.017311, -1.096419, 8.507918>, 
      <2.554273, -0.627091, 9.072532>, <2.336214, -0.893775, 9.072532>, <2.206267, -1.130577, 8.835227>, <2.206267, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.240003, 8.507918>, <2.463838, -0.439034, 8.507918>, <2.308890, -0.628534, 8.507918>, 
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.347419, 8.180608>, <2.463838, -0.524544, 8.247358>, <2.308890, -0.714044, 8.247358>, 
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.347419, 8.180608>, <2.552867, -0.566564, 7.943302>, <2.334808, -0.833248, 7.943302>, 
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.494195, 8.180608>, <2.772331, -0.730997, 7.943302>, <2.554273, -0.997681, 7.943302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.302744, 8.763981>, <2.724866, -0.418457, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.155968, 8.763981>, <2.536645, -0.277433, 9.072532>, <2.366052, -0.486067, 9.072532>, 
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.155968, 8.763981>, <2.463838, -0.365697, 8.731382>, <2.308890, -0.555197, 8.731382>, 
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.240003, 8.507918>, <2.463838, -0.439034, 8.507918>, <2.308890, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.494195, 8.180608>, <2.772331, -0.730997, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <3.091233, -0.528354, 8.507918>, <3.091233, -0.635770, 8.180608>, <2.601737, -0.939632, 7.943302>, <2.383679, -1.206316, 7.943302>, 
      <2.949112, -0.813453, 8.507918>, <2.794164, -1.002954, 8.507918>, <2.402166, -1.468805, 8.251853>, <2.206267, -1.322029, 8.251853>, 
      <2.799655, -0.996238, 8.507918>, <2.644706, -1.185739, 8.507918>, <2.402166, -1.384770, 8.507918>, <2.206267, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.302744, 8.763981>, <2.724866, -0.418457, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <3.091233, -0.528354, 8.507918>, <3.091233, -0.444319, 8.763981>, <2.506807, -0.685141, 9.072532>, <2.336214, -0.893775, 9.072532>, 
      <2.949112, -0.813453, 8.507918>, <2.794164, -1.002954, 8.507918>, <2.402166, -1.277354, 8.835227>, <2.206267, -1.130577, 8.835227>, 
      <2.799655, -0.996238, 8.507918>, <2.644706, -1.185739, 8.507918>, <2.402166, -1.384770, 8.507918>, <2.206267, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.302744, 8.763981>, <2.724866, -0.418457, 9.072532>, <2.554273, -0.627091, 9.072532>, 
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.444319, 8.763981>, <2.944330, -0.582890, 9.072532>, <2.773737, -0.791524, 9.072532>, 
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.444319, 8.763981>, <2.949112, -0.727943, 8.768475>, <2.799655, -0.910728, 8.768475>, 
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.528354, 8.507918>, <2.949112, -0.813453, 8.507918>, <2.799655, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.706379, -0.240003, 8.507918>, <2.463838, -0.439034, 8.507918>, <2.308890, -0.628534, 8.507918>, 
      <3.091233, -0.528354, 8.507918>, <2.895335, -0.381578, 8.507918>, <2.463838, -0.365697, 8.731382>, <2.308890, -0.555197, 8.731382>, 
      <2.949112, -0.813453, 8.507918>, <2.949112, -0.727943, 8.768475>, <2.585516, -0.650500, 9.072532>, <2.366052, -0.486067, 9.072532>, 
      <2.799655, -0.996238, 8.507918>, <2.799655, -0.910728, 8.768475>, <2.773737, -0.791524, 9.072532>, <2.554273, -0.627091, 9.072532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <2.902277, -0.494195, 8.180608>, <2.772331, -0.730997, 7.943302>, <2.554273, -0.997681, 7.943302>, 
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.635770, 8.180608>, <2.960552, -0.872021, 7.943302>, <2.742494, -1.138705, 7.943302>, 
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.635770, 8.180608>, <2.949112, -0.886789, 8.284453>, <2.799655, -1.069575, 8.284453>, 
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.528354, 8.507918>, <2.949112, -0.813453, 8.507918>, <2.799655, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.902277, -0.386779, 8.507918>, <3.091233, -0.528354, 8.507918>, <2.949112, -0.813453, 8.507918>, <2.799655, -0.996238, 8.507918>, 
      <2.706379, -0.240003, 8.507918>, <2.895335, -0.381578, 8.507918>, <2.949112, -0.886789, 8.284453>, <2.799655, -1.069575, 8.284453>, 
      <2.463838, -0.439034, 8.507918>, <2.463838, -0.524544, 8.247358>, <2.523029, -0.974272, 7.943302>, <2.742494, -1.138705, 7.943302>, 
      <2.308890, -0.628534, 8.507918>, <2.308890, -0.714044, 8.247358>, <2.334808, -0.833248, 7.943302>, <2.554273, -0.997681, 7.943302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.805305, -1.322029, 8.251854>, <0.627893, -1.206316, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <0.805305, -1.130577, 8.835227>, <0.805305, -1.214612, 8.579163>, <0.847358, -1.041883, 7.943302>, <0.676764, -0.833248, 7.943302>, 
      <0.675358, -0.893775, 9.072532>, <0.863579, -0.752751, 9.072532>, <0.702683, -0.640707, 8.470823>, <0.702683, -0.714044, 8.247358>, 
      <0.457300, -0.627091, 9.072532>, <0.645521, -0.486067, 9.072532>, <0.702683, -0.555197, 8.731382>, <0.702683, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.805305, -1.322029, 8.251854>, <0.627893, -1.206316, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <0.805305, -1.130577, 8.835227>, <0.805305, -1.214612, 8.579163>, <0.439673, -1.347340, 7.943302>, <0.269079, -1.138705, 7.943302>, 
      <0.675358, -0.893775, 9.072532>, <0.455894, -1.058208, 9.072532>, <0.211918, -0.984065, 8.545010>, <0.211918, -1.069575, 8.284453>, 
      <0.457300, -0.627091, 9.072532>, <0.237836, -0.791524, 9.072532>, <0.211918, -0.910728, 8.768475>, <0.211918, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.805305, -1.130577, 8.835227>, <0.675358, -0.893775, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.277354, 8.835227>, <0.455894, -1.058208, 9.072532>, <0.237836, -0.791524, 9.072532>, 
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.277354, 8.835227>, <0.366866, -1.100229, 8.768475>, <0.211918, -0.910728, 8.768475>, 
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.384770, 8.507918>, <0.366866, -1.185739, 8.507918>, <0.211918, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.805305, -1.322029, 8.251854>, <0.627893, -1.206316, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.468805, 8.251854>, <0.439673, -1.347340, 7.943302>, <0.269079, -1.138705, 7.943302>, 
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.468805, 8.251854>, <0.366866, -1.259075, 8.284453>, <0.211918, -1.069575, 8.284453>, 
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.384770, 8.507918>, <0.366866, -1.185739, 8.507918>, <0.211918, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.805305, -1.322029, 8.251854>, <0.627893, -1.206316, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <0.805305, -1.237994, 8.507918>, <0.994261, -1.180454, 8.251854>, <0.847358, -1.041883, 7.943302>, <0.676764, -0.833248, 7.943302>, 
      <0.805305, -1.237994, 8.507918>, <0.994261, -1.180454, 8.251854>, <0.852140, -0.896829, 8.247358>, <0.702683, -0.714044, 8.247358>, 
      <0.805305, -1.237994, 8.507918>, <0.994261, -1.096419, 8.507918>, <0.852140, -0.811319, 8.507918>, <0.702683, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.994261, -1.096419, 8.507918>, <0.852140, -0.811319, 8.507918>, <0.702683, -0.628534, 8.507918>, 
      <0.609407, -1.384770, 8.507918>, <0.798363, -1.243195, 8.507918>, <0.852140, -0.896829, 8.247358>, <0.702683, -0.714044, 8.247358>, 
      <0.366866, -1.185739, 8.507918>, <0.366866, -1.259075, 8.284453>, <0.488544, -0.974272, 7.943302>, <0.676764, -0.833248, 7.943302>, 
      <0.211918, -0.996238, 8.507918>, <0.211918, -1.069575, 8.284453>, <0.269079, -1.138705, 7.943302>, <0.457300, -0.997681, 7.943302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.805305, -1.130577, 8.835227>, <0.675358, -0.893775, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <0.805305, -1.237994, 8.507918>, <0.994261, -0.989003, 8.835227>, <0.863579, -0.752751, 9.072532>, <0.645521, -0.486067, 9.072532>, 
      <0.805305, -1.237994, 8.507918>, <0.994261, -0.989003, 8.835227>, <0.852140, -0.737983, 8.731382>, <0.702683, -0.555197, 8.731382>, 
      <0.805305, -1.237994, 8.507918>, <0.994261, -1.096419, 8.507918>, <0.852140, -0.811319, 8.507918>, <0.702683, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.805305, -1.237994, 8.507918>, <0.609407, -1.384770, 8.507918>, <0.366866, -1.185739, 8.507918>, <0.211918, -0.996238, 8.507918>, 
      <0.994261, -1.096419, 8.507918>, <0.798363, -1.243195, 8.507918>, <0.366866, -1.100229, 8.768475>, <0.211918, -0.910728, 8.768475>, 
      <0.852140, -0.811319, 8.507918>, <0.852140, -0.737983, 8.731382>, <0.426057, -0.650500, 9.072532>, <0.237836, -0.791524, 9.072532>, 
      <0.702683, -0.628534, 8.507918>, <0.702683, -0.555197, 8.731382>, <0.645521, -0.486067, 9.072532>, <0.457300, -0.627091, 9.072532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.302744, 8.763981>, <0.286707, -0.418457, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <0.109296, -0.494195, 8.180608>, <0.109296, -0.410160, 8.436671>, <0.067243, -0.582889, 9.072532>, <0.237836, -0.791524, 9.072532>, 
      <0.239242, -0.730997, 7.943302>, <0.051021, -0.872021, 7.943302>, <0.211918, -0.984065, 8.545010>, <0.211918, -0.910728, 8.768475>, 
      <0.457300, -0.997681, 7.943302>, <0.269079, -1.138705, 7.943302>, <0.211918, -1.069575, 8.284453>, <0.211918, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.302744, 8.763981>, <0.286707, -0.418457, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <0.109296, -0.494195, 8.180608>, <0.109296, -0.410160, 8.436671>, <0.474928, -0.277433, 9.072532>, <0.645521, -0.486067, 9.072532>, 
      <0.239242, -0.730997, 7.943302>, <0.458706, -0.566564, 7.943302>, <0.702683, -0.640707, 8.470823>, <0.702683, -0.555197, 8.731382>, 
      <0.457300, -0.997681, 7.943302>, <0.676764, -0.833248, 7.943302>, <0.702683, -0.714044, 8.247358>, <0.702683, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.494195, 8.180608>, <0.239242, -0.730997, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <0.305194, -0.240003, 8.507918>, <0.305194, -0.347419, 8.180608>, <0.409835, -0.939632, 7.943302>, <0.627893, -1.206316, 7.943302>, 
      <0.547735, -0.439034, 8.507918>, <0.697192, -0.621819, 8.507918>, <0.994261, -1.180454, 8.251854>, <0.805305, -1.322029, 8.251854>, 
      <0.702683, -0.628534, 8.507918>, <0.852140, -0.811319, 8.507918>, <0.994261, -1.096419, 8.507918>, <0.805305, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.240003, 8.507918>, <0.547735, -0.439034, 8.507918>, <0.702683, -0.628534, 8.507918>, 
      <0.109296, -0.302744, 8.763981>, <0.305194, -0.155968, 8.763981>, <0.697192, -0.621819, 8.507918>, <0.852140, -0.811319, 8.507918>, 
      <0.286707, -0.418457, 9.072532>, <0.504765, -0.685141, 9.072532>, <0.994261, -0.989003, 8.835227>, <0.994261, -1.096419, 8.507918>, 
      <0.457300, -0.627091, 9.072532>, <0.675358, -0.893775, 9.072532>, <0.805305, -1.130577, 8.835227>, <0.805305, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.240003, 8.507918>, <0.547735, -0.439034, 8.507918>, <0.702683, -0.628534, 8.507918>, 
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.347419, 8.180608>, <0.547735, -0.524544, 8.247358>, <0.702683, -0.714044, 8.247358>, 
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.347419, 8.180608>, <0.458706, -0.566564, 7.943302>, <0.676764, -0.833248, 7.943302>, 
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.494195, 8.180608>, <0.239242, -0.730997, 7.943302>, <0.457300, -0.997681, 7.943302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.302744, 8.763981>, <0.286707, -0.418457, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.155968, 8.763981>, <0.474928, -0.277433, 9.072532>, <0.645521, -0.486067, 9.072532>, 
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.155968, 8.763981>, <0.547735, -0.365697, 8.731382>, <0.702683, -0.555197, 8.731382>, 
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.240003, 8.507918>, <0.547735, -0.439034, 8.507918>, <0.702683, -0.628534, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.494195, 8.180608>, <0.239242, -0.730997, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <-0.079660, -0.528354, 8.507918>, <-0.079660, -0.635770, 8.180608>, <0.409835, -0.939632, 7.943302>, <0.627893, -1.206316, 7.943302>, 
      <0.062461, -0.813453, 8.507918>, <0.217409, -1.002953, 8.507918>, <0.609407, -1.468805, 8.251854>, <0.805305, -1.322029, 8.251854>, 
      <0.211918, -0.996238, 8.507918>, <0.366866, -1.185739, 8.507918>, <0.609407, -1.384770, 8.507918>, <0.805305, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.302744, 8.763981>, <0.286707, -0.418457, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <-0.079660, -0.528354, 8.507918>, <-0.079660, -0.444319, 8.763981>, <0.504765, -0.685141, 9.072532>, <0.675358, -0.893775, 9.072532>, 
      <0.062461, -0.813453, 8.507918>, <0.217409, -1.002953, 8.507918>, <0.609407, -1.277354, 8.835227>, <0.805305, -1.130577, 8.835227>, 
      <0.211918, -0.996238, 8.507918>, <0.366866, -1.185739, 8.507918>, <0.609407, -1.384770, 8.507918>, <0.805305, -1.237994, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.302744, 8.763981>, <0.286707, -0.418457, 9.072532>, <0.457300, -0.627091, 9.072532>, 
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.444319, 8.763981>, <0.067243, -0.582889, 9.072532>, <0.237836, -0.791524, 9.072532>, 
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.444319, 8.763981>, <0.062461, -0.727943, 8.768475>, <0.211918, -0.910728, 8.768475>, 
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.528354, 8.507918>, <0.062461, -0.813453, 8.507918>, <0.211918, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.305194, -0.240003, 8.507918>, <0.547735, -0.439034, 8.507918>, <0.702683, -0.628534, 8.507918>, 
      <-0.079660, -0.528354, 8.507918>, <0.116238, -0.381578, 8.507918>, <0.547735, -0.365697, 8.731382>, <0.702683, -0.555197, 8.731382>, 
      <0.062461, -0.813453, 8.507918>, <0.062461, -0.727943, 8.768475>, <0.426057, -0.650500, 9.072532>, <0.645521, -0.486067, 9.072532>, 
      <0.211918, -0.996238, 8.507918>, <0.211918, -0.910728, 8.768475>, <0.237836, -0.791524, 9.072532>, <0.457300, -0.627091, 9.072532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <0.109296, -0.494195, 8.180608>, <0.239242, -0.730997, 7.943302>, <0.457300, -0.997681, 7.943302>, 
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.635770, 8.180608>, <0.051021, -0.872021, 7.943302>, <0.269079, -1.138705, 7.943302>, 
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.635770, 8.180608>, <0.062461, -0.886789, 8.284453>, <0.211918, -1.069575, 8.284453>, 
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.528354, 8.507918>, <0.062461, -0.813453, 8.507918>, <0.211918, -0.996238, 8.507918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.109296, -0.386779, 8.507918>, <-0.079660, -0.528354, 8.507918>, <0.062461, -0.813453, 8.507918>, <0.211918, -0.996238, 8.507918>, 
      <0.305194, -0.240003, 8.507918>, <0.116238, -0.381578, 8.507918>, <0.062461, -0.886789, 8.284453>, <0.211918, -1.069575, 8.284453>, 
      <0.547735, -0.439034, 8.507918>, <0.547735, -0.524544, 8.247358>, <0.488544, -0.974272, 7.943302>, <0.269079, -1.138705, 7.943302>, 
      <0.702683, -0.628534, 8.507918>, <0.702683, -0.714044, 8.247358>, <0.676764, -0.833248, 7.943302>, <0.457300, -0.997681, 7.943302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.249235, 7.554272>, <1.653676, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.786402, -2.151415, 7.850498>, <1.786402, -2.200325, 7.702386>, <1.653676, -2.055226, 7.350432>, <1.497696, -2.055226, 7.350432>, 
      <1.653676, -2.109797, 7.976531>, <1.653676, -1.874171, 7.898722>, <1.497696, -1.647829, 7.519941>, <1.497696, -1.686350, 7.403286>, 
      <1.497696, -2.109797, 7.976531>, <1.497696, -1.874171, 7.898722>, <1.497696, -1.609307, 7.636596>, <1.497696, -1.647829, 7.519941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.249235, 7.554272>, <1.653676, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.786402, -2.151415, 7.850498>, <1.786402, -2.200325, 7.702386>, <1.653676, -2.439333, 7.477271>, <1.497696, -2.439333, 7.477271>, 
      <1.653676, -2.109797, 7.976531>, <1.653676, -2.258278, 8.025562>, <1.497696, -2.475829, 7.793362>, <1.497696, -2.524860, 7.644881>, 
      <1.497696, -2.109797, 7.976531>, <1.497696, -2.258278, 8.025562>, <1.497696, -2.426798, 7.941843>, <1.497696, -2.475829, 7.793362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.151415, 7.850498>, <1.653676, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.299896, 7.899530>, <1.653676, -2.258278, 8.025562>, <1.497696, -2.258278, 8.025562>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.299896, 7.899530>, <1.654063, -2.426798, 7.941843>, <1.497696, -2.426798, 7.941843>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.348806, 7.751416>, <1.654063, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.249235, 7.554272>, <1.653676, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.397716, 7.603303>, <1.653676, -2.439333, 7.477271>, <1.497696, -2.439333, 7.477271>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.397716, 7.603303>, <1.654063, -2.524860, 7.644881>, <1.497696, -2.524860, 7.644881>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.348806, 7.751416>, <1.654063, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.249235, 7.554272>, <1.653676, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.013609, 7.476464>, <1.653676, -2.055226, 7.350432>, <1.497696, -2.055226, 7.350432>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.013609, 7.476464>, <1.620547, -1.686350, 7.403286>, <1.497696, -1.686350, 7.403286>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -1.964699, 7.624577>, <1.620547, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -1.964699, 7.624577>, <1.620547, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>, 
      <1.786402, -2.348806, 7.751416>, <1.786402, -2.113180, 7.673608>, <1.620547, -1.686350, 7.403286>, <1.497696, -1.686350, 7.403286>, 
      <1.654063, -2.475829, 7.793362>, <1.654063, -2.524860, 7.644881>, <1.497696, -2.203707, 7.399463>, <1.497696, -2.055226, 7.350432>, 
      <1.497696, -2.475829, 7.793362>, <1.497696, -2.524860, 7.644881>, <1.497696, -2.439333, 7.477271>, <1.497696, -2.290852, 7.428240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.151415, 7.850498>, <1.653676, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -1.915789, 7.772690>, <1.653676, -1.874171, 7.898722>, <1.497696, -1.874171, 7.898722>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -1.915789, 7.772690>, <1.620547, -1.609307, 7.636596>, <1.497696, -1.609307, 7.636596>, 
      <1.786402, -2.200325, 7.702385>, <1.786402, -1.964699, 7.624577>, <1.620547, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786402, -2.200325, 7.702385>, <1.786402, -2.348806, 7.751416>, <1.654063, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>, 
      <1.786402, -1.964699, 7.624577>, <1.786402, -2.113180, 7.673608>, <1.654063, -2.426798, 7.941843>, <1.497696, -2.426798, 7.941843>, 
      <1.620547, -1.647829, 7.519941>, <1.620547, -1.609307, 7.636596>, <1.497696, -2.022652, 7.947754>, <1.497696, -2.258278, 8.025562>, 
      <1.497696, -1.647829, 7.519941>, <1.497696, -1.609307, 7.636596>, <1.497696, -1.874171, 7.898722>, <1.497696, -2.109797, 7.976531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.151415, 7.850498>, <1.341716, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.208991, -2.249234, 7.554272>, <1.208991, -2.200325, 7.702386>, <1.341716, -2.258278, 8.025562>, <1.497696, -2.258278, 8.025562>, 
      <1.341716, -2.290852, 7.428240>, <1.341716, -2.439333, 7.477271>, <1.497696, -2.475829, 7.793362>, <1.497696, -2.426798, 7.941843>, 
      <1.497696, -2.290852, 7.428240>, <1.497696, -2.439333, 7.477271>, <1.497696, -2.524860, 7.644881>, <1.497696, -2.475829, 7.793362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.151415, 7.850498>, <1.341716, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.208991, -2.249234, 7.554272>, <1.208991, -2.200325, 7.702386>, <1.341716, -1.874171, 7.898722>, <1.497696, -1.874171, 7.898722>, 
      <1.341716, -2.290852, 7.428240>, <1.341716, -2.055226, 7.350432>, <1.497696, -1.647829, 7.519941>, <1.497696, -1.609307, 7.636596>, 
      <1.497696, -2.290852, 7.428240>, <1.497696, -2.055226, 7.350432>, <1.497696, -1.686350, 7.403286>, <1.497696, -1.647829, 7.519941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.249234, 7.554272>, <1.341716, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.208991, -1.964699, 7.624577>, <1.208991, -2.013609, 7.476464>, <1.497696, -2.290852, 7.428240>, <1.653676, -2.290852, 7.428240>, 
      <1.374845, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>, <1.786402, -2.013609, 7.476464>, <1.786402, -2.249235, 7.554272>, 
      <1.497696, -1.647829, 7.519941>, <1.620547, -1.647829, 7.519941>, <1.786402, -1.964699, 7.624577>, <1.786402, -2.200325, 7.702385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -1.964699, 7.624577>, <1.374845, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>, 
      <1.208991, -2.151415, 7.850498>, <1.208991, -1.915790, 7.772690>, <1.497696, -1.647829, 7.519941>, <1.620547, -1.647829, 7.519941>, 
      <1.341716, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, <1.786402, -1.915789, 7.772690>, <1.786402, -1.964699, 7.624577>, 
      <1.497696, -2.109797, 7.976531>, <1.653676, -2.109797, 7.976531>, <1.786402, -2.151415, 7.850498>, <1.786402, -2.200325, 7.702385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -1.964699, 7.624577>, <1.374845, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.013609, 7.476464>, <1.374845, -1.686350, 7.403286>, <1.497696, -1.686350, 7.403286>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.013609, 7.476464>, <1.341716, -2.055226, 7.350432>, <1.497696, -2.055226, 7.350432>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.249234, 7.554272>, <1.341716, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.151415, 7.850498>, <1.341716, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -1.915790, 7.772690>, <1.341716, -1.874171, 7.898722>, <1.497696, -1.874171, 7.898722>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -1.915790, 7.772690>, <1.374845, -1.609307, 7.636596>, <1.497696, -1.609307, 7.636596>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -1.964699, 7.624577>, <1.374845, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.249234, 7.554272>, <1.341716, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.208991, -2.348806, 7.751416>, <1.208991, -2.397715, 7.603303>, <1.497696, -2.290852, 7.428240>, <1.653676, -2.290852, 7.428240>, 
      <1.341329, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>, <1.786402, -2.397716, 7.603303>, <1.786402, -2.249235, 7.554272>, 
      <1.497696, -2.475829, 7.793362>, <1.654063, -2.475829, 7.793362>, <1.786402, -2.348806, 7.751416>, <1.786402, -2.200325, 7.702385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.151415, 7.850498>, <1.341716, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.208991, -2.348806, 7.751416>, <1.208991, -2.299896, 7.899530>, <1.497696, -2.109797, 7.976531>, <1.653676, -2.109797, 7.976531>, 
      <1.341329, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>, <1.786402, -2.299896, 7.899530>, <1.786402, -2.151415, 7.850498>, 
      <1.497696, -2.475829, 7.793362>, <1.654063, -2.475829, 7.793362>, <1.786402, -2.348806, 7.751416>, <1.786402, -2.200325, 7.702385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.151415, 7.850498>, <1.341716, -2.109797, 7.976531>, <1.497696, -2.109797, 7.976531>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.299896, 7.899530>, <1.341716, -2.258278, 8.025562>, <1.497696, -2.258278, 8.025562>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.299896, 7.899530>, <1.341329, -2.426798, 7.941843>, <1.497696, -2.426798, 7.941843>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.348806, 7.751416>, <1.341329, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -1.964699, 7.624577>, <1.374845, -1.647829, 7.519941>, <1.497696, -1.647829, 7.519941>, 
      <1.208991, -2.348806, 7.751416>, <1.208991, -2.113180, 7.673608>, <1.374845, -1.609307, 7.636596>, <1.497696, -1.609307, 7.636596>, 
      <1.341329, -2.475829, 7.793362>, <1.341329, -2.426798, 7.941843>, <1.497696, -2.022652, 7.947754>, <1.497696, -1.874171, 7.898722>, 
      <1.497696, -2.475829, 7.793362>, <1.497696, -2.426798, 7.941843>, <1.497696, -2.258278, 8.025562>, <1.497696, -2.109797, 7.976531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.249234, 7.554272>, <1.341716, -2.290852, 7.428240>, <1.497696, -2.290852, 7.428240>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.397715, 7.603303>, <1.341716, -2.439333, 7.477271>, <1.497696, -2.439333, 7.477271>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.397715, 7.603303>, <1.341329, -2.524860, 7.644881>, <1.497696, -2.524860, 7.644881>, 
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.348806, 7.751416>, <1.341329, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.208991, -2.200325, 7.702385>, <1.208991, -2.348806, 7.751416>, <1.341329, -2.475829, 7.793362>, <1.497696, -2.475829, 7.793362>, 
      <1.208991, -1.964699, 7.624577>, <1.208991, -2.113180, 7.673608>, <1.341329, -2.524860, 7.644881>, <1.497696, -2.524860, 7.644881>, 
      <1.374845, -1.647829, 7.519941>, <1.374845, -1.686350, 7.403286>, <1.497696, -2.203707, 7.399463>, <1.497696, -2.439333, 7.477271>, 
      <1.497696, -1.647829, 7.519941>, <1.497696, -1.686350, 7.403286>, <1.497696, -2.055226, 7.350432>, <1.497696, -2.290852, 7.428240>
    }
  }
  texture {
    Bear_Eye
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.273993, -0.352398, 9.346722>, <2.761769, -0.344679, 8.956280>, <2.296693, -0.222236, 9.161625>, 
      <3.719382, -0.235494, 10.285755>, <3.496688, -0.293946, 9.816239>, <2.695086, -0.748436, 9.036107>, <2.230010, -0.625994, 9.241452>, 
      <3.690794, -0.100833, 10.914982>, <3.623608, -0.507633, 10.995411>, <2.751633, -0.200263, 10.156859>, <2.572737, -0.247219, 9.779685>, 
      <3.225718, 0.021610, 11.120328>, <3.158532, -0.385190, 11.200757>, <2.929191, -0.153658, 10.531213>, <2.750295, -0.200614, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.273993, -0.352398, 9.346722>, <2.761769, -0.344679, 8.956280>, <2.296693, -0.222236, 9.161625>, 
      <3.719382, -0.235494, 10.285755>, <3.496688, -0.293946, 9.816239>, <2.845404, 0.161717, 8.856160>, <2.380328, 0.284160, 9.061506>, 
      <3.690794, -0.100833, 10.914982>, <3.774429, 0.405562, 10.814862>, <2.898762, 0.698339, 9.976305>, <2.676068, 0.639887, 9.506790>, 
      <3.225718, 0.021610, 11.120328>, <3.309352, 0.528005, 11.020208>, <3.121457, 0.756791, 10.445822>, <2.898763, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.719382, -0.235494, 10.285755>, <3.690794, -0.100833, 10.914982>, <3.225718, 0.021610, 11.120328>, 
      <3.496688, -0.293946, 9.816238>, <3.790840, 0.197170, 10.200213>, <3.774429, 0.405562, 10.814862>, <3.309352, 0.528005, 11.020208>, 
      <3.496688, -0.293946, 9.816238>, <3.790840, 0.197170, 10.200213>, <3.518819, 0.652176, 10.270374>, <3.121457, 0.756791, 10.445822>, 
      <3.496688, -0.293946, 9.816238>, <3.568145, 0.138718, 9.730696>, <3.296124, 0.593724, 9.800858>, <2.898763, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.273993, -0.352398, 9.346722>, <2.761769, -0.344679, 8.956280>, <2.296693, -0.222236, 9.161625>, 
      <3.496688, -0.293946, 9.816238>, <3.345451, 0.080267, 9.261180>, <2.845404, 0.161717, 8.856160>, <2.380328, 0.284160, 9.061506>, 
      <3.496688, -0.293946, 9.816238>, <3.345451, 0.080267, 9.261180>, <3.073430, 0.535272, 9.331342>, <2.676068, 0.639887, 9.506790>, 
      <3.496688, -0.293946, 9.816238>, <3.568145, 0.138718, 9.730696>, <3.296124, 0.593724, 9.800858>, <2.898763, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.273993, -0.352398, 9.346722>, <2.761769, -0.344679, 8.956280>, <2.296693, -0.222236, 9.161625>, 
      <3.496688, -0.293946, 9.816238>, <3.223612, -0.657451, 9.407035>, <2.695086, -0.748436, 9.036107>, <2.230010, -0.625994, 9.241452>, 
      <3.496688, -0.293946, 9.816238>, <3.223612, -0.657451, 9.407035>, <2.852899, -0.320978, 9.655985>, <2.572737, -0.247219, 9.779685>, 
      <3.496688, -0.293946, 9.816238>, <3.446306, -0.598999, 9.876550>, <3.030457, -0.274373, 10.030338>, <2.750295, -0.200614, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.446306, -0.598999, 9.876550>, <3.030457, -0.274373, 10.030338>, <2.750295, -0.200614, 10.154038>, 
      <3.568145, 0.138718, 9.730696>, <3.517764, -0.166334, 9.791008>, <2.852899, -0.320978, 9.655985>, <2.572737, -0.247219, 9.779685>, 
      <3.296124, 0.593724, 9.800858>, <3.073430, 0.535272, 9.331342>, <2.313644, -0.119598, 9.141333>, <2.230010, -0.625994, 9.241452>, 
      <2.898763, 0.698339, 9.976306>, <2.676068, 0.639887, 9.506790>, <2.380328, 0.284160, 9.061506>, <2.296693, -0.222236, 9.161625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.719382, -0.235494, 10.285755>, <3.690794, -0.100833, 10.914982>, <3.225718, 0.021610, 11.120328>, 
      <3.496688, -0.293946, 9.816238>, <3.669001, -0.540547, 10.346067>, <3.623608, -0.507633, 10.995411>, <3.158532, -0.385190, 11.200757>, 
      <3.496688, -0.293946, 9.816238>, <3.669001, -0.540547, 10.346067>, <3.209353, -0.227418, 10.407513>, <2.929191, -0.153658, 10.531213>, 
      <3.496688, -0.293946, 9.816238>, <3.446306, -0.598999, 9.876550>, <3.030457, -0.274373, 10.030338>, <2.750295, -0.200614, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.496688, -0.293946, 9.816238>, <3.568145, 0.138718, 9.730696>, <3.296124, 0.593724, 9.800858>, <2.898763, 0.698339, 9.976306>, 
      <3.446306, -0.598999, 9.876550>, <3.517764, -0.166334, 9.791008>, <3.518819, 0.652176, 10.270374>, <3.121457, 0.756791, 10.445822>, 
      <3.030457, -0.274373, 10.030338>, <3.209353, -0.227418, 10.407513>, <3.242167, 0.121205, 11.100638>, <3.309352, 0.528005, 11.020208>, 
      <2.750295, -0.200614, 10.154038>, <2.929191, -0.153658, 10.531213>, <3.158532, -0.385190, 11.200757>, <3.225718, 0.021610, 11.120328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <2.248417, 0.151773, 10.935231>, <2.760642, 0.144053, 11.325673>, <3.225718, 0.021610, 11.120328>, 
      <1.803028, 0.034869, 9.996198>, <2.025723, 0.093321, 10.465714>, <2.844276, 0.650447, 11.225554>, <3.309352, 0.528005, 11.020208>, 
      <1.831617, -0.099793, 9.366971>, <1.915251, 0.406602, 9.266851>, <2.898762, 0.698339, 9.976305>, <3.121457, 0.756791, 10.445822>, 
      <2.296693, -0.222236, 9.161625>, <2.380328, 0.284160, 9.061506>, <2.676068, 0.639887, 9.506790>, <2.898763, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <2.248417, 0.151773, 10.935231>, <2.760642, 0.144053, 11.325673>, <3.225718, 0.021610, 11.120328>, 
      <1.803028, 0.034869, 9.996198>, <2.025723, 0.093321, 10.465714>, <2.693456, -0.262748, 11.406102>, <3.158532, -0.385190, 11.200757>, 
      <1.831617, -0.099793, 9.366971>, <1.764933, -0.503551, 9.446798>, <2.751633, -0.200263, 10.156859>, <2.929191, -0.153658, 10.531213>, 
      <2.296693, -0.222236, 9.161625>, <2.230010, -0.625994, 9.241452>, <2.572737, -0.247219, 9.779685>, <2.750295, -0.200614, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <1.803028, 0.034869, 9.996198>, <1.831617, -0.099793, 9.366971>, <2.296693, -0.222236, 9.161625>, 
      <1.974292, -0.218086, 10.527284>, <1.751597, -0.276538, 10.057767>, <2.296692, -0.222236, 9.161626>, <2.761769, -0.344679, 8.956280>, 
      <2.464297, -0.125318, 10.280315>, <2.744459, -0.199077, 10.156615>, <3.223612, -0.657451, 9.407035>, <3.273993, -0.352398, 9.346722>, 
      <2.750295, -0.200614, 10.154038>, <3.030457, -0.274373, 10.030338>, <3.446306, -0.598999, 9.876550>, <3.496688, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <1.974292, -0.218086, 10.527284>, <2.464297, -0.125318, 10.280315>, <2.750295, -0.200614, 10.154038>, 
      <2.248417, 0.151773, 10.935231>, <2.196986, -0.159635, 10.996799>, <2.744459, -0.199077, 10.156615>, <3.030457, -0.274373, 10.030338>, 
      <2.760642, 0.144053, 11.325673>, <3.225718, 0.021610, 11.120327>, <3.669001, -0.540547, 10.346067>, <3.446306, -0.598999, 9.876550>, 
      <3.225718, 0.021610, 11.120328>, <3.690794, -0.100833, 10.914982>, <3.719382, -0.235494, 10.285755>, <3.496688, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <1.974292, -0.218086, 10.527284>, <2.464297, -0.125318, 10.280315>, <2.750295, -0.200614, 10.154038>, 
      <2.025723, 0.093321, 10.465715>, <1.751597, -0.276538, 10.057767>, <2.286738, -0.171923, 9.905962>, <2.572737, -0.247219, 9.779685>, 
      <2.025723, 0.093321, 10.465715>, <1.751597, -0.276538, 10.057767>, <1.764933, -0.503551, 9.446798>, <2.230010, -0.625994, 9.241452>, 
      <2.025723, 0.093321, 10.465715>, <1.803028, 0.034869, 9.996198>, <1.831617, -0.099793, 9.366971>, <2.296693, -0.222236, 9.161625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <2.248417, 0.151773, 10.935231>, <2.760642, 0.144053, 11.325673>, <3.225718, 0.021610, 11.120328>, 
      <2.025723, 0.093321, 10.465715>, <2.196986, -0.159635, 10.996799>, <2.693456, -0.262748, 11.406102>, <3.158532, -0.385190, 11.200757>, 
      <2.025723, 0.093321, 10.465715>, <2.196986, -0.159635, 10.996799>, <2.643193, -0.078362, 10.657490>, <2.929191, -0.153658, 10.531213>, 
      <2.025723, 0.093321, 10.465715>, <1.974292, -0.218086, 10.527284>, <2.464297, -0.125318, 10.280315>, <2.750295, -0.200614, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <1.803028, 0.034869, 9.996198>, <1.831617, -0.099793, 9.366971>, <2.296693, -0.222236, 9.161625>, 
      <2.097180, 0.525986, 10.380173>, <1.874486, 0.467534, 9.910656>, <2.296692, -0.222236, 9.161626>, <2.761769, -0.344679, 8.956280>, 
      <2.501401, 0.802954, 10.151754>, <2.898763, 0.698339, 9.976306>, <3.345451, 0.080267, 9.261180>, <3.273993, -0.352398, 9.346722>, 
      <2.898763, 0.698339, 9.976306>, <3.296124, 0.593724, 9.800858>, <3.568145, 0.138718, 9.730696>, <3.496688, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <2.248417, 0.151773, 10.935231>, <2.760642, 0.144053, 11.325673>, <3.225718, 0.021610, 11.120328>, 
      <2.097180, 0.525986, 10.380173>, <2.319875, 0.584438, 10.849689>, <3.225718, 0.021610, 11.120327>, <3.690794, -0.100833, 10.914982>, 
      <2.501401, 0.802954, 10.151754>, <2.898763, 0.698339, 9.976306>, <3.790840, 0.197170, 10.200213>, <3.719382, -0.235494, 10.285755>, 
      <2.898763, 0.698339, 9.976306>, <3.296124, 0.593724, 9.800858>, <3.568145, 0.138718, 9.730696>, <3.496688, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <2.248417, 0.151773, 10.935231>, <2.760642, 0.144053, 11.325673>, <3.225718, 0.021610, 11.120328>, 
      <2.025723, 0.093321, 10.465715>, <2.319875, 0.584438, 10.849689>, <2.844276, 0.650447, 11.225554>, <3.309352, 0.528005, 11.020208>, 
      <2.025723, 0.093321, 10.465715>, <2.319875, 0.584438, 10.849689>, <2.724096, 0.861406, 10.621270>, <3.121457, 0.756791, 10.445822>, 
      <2.025723, 0.093321, 10.465715>, <2.097180, 0.525986, 10.380173>, <2.501401, 0.802954, 10.151754>, <2.898763, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <1.974292, -0.218086, 10.527284>, <2.464297, -0.125318, 10.280315>, <2.750295, -0.200614, 10.154038>, 
      <2.097180, 0.525986, 10.380173>, <2.045749, 0.214578, 10.441741>, <2.643193, -0.078362, 10.657490>, <2.929191, -0.153658, 10.531213>, 
      <2.501401, 0.802954, 10.151754>, <2.724096, 0.861406, 10.621270>, <3.242167, 0.121205, 11.100638>, <3.158532, -0.385190, 11.200757>, 
      <2.898763, 0.698339, 9.976306>, <3.121457, 0.756791, 10.445822>, <3.309352, 0.528005, 11.020208>, <3.225718, 0.021610, 11.120328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <1.803028, 0.034869, 9.996198>, <1.831617, -0.099793, 9.366971>, <2.296693, -0.222236, 9.161625>, 
      <2.025723, 0.093321, 10.465715>, <1.874486, 0.467534, 9.910656>, <1.915251, 0.406602, 9.266851>, <2.380328, 0.284160, 9.061506>, 
      <2.025723, 0.093321, 10.465715>, <1.874486, 0.467534, 9.910656>, <2.278707, 0.744502, 9.682237>, <2.676068, 0.639887, 9.506790>, 
      <2.025723, 0.093321, 10.465715>, <2.097180, 0.525986, 10.380173>, <2.501401, 0.802954, 10.151754>, <2.898763, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.025723, 0.093321, 10.465715>, <2.097180, 0.525986, 10.380173>, <2.501401, 0.802954, 10.151754>, <2.898763, 0.698339, 9.976306>, 
      <1.974292, -0.218086, 10.527284>, <2.045749, 0.214578, 10.441741>, <2.278707, 0.744502, 9.682237>, <2.676068, 0.639887, 9.506790>, 
      <2.464297, -0.125318, 10.280315>, <2.286738, -0.171923, 9.905962>, <2.313644, -0.119598, 9.141333>, <2.380328, 0.284160, 9.061506>, 
      <2.750295, -0.200614, 10.154038>, <2.572737, -0.247219, 9.779685>, <2.230010, -0.625994, 9.241452>, <2.296693, -0.222236, 9.161625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.208534, -0.352398, 9.346722>, <0.303691, -0.344679, 8.956279>, <0.768767, -0.222236, 9.161625>, 
      <-0.653923, -0.235494, 10.285754>, <-0.431229, -0.293946, 9.816238>, <0.379209, -0.747551, 9.046682>, <0.844285, -0.625109, 9.252029>, 
      <-0.625335, -0.100833, 10.914982>, <-0.550892, -0.497971, 11.004099>, <0.317709, -0.094370, 10.148675>, <0.493916, -0.140620, 9.777171>, 
      <-0.160259, 0.021610, 11.120328>, <-0.085816, -0.375528, 11.209445>, <0.138959, -0.047452, 10.525542>, <0.315165, -0.093702, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.208534, -0.352398, 9.346722>, <0.303691, -0.344679, 8.956279>, <0.768767, -0.222236, 9.161625>, 
      <-0.653923, -0.235494, 10.285754>, <-0.431229, -0.293946, 9.816238>, <0.209607, 0.157236, 8.843650>, <0.674683, 0.279679, 9.048996>, 
      <-0.625335, -0.100833, 10.914982>, <-0.719419, 0.401081, 10.802353>, <0.166697, 0.698339, 9.976306>, <0.389392, 0.639887, 9.506790>, 
      <-0.160259, 0.021610, 11.120328>, <-0.254343, 0.523524, 11.007699>, <-0.055997, 0.756791, 10.445822>, <0.166697, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.653923, -0.235494, 10.285754>, <-0.625335, -0.100833, 10.914982>, <-0.160259, 0.021610, 11.120328>, 
      <-0.431229, -0.293946, 9.816238>, <-0.734309, 0.193342, 10.189525>, <-0.719419, 0.401081, 10.802353>, <-0.254343, 0.523524, 11.007699>, 
      <-0.431229, -0.293946, 9.816238>, <-0.734309, 0.193342, 10.189525>, <-0.453359, 0.652176, 10.270374>, <-0.055997, 0.756791, 10.445822>, 
      <-0.431229, -0.293946, 9.816238>, <-0.511614, 0.134890, 9.720009>, <-0.230665, 0.593724, 9.800858>, <0.166697, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.208534, -0.352398, 9.346722>, <0.303691, -0.344679, 8.956279>, <0.768767, -0.222236, 9.161625>, 
      <-0.431229, -0.293946, 9.816238>, <-0.288920, 0.076438, 9.250493>, <0.209607, 0.157236, 8.843650>, <0.674683, 0.279679, 9.048996>, 
      <-0.431229, -0.293946, 9.816238>, <-0.288920, 0.076438, 9.250493>, <-0.007970, 0.535272, 9.331342>, <0.389392, 0.639887, 9.506790>, 
      <-0.431229, -0.293946, 9.816238>, <-0.511614, 0.134890, 9.720009>, <-0.230665, 0.593724, 9.800858>, <0.166697, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.208534, -0.352398, 9.346722>, <0.303691, -0.344679, 8.956279>, <0.768767, -0.222236, 9.161625>, 
      <-0.431229, -0.293946, 9.816238>, <-0.150565, -0.661651, 9.416118>, <0.379209, -0.747551, 9.046682>, <0.844285, -0.625109, 9.252029>, 
      <-0.431229, -0.293946, 9.816238>, <-0.150565, -0.661651, 9.416118>, <0.207360, -0.216062, 9.650648>, <0.493916, -0.140620, 9.777171>, 
      <-0.431229, -0.293946, 9.816238>, <-0.373259, -0.603200, 9.885634>, <0.028609, -0.169145, 10.027515>, <0.315165, -0.093702, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.373259, -0.603200, 9.885634>, <0.028609, -0.169145, 10.027515>, <0.315165, -0.093702, 10.154038>, 
      <-0.511614, 0.134890, 9.720009>, <-0.453645, -0.174364, 9.789405>, <0.207360, -0.216062, 9.650648>, <0.493916, -0.140620, 9.777171>, 
      <-0.230665, 0.593724, 9.800858>, <-0.007970, 0.535272, 9.331342>, <0.750202, -0.123194, 9.139399>, <0.844285, -0.625109, 9.252029>, 
      <0.166697, 0.698339, 9.976306>, <0.389392, 0.639887, 9.506790>, <0.674683, 0.279679, 9.048996>, <0.768767, -0.222236, 9.161625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.653923, -0.235494, 10.285754>, <-0.625335, -0.100833, 10.914982>, <-0.160259, 0.021610, 11.120328>, 
      <-0.431229, -0.293946, 9.816238>, <-0.595954, -0.544748, 10.355150>, <-0.550892, -0.497971, 11.004099>, <-0.085816, -0.375528, 11.209445>, 
      <-0.431229, -0.293946, 9.816238>, <-0.595954, -0.544748, 10.355150>, <-0.147597, -0.122895, 10.399019>, <0.138959, -0.047452, 10.525542>, 
      <-0.431229, -0.293946, 9.816238>, <-0.373259, -0.603200, 9.885634>, <0.028609, -0.169145, 10.027515>, <0.315165, -0.093702, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.431229, -0.293946, 9.816238>, <-0.511614, 0.134890, 9.720009>, <-0.230665, 0.593724, 9.800858>, <0.166697, 0.698339, 9.976306>, 
      <-0.373259, -0.603200, 9.885634>, <-0.453645, -0.174364, 9.789405>, <-0.453359, 0.652176, 10.270374>, <-0.055997, 0.756791, 10.445822>, 
      <0.028609, -0.169145, 10.027515>, <-0.147597, -0.122895, 10.399019>, <-0.179899, 0.126386, 11.096816>, <-0.254343, 0.523524, 11.007699>, 
      <0.315165, -0.093702, 10.154038>, <0.138959, -0.047452, 10.525542>, <-0.085816, -0.375528, 11.209445>, <-0.160259, 0.021610, 11.120328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <0.817042, 0.151773, 10.935231>, <0.304817, 0.144053, 11.325673>, <-0.160259, 0.021610, 11.120328>, 
      <1.262431, 0.034869, 9.996198>, <1.039737, 0.093321, 10.465714>, <0.210733, 0.645967, 11.213044>, <-0.254343, 0.523524, 11.007699>, 
      <1.233844, -0.099793, 9.366971>, <1.139760, 0.402121, 9.254342>, <0.166697, 0.698339, 9.976306>, <-0.055997, 0.756791, 10.445822>, 
      <0.768767, -0.222236, 9.161625>, <0.674683, 0.279679, 9.048996>, <0.389392, 0.639887, 9.506790>, <0.166697, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <0.817042, 0.151773, 10.935231>, <0.304817, 0.144053, 11.325673>, <-0.160259, 0.021610, 11.120328>, 
      <1.262431, 0.034869, 9.996198>, <1.039737, 0.093321, 10.465714>, <0.379261, -0.253086, 11.414790>, <-0.085816, -0.375528, 11.209445>, 
      <1.233844, -0.099793, 9.366971>, <1.309362, -0.502666, 9.457374>, <0.317709, -0.094370, 10.148675>, <0.138959, -0.047452, 10.525542>, 
      <0.768767, -0.222236, 9.161625>, <0.844285, -0.625109, 9.252029>, <0.493916, -0.140620, 9.777171>, <0.315165, -0.093702, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <1.262431, 0.034869, 9.996198>, <1.233844, -0.099793, 9.366971>, <0.768767, -0.222236, 9.161625>, 
      <1.095454, -0.203920, 10.532415>, <1.318149, -0.262372, 10.062898>, <0.768767, -0.222236, 9.161625>, <0.303691, -0.344679, 8.956279>, 
      <0.590590, -0.021190, 10.275647>, <0.304034, -0.096632, 10.149124>, <-0.150565, -0.661651, 9.416118>, <-0.208534, -0.352398, 9.346722>, 
      <0.315165, -0.093702, 10.154038>, <0.028609, -0.169145, 10.027515>, <-0.373259, -0.603200, 9.885634>, <-0.431229, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <1.095454, -0.203920, 10.532415>, <0.590590, -0.021190, 10.275647>, <0.315165, -0.093702, 10.154038>, 
      <0.817042, 0.151773, 10.935231>, <0.872759, -0.145468, 11.001931>, <0.304034, -0.096632, 10.149124>, <0.028609, -0.169145, 10.027515>, 
      <0.304817, 0.144053, 11.325673>, <-0.160259, 0.021610, 11.120327>, <-0.595954, -0.544748, 10.355150>, <-0.373259, -0.603200, 9.885634>, 
      <-0.160259, 0.021610, 11.120328>, <-0.625335, -0.100833, 10.914982>, <-0.653923, -0.235494, 10.285754>, <-0.431229, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <1.095454, -0.203920, 10.532415>, <0.590590, -0.021190, 10.275647>, <0.315165, -0.093702, 10.154038>, 
      <1.039736, 0.093321, 10.465715>, <1.318149, -0.262372, 10.062898>, <0.769341, -0.068107, 9.898780>, <0.493916, -0.140620, 9.777171>, 
      <1.039736, 0.093321, 10.465715>, <1.318149, -0.262372, 10.062898>, <1.309362, -0.502666, 9.457374>, <0.844285, -0.625109, 9.252029>, 
      <1.039736, 0.093321, 10.465715>, <1.262431, 0.034869, 9.996198>, <1.233844, -0.099793, 9.366971>, <0.768767, -0.222236, 9.161625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <0.817042, 0.151773, 10.935231>, <0.304817, 0.144053, 11.325673>, <-0.160259, 0.021610, 11.120328>, 
      <1.039736, 0.093321, 10.465715>, <0.872759, -0.145468, 11.001931>, <0.379261, -0.253086, 11.414790>, <-0.085816, -0.375528, 11.209445>, 
      <1.039736, 0.093321, 10.465715>, <0.872759, -0.145468, 11.001931>, <0.414384, 0.025060, 10.647151>, <0.138959, -0.047452, 10.525542>, 
      <1.039736, 0.093321, 10.465715>, <1.095454, -0.203920, 10.532415>, <0.590590, -0.021190, 10.275647>, <0.315165, -0.093702, 10.154038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <1.262431, 0.034869, 9.996198>, <1.233844, -0.099793, 9.366971>, <0.768767, -0.222236, 9.161625>, 
      <0.959351, 0.522157, 10.369486>, <1.182046, 0.463705, 9.899969>, <0.768767, -0.222236, 9.161625>, <0.303691, -0.344679, 8.956279>, 
      <0.564058, 0.802954, 10.151754>, <0.166697, 0.698339, 9.976306>, <-0.288920, 0.076438, 9.250493>, <-0.208534, -0.352398, 9.346722>, 
      <0.166697, 0.698339, 9.976306>, <-0.230665, 0.593724, 9.800858>, <-0.511614, 0.134890, 9.720009>, <-0.431229, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <0.817042, 0.151773, 10.935231>, <0.304817, 0.144053, 11.325673>, <-0.160259, 0.021610, 11.120328>, 
      <0.959351, 0.522157, 10.369486>, <0.736656, 0.580609, 10.839002>, <-0.160259, 0.021610, 11.120327>, <-0.625335, -0.100833, 10.914982>, 
      <0.564058, 0.802954, 10.151754>, <0.166697, 0.698339, 9.976306>, <-0.734309, 0.193342, 10.189525>, <-0.653923, -0.235494, 10.285754>, 
      <0.166697, 0.698339, 9.976306>, <-0.230665, 0.593724, 9.800858>, <-0.511614, 0.134890, 9.720009>, <-0.431229, -0.293946, 9.816238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <0.817042, 0.151773, 10.935231>, <0.304817, 0.144053, 11.325673>, <-0.160259, 0.021610, 11.120328>, 
      <1.039736, 0.093321, 10.465715>, <0.736656, 0.580609, 10.839002>, <0.210733, 0.645967, 11.213044>, <-0.254343, 0.523524, 11.007699>, 
      <1.039736, 0.093321, 10.465715>, <0.736656, 0.580609, 10.839002>, <0.341364, 0.861406, 10.621270>, <-0.055997, 0.756791, 10.445822>, 
      <1.039736, 0.093321, 10.465715>, <0.959351, 0.522157, 10.369486>, <0.564058, 0.802954, 10.151754>, <0.166697, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <1.095454, -0.203920, 10.532415>, <0.590590, -0.021190, 10.275647>, <0.315165, -0.093702, 10.154038>, 
      <0.959351, 0.522157, 10.369486>, <1.015068, 0.224916, 10.436186>, <0.414384, 0.025060, 10.647151>, <0.138959, -0.047452, 10.525542>, 
      <0.564058, 0.802954, 10.151754>, <0.341364, 0.861406, 10.621270>, <-0.179899, 0.126386, 11.096816>, <-0.085816, -0.375528, 11.209445>, 
      <0.166697, 0.698339, 9.976306>, <-0.055997, 0.756791, 10.445822>, <-0.254343, 0.523524, 11.007699>, <-0.160259, 0.021610, 11.120328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <1.262431, 0.034869, 9.996198>, <1.233844, -0.099793, 9.366971>, <0.768767, -0.222236, 9.161625>, 
      <1.039736, 0.093321, 10.465715>, <1.182046, 0.463705, 9.899969>, <1.139760, 0.402121, 9.254342>, <0.674683, 0.279679, 9.048996>, 
      <1.039736, 0.093321, 10.465715>, <1.182046, 0.463705, 9.899969>, <0.786753, 0.744502, 9.682238>, <0.389392, 0.639887, 9.506790>, 
      <1.039736, 0.093321, 10.465715>, <0.959351, 0.522157, 10.369486>, <0.564058, 0.802954, 10.151754>, <0.166697, 0.698339, 9.976306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.039736, 0.093321, 10.465715>, <0.959351, 0.522157, 10.369486>, <0.564058, 0.802954, 10.151754>, <0.166697, 0.698339, 9.976306>, 
      <1.095454, -0.203920, 10.532415>, <1.015068, 0.224916, 10.436186>, <0.786753, 0.744502, 9.682238>, <0.389392, 0.639887, 9.506790>, 
      <0.590590, -0.021190, 10.275647>, <0.769341, -0.068107, 9.898780>, <0.750202, -0.123194, 9.139399>, <0.674683, 0.279679, 9.048996>, 
      <0.315165, -0.093702, 10.154038>, <0.493916, -0.140620, 9.777171>, <0.844285, -0.625109, 9.252029>, <0.768767, -0.222236, 9.161625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.588646, -0.018235, 9.882761>, <1.567592, 0.022253, 9.882761>, <1.553244, 0.070181, 9.882761>, <1.464862, 0.070181, 9.882761>, 
      <2.004069, 0.078132, 9.704858>, <1.983015, 0.118621, 9.704858>, <1.531106, 0.479092, 9.704858>, <1.442723, 0.479092, 9.704858>, 
      <2.659516, 0.230179, 9.620952>, <2.390382, 0.747743, 9.620952>, <2.537336, 1.128869, 9.616014>, <1.407544, 1.128869, 9.616014>, 
      <2.973390, 0.302990, 9.289751>, <2.704257, 0.820554, 9.289751>, <2.520858, 1.433218, 9.289751>, <1.391066, 1.433218, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.551069, -0.095601, 9.882761>, <1.570374, -0.078481, 9.882761>, <1.600550, -0.041127, 9.882761>, <1.588646, -0.018235, 9.882761>, 
      <1.833661, -0.272709, 9.704858>, <1.852966, -0.255589, 9.704858>, <2.015974, 0.055240, 9.704858>, <2.004069, 0.078132, 9.704858>, 
      <2.298408, -0.568318, 9.591666>, <2.545183, -0.349480, 9.591666>, <2.811684, -0.062452, 9.620952>, <2.659516, 0.230179, 9.620952>, 
      <2.493041, -0.685961, 9.289751>, <2.739817, -0.467123, 9.289751>, <3.125559, 0.010359, 9.289751>, <2.973390, 0.302990, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.471494, -0.122125, 9.882761>, <1.496635, -0.123187, 9.882761>, <1.532242, -0.112297, 9.882761>, <1.551069, -0.095601, 9.882761>, 
      <1.472796, -0.392996, 9.704858>, <1.497937, -0.394059, 9.704858>, <1.814833, -0.289405, 9.704858>, <1.833661, -0.272709, 9.704858>, 
      <1.475236, -0.800536, 9.523471>, <1.796618, -0.814116, 9.523471>, <2.057739, -0.781741, 9.591666>, <2.298408, -0.568318, 9.591666>, 
      <1.475834, -1.025029, 9.289751>, <1.797216, -1.038609, 9.289751>, <2.252372, -0.899384, 9.289751>, <2.493041, -0.685961, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.394129, -0.088969, 9.882761>, <1.412862, -0.105901, 9.882761>, <1.446265, -0.121059, 9.882761>, <1.471494, -0.122125, 9.882761>, 
      <1.121956, -0.242636, 9.704858>, <1.140689, -0.259568, 9.704858>, <1.447567, -0.391930, 9.704858>, <1.472796, -0.392996, 9.704858>, 
      <0.668700, -0.498541, 9.582578>, <0.908165, -0.714980, 9.582578>, <1.152740, -0.786909, 9.523471>, <1.475236, -0.800536, 9.523471>, 
      <0.486885, -0.601193, 9.289751>, <0.726350, -0.817632, 9.289751>, <1.153338, -1.011402, 9.289751>, <1.475834, -1.025029, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.356552, -0.018235, 9.882761>, <1.346793, -0.040193, 9.882761>, <1.376303, -0.072857, 9.882761>, <1.394129, -0.088969, 9.882761>, 
      <0.951547, 0.078132, 9.704858>, <0.941789, 0.056175, 9.704858>, <1.104130, -0.226524, 9.704858>, <1.121956, -0.242636, 9.704858>, 
      <0.309838, 0.230821, 9.618028>, <0.185090, -0.049862, 9.618028>, <0.440829, -0.292581, 9.582578>, <0.668700, -0.498541, 9.582578>, 
      <0.006537, 0.302989, 9.289751>, <-0.118211, 0.022306, 9.289751>, <0.259014, -0.395232, 9.289751>, <0.486885, -0.601193, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.356552, -0.018235, 9.882761>, <0.951547, 0.078132, 9.704858>, <0.309838, 0.230821, 9.618028>, <0.006537, 0.302989, 9.289751>, 
      <1.373587, 0.020095, 9.882761>, <0.968583, 0.116462, 9.704858>, <0.527601, 0.720790, 9.618028>, <0.224301, 0.792958, 9.289751>, 
      <1.383627, 0.070181, 9.882761>, <1.361488, 0.479092, 9.704858>, <0.369116, 1.128869, 9.616014>, <0.352638, 1.433218, 9.289751>, 
      <1.464862, 0.070181, 9.882761>, <1.442723, 0.479092, 9.704858>, <1.407544, 1.128869, 9.616014>, <1.391066, 1.433218, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.465728, 0.417201, 7.902061>, <3.421188, 0.406869, 8.342754>, <3.274348, 0.372805, 8.972179>, <2.973390, 0.302990, 9.289751>, 
      <3.105526, 1.102888, 7.902061>, <3.060986, 1.092556, 8.342754>, <3.005214, 0.890368, 8.972179>, <2.704257, 0.820554, 9.289751>, 
      <2.864889, 1.917840, 7.902061>, <2.867252, 1.874181, 8.340922>, <2.504582, 1.733852, 8.967470>, <2.520858, 1.433218, 9.289751>, 
      <1.364829, 1.917840, 7.902061>, <1.367193, 1.874180, 8.340922>, <1.374790, 1.733852, 8.967470>, <1.391066, 1.433218, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.827954, -0.867394, 7.902061>, <2.798371, -0.848853, 8.332352>, <2.715335, -0.820323, 8.944930>, <2.493041, -0.685961, 9.289751>, 
      <3.079045, -0.520329, 7.942360>, <3.049461, -0.501788, 8.372650>, <2.962110, -0.601485, 8.944930>, <2.739817, -0.467123, 9.289751>, 
      <3.665822, 0.036298, 7.902061>, <3.621282, 0.025966, 8.342754>, <3.426516, 0.080173, 8.972179>, <3.125559, 0.010359, 9.289751>, 
      <3.465728, 0.417201, 7.902061>, <3.421188, 0.406869, 8.342754>, <3.274348, 0.372805, 8.972179>, <2.973390, 0.302990, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.477378, -2.331159, 7.582938>, <1.477180, -2.169705, 8.207166>, <1.477024, -1.471678, 8.824745>, <1.475834, -1.025029, 9.289751>, 
      <2.082193, -2.350251, 7.582938>, <2.081995, -2.188797, 8.207166>, <1.798406, -1.485258, 8.824745>, <1.797216, -1.038609, 9.289751>, 
      <2.474822, -1.355504, 7.845385>, <2.445239, -1.336963, 8.275675>, <2.474666, -1.033746, 8.944930>, <2.252372, -0.899384, 9.289751>, 
      <2.827954, -0.867394, 7.902061>, <2.798371, -0.848853, 8.332352>, <2.715335, -0.820323, 8.944930>, <2.493041, -0.685961, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.164318, -0.783312, 7.902061>, <0.192768, -0.767249, 8.331705>, <0.269053, -0.724179, 8.938917>, <0.486885, -0.601193, 9.289751>, 
      <0.519522, -1.283728, 7.843956>, <0.547972, -1.267665, 8.273600>, <0.508518, -0.940619, 8.938917>, <0.726350, -0.817632, 9.289751>, 
      <0.861275, -2.311711, 7.582938>, <0.861077, -2.150256, 8.207166>, <1.154528, -1.458051, 8.824745>, <1.153338, -1.011402, 9.289751>, 
      <1.477378, -2.331159, 7.582938>, <1.477180, -2.169705, 8.207166>, <1.477024, -1.471678, 8.824745>, <1.475834, -1.025029, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473454, 0.417200, 7.902061>, <-0.430140, 0.406894, 8.341650>, <-0.289466, 0.373421, 8.969373>, <0.006537, 0.302989, 9.289751>, 
      <-0.639086, 0.044528, 7.902061>, <-0.595772, 0.034222, 8.341650>, <-0.414214, 0.092737, 8.969373>, <-0.118211, 0.022306, 9.289751>, 
      <-0.070687, -0.452233, 7.940504>, <-0.042237, -0.436171, 8.370148>, <0.041182, -0.518219, 8.938917>, <0.259014, -0.395232, 9.289751>, 
      <0.164318, -0.783312, 7.902061>, <0.192768, -0.767249, 8.331705>, <0.269053, -0.724179, 8.938917>, <0.486885, -0.601193, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.473454, 0.417200, 7.902061>, <-0.184322, 1.067747, 7.902061>, <-0.013924, 1.917840, 7.902061>, <1.364829, 1.917840, 7.902061>, 
      <-0.430140, 0.406894, 8.341650>, <-0.141008, 1.057441, 8.341650>, <-0.011561, 1.874180, 8.340922>, <1.367193, 1.874180, 8.340922>, 
      <-0.289466, 0.373421, 8.969373>, <-0.071703, 0.863390, 8.969373>, <0.336362, 1.733852, 8.967470>, <1.374790, 1.733852, 8.967470>, 
      <0.006537, 0.302989, 9.289751>, <0.224301, 0.792958, 9.289751>, <0.352638, 1.433218, 9.289751>, <1.391066, 1.433218, 9.289751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.225842, 0.361554, 6.791908>, <3.418720, 0.406297, 7.069709>, <3.500022, 0.425157, 7.562742>, <3.465728, 0.417201, 7.902061>, 
      <2.911481, 0.966093, 6.791908>, <3.104359, 1.010836, 7.069709>, <3.139821, 1.110844, 7.562742>, <3.105526, 1.102888, 7.902061>, 
      <2.697264, 1.681715, 6.791908>, <2.686866, 1.873759, 7.072912>, <2.863064, 1.951550, 7.563221>, <2.864889, 1.917840, 7.902061>, 
      <1.377613, 1.681714, 6.791908>, <1.367215, 1.873758, 7.072912>, <1.363004, 1.951549, 7.563221>, <1.364829, 1.917840, 7.902061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.664772, -0.793589, 6.791908>, <2.804448, -0.876275, 7.087644>, <2.851072, -0.881882, 7.565814>, <2.827954, -0.867394, 7.902061>, 
      <2.916070, -0.501573, 6.791908>, <3.055746, -0.584259, 7.087644>, <3.102162, -0.534817, 7.606113>, <3.079045, -0.520329, 7.942360>, 
      <3.403582, 0.019747, 6.791908>, <3.596460, 0.064489, 7.069709>, <3.700116, 0.044254, 7.562742>, <3.665822, 0.036298, 7.902061>, 
      <3.225842, 0.361554, 6.791908>, <3.418720, 0.406297, 7.069709>, <3.500022, 0.425157, 7.562742>, <3.465728, 0.417201, 7.902061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.476626, -1.671088, 6.791908>, <1.477141, -1.912490, 6.984918>, <1.477473, -2.408554, 7.283709>, <1.477378, -2.331159, 7.582938>, 
      <1.919348, -1.689794, 6.791908>, <1.919863, -1.931196, 6.984918>, <2.082288, -2.427646, 7.283709>, <2.082193, -2.350251, 7.582938>, 
      <2.375734, -1.129460, 6.791908>, <2.515410, -1.212146, 7.087644>, <2.497940, -1.369992, 7.509138>, <2.474822, -1.355504, 7.845385>, 
      <2.664772, -0.793589, 6.791908>, <2.804448, -0.876275, 7.087644>, <2.851072, -0.881882, 7.565814>, <2.827954, -0.867394, 7.902061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.321484, -0.694578, 6.791908>, <0.185440, -0.771387, 7.090979>, <0.142039, -0.795890, 7.565614>, <0.164318, -0.783312, 7.902061>, 
      <0.614228, -1.041297, 6.791908>, <0.478184, -1.118107, 7.090979>, <0.497243, -1.296306, 7.507509>, <0.519522, -1.283728, 7.843956>, 
      <1.023254, -1.651932, 6.791908>, <1.023769, -1.893334, 6.984918>, <0.861370, -2.389106, 7.283709>, <0.861275, -2.311711, 7.582938>, 
      <1.476626, -1.671088, 6.791908>, <1.477141, -1.912490, 6.984918>, <1.477473, -2.408554, 7.283709>, <1.477378, -2.331159, 7.582938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.239584, 0.361552, 6.791908>, <-0.428922, 0.406604, 7.071626>, <-0.506860, 0.425149, 7.563030>, <-0.473454, 0.417200, 7.902061>, 
      <-0.385296, 0.033700, 6.791908>, <-0.574634, 0.078752, 7.071626>, <-0.672492, 0.052477, 7.563030>, <-0.639086, 0.044528, 7.902061>, 
      <0.090029, -0.420448, 6.791908>, <-0.046015, -0.497257, 7.090979>, <-0.092966, -0.464812, 7.604057>, <-0.070687, -0.452233, 7.940504>, 
      <0.321484, -0.694578, 6.791908>, <0.185440, -0.771387, 7.090979>, <0.142039, -0.795890, 7.565614>, <0.164318, -0.783312, 7.902061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.239584, 0.361552, 6.791908>, <0.014775, 0.933859, 6.791908>, <0.164679, 1.681713, 6.791908>, <1.377613, 1.681714, 6.791908>, 
      <-0.428922, 0.406604, 7.071626>, <-0.174564, 0.978911, 7.071626>, <0.154281, 1.873757, 7.072912>, <1.367215, 1.873758, 7.072912>, 
      <-0.506860, 0.425149, 7.563030>, <-0.217728, 1.075696, 7.563030>, <-0.015749, 1.951549, 7.563221>, <1.363004, 1.951549, 7.563221>, 
      <-0.473454, 0.417200, 7.902061>, <-0.184322, 1.067747, 7.902061>, <-0.013924, 1.917840, 7.902061>, <1.364829, 1.917840, 7.902061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.261381, 0.137823, 6.167447>, <2.550719, 0.204942, 6.354786>, <3.027296, 0.315496, 6.505943>, <3.225842, 0.361554, 6.791908>, 
      <2.119805, 0.410083, 6.167447>, <2.409144, 0.477203, 6.354786>, <2.712936, 0.920035, 6.505943>, <2.911481, 0.966093, 6.791908>, 
      <2.023330, 0.732371, 6.167447>, <2.007911, 1.017174, 6.354786>, <2.707683, 1.489262, 6.510306>, <2.697264, 1.681715, 6.791908>, 
      <1.429012, 0.732371, 6.167447>, <1.413592, 1.017174, 6.354786>, <1.388033, 1.489262, 6.510306>, <1.377613, 1.681714, 6.791908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.008698, -0.382408, 6.167447>, <2.205520, -0.505762, 6.354786>, <2.541218, -0.720447, 6.530306>, <2.664772, -0.793589, 6.791908>, 
      <2.138512, -0.267290, 6.167447>, <2.335334, -0.390644, 6.354786>, <2.792516, -0.428431, 6.530306>, <2.916070, -0.501573, 6.791908>, 
      <2.341428, -0.016113, 6.167447>, <2.630766, 0.051006, 6.354786>, <3.205036, -0.026311, 6.505943>, <3.403582, 0.019747, 6.791908>, 
      <2.261381, 0.137823, 6.167447>, <2.550719, 0.204942, 6.354786>, <3.027296, 0.315496, 6.505943>, <3.225842, 0.361554, 6.791908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.473603, -0.560774, 6.167447>, <1.474510, -0.893868, 6.354786>, <1.475990, -1.372602, 6.553257>, <1.476626, -1.671088, 6.791908>, 
      <1.642664, -0.567917, 6.167447>, <1.643571, -0.901011, 6.354786>, <1.918711, -1.391309, 6.553257>, <1.919348, -1.689794, 6.791908>, 
      <1.882096, -0.494678, 6.167447>, <2.078918, -0.618032, 6.354786>, <2.252180, -1.056318, 6.530306>, <2.375734, -1.129460, 6.791908>, 
      <2.008698, -0.382408, 6.167447>, <2.205520, -0.505762, 6.354786>, <2.541218, -0.720447, 6.530306>, <2.664772, -0.793589, 6.791908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.953372, -0.337818, 6.167447>, <0.763806, -0.444846, 6.354786>, <0.437282, -0.629200, 6.537344>, <0.321484, -0.694578, 6.791908>, 
      <1.079341, -0.451674, 6.167447>, <0.889775, -0.558703, 6.354786>, <0.730026, -0.975919, 6.537344>, <0.614228, -1.041297, 6.791908>, 
      <1.303956, -0.553606, 6.167447>, <1.304863, -0.886700, 6.354786>, <1.022618, -1.353446, 6.553257>, <1.023254, -1.651932, 6.791908>, 
      <1.473603, -0.560774, 6.167447>, <1.474510, -0.893868, 6.354786>, <1.475990, -1.372602, 6.553257>, <1.476626, -1.671088, 6.791908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.700688, 0.137822, 6.167447>, <0.418606, 0.204941, 6.354786>, <-0.047775, 0.315913, 6.508540>, <-0.239584, 0.361552, 6.791908>, 
      <0.635065, -0.009830, 6.167447>, <0.352983, 0.057289, 6.354786>, <-0.193487, -0.011939, 6.508540>, <-0.385296, 0.033700, 6.791908>, 
      <0.833502, -0.229474, 6.167447>, <0.643935, -0.336502, 6.354786>, <0.205827, -0.355069, 6.537344>, <0.090029, -0.420448, 6.791908>, 
      <0.953372, -0.337818, 6.167447>, <0.763806, -0.444846, 6.354786>, <0.437282, -0.629200, 6.537344>, <0.321484, -0.694578, 6.791908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.700688, 0.137822, 6.167447>, <0.815241, 0.395567, 6.167447>, <0.882753, 0.732371, 6.167447>, <1.429012, 0.732371, 6.167447>, 
      <0.418606, 0.204941, 6.354786>, <0.533160, 0.462686, 6.354786>, <0.867334, 1.017174, 6.354786>, <1.413592, 1.017174, 6.354786>, 
      <-0.047775, 0.315913, 6.508540>, <0.206583, 0.888220, 6.508540>, <0.175099, 1.489261, 6.510306>, <1.388033, 1.489262, 6.510306>, 
      <-0.239584, 0.361552, 6.791908>, <0.014775, 0.933859, 6.791908>, <0.164679, 1.681713, 6.791908>, <1.377613, 1.681714, 6.791908>
    }
  }
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <5.089555, 0.423802, 3.875087>, <5.426150, 0.213076, 3.655255>, <5.891471, -0.325329, 3.269748>, <5.822028, -0.772289, 3.307592>, 
      <5.089555, 0.423802, 3.875087>, <5.289755, 0.231145, 3.371484>, <5.726501, -0.303474, 2.926526>, <5.657058, -0.750435, 2.964370>, 
      <5.089555, 0.423802, 3.875087>, <5.289755, 0.231145, 3.371484>, <5.047330, -0.082799, 3.097478>, <4.999082, -0.393342, 3.123771>, 
      <5.089555, 0.423802, 3.875087>, <4.953160, 0.441871, 3.591316>, <4.698816, 0.026892, 3.207023>, <4.650568, -0.283651, 3.233317>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <5.089555, 0.423802, 3.875087>, <5.223735, 0.406027, 4.154250>, <5.315934, -0.060006, 4.493000>, <5.268469, -0.365506, 4.518866>, 
      <5.089555, 0.423802, 3.875087>, <5.560330, 0.195301, 3.934418>, <5.610012, -0.147178, 4.209386>, <5.562547, -0.452678, 4.235252>, 
      <5.089555, 0.423802, 3.875087>, <5.560330, 0.195301, 3.934418>, <6.072148, -0.349263, 3.645648>, <6.002705, -0.796224, 3.683492>, 
      <5.089555, 0.423802, 3.875087>, <5.426150, 0.213076, 3.655255>, <5.891471, -0.325329, 3.269748>, <5.822028, -0.772289, 3.307592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <5.089555, 0.423802, 3.875087>, <5.223735, 0.406027, 4.154250>, <5.315934, -0.060006, 4.493000>, <5.268469, -0.365506, 4.518866>, 
      <4.953160, 0.441871, 3.591316>, <5.087340, 0.424095, 3.870479>, <5.610012, -0.147178, 4.209386>, <5.562547, -0.452678, 4.235252>, 
      <4.698816, 0.026892, 3.207023>, <5.047330, -0.082799, 3.097478>, <5.837735, -0.774370, 3.340270>, <6.002705, -0.796224, 3.683492>, 
      <4.650568, -0.283651, 3.233317>, <4.999082, -0.393342, 3.123771>, <5.657058, -0.750435, 2.964370>, <5.822028, -0.772289, 3.307592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <4.853178, -1.097596, 4.003903>, <5.166335, -1.090067, 3.805114>, <5.765268, -1.137614, 3.338524>, <5.822028, -0.772289, 3.307592>, 
      <4.853178, -1.097596, 4.003903>, <5.294361, -1.107027, 4.071472>, <5.945945, -1.161549, 3.714424>, <6.002705, -0.796224, 3.683492>, 
      <4.853178, -1.097596, 4.003903>, <5.294361, -1.107027, 4.071472>, <5.517260, -0.744166, 4.259932>, <5.562547, -0.452678, 4.235252>, 
      <4.853178, -1.097596, 4.003903>, <4.981204, -1.114556, 4.270261>, <5.223181, -0.656993, 4.543546>, <5.268469, -0.365506, 4.518866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <4.853178, -1.097596, 4.003903>, <5.166335, -1.090067, 3.805114>, <5.765268, -1.137614, 3.338524>, <5.822028, -0.772289, 3.307592>, 
      <4.981204, -1.114556, 4.270261>, <5.294361, -1.107027, 4.071472>, <5.834712, -0.690654, 3.300680>, <5.891471, -0.325329, 3.269748>, 
      <5.223181, -0.656993, 4.543546>, <5.270646, -0.351493, 4.517680>, <5.560330, 0.195301, 3.934418>, <5.426150, 0.213076, 3.655255>, 
      <5.268469, -0.365506, 4.518866>, <5.315934, -0.060006, 4.493000>, <5.223735, 0.406027, 4.154250>, <5.089555, 0.423802, 3.875087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <4.853178, -1.097596, 4.003903>, <5.166335, -1.090067, 3.805114>, <5.765268, -1.137614, 3.338524>, <5.822028, -0.772289, 3.307592>, 
      <4.853178, -1.097596, 4.003903>, <5.018549, -1.070489, 3.497643>, <5.600298, -1.115760, 2.995301>, <5.657058, -0.750435, 2.964370>, 
      <4.853178, -1.097596, 4.003903>, <5.018549, -1.070489, 3.497643>, <4.946804, -0.729820, 3.152261>, <4.999082, -0.393342, 3.123771>, 
      <4.853178, -1.097596, 4.003903>, <4.705392, -1.078018, 3.696432>, <4.598290, -0.620130, 3.261806>, <4.650568, -0.283651, 3.233317>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <4.853178, -1.097596, 4.003903>, <4.705392, -1.078018, 3.696432>, <4.598290, -0.620130, 3.261806>, <4.650568, -0.283651, 3.233317>, 
      <4.981204, -1.114556, 4.270261>, <4.833418, -1.094978, 3.962790>, <4.946804, -0.729820, 3.152261>, <4.999082, -0.393342, 3.123771>, 
      <5.223181, -0.656993, 4.543546>, <5.517260, -0.744166, 4.259932>, <5.837735, -0.774370, 3.340270>, <5.657058, -0.750435, 2.964370>, 
      <5.268469, -0.365506, 4.518866>, <5.562547, -0.452678, 4.235252>, <6.002705, -0.796224, 3.683492>, <5.822028, -0.772289, 3.307592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <4.853178, -1.097596, 4.003903>, <4.705392, -1.078018, 3.696432>, <4.598290, -0.620130, 3.261806>, <4.650568, -0.283651, 3.233317>, 
      <5.166335, -1.090067, 3.805114>, <5.018549, -1.070489, 3.497643>, <4.646538, -0.309587, 3.235513>, <4.698816, 0.026892, 3.207023>, 
      <5.765268, -1.137614, 3.338524>, <5.834712, -0.690654, 3.300680>, <5.289755, 0.231145, 3.371484>, <4.953160, 0.441871, 3.591316>, 
      <5.822028, -0.772289, 3.307592>, <5.891471, -0.325329, 3.269748>, <5.426150, 0.213076, 3.655255>, <5.089555, 0.423802, 3.875087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.130983, 0.074685, 4.153445>, <3.586858, -0.032816, 3.877406>, <4.153825, -0.127307, 3.389454>, <4.650568, -0.283651, 3.233317>, 
      <3.130983, -0.301648, 4.142844>, <3.586858, -0.409149, 3.866805>, <4.101547, -0.463786, 3.417943>, <4.598290, -0.620130, 3.261806>, 
      <3.130983, -0.826388, 4.639507>, <3.647642, -0.904570, 4.335926>, <4.195287, -1.090283, 4.020242>, <4.705392, -1.078018, 3.696432>, 
      <3.130983, -0.836989, 5.015840>, <3.647642, -0.915171, 4.712259>, <4.343073, -1.109860, 4.327712>, <4.853178, -1.097596, 4.003903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.130983, 0.912442, 5.065120>, <3.718555, 0.765850, 4.708110>, <4.568252, 0.750164, 4.215551>, <5.089555, 0.423802, 3.875087>, 
      <3.130983, 0.922901, 4.693826>, <3.718555, 0.776309, 4.336816>, <4.431857, 0.768233, 3.931780>, <4.953160, 0.441871, 3.591316>, 
      <3.130983, 0.445980, 4.163904>, <3.586858, 0.338479, 3.887865>, <4.202073, 0.183236, 3.363160>, <4.698816, 0.026892, 3.207023>, 
      <3.130983, 0.074685, 4.153445>, <3.586858, -0.032816, 3.877406>, <4.153825, -0.127307, 3.389454>, <4.650568, -0.283651, 3.233317>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.130983, 0.025406, 5.902875>, <3.772229, -0.091868, 5.487672>, <4.724399, -0.204230, 5.043575>, <5.268469, -0.365506, 4.518866>, 
      <3.130983, 0.391294, 5.913182>, <3.772229, 0.274020, 5.497979>, <4.771864, 0.101270, 5.017709>, <5.315934, -0.060006, 4.493000>, 
      <3.130983, 0.902135, 5.431008>, <3.718555, 0.755544, 5.073998>, <4.702432, 0.732389, 4.494715>, <5.223735, 0.406027, 4.154250>, 
      <3.130983, 0.912442, 5.065120>, <3.718555, 0.765850, 4.708110>, <4.568252, 0.750164, 4.215551>, <5.089555, 0.423802, 3.875087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.130983, 0.025406, 5.902875>, <3.130983, -0.345594, 5.892424>, <3.130983, -0.847440, 5.386840>, <3.130983, -0.836989, 5.015840>, 
      <3.772229, -0.091868, 5.487672>, <3.772229, -0.462867, 5.477222>, <3.647642, -0.925622, 5.083259>, <3.647642, -0.915171, 4.712259>, 
      <4.724399, -0.204230, 5.043575>, <4.679111, -0.495717, 5.068256>, <4.471098, -1.126820, 4.594071>, <4.343073, -1.109860, 4.327712>, 
      <5.268469, -0.365506, 4.518866>, <5.223181, -0.656993, 4.543546>, <4.981204, -1.114556, 4.270261>, <4.853178, -1.097596, 4.003903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.940625, 0.505975, 3.610482>, <-2.250202, 0.277072, 3.325217>, <-2.610348, -0.266565, 2.806708>, <-2.588222, -0.742885, 2.854042>, 
      <-1.940625, 0.505975, 3.610482>, <-2.141013, 0.294220, 3.042717>, <-2.475892, -0.245449, 2.458836>, <-2.453766, -0.721769, 2.506170>, 
      <-1.940625, 0.505975, 3.610482>, <-2.141013, 0.294220, 3.042717>, <-1.807303, -0.048086, 2.903206>, <-1.793296, -0.349629, 2.933171>, 
      <-1.940625, 0.505975, 3.610482>, <-1.831436, 0.523123, 3.327982>, <-1.492716, 0.068854, 3.067214>, <-1.478708, -0.232689, 3.097180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.940625, 0.505975, 3.610482>, <-2.072276, 0.485299, 3.951097>, <-2.039799, 0.045421, 4.469037>, <-2.022910, -0.318155, 4.505167>, 
      <-1.940625, 0.505975, 3.610482>, <-2.381854, 0.256396, 3.665832>, <-2.362719, -0.067633, 4.052746>, <-2.345830, -0.431209, 4.088876>, 
      <-1.940625, 0.505975, 3.610482>, <-2.381854, 0.256396, 3.665832>, <-2.804302, -0.297025, 3.308516>, <-2.782176, -0.773345, 3.355850>, 
      <-1.940625, 0.505975, 3.610482>, <-2.250202, 0.277072, 3.325217>, <-2.610348, -0.266565, 2.806708>, <-2.588222, -0.742885, 2.854042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.940625, 0.505975, 3.610482>, <-2.072276, 0.485299, 3.951097>, <-2.039799, 0.045421, 4.469037>, <-2.022910, -0.318155, 4.505167>, 
      <-1.831436, 0.523123, 3.327982>, <-1.963087, 0.502447, 3.668597>, <-2.362719, -0.067633, 4.052746>, <-2.345830, -0.431209, 4.088876>, 
      <-1.492716, 0.068854, 3.067214>, <-1.807303, -0.048086, 2.903206>, <-2.647720, -0.752229, 3.007978>, <-2.782176, -0.773345, 3.355850>, 
      <-1.478708, -0.232689, 3.097180>, <-1.793296, -0.349629, 2.933171>, <-2.453766, -0.721769, 2.506170>, <-2.588222, -0.742885, 2.854042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.866834, -1.082544, 3.768340>, <-2.137311, -1.074864, 3.524954>, <-2.571417, -1.104657, 2.889993>, <-2.588222, -0.742885, 2.854042>, 
      <-1.866834, -1.082544, 3.768340>, <-2.253189, -1.093062, 3.824757>, <-2.765371, -1.135117, 3.391801>, <-2.782176, -0.773345, 3.355850>, 
      <-1.866834, -1.082544, 3.768340>, <-2.253189, -1.093062, 3.824757>, <-2.330965, -0.751222, 4.120677>, <-2.345830, -0.431209, 4.088876>, 
      <-1.866834, -1.082544, 3.768340>, <-1.982711, -1.100742, 4.068143>, <-2.008045, -0.638168, 4.536968>, <-2.022910, -0.318155, 4.505167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.866834, -1.082544, 3.768340>, <-2.137311, -1.074864, 3.524954>, <-2.571417, -1.104657, 2.889993>, <-2.588222, -0.742885, 2.854042>, 
      <-1.982711, -1.100742, 4.068143>, <-2.253189, -1.093062, 3.824757>, <-2.593543, -0.628337, 2.842659>, <-2.610348, -0.266565, 2.806708>, 
      <-2.008045, -0.638168, 4.536968>, <-2.024934, -0.274592, 4.500838>, <-2.381854, 0.256396, 3.665832>, <-2.250202, 0.277072, 3.325217>, 
      <-2.022910, -0.318155, 4.505167>, <-2.039799, 0.045421, 4.469037>, <-2.072276, 0.485299, 3.951097>, <-1.940625, 0.505975, 3.610482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.866834, -1.082544, 3.768340>, <-2.137311, -1.074864, 3.524954>, <-2.571417, -1.104657, 2.889993>, <-2.588222, -0.742885, 2.854042>, 
      <-1.866834, -1.082544, 3.768340>, <-2.013092, -1.055355, 3.203566>, <-2.436961, -1.083541, 2.542121>, <-2.453766, -0.721769, 2.506170>, 
      <-1.866834, -1.082544, 3.768340>, <-2.013092, -1.055355, 3.203566>, <-1.777360, -0.692683, 2.967262>, <-1.793296, -0.349629, 2.933171>, 
      <-1.866834, -1.082544, 3.768340>, <-1.742614, -1.063036, 3.446952>, <-1.462772, -0.575742, 3.131271>, <-1.478708, -0.232689, 3.097180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.866834, -1.082544, 3.768340>, <-1.742614, -1.063036, 3.446952>, <-1.462772, -0.575742, 3.131271>, <-1.478708, -0.232689, 3.097180>, 
      <-1.982711, -1.100742, 4.068143>, <-1.858491, -1.081234, 3.746755>, <-1.777360, -0.692683, 2.967262>, <-1.793296, -0.349629, 2.933171>, 
      <-2.008045, -0.638168, 4.536968>, <-2.330965, -0.751222, 4.120677>, <-2.647720, -0.752229, 3.007978>, <-2.453766, -0.721769, 2.506170>, 
      <-2.022910, -0.318155, 4.505167>, <-2.345830, -0.431209, 4.088876>, <-2.782176, -0.773345, 3.355850>, <-2.588222, -0.742885, 2.854042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.866834, -1.082544, 3.768340>, <-1.742614, -1.063036, 3.446952>, <-1.462772, -0.575742, 3.131271>, <-1.478708, -0.232689, 3.097180>, 
      <-2.137311, -1.074864, 3.524954>, <-2.013092, -1.055355, 3.203566>, <-1.476780, -0.274199, 3.101305>, <-1.492716, 0.068854, 3.067214>, 
      <-2.571417, -1.104657, 2.889993>, <-2.593543, -0.628337, 2.842659>, <-2.141013, 0.294220, 3.042717>, <-1.831436, 0.523123, 3.327982>, 
      <-2.588222, -0.742885, 2.854042>, <-2.610348, -0.266565, 2.806708>, <-2.250202, 0.277072, 3.325217>, <-1.940625, 0.505975, 3.610482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.209211, 0.141455, 4.094327>, <-0.590060, 0.029212, 3.795183>, <-1.060052, -0.077064, 3.315444>, <-1.478708, -0.232689, 3.097180>, 
      <-0.209211, -0.251481, 4.083258>, <-0.590060, -0.363724, 3.784114>, <-1.044116, -0.420117, 3.349535>, <-1.462772, -0.575742, 3.131271>, 
      <-0.209211, -0.799371, 4.601833>, <-0.706498, -0.881002, 4.233905>, <-1.278892, -1.076203, 3.864227>, <-1.742614, -1.063036, 3.446952>, 
      <-0.209211, -0.810439, 4.994769>, <-0.706498, -0.892070, 4.626840>, <-1.403112, -1.095712, 4.185615>, <-1.866834, -1.082544, 3.768340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.209211, 1.016172, 5.046223>, <-0.728635, 0.863113, 4.615501>, <-1.493605, 0.836505, 4.022396>, <-1.940625, 0.505975, 3.610482>, 
      <-0.209211, 1.027092, 4.658548>, <-0.728635, 0.874033, 4.227826>, <-1.384416, 0.853653, 3.739897>, <-1.831436, 0.523123, 3.327982>, 
      <-0.209211, 0.529130, 4.105248>, <-0.590060, 0.416887, 3.806104>, <-1.074059, 0.224480, 3.285479>, <-1.492716, 0.068854, 3.067214>, 
      <-0.209211, 0.141455, 4.094327>, <-0.590060, 0.029212, 3.795183>, <-1.060052, -0.077064, 3.315444>, <-1.478708, -0.232689, 3.097180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.209211, 0.090003, 5.920938>, <-0.753321, -0.032444, 5.496207>, <-1.602797, -0.171074, 5.046755>, <-2.022910, -0.318155, 4.505167>, 
      <-0.209211, 0.472033, 5.931699>, <-0.753321, 0.349585, 5.506968>, <-1.619686, 0.192502, 5.010625>, <-2.039799, 0.045421, 4.469037>, 
      <-0.209211, 1.005411, 5.428253>, <-0.728635, 0.852352, 4.997530>, <-1.625256, 0.815829, 4.363011>, <-2.072276, 0.485299, 3.951097>, 
      <-0.209211, 1.016172, 5.046223>, <-0.728635, 0.863113, 4.615501>, <-1.493605, 0.836505, 4.022396>, <-1.940625, 0.505975, 3.610482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.209211, 0.090003, 5.920938>, <-0.209211, -0.297364, 5.910026>, <-0.209211, -0.821350, 5.382137>, <-0.209211, -0.810439, 4.994769>, 
      <-0.753321, -0.032444, 5.496207>, <-0.753321, -0.419812, 5.485295>, <-0.706498, -0.902982, 5.014208>, <-0.706498, -0.892070, 4.626840>, 
      <-1.602797, -0.171074, 5.046755>, <-1.587931, -0.491087, 5.078556>, <-1.518990, -1.113910, 4.485418>, <-1.403112, -1.095712, 4.185615>, 
      <-2.022910, -0.318155, 4.505167>, <-2.008045, -0.638168, 4.536968>, <-1.982711, -1.100742, 4.068143>, <-1.866834, -1.082544, 3.768340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.254359, 0.020946, 6.089309>, <3.274362, -0.319109, 6.089309>, <2.900206, -0.721690, 6.089309>, <2.627490, -0.925806, 6.089309>, 
      <3.230905, 0.419664, 6.089309>, <3.250908, 0.079609, 6.089309>, <2.619941, -0.508145, 6.427315>, <2.347225, -0.712261, 6.427315>, 
      <2.833046, 0.892062, 6.089309>, <2.578438, 0.641112, 6.429419>, <2.512655, 0.047405, 6.549070>, <1.956161, -0.471087, 6.549070>, 
      <2.506987, 1.122738, 6.089309>, <2.252379, 0.871788, 6.429419>, <1.938002, 0.533439, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.254359, 0.020946, 6.089309>, <3.230905, 0.419664, 6.089309>, <2.833046, 0.892062, 6.089309>, <2.506987, 1.122738, 6.089309>, 
      <3.254359, 0.020946, 6.089309>, <2.779383, 0.419227, 6.451022>, <2.578438, 0.641112, 6.429419>, <2.252379, 0.871788, 6.429419>, 
      <3.254359, 0.020946, 6.089309>, <2.779383, 0.419227, 6.451022>, <2.829772, 0.540112, 6.549070>, <1.938002, 0.533439, 6.549070>, 
      <3.254359, 0.020946, 6.089309>, <2.802837, 0.020510, 6.451022>, <2.273278, 0.021619, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.254359, 0.020946, 6.089309>, <3.274362, -0.319109, 6.089309>, <2.900206, -0.721690, 6.089309>, <2.627490, -0.925806, 6.089309>, 
      <3.254359, 0.020946, 6.089309>, <2.822840, -0.319545, 6.451022>, <2.619941, -0.508145, 6.427315>, <2.347225, -0.712261, 6.427315>, 
      <3.254359, 0.020946, 6.089309>, <2.822840, -0.319545, 6.451022>, <2.847931, -0.464414, 6.549070>, <1.956161, -0.471087, 6.549070>, 
      <3.254359, 0.020946, 6.089309>, <2.802837, 0.020510, 6.451022>, <2.273278, 0.021619, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.316714, -0.005776, 6.089309>, <0.079965, 0.000025, 6.437492>, <0.567883, 0.008858, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <-0.316714, -0.005776, 6.089309>, <0.090268, 0.368609, 6.437492>, <-0.005224, 0.493584, 6.549070>, <0.808402, 0.499673, 6.549070>, 
      <-0.316714, -0.005776, 6.089309>, <0.090268, 0.368609, 6.437492>, <0.223083, 0.608901, 6.426534>, <0.506833, 0.844373, 6.426534>, 
      <-0.316714, -0.005776, 6.089309>, <-0.306411, 0.362808, 6.089309>, <-0.033218, 0.849122, 6.089309>, <0.250531, 1.084594, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.316714, -0.005776, 6.089309>, <0.079965, 0.000025, 6.437492>, <0.567883, 0.008858, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <-0.316714, -0.005776, 6.089309>, <0.070345, -0.344125, 6.437492>, <0.008849, -0.512002, 6.549070>, <0.822475, -0.505913, 6.549070>, 
      <-0.316714, -0.005776, 6.089309>, <0.070345, -0.344125, 6.437492>, <0.186351, -0.590221, 6.428471>, <0.462495, -0.795834, 6.428471>, 
      <-0.316714, -0.005776, 6.089309>, <-0.326334, -0.349926, 6.089309>, <-0.084856, -0.829219, 6.089309>, <0.191288, -1.034831, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.316714, -0.005776, 6.089309>, <-0.326334, -0.349926, 6.089309>, <-0.084856, -0.829219, 6.089309>, <0.191288, -1.034831, 6.089309>, 
      <-0.306411, 0.362808, 6.089309>, <-0.316031, 0.018658, 6.089309>, <0.186351, -0.590221, 6.428471>, <0.462495, -0.795834, 6.428471>, 
      <-0.033218, 0.849122, 6.089309>, <0.223083, 0.608901, 6.426534>, <0.249368, -0.021187, 6.549070>, <0.822475, -0.505913, 6.549070>, 
      <0.250531, 1.084594, 6.089309>, <0.506833, 0.844373, 6.426534>, <0.808402, 0.499673, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.344054, 1.372426, 6.089309>, <1.700834, 1.378457, 6.089309>, <2.215686, 1.328825, 6.089309>, <2.506987, 1.122738, 6.089309>, 
      <1.004872, 1.366692, 6.089309>, <1.361651, 1.372724, 6.089309>, <1.961078, 1.077875, 6.429419>, <2.252379, 0.871788, 6.429419>, 
      <0.511581, 1.301228, 6.089309>, <0.767883, 1.061007, 6.426534>, <1.364895, 1.018165, 6.549070>, <1.938002, 0.533439, 6.549070>, 
      <0.250531, 1.084594, 6.089309>, <0.506833, 0.844373, 6.426534>, <0.808402, 0.499673, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.344054, 1.372426, 6.089309>, <1.353274, 1.083919, 6.408177>, <1.354130, 0.677383, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <1.344054, 1.372426, 6.089309>, <1.710054, 1.089950, 6.408177>, <1.910623, 1.195875, 6.549070>, <1.938002, 0.533439, 6.549070>, 
      <1.344054, 1.372426, 6.089309>, <1.710054, 1.089950, 6.408177>, <1.961078, 1.077875, 6.429419>, <2.252379, 0.871788, 6.429419>, 
      <1.344054, 1.372426, 6.089309>, <1.700834, 1.378457, 6.089309>, <2.215686, 1.328825, 6.089309>, <2.506987, 1.122738, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.344054, 1.372426, 6.089309>, <1.004872, 1.366692, 6.089309>, <0.511581, 1.301228, 6.089309>, <0.250531, 1.084594, 6.089309>, 
      <1.353274, 1.083919, 6.408177>, <1.014092, 1.078185, 6.408177>, <0.227832, 1.065757, 6.089309>, <-0.033218, 0.849122, 6.089309>, 
      <1.354130, 0.677383, 6.549070>, <0.540504, 0.671294, 6.549070>, <0.090268, 0.368609, 6.437492>, <-0.306411, 0.362808, 6.089309>, 
      <1.381509, 0.014946, 6.549070>, <0.567883, 0.008858, 6.549070>, <0.079965, 0.000025, 6.437492>, <-0.316714, -0.005776, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.344054, 1.372426, 6.089309>, <1.353274, 1.083919, 6.408177>, <1.354130, 0.677383, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <1.700834, 1.378457, 6.089309>, <1.710054, 1.089950, 6.408177>, <2.245899, 0.684056, 6.549070>, <2.273278, 0.021619, 6.549070>, 
      <2.215686, 1.328825, 6.089309>, <2.541744, 1.098148, 6.089309>, <2.779383, 0.419227, 6.451022>, <2.802837, 0.020510, 6.451022>, 
      <2.506987, 1.122738, 6.089309>, <2.833046, 0.892062, 6.089309>, <3.230905, 0.419664, 6.089309>, <3.254359, 0.020946, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.344054, 1.372426, 6.089309>, <1.004872, 1.366692, 6.089309>, <0.511581, 1.301228, 6.089309>, <0.250531, 1.084594, 6.089309>, 
      <1.344054, 1.372426, 6.089309>, <1.014092, 1.078185, 6.408177>, <0.767883, 1.061007, 6.426534>, <0.506833, 0.844373, 6.426534>, 
      <1.344054, 1.372426, 6.089309>, <1.014092, 1.078185, 6.408177>, <0.781022, 1.162109, 6.549070>, <0.808402, 0.499673, 6.549070>, 
      <1.344054, 1.372426, 6.089309>, <1.353274, 1.083919, 6.408177>, <1.354130, 0.677383, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.455557, -1.325383, 6.089309>, <1.441119, -1.040971, 6.405699>, <1.408606, -0.640657, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <1.455557, -1.325383, 6.089309>, <1.052340, -1.058369, 6.405699>, <0.849572, -1.161516, 6.549070>, <0.822475, -0.505913, 6.549070>, 
      <1.455557, -1.325383, 6.089309>, <1.052340, -1.058369, 6.405699>, <0.774639, -1.028251, 6.428471>, <0.462495, -0.795834, 6.428471>, 
      <1.455557, -1.325383, 6.089309>, <1.066778, -1.342782, 6.089309>, <0.503432, -1.267249, 6.089309>, <0.191288, -1.034831, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.455557, -1.325383, 6.089309>, <1.441119, -1.040971, 6.405699>, <1.408606, -0.640657, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <1.066778, -1.342782, 6.089309>, <1.052340, -1.058369, 6.405699>, <0.594980, -0.646745, 6.549070>, <0.567883, 0.008858, 6.549070>, 
      <0.503432, -1.267249, 6.089309>, <0.227288, -1.061636, 6.089309>, <0.070345, -0.344125, 6.437492>, <0.079965, 0.000025, 6.437492>, 
      <0.191288, -1.034831, 6.089309>, <-0.084856, -0.829219, 6.089309>, <-0.326334, -0.349926, 6.089309>, <-0.316714, -0.005776, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.455557, -1.325383, 6.089309>, <1.826640, -1.308776, 6.089309>, <2.330107, -1.148385, 6.089309>, <2.627490, -0.925806, 6.089309>, 
      <1.066778, -1.342782, 6.089309>, <1.437861, -1.326175, 6.089309>, <2.049842, -0.934840, 6.427315>, <2.347225, -0.712261, 6.427315>, 
      <0.503432, -1.267249, 6.089309>, <0.774639, -1.028251, 6.428471>, <1.397128, -0.991947, 6.549070>, <1.956161, -0.471087, 6.549070>, 
      <0.191288, -1.034831, 6.089309>, <0.462495, -0.795834, 6.428471>, <0.822475, -0.505913, 6.549070>, <1.381509, 0.014946, 6.549070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.455557, -1.325383, 6.089309>, <1.441119, -1.040971, 6.405699>, <1.408606, -0.640657, 6.549070>, <1.381509, 0.014946, 6.549070>, 
      <1.455557, -1.325383, 6.089309>, <1.812202, -1.024364, 6.405699>, <1.983258, -1.126691, 6.549070>, <1.956161, -0.471087, 6.549070>, 
      <1.455557, -1.325383, 6.089309>, <1.812202, -1.024364, 6.405699>, <2.049842, -0.934840, 6.427315>, <2.347225, -0.712261, 6.427315>, 
      <1.455557, -1.325383, 6.089309>, <1.826640, -1.308776, 6.089309>, <2.330107, -1.148385, 6.089309>, <2.627490, -0.925806, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.455557, -1.325383, 6.089309>, <1.826640, -1.308776, 6.089309>, <2.330107, -1.148385, 6.089309>, <2.627490, -0.925806, 6.089309>, 
      <1.441119, -1.040971, 6.405699>, <1.812202, -1.024364, 6.405699>, <2.602823, -0.944268, 6.089309>, <2.900206, -0.721690, 6.089309>, 
      <1.408606, -0.640657, 6.549070>, <2.300375, -0.633984, 6.549070>, <2.822840, -0.319545, 6.451022>, <3.274362, -0.319109, 6.089309>, 
      <1.381509, 0.014946, 6.549070>, <2.273278, 0.021619, 6.549070>, <2.802837, 0.020510, 6.451022>, <3.254359, 0.020946, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.072238, -1.266149, 4.731068>, <-0.045701, -1.242855, 5.150416>, <-0.038964, -1.237738, 5.801364>, <0.191288, -1.034831, 6.089309>, 
      <-0.407888, -1.016229, 4.731068>, <-0.381351, -0.992935, 5.150416>, <-0.315108, -1.032125, 5.801364>, <-0.084856, -0.829219, 6.089309>, 
      <-0.701403, -0.433653, 4.731068>, <-0.663705, -0.432687, 5.151950>, <-0.643897, -0.354570, 5.810570>, <-0.326334, -0.349926, 6.089309>, 
      <-0.689710, -0.015342, 4.731068>, <-0.652012, -0.014375, 5.151950>, <-0.634277, -0.010420, 5.810570>, <-0.316714, -0.005776, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.464470, -1.619313, 4.731068>, <1.463580, -1.589959, 5.146946>, <1.469698, -1.603940, 5.779434>, <1.455557, -1.325383, 6.089309>, 
      <0.991913, -1.640461, 4.731068>, <0.991023, -1.611107, 5.146946>, <1.080919, -1.621338, 5.779434>, <1.066778, -1.342782, 6.089309>, 
      <0.307170, -1.548651, 4.731068>, <0.333707, -1.525357, 5.150416>, <0.273179, -1.470155, 5.801364>, <0.503432, -1.267249, 6.089309>, 
      <-0.072238, -1.266149, 4.731068>, <-0.045701, -1.242855, 5.150416>, <-0.038964, -1.237738, 5.801364>, <0.191288, -1.034831, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.888945, -1.133631, 4.731068>, <2.862684, -1.112757, 5.149336>, <2.868350, -1.109327, 5.798827>, <2.627490, -0.925806, 6.089309>, 
      <2.527479, -1.404174, 4.731068>, <2.501218, -1.383300, 5.149336>, <2.570967, -1.331906, 5.798827>, <2.330107, -1.148385, 6.089309>, 
      <1.915518, -1.599128, 4.731068>, <1.914628, -1.569774, 5.146946>, <1.840780, -1.587333, 5.779434>, <1.826640, -1.308776, 6.089309>, 
      <1.464470, -1.619313, 4.731068>, <1.463580, -1.589959, 5.146946>, <1.469698, -1.603940, 5.779434>, <1.455557, -1.325383, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.650898, 0.017139, 4.731068>, <3.610659, 0.017525, 5.153641>, <3.585648, 0.021266, 5.823914>, <3.254359, 0.020946, 6.089309>, 
      <3.675212, -0.396195, 4.731068>, <3.634973, -0.395808, 5.153641>, <3.605651, -0.318789, 5.823914>, <3.274362, -0.319109, 6.089309>, 
      <3.220429, -0.885529, 4.731068>, <3.194168, -0.864655, 5.149336>, <3.141066, -0.905210, 5.798827>, <2.900206, -0.721690, 6.089309>, 
      <2.888945, -1.133631, 4.731068>, <2.862684, -1.112757, 5.149336>, <2.868350, -1.109327, 5.798827>, <2.627490, -0.925806, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.742475, 1.356358, 4.731068>, <2.718831, 1.332901, 5.149192>, <2.723420, 1.336061, 5.800195>, <2.506987, 1.122738, 6.089309>, 
      <3.138797, 1.075973, 4.731068>, <3.115152, 1.052516, 5.149192>, <3.049479, 1.105385, 5.800195>, <2.833046, 0.892062, 6.089309>, 
      <3.622390, 0.501777, 4.731068>, <3.582151, 0.502163, 5.153641>, <3.562194, 0.419984, 5.823914>, <3.230905, 0.419664, 6.089309>, 
      <3.650898, 0.017139, 4.731068>, <3.610659, 0.017525, 5.153641>, <3.585648, 0.021266, 5.823914>, <3.254359, 0.020946, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.328940, 1.659851, 4.731068>, <1.330448, 1.631171, 5.146597>, <1.335125, 1.651815, 5.780519>, <1.344054, 1.372426, 6.089309>, 
      <1.762603, 1.667182, 4.731068>, <1.764111, 1.638502, 5.146597>, <1.691905, 1.657847, 5.780519>, <1.700834, 1.378457, 6.089309>, 
      <2.388401, 1.606854, 4.731068>, <2.364756, 1.583398, 5.149192>, <2.432118, 1.542147, 5.800195>, <2.215686, 1.328825, 6.089309>, 
      <2.742475, 1.356358, 4.731068>, <2.718831, 1.332901, 5.149192>, <2.723420, 1.336061, 5.800195>, <2.506987, 1.122738, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.000229, 1.309994, 4.731068>, <0.024970, 1.287344, 5.149538>, <0.029551, 1.291710, 5.798558>, <0.250531, 1.084594, 6.089309>, 
      <0.317075, 1.573312, 4.731068>, <0.342274, 1.550661, 5.149538>, <0.290601, 1.508344, 5.798558>, <0.511581, 1.301228, 6.089309>, 
      <0.916666, 1.652882, 4.731068>, <0.918175, 1.624202, 5.146597>, <0.995943, 1.646082, 5.780519>, <1.004872, 1.366692, 6.089309>, 
      <1.328940, 1.659851, 4.731068>, <1.330448, 1.631171, 5.146597>, <1.335125, 1.651815, 5.780519>, <1.344054, 1.372426, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.000229, 1.309994, 4.731068>, <-0.345124, 1.023780, 4.731068>, <-0.677187, 0.432669, 4.731068>, <-0.689710, -0.015342, 4.731068>, 
      <0.024970, 1.287344, 5.149538>, <-0.319925, 1.001130, 5.149538>, <-0.639489, 0.433636, 5.151950>, <-0.652012, -0.014375, 5.151950>, 
      <0.029551, 1.291710, 5.798558>, <-0.254198, 1.056238, 5.798558>, <-0.623974, 0.358165, 5.810570>, <-0.634277, -0.010420, 5.810570>, 
      <0.250531, 1.084594, 6.089309>, <-0.033218, 0.849122, 6.089309>, <-0.306411, 0.362808, 6.089309>, <-0.316714, -0.005776, 6.089309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.004343, -1.198928, 3.135135>, <-0.087061, -1.275271, 3.599874>, <-0.102491, -1.292704, 4.253005>, <-0.072238, -1.266149, 4.731068>, 
      <-0.314014, -0.961884, 3.135135>, <-0.405419, -1.038226, 3.599874>, <-0.438141, -1.042784, 4.253005>, <-0.407888, -1.016229, 4.731068>, 
      <-0.592407, -0.409322, 3.135135>, <-0.635825, -0.412573, 3.613040>, <-0.744214, -0.434751, 4.253099>, <-0.701403, -0.433653, 4.731068>, 
      <-0.581317, -0.012562, 3.135135>, <-0.624734, -0.015813, 3.613040>, <-0.732521, -0.016440, 4.253099>, <-0.689710, -0.015342, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.461880, -1.533897, 3.135135>, <1.473345, -1.781184, 3.545751>, <1.465494, -1.653071, 4.252793>, <1.464470, -1.619313, 4.731068>, 
      <1.013669, -1.553955, 3.135135>, <1.025133, -1.801242, 3.545751>, <0.992936, -1.674219, 4.252793>, <0.991913, -1.640461, 4.731068>, 
      <0.364204, -1.466875, 3.135135>, <0.272800, -1.543218, 3.599874>, <0.276917, -1.575206, 4.253005>, <0.307170, -1.548651, 4.731068>, 
      <0.004343, -1.198928, 3.135135>, <-0.087061, -1.275271, 3.599874>, <-0.102491, -1.292704, 4.253005>, <-0.072238, -1.266149, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.812966, -1.073237, 3.135135>, <2.880638, -1.125647, 3.607101>, <2.918964, -1.157493, 4.252939>, <2.888945, -1.133631, 4.731068>, 
      <2.470122, -1.329841, 3.135135>, <2.537794, -1.382251, 3.607101>, <2.557498, -1.428035, 4.252939>, <2.527479, -1.404174, 4.731068>, 
      <1.889690, -1.514752, 3.135135>, <1.901155, -1.762038, 3.545751>, <1.916541, -1.632886, 4.252793>, <1.915518, -1.599128, 4.731068>, 
      <1.461880, -1.533897, 3.135135>, <1.473345, -1.781184, 3.545751>, <1.465494, -1.653071, 4.252793>, <1.464470, -1.619313, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.535664, 0.018245, 3.135135>, <3.581570, 0.021876, 3.612948>, <3.696402, 0.016702, 4.253203>, <3.650898, 0.017139, 4.731068>, 
      <3.558725, -0.373794, 3.135135>, <3.604631, -0.370163, 3.612948>, <3.720715, -0.396632, 4.253203>, <3.675212, -0.396195, 4.731068>, 
      <3.127372, -0.837917, 3.135135>, <3.195044, -0.890327, 3.607101>, <3.250448, -0.909391, 4.252939>, <3.220429, -0.885529, 4.731068>, 
      <2.812966, -1.073237, 3.135135>, <2.880638, -1.125647, 3.607101>, <2.918964, -1.157493, 4.252939>, <2.888945, -1.133631, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.674042, 1.288468, 3.135135>, <2.705631, 1.382972, 3.604323>, <2.769513, 1.383182, 4.252930>, <2.742475, 1.356358, 4.731068>, 
      <3.049945, 1.022528, 3.135135>, <3.081535, 1.117032, 3.604323>, <3.165835, 1.102797, 4.252930>, <3.138797, 1.075973, 4.731068>, 
      <3.508624, 0.477915, 3.135135>, <3.554530, 0.481546, 3.612948>, <3.667894, 0.501340, 4.253203>, <3.622390, 0.501777, 4.731068>, 
      <3.535664, 0.018245, 3.135135>, <3.581570, 0.021876, 3.612948>, <3.696402, 0.016702, 4.253203>, <3.650898, 0.017139, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.333332, 1.576325, 3.135135>, <1.324258, 1.825873, 3.544407>, <1.327204, 1.692863, 4.252772>, <1.328940, 1.659851, 4.731068>, 
      <1.744652, 1.583278, 3.135135>, <1.735579, 1.832826, 3.544407>, <1.760867, 1.700194, 4.252772>, <1.762603, 1.667182, 4.731068>, 
      <2.338209, 1.526059, 3.135135>, <2.369799, 1.620563, 3.604323>, <2.415439, 1.633678, 4.252930>, <2.388401, 1.606854, 4.731068>, 
      <2.674042, 1.288468, 3.135135>, <2.705631, 1.382972, 3.604323>, <2.769513, 1.383182, 4.252930>, <2.742475, 1.356358, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.072642, 1.244493, 3.135135>, <0.002204, 1.329775, 3.601889>, <-0.029019, 1.335873, 4.252951>, <-0.000229, 1.309994, 4.731068>, 
      <0.373599, 1.494244, 3.135135>, <0.303160, 1.579526, 3.601889>, <0.288285, 1.599190, 4.252951>, <0.317075, 1.573312, 4.731068>, 
      <0.942299, 1.569715, 3.135135>, <0.933225, 1.819263, 3.544407>, <0.914930, 1.685894, 4.252772>, <0.916666, 1.652882, 4.731068>, 
      <1.333332, 1.576325, 3.135135>, <1.324258, 1.825873, 3.544407>, <1.327204, 1.692863, 4.252772>, <1.328940, 1.659851, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.072642, 1.244493, 3.135135>, <-0.254484, 0.973025, 3.135135>, <-0.569439, 0.412368, 3.135135>, <-0.581317, -0.012562, 3.135135>, 
      <0.002204, 1.329775, 3.601889>, <-0.324923, 1.058307, 3.601889>, <-0.612857, 0.409117, 3.613040>, <-0.624734, -0.015813, 3.613040>, 
      <-0.029019, 1.335873, 4.252951>, <-0.373914, 1.049659, 4.252951>, <-0.719998, 0.431571, 4.253099>, <-0.732521, -0.016440, 4.253099>, 
      <-0.000229, 1.309994, 4.731068>, <-0.345124, 1.023780, 4.731068>, <-0.677187, 0.432669, 4.731068>, <-0.689710, -0.015342, 4.731068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.531943, -0.857143, 2.241222>, <2.524942, -0.876975, 2.528946>, <2.772265, -1.041715, 2.851273>, <2.812966, -1.073237, 3.135135>, 
      <2.106859, -0.855040, 2.147586>, <2.099858, -0.874872, 2.435310>, <2.429421, -1.298320, 2.851273>, <2.470122, -1.329841, 3.135135>, 
      <1.377844, -0.425010, 2.022536>, <1.401418, -0.995373, 2.022536>, <1.876040, -1.220333, 2.646257>, <1.889690, -1.514752, 3.135135>, 
      <1.388926, 0.010119, 2.025419>, <1.412500, -0.560244, 2.025419>, <1.448230, -1.239479, 2.646257>, <1.461880, -1.533897, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.575603, 0.857142, 2.252580>, <2.551322, 0.897373, 2.544999>, <2.654536, 1.230115, 2.845425>, <2.674042, 1.288468, 3.135135>, 
      <2.143306, 0.859281, 2.157355>, <2.119025, 0.899511, 2.449774>, <2.318704, 1.467706, 2.845425>, <2.338209, 1.526059, 3.135135>, 
      <1.400196, 0.452631, 2.028351>, <1.376406, 1.028231, 2.028351>, <1.755556, 1.283422, 2.643354>, <1.744652, 1.583278, 3.135135>, 
      <1.388926, 0.010119, 2.025419>, <1.365136, 0.585718, 2.025419>, <1.344235, 1.276469, 2.643354>, <1.333332, 1.576325, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.373802, 0.857142, 2.252580>, <0.379325, 0.894281, 2.553176>, <0.117126, 1.190635, 2.840367>, <0.072642, 1.244493, 3.135135>, 
      <0.765084, 0.859255, 2.158498>, <0.770607, 0.896394, 2.459094>, <0.418082, 1.440386, 2.840367>, <0.373599, 1.494244, 3.135135>, 
      <1.378680, 0.412419, 2.028084>, <1.354890, 0.988018, 2.028084>, <0.953202, 1.269859, 2.643354>, <0.942299, 1.569715, 3.135135>, 
      <1.388926, 0.010119, 2.025419>, <1.365136, 0.585718, 2.025419>, <1.344235, 1.276469, 2.643354>, <1.333332, 1.576325, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.417462, -0.857143, 2.241222>, <0.802489, -0.855064, 2.148644>, <1.399008, -0.385750, 2.022796>, <1.388926, 0.010119, 2.025419>, 
      <0.411929, -0.891028, 2.552047>, <0.796957, -0.888949, 2.459469>, <1.422582, -0.956114, 2.022796>, <1.412500, -0.560244, 2.025419>, 
      <0.063922, -1.149166, 2.832208>, <0.423783, -1.417113, 2.832208>, <1.000019, -1.259537, 2.646257>, <1.448230, -1.239479, 2.646257>, 
      <0.004343, -1.198928, 3.135135>, <0.364204, -1.466875, 3.135135>, <1.013669, -1.553955, 3.135135>, <1.461880, -1.533897, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.434240, 0.000000, 2.475955>, <3.424567, -0.379808, 2.473439>, <2.902983, -0.858979, 2.322953>, <2.531943, -0.857143, 2.241222>, 
      <3.416062, 0.001160, 2.675280>, <3.406389, -0.378648, 2.672764>, <2.895982, -0.878811, 2.610678>, <2.524942, -0.876975, 2.528946>, 
      <3.516523, 0.016731, 2.935902>, <3.539584, -0.375308, 2.935902>, <3.086671, -0.806395, 2.851273>, <2.772265, -1.041715, 2.851273>, 
      <3.535664, 0.018245, 3.135135>, <3.558725, -0.373794, 3.135135>, <3.127372, -0.837917, 3.135135>, <2.812966, -1.073237, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.434240, 0.000000, 2.475955>, <3.416062, 0.001160, 2.675280>, <3.516523, 0.016731, 2.935902>, <3.535664, 0.018245, 3.135135>, 
      <3.443662, 0.369961, 2.478406>, <3.425484, 0.371121, 2.677732>, <3.489483, 0.476401, 2.935902>, <3.508624, 0.477915, 3.135135>, 
      <2.937024, 0.855354, 2.332193>, <2.912743, 0.895584, 2.624612>, <3.030440, 0.964175, 2.845425>, <3.049945, 1.022528, 3.135135>, 
      <2.575603, 0.857142, 2.252580>, <2.551322, 0.897373, 2.544999>, <2.654536, 1.230115, 2.845425>, <2.674042, 1.288468, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.484835, 0.000000, 2.475955>, <-0.475162, -0.379808, 2.473439>, <0.048056, -0.859138, 2.330044>, <0.417462, -0.857143, 2.241222>, 
      <-0.466369, -0.000798, 2.674995>, <-0.456696, -0.380606, 2.672479>, <0.042523, -0.893023, 2.640868>, <0.411929, -0.891028, 2.552047>, 
      <-0.563232, -0.011208, 2.936063>, <-0.574322, -0.407968, 2.936063>, <-0.254435, -0.912122, 2.832208>, <0.063922, -1.149166, 2.832208>, 
      <-0.581317, -0.012562, 3.135135>, <-0.592407, -0.409322, 3.135135>, <-0.314014, -0.961884, 3.135135>, <0.004343, -1.198928, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.484835, 0.000000, 2.475955>, <-0.466369, -0.000798, 2.674995>, <-0.563232, -0.011208, 2.936063>, <-0.581317, -0.012562, 3.135135>, 
      <-0.494257, 0.369961, 2.478406>, <-0.475791, 0.369164, 2.677446>, <-0.551354, 0.413722, 2.936063>, <-0.569439, 0.412368, 3.135135>, 
      <0.013973, 0.855199, 2.339099>, <0.019496, 0.892338, 2.639695>, <-0.210000, 0.919167, 2.840367>, <-0.254484, 0.973025, 3.135135>, 
      <0.373802, 0.857142, 2.252580>, <0.379325, 0.894281, 2.553176>, <0.117126, 1.190635, 2.840367>, <0.072642, 1.244493, 3.135135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.032111, -0.015037, 0.000000>, <2.042015, 0.361302, 0.000000>, <2.557912, 0.853979, 0.000000>, <2.934368, 0.857142, 0.000000>, 
      <1.702286, 0.012277, 0.544947>, <1.712189, 0.388616, 0.544947>, <2.469911, 1.075578, 0.641408>, <2.846366, 1.078741, 0.641408>, 
      <2.026498, 0.010119, 2.025419>, <2.037768, 0.452631, 2.028351>, <2.199407, 0.766330, 1.481731>, <2.631703, 0.764191, 1.576956>, 
      <1.388926, 0.010119, 2.025419>, <1.400196, 0.452631, 2.028351>, <2.143306, 0.859281, 2.157355>, <2.575603, 0.857142, 2.252580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.889255, -0.857143, 0.000000>, <2.528788, -0.860172, 0.000000>, <2.022628, -0.375392, 0.000000>, <2.032111, -0.015037, 0.000000>, 
      <2.789401, -1.027530, 0.651586>, <2.428934, -1.030559, 0.651586>, <1.692803, -0.348077, 0.544947>, <1.702286, 0.012277, 0.544947>, 
      <2.548467, -0.810339, 1.562176>, <2.123383, -0.808236, 1.468540>, <2.015416, -0.425010, 2.022536>, <2.026498, 0.010119, 2.025419>, 
      <2.531943, -0.857143, 2.241222>, <2.106859, -0.855040, 2.147586>, <1.377844, -0.425010, 2.022536>, <1.388926, 0.010119, 2.025419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.821585, 0.000000, 0.000000>, <3.811590, -0.379808, 0.000000>, <3.269181, -0.853950, 0.000000>, <2.889255, -0.857143, 0.000000>, 
      <3.936021, 0.029261, 0.742484>, <3.926026, -0.350546, 0.742484>, <3.169327, -1.024337, 0.651586>, <2.789401, -1.027530, 0.651586>, 
      <3.502521, -0.004357, 1.727254>, <3.492848, -0.384165, 1.724737>, <2.919507, -0.812175, 1.643907>, <2.548467, -0.810339, 1.562176>, 
      <3.434240, 0.000000, 2.475955>, <3.424567, -0.379808, 2.473439>, <2.902983, -0.858979, 2.322953>, <2.531943, -0.857143, 2.241222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <3.821585, 0.000000, 0.000000>, <3.936021, 0.029261, 0.742484>, <3.502521, -0.004357, 1.727254>, <3.434240, 0.000000, 2.475955>, 
      <3.831321, 0.369961, 0.000000>, <3.945757, 0.399223, 0.742484>, <3.511943, 0.365604, 1.729705>, <3.443662, 0.369961, 2.478406>, 
      <3.304444, 0.860252, 0.000000>, <3.216443, 1.081851, 0.641408>, <2.993124, 0.762403, 1.656569>, <2.937024, 0.855354, 2.332193>, 
      <2.934368, 0.857142, 0.000000>, <2.846366, 1.078741, 0.641408>, <2.631703, 0.764191, 1.576956>, <2.575603, 0.857142, 2.252580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <2.942670, -0.921973, -0.576577>, <2.930551, -0.786678, -0.269468>, <2.889255, -0.857143, 0.000000>, 
      <2.989283, 0.849320, -0.576577>, <2.968186, 0.047648, -0.576577>, <3.310477, -0.783486, -0.269468>, <3.269181, -0.853950, 0.000000>, 
      <2.978165, 0.746855, -0.319220>, <3.348242, 0.749965, -0.319220>, <3.821326, -0.009847, 0.000000>, <3.811590, -0.379808, 0.000000>, 
      <2.934368, 0.857142, 0.000000>, <3.304444, 0.860252, 0.000000>, <3.831321, 0.369961, 0.000000>, <3.821585, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <2.942670, -0.921973, -0.576577>, <2.930551, -0.786678, -0.269468>, <2.889255, -0.857143, 0.000000>, 
      <2.989283, 0.849320, -0.576577>, <2.968186, 0.047648, -0.576577>, <2.570084, -0.789707, -0.269468>, <2.528788, -0.860172, 0.000000>, 
      <2.978165, 0.746855, -0.319220>, <2.601710, 0.743691, -0.319220>, <2.032531, 0.000947, 0.000000>, <2.022628, -0.375392, 0.000000>, 
      <2.934368, 0.857142, 0.000000>, <2.557912, 0.853979, 0.000000>, <2.042015, 0.361302, 0.000000>, <2.032111, -0.015037, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <3.852821, -0.112830, -0.576577>, <3.774069, -0.012150, -0.308292>, <3.821585, 0.000000, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <3.831725, -0.914502, -0.576577>, <3.764074, -0.391958, -0.308292>, <3.811590, -0.379808, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <3.831725, -0.914502, -0.576577>, <3.310477, -0.783486, -0.269468>, <3.269181, -0.853950, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.942670, -0.921973, -0.576577>, <2.930551, -0.786678, -0.269468>, <2.889255, -0.857143, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <2.989283, 0.849320, -0.576577>, <2.978165, 0.746855, -0.319220>, <2.934368, 0.857142, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <3.878338, 0.856791, -0.576577>, <3.348242, 0.749965, -0.319220>, <3.304444, 0.860252, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <3.878338, 0.856791, -0.576577>, <3.783805, 0.357812, -0.308292>, <3.831321, 0.369961, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <3.852821, -0.112830, -0.576577>, <3.774069, -0.012150, -0.308292>, <3.821585, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <2.989283, 0.849320, -0.576577>, <2.978165, 0.746855, -0.319220>, <2.934368, 0.857142, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.048859, 0.841418, -0.576577>, <2.601710, 0.743691, -0.319220>, <2.557912, 0.853979, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.048859, 0.841418, -0.576577>, <2.212834, 0.347155, -0.282234>, <2.042015, 0.361302, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.023343, -0.128203, -0.576577>, <2.202931, -0.029183, -0.282234>, <2.032111, -0.015037, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <3.852821, -0.112830, -0.576577>, <3.774069, -0.012150, -0.308292>, <3.821585, 0.000000, 0.000000>, 
      <2.023343, -0.128203, -0.576577>, <2.912398, -0.120733, -0.576577>, <3.783805, 0.357812, -0.308292>, <3.831321, 0.369961, 0.000000>, 
      <2.202931, -0.029183, -0.282234>, <2.212834, 0.347155, -0.282234>, <2.927989, 0.857088, 0.000000>, <3.304444, 0.860252, 0.000000>, 
      <2.032111, -0.015037, 0.000000>, <2.042015, 0.361302, 0.000000>, <2.557912, 0.853979, 0.000000>, <2.934368, 0.857142, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <2.942670, -0.921973, -0.576577>, <2.930551, -0.786678, -0.269468>, <2.889255, -0.857143, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.002246, -0.929875, -0.576577>, <2.570084, -0.789707, -0.269468>, <2.528788, -0.860172, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.002246, -0.929875, -0.576577>, <2.193448, -0.389538, -0.282234>, <2.022628, -0.375392, 0.000000>, 
      <2.963766, -0.120301, -0.576577>, <2.023343, -0.128203, -0.576577>, <2.202931, -0.029183, -0.282234>, <2.032111, -0.015037, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.963766, -0.120301, -0.576577>, <2.023343, -0.128203, -0.576577>, <2.202931, -0.029183, -0.282234>, <2.032111, -0.015037, 0.000000>, 
      <3.852821, -0.112830, -0.576577>, <2.912398, -0.120733, -0.576577>, <2.193448, -0.389538, -0.282234>, <2.022628, -0.375392, 0.000000>, 
      <3.774069, -0.012150, -0.308292>, <3.764074, -0.391958, -0.308292>, <2.908714, -0.856979, 0.000000>, <2.528788, -0.860172, 0.000000>, 
      <3.821585, 0.000000, 0.000000>, <3.811590, -0.379808, 0.000000>, <3.269181, -0.853950, 0.000000>, <2.889255, -0.857143, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.917294, -0.015037, 0.000000>, <0.907390, 0.361302, 0.000000>, <0.391493, 0.853979, 0.000000>, <0.015037, 0.857142, 0.000000>, 
      <1.213172, 0.012462, 0.548621>, <1.203268, 0.388800, 0.548621>, <0.479494, 1.075578, 0.641408>, <0.103039, 1.078741, 0.641408>, 
      <0.764999, 0.010119, 2.025419>, <0.754753, 0.412419, 2.028084>, <0.752608, 0.775362, 1.479484>, <0.361326, 0.773249, 1.573565>, 
      <1.388926, 0.010119, 2.025419>, <1.378680, 0.412419, 2.028084>, <0.765084, 0.859255, 2.158498>, <0.373802, 0.857142, 2.252580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.060150, -0.857143, 0.000000>, <0.420617, -0.860172, 0.000000>, <0.926777, -0.375392, 0.000000>, <0.917294, -0.015037, 0.000000>, 
      <0.160004, -1.027530, 0.651586>, <0.520471, -1.030559, 0.651586>, <1.222655, -0.347893, 0.548621>, <1.213172, 0.012462, 0.548621>, 
      <0.429508, -0.783366, 1.564480>, <0.814536, -0.781287, 1.471902>, <0.775081, -0.385750, 2.022796>, <0.764999, 0.010119, 2.025419>, 
      <0.417462, -0.857143, 2.241222>, <0.802489, -0.855064, 2.148644>, <1.399008, -0.385750, 2.022796>, <1.388926, 0.010119, 2.025419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.872180, 0.000000, 0.000000>, <-0.862185, -0.379808, 0.000000>, <-0.319776, -0.853950, 0.000000>, <0.060150, -0.857143, 0.000000>, 
      <-0.986616, 0.029261, 0.742485>, <-0.976621, -0.350546, 0.742485>, <-0.219922, -1.024337, 0.651586>, <0.160004, -1.027530, 0.651586>, 
      <-0.554287, 0.003000, 1.727355>, <-0.544613, -0.376808, 1.724838>, <0.060102, -0.785361, 1.653302>, <0.429508, -0.783366, 1.564480>, 
      <-0.484835, 0.000000, 2.475955>, <-0.475162, -0.379808, 2.473439>, <0.048056, -0.859138, 2.330044>, <0.417462, -0.857143, 2.241222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.872180, 0.000000, 0.000000>, <-0.986616, 0.029261, 0.742485>, <-0.554287, 0.003000, 1.727355>, <-0.484835, 0.000000, 2.475955>, 
      <-0.881916, 0.369961, 0.000000>, <-0.996352, 0.399223, 0.742485>, <-0.563709, 0.372961, 1.729806>, <-0.494257, 0.369961, 2.478406>, 
      <-0.355039, 0.860252, 0.000000>, <-0.267038, 1.081851, 0.641408>, <0.001497, 0.771305, 1.660084>, <0.013973, 0.855199, 2.339099>, 
      <0.015037, 0.857142, 0.000000>, <0.103039, 1.078741, 0.641408>, <0.361326, 0.773249, 1.573565>, <0.373802, 0.857142, 2.252580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <0.006736, -0.921973, -0.576577>, <0.018855, -0.786678, -0.269468>, <0.060150, -0.857143, 0.000000>, 
      <-0.039878, 0.849320, -0.576577>, <-0.018781, 0.047648, -0.576577>, <-0.361072, -0.783486, -0.269468>, <-0.319776, -0.853950, 0.000000>, 
      <-0.028760, 0.746855, -0.319220>, <-0.398837, 0.749965, -0.319220>, <-0.871921, -0.009847, 0.000000>, <-0.862185, -0.379808, 0.000000>, 
      <0.015037, 0.857142, 0.000000>, <-0.355039, 0.860252, 0.000000>, <-0.881916, 0.369961, 0.000000>, <-0.872180, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <0.006736, -0.921973, -0.576577>, <0.018855, -0.786678, -0.269468>, <0.060150, -0.857143, 0.000000>, 
      <-0.039878, 0.849320, -0.576577>, <-0.018781, 0.047648, -0.576577>, <0.379321, -0.789707, -0.269468>, <0.420617, -0.860172, 0.000000>, 
      <-0.028760, 0.746855, -0.319220>, <0.347695, 0.743691, -0.319220>, <0.916874, 0.000947, 0.000000>, <0.926777, -0.375392, 0.000000>, 
      <0.015037, 0.857142, 0.000000>, <0.391493, 0.853979, 0.000000>, <0.907390, 0.361302, 0.000000>, <0.917294, -0.015037, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <0.926062, -0.128203, -0.576577>, <0.760705, -0.029590, -0.290350>, <0.917294, -0.015037, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <0.900546, 0.841418, -0.576577>, <0.750801, 0.346748, -0.290350>, <0.907390, 0.361302, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <0.900546, 0.841418, -0.576577>, <0.347695, 0.743691, -0.319220>, <0.391493, 0.853979, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.039878, 0.849320, -0.576577>, <-0.028760, 0.746855, -0.319220>, <0.015037, 0.857142, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <0.006736, -0.921973, -0.576577>, <0.018855, -0.786678, -0.269468>, <0.060150, -0.857143, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <0.947159, -0.929875, -0.576577>, <0.379321, -0.789707, -0.269468>, <0.420617, -0.860172, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <0.947159, -0.929875, -0.576577>, <0.770188, -0.389945, -0.290350>, <0.926777, -0.375392, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <0.926062, -0.128203, -0.576577>, <0.760705, -0.029590, -0.290350>, <0.917294, -0.015037, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <0.006736, -0.921973, -0.576577>, <0.018855, -0.786678, -0.269468>, <0.060150, -0.857143, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.882319, -0.914502, -0.576577>, <-0.361072, -0.783486, -0.269468>, <-0.319776, -0.853950, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.882319, -0.914502, -0.576577>, <-0.814669, -0.391958, -0.308292>, <-0.862185, -0.379808, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.903416, -0.112830, -0.576577>, <-0.824664, -0.012150, -0.308292>, <-0.872180, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <0.926062, -0.128203, -0.576577>, <0.760705, -0.029590, -0.290350>, <0.917294, -0.015037, 0.000000>, 
      <-0.903416, -0.112830, -0.576577>, <0.037007, -0.120733, -0.576577>, <0.770188, -0.389945, -0.290350>, <0.926777, -0.375392, 0.000000>, 
      <-0.824664, -0.012150, -0.308292>, <-0.814669, -0.391958, -0.308292>, <0.040691, -0.856979, 0.000000>, <0.420617, -0.860172, 0.000000>, 
      <-0.872180, 0.000000, 0.000000>, <-0.862185, -0.379808, 0.000000>, <-0.319776, -0.853950, 0.000000>, <0.060150, -0.857143, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <-0.039878, 0.849320, -0.576577>, <-0.028760, 0.746855, -0.319220>, <0.015037, 0.857142, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.928933, 0.856791, -0.576577>, <-0.398837, 0.749965, -0.319220>, <-0.355039, 0.860252, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.928933, 0.856791, -0.576577>, <-0.834400, 0.357812, -0.308292>, <-0.881916, 0.369961, 0.000000>, 
      <-0.014361, -0.120301, -0.576577>, <-0.903416, -0.112830, -0.576577>, <-0.824664, -0.012150, -0.308292>, <-0.872180, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.014361, -0.120301, -0.576577>, <-0.903416, -0.112830, -0.576577>, <-0.824664, -0.012150, -0.308292>, <-0.872180, 0.000000, 0.000000>, 
      <0.926062, -0.128203, -0.576577>, <0.037007, -0.120733, -0.576577>, <-0.834400, 0.357812, -0.308292>, <-0.881916, 0.369961, 0.000000>, 
      <0.760705, -0.029590, -0.290350>, <0.750801, 0.346748, -0.290350>, <0.021416, 0.857088, 0.000000>, <-0.355039, 0.860252, 0.000000>, 
      <0.917294, -0.015037, 0.000000>, <0.907390, 0.361302, 0.000000>, <0.391493, 0.853979, 0.000000>, <0.015037, 0.857142, 0.000000>
    }
  }
}
union { // sPatchGroup
  object { sPatchObj }
  object { sPatchObj1 }
  object { sPatchObj2 }
  texture {
    Bear_Body
  }
  scale 0.05
  rotate <79.830452, -1.292563, 154.94548>
  translate  <-4.83, -13.12, 0.02>
}


