#declare cam = off;
#declare nucl_wave = on;
#declare nucl_mush = on;
#declare media_intervals = 30;
#if (cam)
  camera {  //  Camera Camera01
    location  <    -10.710,     -18.240,       2.340>
    direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
    sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
    up        <        0.0,         0.0,         1.0> // Where Z is up
    right     <    1.33333,         0.0,         0.0> // Aspect ratio
    look_at   <     -0.060,       4.250,       3.170>
  }
#end

// ********  REFERENCED OBJECTS  *******

#declare HgtFld005 = object { 
  height_field {
    tga "hfbr02.tga"
    water_level 0.1
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <3.0, 3.2, 0.6>
  rotate <156.011902, -256.745392, 100.379143>
  translate  <6.76, 37.36, 3.6>
}
#declare HgtFld004 = object { 
  height_field {
    tga "hfbr01.tga"
    water_level 0.1
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <2.7, 2.295, 0.4725>
  rotate <26.456766, -232.803085, -69.507408>
  translate  <1.72, 35.46, 5.46>
}
#declare HgtFld003 = object { 
  height_field {
    tga "hfbr01.tga"
    water_level 0.1
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <4.0, 3.4, 0.7>
  rotate <43.04636, 7.473181, 16.38624>
  translate  <-0.19, 32.34, 2.59>
}
#declare CSG147 = union { // CSG147
  object { HgtFld005 }
  object { HgtFld004 }
  object { HgtFld003 }
  texture { Wall01 }
  translate  <5.25, -0.41, 0.0>
}

// ********  OBJECTS  *******

object { // CSG148->CSG147
  CSG147
  scale <-1.0, 1.0, 1.0>
  rotate <-10.0, -105.0, -0.0>
  translate  <14.63, 0.99, 10.77>
}

object { CSG147 }

// EXPLOSION

#declare emis01 = 0.4;
#if (nucl_wave)
  box {
     <-10,0,20> <10,5,0>
     material {
        texture {
          pigment { color rgb 0 transmit 1 }
          finish { ambient 0 diffuse 0 }
        }
        interior {
           media {
              emission 0.4
              absorption <0,0.1,0.3>
              intervals media_intervals
              density {
                 gradient y
                 density_map {
                    [ 0
                       gradient z
                       density_map {
                          [ 0
                             average
                             density_map {
                               [ 1
                                 wrinkles
                                 color_map {
                                    [ 0.6 color rgb <0.1,0.0,0.0>*0.1*emis01 ]
                                    [ 0.6 color rgb <0.3,0.1,0.0>*emis01 ]
                                    [ 0.7 color rgb <0.6,0.6,0.4>*emis01 ]
                                    [ 0.8 color rgb <0.7,0.7,0.6>*emis01 ]
                                 }
                                 scale <0.1,0.1,0.5>*0.5
                               ]
                               [ .2
                                 granite
                                 color_map {
                                    [ 0.6 color rgb <0.1,0.0,0.0>*0.1*emis01  ]
                                    [ 0.6 color rgb <0.3,0.1,0.0>*emis01  ]
                                    [ 0.7 color rgb <0.6,0.6,0.4>*emis01  ]
                                    [ 0.8 color rgb <0.7,0.7,0.6>*emis01  ]
                                 }
                                 scale <0.1,0.1,0.3>*0.2
                               ]
                             }
                          ]
                          [ .8
                            average
                            density_map {
                               [ 1
                                 wrinkles
                                 color_map {
                                    [ 0.4 color rgb <0.1,0.0,0.0> ]
                                    [ 0.4 color rgb <0.3,0.1,0.0> ]
                                    [ 0.6 color rgb <0.6,0.6,0.4> ]
                                    [ 0.8 color rgb <0.7,0.7,0.6> ]
                                 }
                                 scale <0.1,0.1,0.5>*0.5
                               ]
                               [ .3
                                 wrinkles
                                 color_map {
                                    [ 0.4 color rgb <0.1,0.0,0.0> ]
                                    [ 0.4 color rgb <0.3,0.1,0.0> ]
                                    [ 0.6 color rgb <0.6,0.6,0.4> ]
                                    [ 0.8 color rgb <0.7,0.7,0.6> ]
                                 }
                                 scale <0.1,0.1,0.5>*0.1
                               ]
                               [ .4
                                 granite
                                 color_map {
                                    [ 0.4 color rgb <0.1,0.0,0.0> ]
                                    [ 0.4 color rgb <0.3,0.1,0.0> ]
                                    [ 0.6 color rgb <0.6,0.6,0.4> ]
                                    [ 0.8 color rgb <0.7,0.7,0.6> ]
                                 }
                                 scale <0.1,0.1,0.3>*0.2
                               ]
                            }
                          ]
                       }
                       turbulence 0.1
                       octaves 8
                       lambda 3
                       omega 0.3
                       scale 12
                       translate <0,0,-5>
                    ]
                    [ 1 color rgb 0 ]
                 }
                 scale 5
              }
           }
        }
     }
     hollow
     scale 3
     rotate 90*x
     translate <10,78,0>
  }
#end

// --------------------------------------

#declare nuclear_volume =
material {
  texture {
     pigment { color rgb 0 transmit 1 }
     finish { ambient 0 diffuse 0 }
  }
  interior {
    media {
       intervals media_intervals
       emission 0.015          
       absorption 0.188*1.5
       density {
        gradient y
        density_map {
           [ 0.00
              average
              density_map {
                [ 1
                  wrinkles
                  color_map {
                     [ 0.4 color rgb <0.3,0.3,0.3>*0.0 ]  
                     [ 0.6 color rgb <0.5,0.4,0.2>*0.05 ]  
                  }
                  scale <0.05,0.3,0.05>
                ]
                [ 1
                  wrinkles
                  color_map {
                     [ 0.4 color rgb <0.8,0.3,0.1>*0.0 ]  
                     [ 0.6 color rgb <0.6,0.4,0.2>*0.05 ]  
                  }
                  scale <0.05,0.3,0.05>*0.2
                ]
              }
           ]
           [ 0.35
              wrinkles
              color_map {
                 [ 0.4 color rgb <0.3,0.3,0.3>*0.0 ]  
                 [ 0.6 color rgb <0.3,0.3,0.3>*0.0 ]  
              }
              scale <0.05,0.3,0.05>
           ]
           [ 0.40 color rgb <0.8,0.7,0.4>*0.0 ]
           [ 0.70
              wrinkles
              color_map {
                 [ 0.4 color rgb <0.3,0.3,0.3>*0.4 ]  
                 [ 0.6 color rgb <0.3,0.3,0.3>*0.1 ]  
              }
              scale 0.05
           ]
           [ 0.75 color rgb <0.9,0.8,0.6>*0.0 ]
           [ 0.95 color rgb <0.9,0.8,0.6>*0.0 ]
        }
       }
       
    }
    media {
       intervals media_intervals
       emission <0.01,0.009,0.006>*7.2*3
       absorption <0,0.2,0.5>0.04*4
       density {
          wrinkles
          density_map {
             [ 0.35 color rgb 0 ]
             [ 0.60
                average
                density_map {
                  [ 1
                    gradient y
                    color_map {
                       [ 0.00 color rgb <0.3,0.2,0.2>*1.0 ]
                       [ 0.35 color rgb <0.5,0.4,0.3>*1.0 ]
                       [ 0.40 color rgb <0.7,0.4,0.1>*1.0 ]
                       [ 0.70 color rgb <0.5,0.4,0.4>*0.0 ]
                       [ 0.76 color rgb <0.7,0.2,0.1>*1.0 ]
                       [ 0.85 color rgb <0.9,0.6,0.3>*1.0 ]
                    }
                    scale 20
                  ]
                  [ 0.5
                    wrinkles
                    color_map {
                       [ 0.3 color rgb 0 ]
                       [ 0.4 color rgb <0.4,0.3,0.1>*2 ]
                    }
                    scale 0.2
                    turbulence 0.2
                  ]
                  [ 0.5
                    wrinkles
                    color_map {
                       [ 0.3 color rgb 0 ]
                       [ 0.4 color rgb <0.4,0.3,0.1>*2 ]
                    }
                    scale 0.6
                    turbulence 0.2
                  ]
                }
             ]
          }
          scale 0.05
          turbulence 0.3
       }  
    } 
  }
}
   
#if (nucl_mush)
  lathe{
  	cubic_spline
  	23,
  	<0.000000,0.013000>,
  	<0.003000,0.023000>,
  	<0.038000,0.027000>,
  	<0.089000,0.045000>,
  	<0.142000,0.106000>,
  	<0.122000,0.179000>,
  	<0.037000,0.167000>,
  	<0.071000,0.196000>,
  	<0.111000,0.251000>,
  	<0.100000,0.303000>,
  	<0.050000,0.308000>,
  	<0.029000,0.311000>,
  	<0.068000,0.444000>,
  	<0.209000,0.479000>,
  	<0.362000,0.448000>,
  	<0.415000,0.477000>,
  	<0.393000,0.513000>,
  	<0.282000,0.518000>,
  	<0.000000,0.521000>,
  	<0.000000,0.514000>,
  	<0.000000,0.013000>,
  	<0.003000,0.023000>,
  	<0.038000,0.027000>
  	scale 2
  	rotate -180*x
    translate <0,1,0>
    hollow
    material { nuclear_volume }
    scale 250
    rotate x*90
    translate y*350
    translate x*150
  }
#end
