/*
camera {
   location <0,10,0>
   look_at 0
}

light_source { <0,10,0> color rgb 1 }

#include "nucl_textures.inc"

camera {  //  Camera Camera01
  location  <    -10.710,     -18.240,       2.340>
  direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.060,       4.250,       3.170>
}

// *******  L I G H T S *******

light_source { <5000,-6000,10000> color rgb 1.0 }
light_source { <-10,-18,2.3> color rgb 0.1 }
*/
#declare leaf_points = 5;
#declare sin_size    = .05;
#declare pow_size    = 2;
#declare ppow_size   = pow(pow_size+1,2);
#declare lf_counter = 0;
#declare leaf = mesh {
#while (lf_counter<1)
   #declare lf_point_xpos = 0.01+sin_size*sin(lf_counter*pi);
   #declare lf_npoint_xpos = 0.01+sin_size*sin((lf_counter+1/leaf_points)*pi);
   #declare lf_point_ypos = pow(1+lf_counter*pow_size,2)/ppow_size;
   #declare lf_npoint_ypos = pow(1+(lf_counter+1/leaf_points)*pow_size,2)/ppow_size;
     triangle {
         <lf_point_xpos,lf_point_ypos,lf_counter>,
         <-lf_point_xpos,lf_point_ypos,lf_counter>,
         <-lf_npoint_xpos,lf_npoint_ypos,lf_counter+1/leaf_points>
     }
     triangle {
         <lf_point_xpos,lf_point_ypos,lf_counter>,
         <-lf_npoint_xpos,lf_npoint_ypos,lf_counter+1/leaf_points>,
         <lf_npoint_xpos,lf_npoint_ypos,lf_counter+1/leaf_points>
     }
   #declare lf_counter = lf_counter + 1/leaf_points;
#end
}

#declare counter1 = 0;
#declare max_count = 4000;
#declare se01 = seed (1234);
#declare se02 = seed (2322);
#declare max_leaf_s = seed (343);
#declare max_leaf = 6;
#declare min_leaf = 3;
#declare lbsiz_x = 11;
#declare lbsiz_y = 3;
// x 5.5 y 1.5 
union {
  #while (counter1<max_count)
    #declare rand_mov1 = lbsiz_x*rand (se01);
    #declare rand_mov2 = lbsiz_y*rand (se02);
    #declare rand_lrot = rand(se01);
    #declare counter = 0;
    #declare max_leaf = int(min_leaf+(max_leaf-min_leaf)*rand(max_leaf_s));
    #declare rss = seed (213);
    #while (counter<max_leaf)
       #declare l_rand_scale1 = 2*rand(rss);
       #declare l_rand_scale2 = rand(rss);
       object {
          leaf
          rotate -70*x
          scale <1,1+l_rand_scale1,1>
          rotate y*(counter*(360/max_leaf))
          rotate y*rand(max_leaf_s)*360
          texture { gr_text }
          texture { pigment { color green 1*rand_lrot transmit 0.7 } }
          scale <.2,.03,.2>*(1-rand_lrot*0.2)
          rotate 90*x
          translate <lbsiz_x/2-rand_mov1,lbsiz_y/2-rand_mov2,0>
       }
       #declare counter = counter + 1;
    #end
    #declare counter1 = counter1 + 1;
  #end
  translate  <-6.5, -10.6, -0.15>
  texture {
     pigment {
        wrinkles
        color_map {
         [ 0.0 color rgb <0.1,0.7,0.2>*0.3 transmit 0.8 ]
         [ 0.3 color rgb <0.1,0.7,0.2>*1.0 transmit 0.8 ]
         [ 0.7 color rgb <0.1,0.7,0.2>*0.4 transmit 0.8 ]
         [ 1.0 color rgb <0.1,0.7,0.2>*1.0 transmit 0.8 ]
        }
     }
     scale 2
  }
} 

#declare counter = 0;
#declare flowers = 100;
#declare sd = seed (3423);
#while (counter<flowers)
   union {
      #declare lattice = int(6+rand(sd)*6);
      #declare counter2 = 0;
      #declare fcol = 1.2*<0.8,0.8,0>-rand(sd)*0.2;
      #while (counter2<lattice)
         sphere {
            <0,0,0>,1
            scale <1,.1,.5>
            translate x*1
            rotate z*(15-rand(sd)*30)
            rotate y*counter2*(360/lattice)
            pigment { color rgb fcol }
         }
         #declare counter2 = counter2 +1;
      #end
      sphere {
        <0,0,0>,0.3
        scale <1,.3,1>
        pigment { color rgb <1,.8,0> }
      }
      cylinder {
        <0,-4,0> <0,0,0>,0.2
        pigment { color rgb <.4,.3,.1> }
      }
      translate y*(3-rand(sd)*1.5)
      rotate y*(rand(sd)*360)
      scale (0.1+(rand(sd)/10))*0.2
      //translate <rand(sd),rand(sd)*0.2,rand(sd)>*12
      //translate <-6,0.4,-6>
      pigment { color rgb 1 }
      finish {
         ambient 0.2
         diffuse 0.7
         specular 0.2
         roughness 0.1
         crand 0.05
      }
      rotate 90*x
      translate <lbsiz_x/2-rand(sd)*lbsiz_x,lbsiz_y/2-rand(sd)*lbsiz_y,0>
      translate  <-6.5, -10.6, -0.15>
   }
   #declare counter = counter +1;
#end 

object { 
  height_field {
    tga "grass.tga"
    smooth
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <8.0, 8.0, 0.05>
  translate  <-6.92, -17.1, -0.16>
  texture { HFTexture01 }
}
object { 
  height_field {
    tga "grass02.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <8.0, 8.0, 0.10>
  translate  <-6.92, -16.8, -0.16>
  //texture { gr_text scale 0.2 }
  //texture { pigment { color 1*rand_lrot transmit 0.7 } scale 0.2 }
  texture {
     pigment {
        wrinkles
        color_map {
         [ 0.00 color rgb <0.1,0.7,0.2> ]
         [ 0.50 color rgb <0.1,0.7,0.2> ]
         [ 0.55 color rgb 1  ]
         [ 1.00 color rgb 1  ]
        }
     }
     scale 1
  } 
}
