#include "left_building.inc"

#declare box_size_x = 3;
#declare box_size_y = 3;
#declare box_size_z = 3;
#declare round_amount = 1;

#macro rounded_box (bsx,bsy,bsz,rou)
   #declare box_size_x = bsx;
   #declare box_size_y = bsy;
   #declare box_size_z = bsz;
   #declare round_amount = rou;
   union {
      #declare x1p = (box_size_x/2)-round_amount;
      #declare y1p = (box_size_y/2)-round_amount;
      #declare z1p = (box_size_z/2)-round_amount;
   
      #declare corners =
      union {
         cylinder { <x1p,y1p,z1p> <-x1p,y1p,z1p>,round_amount }
         cylinder { <x1p,y1p,-z1p> <-x1p,y1p,-z1p>,round_amount }
         cylinder { <x1p,y1p,z1p> <x1p,y1p,-z1p>,round_amount }
         cylinder { <-x1p,y1p,z1p> <-x1p,y1p,-z1p>,round_amount }
         cylinder { <x1p,y1p,-z1p> <x1p,-y1p,-z1p>,round_amount }
         cylinder { <-x1p,y1p,-z1p> <-x1p,-y1p,-z1p>,round_amount }
         sphere   { <x1p,y1p,z1p>,round_amount }
         sphere   { <-x1p,y1p,z1p>,round_amount }
         sphere   { <x1p,y1p,-z1p>,round_amount }
         sphere   { <-x1p,y1p,-z1p>,round_amount }
         sphere   { <x1p,-y1p,-z1p>,round_amount }
         sphere   { <-x1p,-y1p,-z1p>,round_amount }
      }
      
      object { corners }
      object { corners rotate x*180 }
   
      box {
         <-(box_size_x/2-round_amount),-box_size_y/2,-(box_size_z/2-round_amount)>
         <box_size_x/2-round_amount,box_size_y/2,box_size_z/2-round_amount>
      }
      box {
         <-box_size_x/2,-(box_size_y/2-round_amount),-(box_size_z/2-round_amount)>
         <box_size_x/2,box_size_y/2-round_amount,box_size_z/2-round_amount>
      }
      box {
         <-(box_size_x/2-round_amount),-(box_size_y/2-round_amount),-box_size_z/2>
         <box_size_x/2-round_amount,box_size_y/2-round_amount,box_size_z/2>
      }
      translate <box_size_x/2,box_size_y/2,box_size_z/2>
   }
#end

// corner_blocks 
#declare cb =
union {
  #declare cbx_counter = 0;
  #while (cbx_counter<8)
      object {
        rounded_box(0.2,0.2,0.25,0.03)
        translate <10.05-0.2,-0.05,cbx_counter>
      }
      object {
        rounded_box(0.5,0.5,0.25,0.03)
        translate <10.05-0.5,-0.05,cbx_counter+0.25>
      }
    #declare cbx_counter = cbx_counter+0.5;
  #end
  texture { Stone01 }
}

// middle_blocks
#declare mb =
union {
  #declare cbx_counter = 0;
  #while (cbx_counter<8)
      object {
        rounded_box(0.3,0.2,0.25,0.03)
        translate <2.15,-0.05,cbx_counter>
      }
      object {
        rounded_box(0.6,0.5,0.25,0.03)
        translate <2.0,-0.05,cbx_counter+0.25>
      }
    #declare cbx_counter = cbx_counter+0.5;
  #end
  texture { Stone01 }
}

#declare Balcony = difference {
  /*box { // RBox
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.1>
    translate  <6.0, -0.5, 4.3>
  }*/
  object {
       rounded_box (4.0,1.0,0.2,0.02)
       translate <-2,-0.5,-0.1>
       translate  <6.0, -0.5, 4.3>
  }
  box { // RBox1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.9, 0.4, 0.1>
    translate  <6.0, -0.5, 4.15>
  }
  translate  -0.35*z
}

#declare SDoor = difference {
  object {
    rounded_box (2.2,0.4,3.2,0.02)
    translate <-1.1,-0.2,-1.6>
    translate  <6.0, 0.2, 5.8>
  }
  /* box { // Rbox2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.2, 1.4>
    translate  <6.0, 0.2, 5.8>
  }  */
  box { // Rbox3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 1.6>
    translate  <6.0, 0.2, 5.7>
  }
}

#declare SWin1 = difference {
  object {
    rounded_box (1.6,0.4,2.0,0.02)
    translate <-0.8,-0.2,-1.0>
    translate  <6.0, 0.2, 5.9>
  }/*
  box { // Rbox4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.2, 1.0>
    translate  <6.0, 0.2, 5.9>
  }*/
  box { // Rbox5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.25, 0.9>
    translate  <6.0, 0.2, 5.9>
  }
  translate  -0.3*z
}
/*
// ROOF GENERATORS --------------------
#declare Row =
union {
  #declare counter = 0;
  #declare max_count = 10;
  #while (counter<max_count)
     object { KP  translate <0,-0.52*counter,0> }
     #declare counter = counter +1;
  #end
  material {
    RoofT
  }
  translate  <0.0, -5.0, -10.9>
  rotate 28.5*x
  translate  <9.8, 5.0, 10.9>
}
union { // Roof
  #declare counter = 0;
  #declare max_count = 30;
  #while (counter<max_count)
     object { Row translate <-0.4*counter,0,0> }
     #declare counter = counter +1;
  #end
  material {
    RoofT
  }
}
union { // CSG001
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    rotate -45.0*x
  }
  material {
    Material1
  }
  scale <1.0, 3.6, 2.0>
  translate  <0.0, 5.0, 8.0>
}
// ------------------------------------

*/