#declare cam = off;
#if (cam)
  camera {  //  Camera Camera01
    location  <    -10.710,     -18.240,       2.340>
    direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
    sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
    up        <        0.0,         0.0,         1.0> // Where Z is up
    right     <    1.33333,         0.0,         0.0> // Aspect ratio
    look_at   <     -0.060,       4.250,       3.170>
  }
#end

// ### ATMOSPHERE ###
#declare sky_color01 = <0.9,0.8,0.6>;                
#declare sky_color02 = <0.7,0.8,0.8>;
sky_sphere {
  pigment {
    average 
    pigment_map {
      [ 1
        gradient y
        color_map {
           [ 0.15 color rgb sky_color02*0.3 ]
           [ 0.60 color rgb sky_color02 *1.0 ]
        }
      ]
      [ 0.1
        wrinkles
        color_map {
           [ 0.30 color rgb sky_color01*0.2 ]
           [ 0.70 color rgb sky_color01*1.3 ]
        }
        scale <1,1,0.5>*0.7
      ]
    }
  }
  rotate x*90
} 

// ### CLOUDS ###
#declare col = sky_color01;
plane {
   y,10000
   pigment {
      spherical
      pigment_map {
        [ 0 color rgb col*0.5 transmit 0.7 ]
        [ 0.6
          wrinkles
          pigment_map {
             [ 0.4 color rgb col transmit 1 ]   
             [ 0.5
                wrinkles
                pigment_map {
                  [ 0.4
                     wrinkles
                     color_map {
                        [ 0.4 color rgb col*2.0 transmit 0.7 ]
                        [ 0.5 color rgb col*3.0 transmit 0.7 ]
                     }
                     turbulence 0.05
                  ]
                  [ 0.5
                     wrinkles
                     color_map {
                        [ 0.4 color rgb col*0.5 transmit 0.7 ]
                        [ 0.5 color rgb col*1.0 transmit 0.7 ]
                     }
                  ]
                }
                turbulence 0.05
                translate <-0.04,0,-0.08>
             ]   
             [ 0.6
                average
                pigment_map {
                  [ 1
                    wrinkles
                    pigment_map {
                      [ 0.3 color rgb col*0.5 transmit 0.7 ]
                      [ 0.7
                         wrinkles
                         color_map {
                            [ 0.1 color rgb col*1.0 transmit 0.7 ]
                            [ 0.9 color rgb <0.6,0.4,0>+col*2.0 transmit 0.7 ]
                         }
                         translate <-0.1,0,0.02>
                      ]
                      
                    }
                    scale 0.8
                  ]
                  [ 0.5
                    granite
                    pigment_map {
                      [ 0.3 color rgb col*0.5 transmit 0.5 ]
                      [ 0.7
                         granite
                         color_map {
                            [ 0.1 color rgb col*col*1.0 transmit 0.5 ]
                            [ 0.9 color rgb <0.6,0.4,0>+col*2.0 transmit 0.5 ]
                         }
                         translate <-0.1,0,0.02>
                      ]
                      
                    }
                    turbulence 0.4
                    octaves 8
                    lambda 2
                    omega 0.2
                    scale 0.8
                  ]
                }
             ]   
          }
          turbulence 0.2
          octaves 8
          lambda 3
          omega 0.2
          scale 0.3
        ]
      }
      scale 100000
      translate 10000*y
      translate 10000*z
   }
   finish { ambient 1 diffuse 0 }
   hollow
   rotate x*90
}             
