/*
This file is made by and copyrighted 1999 to Peter Hertel {B160NE} Email:bigone@hertel.no

It was made as a part of my Horror project at Internet Ray Tracing Competition (www.irtc.org)

You may use this file if you mention me as the creator, my homepage, and mail.

Visit my homepage at http://hertel.no/bigone

If you use this file for something cool, tell me, so that I know my work were useful for someone.
Please drop me some feedback.

This file is made with POV-Ray for Windows v3.1 only, no other programs.
*/

/*
In here you'll find all the "smaller" objects in my scene
It ranges from pens and disks to the corkboard
The cables are in "cable.inc"
*/

//this is the phone in the background
#declare Phone=
union{

#declare Phone_T = texture {pigment {White} finish {Plastic_Dull}}

difference{
   union{
      sphere{< 1.5,2.5, 1.5>,1.5 texture {Phone_T}}
      sphere{< 1.5,2.5,14  >,1.5 texture {Phone_T}}
      sphere{<20  ,2.5, 1.5>,1.5 texture {Phone_T}}
      sphere{<20  ,2.5,14  >,1.5 texture {Phone_T}}

      cylinder {< 1.5,2.5, 1.5>,<20  ,2.5, 1.5>,1.5 texture {Phone_T}}
      cylinder {< 1.5,2.5,14  >,<20  ,2.5,14  >,1.5 texture {Phone_T}}
      cylinder {< 1.5,2.5, 1.5>,< 1.5,2.5,14  >,1.5 texture {Phone_T}}
      cylinder {<20  ,2.5,14  >,<20  ,2.5, 1.5>,1.5 texture {Phone_T}}
      box      {< 1.5,0  , 1.5>,<20  ,4  ,14  >     texture {Phone_T}}
   }
   union{
      box      {<14.5,3.9, 8.5>,<19.5,4.1, 1.5>     texture {Phone_T}}
      cylinder {<17  ,3.5,11.5>,<17  ,5  ,11.5> 2.8 texture {Phone_T}}
      cylinder {< 5  ,3.5,11.5>,< 5  ,5  ,11.5> 2.8 texture {Phone_T}}
   }
}
union{
   difference{
      sphere {< 0, 0, 0>,    2.6 texture {Phone_T}}
      box    {<-4,-4,-4>,<4,0,4> texture {Phone_T}}
   }
   difference{
      sphere {< 0, 0, 0>,    2.6 texture {Phone_T}}
      box    {<-4,-4,-4>,<4,0,4> texture {Phone_T}}
   translate x*12
   }
   difference{
      cylinder {<0,1.6, 0>,<12,1.6,0>,1 texture {Phone_T}}
      box      {<0,0  ,-2>,<12,1.6,2>   texture {Phone_T}}
   }
translate <5,3.5,11.5>
}

#undef Phone_T

//Phone buttons
#declare Phone_B_T = texture {pigment {Gray} finish {Plastic_Dull}}
   #declare Phone_B =
      union{
         cylinder {<0.5,3.5, 0  >,<0.5,4.2,  0>,0.5 texture {Phone_B_T}}
         box      {<0.5,3.5,-0.5>,<1.5,4.2,0.5>     texture {Phone_B_T}}
         cylinder {<1.5,3.5, 0  >,<1.5,4.2,  0>,0.5 texture {Phone_B_T}}
      rotate y*90
      }
   #declare Phone_B2 =
      cylinder {<0,3.5,0>,<0,4.2,0>,0.2 texture {Phone_B_T}}
#undef Phone_B_T

object {Phone_B2 translate <15,0,8>} object {Phone_B2 translate <15,0,2>}
object {Phone_B2 translate <16,0,8>} object {Phone_B2 translate <16,0,2>}
object {Phone_B2 translate <17,0,8>} object {Phone_B2 translate <17,0,2>}
object {Phone_B2 translate <18,0,8>} object {Phone_B2 translate <18,0,2>}
object {Phone_B2 translate <19,0,8>} object {Phone_B2 translate <19,0,2>}

object {Phone_B rotate y*-90 scale <2,1,0.5> translate <15,0,5>}

object {Phone_B scale <0.5,1,1> translate <13.5,0,3.5>}
object {Phone_B scale <0.5,1,1> translate <13.5,0,6  >}
object {Phone_B scale <0.5,1,1> translate <13.5,0,8.5>}

object {Phone_B translate < 5,0,8.5>} object {Phone_B translate < 7,0,8.5>} object {Phone_B translate < 9,0,8.5>} object {Phone_B translate <11,0,8.5>}
object {Phone_B translate < 5,0,6  >} object {Phone_B translate < 7,0,6  >} object {Phone_B translate < 9,0,6  >} object {Phone_B translate <11,0,6  >}
object {Phone_B translate < 5,0,3.5>} object {Phone_B translate < 7,0,3.5>} object {Phone_B translate < 9,0,3.5>} object {Phone_B translate <11,0,3.5>}

object {Phone_B scale <0.5,1,1> translate <3,0,3.5>}

#undef Phone_B

#declare Phone_L_T = texture {pigment {Clear}
finish {ambient 0.2 reflection 0.1 specular 1}
}
   //the little lamp which indicates that the speaker is on or off
   union{
      cylinder {<0.5,3.5, 0  >,<0.5,4.2,  0>,0.5 texture {Phone_L_T}}
      box      {<0.5,3.5,-0.5>,<1.5,4.2,0.5>     texture {Phone_L_T}}
      cylinder {<1.5,3.5, 0  >,<1.5,4.2,  0>,0.5 texture {Phone_L_T}}
      sphere   {<1  ,3.6, 0  >,              0.5 pigment {Red}      }
   rotate y*90
   scale <0.5,1,1>
   translate <3,0,6>
   }
   //the transparent plastic plate behind the top buttons
   box {<14.5,3.5,8.5>,<19.5,4,1.5> texture {Phone_L_T}}
#undef Phone_L_T

cylinder {<18,1, 1.5>,<18,-5, 1.5>,0.15 texture {Gray_Metal}}
cylinder {<18,1,14  >,<18,-5,14  >,0.15 texture {Gray_Metal}}

}//phone end

//Microphone
#declare Mic =
union{
   cone {<0,0,0>,0.2,<1,0,0>,0.25 texture {Plastic_Black}}
   cone {<1,0,0>,0.7,<10.5,0,0>,1.2 texture {Plastic_Black}}
   cone {<10.5,0,0>,1.3,<11.2,0,0>,1.4 texture {Plastic_Black}}
   cone {<11.2,0,0>,1.4,<11.7,0,0>,1.7 texture {Plastic_Black}}

   sphere {<13,0,0>,2.1 texture {Gray_Metal} normal {bumps 1 scale 1/10}}

   cylinder {<12.7,0,0>,<13.2,0,0>,2.2 texture {Plastic_Black}}
   translate y*0.5
   rotate z*8
}

#declare Disk = //THIS one is photorealistic, at least from great distance =:~}
union{
difference{
   box {<0,0,0>,<9,0.3,9> texture {Plastic_Blue}}
   union{
      box      { < 0.2 ,-0.1,0.5 >,<0.7 ,0.4,1   >     texture {Plastic_Blue} }
      box      { < 8.2 ,-0.1,0.5 >,<8.8 ,0.4,1   >     texture {Plastic_Blue} }
      box      { <-0.1 ,-0.1,0   >,<0.6 ,0.4,0.5 >     texture {Plastic_Blue} rotate y*-45 translate z*8.7}
      cylinder { < 0.5 , 0.1,7.6 >,<0.5 ,0.4,7.6 >,0.2 texture {Plastic_Blue} }
      cylinder { < 0   , 0.1,8.35>,<0   ,0.4,8.35>,0.3 texture {Plastic_Blue} }
      cylinder { < 8.45, 0.1,7.6 >,<8.45,0.4,7.6 >,0.2 texture {Plastic_Blue} }
      cylinder { < 9   , 0.1,8.35>,<9   ,0.4,8.35>,0.3 texture {Plastic_Blue} }
      cylinder { < 4.5 , 0.1,4.4 >,<4.5 ,0.4,4.4 >,1.3 texture {Plastic_Blue} }
   }
}   
difference{
   cylinder { <4.5, 0.09,4.4 >,<4.5, 0.31,4.4>,1.2  texture {Gray_Metal} }
   union{
      cylinder { <4.5,0.09,4.4 >,<4.5,0.3,4.4 >,1.15 texture {Gray_Metal} }
      box      { <4.3,0.2 ,4.2 >,<4.7,0.4,4.6 >      texture {Gray_Metal} }
      cylinder { <4.1,0.15,3.65>,<4.9,0.15,3.8>,0.25 texture {Gray_Metal}}
   }
}
difference{
   box {<2,-0.01,6>,   <7,0.31,9.05> texture {Gray_Metal}}
   box {<2.8,-0.1,6.4>,<4,0.4,8.8> texture {Gray_Metal}}
}
box {<0.9,-0.01,-0.01>,<8.1,0.31,1.4> texture {Paper}}
box {<0.9,-0.01,-0.01>,<8.1,0.1, 5.5> texture {Paper}}
translate <-4.5,0,-4.5> //do this if you want to translate the disk from the center
}

//Chair
//I've only made the upper part of it, because you couldn't see the lower part.
//note that I didn't finish this model, because I only used a little part of it, but you can
//model more on it if you want to
#declare Chair =
//union{//use this is you use the whole chair

/*
cylinder {<0,0,0>,<0,40,0>,  3 texture {Gray_Metal}}

cylinder {<0,40,0>,<0,46,0>,20 pigment {Blue}}

box      {<-3,40,0>, <3,34,-26>   texture {Gray_Metal}}
cylinder {<0,39,-24>,<0,59,-24>,1 texture {Gray_Metal}}
cylinder {<0,59,-24>,<0,69,-18>,1 texture {Gray_Metal}}
//difference{ //add this if seeing the chair from the front, (turn off back tilting too)
   cylinder {<-5,69,-24>,<5,69,-24>  ,3 texture {Gray_Metal}}
   //box      {<-6,62,-20>,<6,75,-23.9>   texture {Gray_Metal}}
//}
*/
difference{ //seems very complex... took me no time to make :)
   difference{
      prism {cubic_spline 0,6,11,
      <-1,15>,<0,15>,<15,12>,<20,-5>,<15,-13>,<0,-15>,
      <-15,-13>,<-20,-5>,<-15,12>,<0,15>,<1,15>
      pigment {Blue}}
   
      prism {cubic_spline -16,16,6
      <-25,4>,<0,0>,<25,4>,<-25,4>,<0,0>,<25,4>
      pigment {Blue}
      rotate x*-90 translate y*3}
   }
   difference{
      prism {cubic_spline 0,6,11,
      <-1,15>,<0,15>,<15,12>,<20,-5>,<15,-13>,<0,-15>,
      <-15,-13>,<-20,-5>,<-15,12>,<0,15>,<1,15>
      pigment {Blue}}
      
      prism {cubic_spline -16,16,6
      <-25,4>,<0,0>,<25,4>,<-25,4>,<0,0>,<25,4>
      pigment {Blue}
      rotate x*-90 translate y*3}
   translate y*-1
   scale 1.001/1
   }
rotate <-90,180,0>
rotate x*20//tilts the back forwards, needs to be translated up a bit
translate <0,69,-24>
//translate <0,69,-24> //use this if you turn off the back tilting
}
//}//this is if you're using the whole chair


//corkboard pin
#declare Pin =
   union{
      cone {<0,0,0>,0.1,<0,0,-3>,0.2 texture {Gray_Metal}}
      sphere {<0,0,-3>,0.4 pigment {Red}}
   }

//speakers
#declare Speakertext   = texture {pigment {White} finish {diffuse 0.5 reflection 0 specular 0.1}}

#declare Speaker=
difference{
   union{
      box      {<0,0,-3.5>,  <3.5,12,3.5>  texture {Speakertext}}
      box      {<3,1,-4>,    <4,12.5,4>    texture {Speakertext}}
      box      {<3.5,5,-3.5>,<4.1,12,3.5>  pigment {image_map {tga "speaker.tga" map_type 0} rotate y*90}
                                           finish {diffuse 0.5 reflection 0 specular 0.1}}
      cylinder {<0,0,0>,     <0,12,0>, 3.5 texture {Speakertext}}
      rotate z*10 translate y*-1
      }
   box {<-10,0,-10>,<10,-1,10> pigment {White}}
}

#declare Speakerbuttons =
union{
   cone     {<3.5,2.5,2>,  0.5, <5,2.5,2>,   0.4 texture {Speakertext}}
   cone     {<3.5,2.5,0.5>,0.3, <5,2.5,0.5>, 0.2 texture {Speakertext}}
   cylinder {<3.5,2.5,-1>,      <4.1,2.5,-1>,0.2 pigment {Red} finish {ambient 1 specular 1}}
   rotate z*10 translate y*-1
}
#undef Speakertext

//cup
#declare Cupfinish = finish {diffuse 0.7 reflection 0.05 specular 0.3}
#declare Cuptext = texture {pigment {White} finish {Cupfinish}}

#declare Cup =
union{
   union{
      cylinder{<0,0,0>,<0,10,0>,  5 open pigment {image_map {tga "cup.tga" map_type 2} scale 10} finish {Cupfinish}}
      cylinder{<0,0,0>,<0,10,0>,  4 open              texture {Cuptext}}
      torus   {4.5,0.5                                texture {Cuptext} translate y*10}
      cylinder{<0,0,0>,<0,0.5,0>, 4.99                texture {Cuptext}}
      difference{
         torus   {2,0.5 texture {Cuptext} rotate x*90 translate <5,5,0> rotate y*-41}
         cylinder{<0,0,0>,<0,10,0>, 4.1 texture {Cuptext}}
      }
   rotate <90,180,0> translate y*5
   }
//the red liquid "flowing" out of the cup, not that realistic..
   blob { threshold 0.01
      sphere {<0,0,-14>, 1.5,3}
      sphere {<0,0,-12> ,1,1}
      sphere {<2,0,-13> ,1,1}
      sphere {<-2,0,-14>,1,1}
      sphere {<2,0,-16> ,1,1}
      sphere {<-1,0,-17>,1,1}
      sphere {<0,1,-9>  ,1,2}
      pigment {Red} finish {specular 0.9 reflection 0.7}
      normal {bumps 0.5}
   }
}
#undef Cuptext
#undef Cupfinish

//lamp
#declare Lamptext = texture {pigment {Red} finish {Metal}}

#declare Lamp = union{
light_source {<0,-5,0> White rotate z*-40 translate y*30}
cone     {<0,-10,0>,5,<0,0,0>,1 open texture {Lamptext} rotate z*-40 translate y*30}
sphere   {<0,30,0>, 1                texture {Lamptext}}
cylinder {<0,30,0>,<10,0,0>,  0.5    texture {Lamptext}}
cylinder {<10,0,0>,<10,0.5,0>,5      texture {Lamptext}}
}

#undef Lamptext


//this is the corkboard behind the computer with my url sticker on
#declare Board = union{
box{<0,0,0>,<60,40,-0.8> texture {Cork scale <4,4,2>}}
box{<-1,0,0>, <61,1,-1>  texture {Wood1 scale 10}}
box{<-1,40,0>,<61,41,-1> texture {Wood1 scale 10}}
box{<-1,0,0>, <0,41,-1>  texture {Wood1 scale 10}}
box{<60,0,0>, <61,41,-1> texture {Wood1 scale 10}}
   //nails and holders for the board, I didn't use it..
   /*
   union{
      cylinder {<0,0,0>,<0,1,0>, 0.1 texture {Gray_Metal}}
      torus {1,0.1 rotate x*90 translate y*2 texture {Gray_Metal}}
      cylinder {<0,2.7,1>,<0,2.7,-2>, 0.2 texture {Gray_Metal}}
      cylinder {<0,2.7,-2>,<0,2.7,-2.1>,0.3 texture {Gray_Metal}}
      translate <2,41,0.5>
   }
   union{
      cylinder {<0,0,0>,<0,1,0>, 0.1 texture {Gray_Metal}}
      torus {1,0.1 rotate x*90 translate y*2 texture {Gray_Metal}}
      cylinder {<0,2.7,1>,<0,2.7,-2>, 0.2 texture {Gray_Metal}}
      cylinder {<0,2.7,-2>,<0,2.7,-2.1>,0.3 texture {Gray_Metal}}
      translate <59,41,0.5>
   }
   */
}

//the note with my url on the board
#declare Url = box{<0,0,0>,<10,0.01,15>
               pigment {image_map {tga "url.tga" map_type 0 once} rotate x*90 scale <10,1,15>}
               }

//This is the pen...
#declare Pentext = texture {pigment {Red} finish {Plastic}}

#declare Pen1 =
union{
   cylinder {< 0.8,0.4, 0  >,     <13  ,0.4, 0  >,0.4     texture {Pentext   }}
   cylinder {< 9  ,0.4, 0  >,     < 9.2,0.4, 0  >,0.40001 texture {Gray_Metal}}
   cylinder {< 0  ,0.4, 0  >,     < 1.5,0.4, 0  >,0.2     texture {Gray_Metal}}
   cylinder {< 0.8,0.4,-0.5>,     < 4  ,0.4,-0.5>,0.1     texture {Gray_Metal}}
   cone     {<13  ,0.4, 0  >,0.35,<14  ,0.4, 0  >,0.2     texture {Gray_Metal}}
   cone     {<14  ,0.4, 0  >,0.19,<14.3,0.4, 0  >,0.00001 texture {Gray_Metal}}
}

#undef Pentext

//broken mouse
#declare Chip = union{
box      {<0,0,0>,       <0.5,0.3,1.6>     pigment {Black}                    }
cylinder {<-0.1,0.2,0.2>,<0.6,0.2,0.2>,0.1 pigment {Gray } finish {specular 1}}
cylinder {<-0.1,0.2,0.4>,<0.6,0.2,0.4>,0.1 pigment {Gray } finish {specular 1}}
cylinder {<-0.1,0.2,0.6>,<0.6,0.2,0.6>,0.1 pigment {Gray } finish {specular 1}}
cylinder {<-0.1,0.2,0.8>,<0.6,0.2,0.8>,0.1 pigment {Gray } finish {specular 1}}
cylinder {<-0.1,0.2,1.0>,<0.6,0.2,1.0>,0.1 pigment {Gray } finish {specular 1}}
cylinder {<-0.1,0.2,1.2>,<0.6,0.2,1.2>,0.1 pigment {Gray } finish {specular 1}}
cylinder {<-0.1,0.2,1.4>,<0.6,0.2,1.4>,0.1 pigment {Gray } finish {specular 1}}
}

#declare Mouse = union{
box {<-2.5,0.3,0>,<2.5,0.5,6> pigment {Green}}
cylinder {<0,0.3,6>,<0,0.5,6>, 2.5 pigment {Green}}

difference{
union{
box {<-2.7,0,-0.2>,<2.7,1,6> pigment {White}}
cylinder {<0,0,6>,<0,1,6>, 2.7 pigment {White}}
}
union{
box {<-2.5,0.2,0>,<2.5,2,6> pigment {White}}
cylinder {<0,0.2,6>,<0,2,6>, 2.5 pigment {White}}
}
}

cylinder{<0,0.3,1>,<0,0.3,-0.5>,0.3 pigment {White}}
object {Cableripped1 translate <0,0.3,-0.5>}
cylinder{<0,0,3>,<0,1,3>,1 open pigment {Black} finish {reflection 0.1 specular 0.6 ambient 0.4}}
sphere {<0,0.2,3>,1 pigment {White}}
box{<0,0,0>,<1,0.7,0.5> pigment {Black} translate <-1.5,0,4>}
box{<0,0,0>,<1,0.7,0.5> pigment {Black} translate <-2.4,0,0.2>}
box{<0,0,0>,<1,0.7,0.5> pigment {Black} translate <1.4,0,0.2>}
sphere{<0,0.7,6>, 0.3 pigment {Blue}}
sphere{<0,0.6,7>, 0.2 pigment {Yellow}}
object{Chip translate <-1,0.8,5>}
object{Chip translate <1.5,0.3,2>}
object{Chip translate <2,0.6,1> scale 0.5}
object{Chip rotate y*70 translate <-3,0,-3>}
cylinder{<-1.5,0.7,2.0>,<-1.5,0.7,2.1>, 0.2 pigment {Yellow}}
cylinder{<-1.5,0.7,2.3>,<-1.5,0.7,2.4>, 0.2 pigment {Yellow}}
cylinder{<-1.5,0.7,2.6>,<-1.5,0.7,2.7>, 0.2 pigment {Yellow}}


cylinder {<0,0.5,0>, <2,0.5,0>, 0.1 pigment {White} finish {specular 1}}
cylinder {<2,0.5,0>, <2,0.5,5>, 0.1 pigment {White} finish {specular 1}}
cylinder {<2,0.5,5>, <1,0.5,5>, 0.1 pigment {White} finish {specular 1}}
cylinder {<1,0.5,5>, <1,0.5,6>, 0.1 pigment {White} finish {specular 1}}
cylinder {<1,0.5,6>, <-2,0.5,6>,0.1 pigment {White} finish {specular 1}}
cylinder {<-2,0.5,6>,<-2,0.5,0>,0.1 pigment {White} finish {specular 1}}
cylinder {<-2,0.5,2>,<2,0.5,2>, 0.1 pigment {White} finish {specular 1}}
cylinder {<0,0.5,1>, <-2,0.5,2>,0.1 pigment {White} finish {specular 1}}
}

//notepad
#declare Notepad = union{
box{<0,0,0>,<10,1,15> pigment {image_map {tga "notepad.tga" map_type 0 once} rotate x*90 scale <10,1,15>}}
#declare Ring = torus
{1,0.1 pigment {Gray} finish {reflection 0.1 specular 0.7} rotate <90,90,0> translate z*15}
object {Ring translate x*1}object {Ring translate x*2}object {Ring translate x*3}
object {Ring translate x*4}object {Ring translate x*5}object {Ring translate x*6}
object {Ring translate x*7}object {Ring translate x*8}object {Ring translate x*9}
}

//mousemat
#declare Mousemat=difference{
box{<0,0,0>,<22,0.5,26>
pigment {rgb <0.9,0.2,0.3>} finish {reflection 0 specular 0 ambient 0}}
   #declare Corner = difference{
   torus {2,0.5 pigment {Red}}
   union{
   box {<-4,-2,0>,<4,2,4> pigment {Red}}
   box {<0,-2,-4>,<4,2,4> pigment {Red}}
   }translate <1.5,0.25,1.5>}
union{
object {Corner}
object {Corner rotate y*-90 translate x*22}
object {Corner rotate y*180 translate <22,0,26>}
object {Corner rotate y*90  translate <0,0,26>}
}}

//drawings on the desk (all of them are taken from my previous scenes)
#declare Drawingfinish = finish {diffuse 0.5 reflection 0.2 specular 0.2}
#declare Drawing1 = box{<0,0,0>,<20,-0.01,15> finish {Drawingfinish}
                    pigment {image_map {tga "drawing1.tga" map_type 0 once} scale <20,15,1> rotate x*90}}
#declare Drawing2 = box{<0,0,0>,<20,-0.01,15> finish {Drawingfinish}
                    pigment {image_map {tga "drawing2.tga" map_type 0 once} scale <20,15,1> rotate x*90}}
#declare Drawing3 = box{<0,0,0>,<20,-0.01,15> finish {Drawingfinish}
                    pigment {image_map {tga "drawing3.tga" map_type 0 once} scale <20,15,1> rotate x*90}}
#undef Drawingfinish