// --- OBJECT INCLUDE FILES ---
#include "courtroom\c_podium.inc"
#include "courtroom\c_mic.inc" 
#include "courtroom\c_door.inc" 

// --- TEXTURES ---
#declare carpet =
texture
{
	//pigment {rgb <.7,.9,1>}
	//normal {bumps .5 scale .05}  
	//finish {phong 100}
	pigment {Black}
	finish  {reflection .7}
}
       
#declare wall = texture{PinkAlabaster scale .05}

// --- OBJECT DECLARATIONS ---
#declare mirror =
union
{
	torus 
	{	1, .1 
		translate -.5*y 
		rotate<90,-45,0> 
		texture {T_Gold_5E}
		normal {crackle .5}
	}
	cylinder 
	{	0, .3*x, 1
		translate .3*x
		rotate <15,45,0>
		texture {T_Chrome_5E}
	}
scale .75       
translate -.1*y   
rotate 20*x
}              
	
#declare seal =
height_field{tga "images\scosv.tga"  scale <3.5,1,3.5> rotate -90*x}  
#declare Bseal =
height_field{tga "images\scosv_b.tga"scale <3.5,1,3.5> rotate -90*x}

#declare self =
height_field
{
  tga "images\scosvs.tga"
  texture
  {
    pigment
    {
      image_map {tga "images\scosvs_c.tga" map_type 0 interpolate 2 once }
      rotate x*90 
    }
  }
  scale <3,1,3> 
  rotate -90*x    
}
		
#declare desk =
union
{
	union
	{  
		box {<-.5,-.5,-.5>,<.5,.5,.5> scale <5,1,2>}
		box {<-.5,-.5,-.5>,<.5,.5,.5> scale <5,1,2> rotate <0,0,30> translate <-4.27, -1.18, 0>}
		box {<-.5,-.5,-.5>,<.5,.5,.5> scale <5,1,2> rotate <0,0,-30>translate < 4.37, -1.18, 0>}  
		texture{T_Wood23}     
		rotate <90,-45,0> 
		scale <.5,.75,.5> 
		translate -.25*y
	}
object {Bseal texture {T_Silver_5E} rotate -15*y scale .4 translate <   1,-.95,   1>}
object {seal texture {T_Silver_5E} rotate -75*y scale .4 translate <-1.3,-.95,-2.2>}
}

#declare pod = 
union
{
	object{podium texture{T_Wood23 rotate 90*z} finish{ambient .3}}
	object{mic    pigment{rgb .1}   finish{phong 80}}
}  

#declare DiagWall =
union
{
	plane {x, -2 hollow on texture{wall} rotate 45*y}          
	object{seal hollow on texture{T_Gold_5E} translate <-1.8,.75,2.95> rotate -45*y}
}

#declare BackWall =
union
{
	plane {x, -2 hollow on texture{wall} rotate 45*y}          
	object{self hollow on translate <-1.75,.8,2.3> rotate -45*y}
}                         

#declare Door =
union
{
	object{doorKnob  texture{T_Silver_5E}}
	object{doorFrame texture{T_Wood23}   }
}	
// --- COURTROOM ---
#declare courtRoom = 
union
{
	
	//Floor / Ceiling
	plane {y, -1 hollow on texture{carpet}}
	plane {y, -3 hollow on texture{wall}}
	//Rt Ft Wall / Lf Ft Wall 
	plane {x, -3 hollow on texture{wall}}  
	plane {z,  3 hollow on texture{wall}}	 
   //Front / Back Diagonal walls
   object{DiagWall}
   object{BackWall rotate 180*y translate <5.5,.7,-7>}
	object{mirror}
	object{pod rotate -135*y translate <4,-.1,-3.5>}
	
	object{desk}       
	object{Door rotate-15*y scale 1.25 translate <1.5,.5,3>}
	
	
}