
// POV-Ray Object File - Fuselage
// created 3-Sep-99
// last update 28-Oct-99
// 1999 Glenn McCarter
// This file does not render.  #include "Fuselage.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "AirplaneSeat.inc"
//
// Objects:
// MainGroup
// FuelageSectionShape
// TailSectionS
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#include "AirplaneSeat.inc"

//===============================================
//             Variables
//===============================================

// Scene origin is at bottom front of seat

#macro ShearX(Angle)
//	transform //{
  	matrix <  1,  0, 0, // shear along X axis
             0,  1, 0,
            Angle/10,  0, 1,
             0,  0, 0 >
//	}
#end

//===============================================
//             Textures
//===============================================


#declare PlainTex =
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .10 specular .65 roughness .125 }
	}

#declare AlumSkinTex =
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .10 metallic brilliance 6 specular .75 roughness .015 }
	}

#declare CabinTex =
	texture {
		pigment { color rgb <.964,.926,.910> }
		finish { ambient .10 specular .65 roughness .053 }
	}
#declare ShadesTex =
	texture {
		pigment { color rgb <.964,.926,.910>*.65 }
		finish { ambient .10 specular .35 roughness .053 }
	}
#declare CabinCeilingTex =
	texture {
		pigment { color rgb <.969,.942,.971>*.6 }
		finish { ambient .13 specular .65 roughness .053 }
	}

#declare OxyCordTex =
	texture {
		pigment { color rgbt <.65,.61,.64,.73> }
		finish { ambient .10 specular .55 roughness .025 }
	}

#declare OxyMaskTex =
	texture {
		pigment { color rgbt <.65,.71,.34,.59> }
		finish { ambient .10 specular .75 roughness .025 }
	}

#declare CarpetTex =
	texture {
		pigment { color rgb <.996,.971,.931>*1.0 }
		finish { ambient .10 diffuse 3.3 specular .3 roughness .125 }
	}

#declare BluePipeTex =
	texture {
		pigment { color rgb <.221,.321,.998> }
		finish { ambient .10 specular .55 roughness .033 }
	}
#declare FloorPipeTex =
	texture {
		pigment { color rgb <.364,.326,.310> }
		finish { ambient .10 specular .65 roughness .053 }
	}

#declare BulkheadTex =
	texture {
		pigment { color rgb <.796,.771,.731>*1.0 }
		finish { ambient .10 diffuse 0.8 metallic specular .6 roughness .075 }
	}


//===============================================
//             Objects
//===============================================

//---------- Main Fuselage ----------------------

#declare FusCutter =
	height_field {
		png "FusCutterHF01.png"
//		smooth
//		water_level .015
//		translate <-0.085*in,0,-0.008*in> // align to scene origin
//		rotate x*90 // set up for RH coordinate system
//		translate <-0.5,0.5,0>
//		rotate z*180 // orient to tail
		scale <12*Feet,20*Feet,20*Feet> // scale it up, Y-scale sets max height
		translate <0*Feet,0*Feet,0*Feet> //
		texture { PlainTex }
	}
//object { FusCutter rotate z*-0}

#declare WindowCutout =
		superellipsoid { // window
			<.5,.5>
//			scale <0.85*Feet,1.0*Feet,4*Feet> // big
			scale <0.65*Feet,4*Feet,0.95*Feet> // medium
			texture { AlumSkinTex }
		}
#local WindowOffset = -1*Feet;
#local WindowSpacing = 2.5*Feet;
#local WH = 2.3*Feet; // WindowHeight

#declare MainFuselageSkinShape =
	difference {
		cylinder { // outer skin
			<-20*Feet,0,0>,<6*Feet,0,0>,6.5*Feet // was 8 feet
		}
		cylinder { // inner skin
			<-21*Feet,0,0>,<6.1*Feet,0,0>,6.45*Feet
		}
		object { WindowCutout translate <WindowOffset+ 2*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+ 1*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-0*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-1*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-2*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-3*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-4*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-5*WindowSpacing,8*Feet,WH> }
		object { WindowCutout translate <WindowOffset+-6*WindowSpacing,8*Feet,WH> }
		box { // near half
			<-21*Feet,-9*Feet,-9*Feet>,<21*Feet,0,9*Feet>
		}
	} // end difference
#declare MainFuselage =
	difference {
		union {
			object { MainFuselageSkinShape texture { AlumSkinTex } }
			object { MainFuselageSkinShape scale 1.04 texture { AlumSkinTex } }
		} // end union
		object { FusCutter translate <-4.0*Feet,0,-5*Feet> }
	} // end difference

#declare Windowshades =
	union {
		box { // closed
			<-8,0,-10>,<8,1,12>
			rotate x*6
		}
		box { // open
			<-8,0,7>,<8,1,14>
			rotate x*6
			translate <WindowSpacing,0,0>
		}
		box { // open
			<-8,0,7>,<8,1,14>
			rotate x*6
			translate <-WindowSpacing,0,0>
		}
		box { // open
			<-8,0,7>,<8,1,14>
			rotate x*6
			translate <-2*WindowSpacing,0,0>
		}
		texture { ShadesTex }
		translate <WindowOffset+-0*WindowSpacing,7.6*Feet,WH>
	} // end union


#declare FloorPipe =
	union {
		cylinder { <-30*Feet,0,0>,<3.8*Feet,0,0>,0.85 }
		object { CurveTube(18,0.85,57) translate <3.8*Feet,0,0> }
		texture { FloorPipeTex }
	} // end union
#declare FloorBulkhead =
	box {
		<-.5,0,-14>,<.5,9*Feet,-1>
		texture { AlumSkinTex }
	}
//#local BHS = 1.4*Feet; // bulkhead spacing
#local BHS = 0.9*Feet; // bulkhead spacing
#local BHO = 4*Feet; // bulkhead offset
#local BHC = 1;
#declare MainFloor =
	union {
		object { FloorPipe translate <0,1.4,-7.5> }
		box { // upper
			<-20*Feet,0,-2>,<3*Feet,8*Feet,0>
			texture { CarpetTex }
		}
		object { FloorBulkhead rotate <0,0,18> translate <BHO*BHS,0,0> }
		#while ( BHC < 16 )
			object { FloorBulkhead translate <BHO-BHC*BHS,0,0> }
			#local BHC = BHC + 1;
		#end
/*
		object { FloorBulkhead translate <BHO-1*BHS,0,0> }
		object { FloorBulkhead translate <BHO-2*BHS,0,0> }
		object { FloorBulkhead translate <BHO-3*BHS,0,0> }
		object { FloorBulkhead translate <BHO-4*BHS,0,0> }
		object { FloorBulkhead translate <BHO-5*BHS,0,0> }
		object { FloorBulkhead translate <BHO-6*BHS,0,0> }
		object { FloorBulkhead translate <BHO-7*BHS,0,0> }
*/
		box { // center rib
			<-20*Feet,0,-16>,<3.5*Feet,1,-1>
//			translate <0,1.8*Feet,0>
			translate <0,0.93*Feet,0>
			texture { AlumSkinTex }
		}
	} // end union

#declare Ceiling =
	box {
		<-20*Feet,0,0>,<3*Feet,4*Feet,1>
		texture { CabinTex }
	}
#declare TopSpar =
	box {
		<-20*Feet,-1,1>,<3.6*Feet,1,8>
		translate <0,1*Feet,0>
		texture { AlumSkinTex }
	}
#declare BlueTopPipe =
	cylinder {
		<-20*Feet,0,0>,<4*Feet,0,0>,0.77
		translate <0,8,5>
		texture { BluePipeTex }
	}
#declare BCutterRing =
	difference {
		cylinder { // main
			<0,0,0>,<2,0,0>,6.35*Feet
		}
		cylinder { // inner
			<-1,0,0>,<3,0,0>,5.9*Feet
		}
		texture { BulkheadTex }
	} // end difference
#declare BHole =
	cylinder { <-2,0,0>,<2,0,0>,2.1 texture { BulkheadTex } }
#declare Bulkhead =
	difference {
		cylinder { // main
			<-1.5,0,0>,<1.5,0,0>6.45*Feet
		}
		cylinder { // inner
			<-2,0,0>,<2,0,0>,5.8*Feet
		}
		object { BCutterRing translate <0.35,0,0> }
		object { BCutterRing rotate z*180 translate <-0.35,0,0> }
		object { BHole translate <0,0,6.1*Feet> rotate x*6 }
		object { BHole translate <0,0,6.1*Feet> rotate x*0 }
		object { BHole translate <0,0,6.1*Feet> rotate x*-6 }
		object { BHole translate <0,0,6.1*Feet> rotate x*-12 }
		object { BHole translate <0,0,6.1*Feet> rotate x*-18 }
		object { BHole translate <0,0,6.1*Feet> rotate x*-24 }
		object { BHole translate <0,0,6.1*Feet> rotate x*-30 }
		box { // elim bottom
			<-3,-8*Feet,-8*Feet>,<3,8*Feet,5*Feet>
		}
		box { // elim near side
			<-3,-8*Feet,-8*Feet>,<3,-0.6*Feet,8*Feet>
		}
		texture { BulkheadTex }
	} // end difference
#local BS = 30;
#local BF = 20;
#declare BulkheadGroup =
	union {
		object { Bulkhead rotate <0,0,0> translate <BF,0,0> }
		object { Bulkhead rotate <4,0,0> translate <BF+BS*-1,0,0> }
		object { Bulkhead rotate <0,0,0> translate <BF+BS*-2,0,0> }
		object { Bulkhead rotate <8,0,22> translate <BF+BS*-3,0,0> }
		object { Bulkhead rotate <12,0,-6> translate <BF+BS*-4,15,-8> }
	} // end union
#declare MainCeilingGroup = // origin at bottom front edge of ceiling
	union {
		object { Ceiling }
		object { TopSpar }
		object { BlueTopPipe }
	}

#local OCW = 18; // half width of overhead console
#declare OverheadDoorShape =
	union {
  	difference {
			superellipsoid {
				<.2,.2>
				scale <17,.8,5>
				translate <0,0,-7> // origin at hinge
			}
			box {
				<-2,-3,-2>,<2,3,2>
				translate <0,0,-11>
			}
		} // end difference
		texture { CabinCeilingTex }
	} // end union
#declare OverheadDoorClosed =
  union {
		object { OverheadDoorShape }
		box { // handle
			<-1.8,0,0>,<1.8,.4,1.8>
			translate <0,0,-11>
			texture { AlumSkinTex }
		}
		rotate <8,0,0>
	} // end union
#macro OverheadDoorOpen(Angle)
  union {
		object { OverheadDoorShape }
		box { // handle
			<-1.8,0,0>,<1.8,.4,1.8>
			rotate <0,-70,0>
			translate <0,-1.0,-8>
			texture { AlumSkinTex }
		}
		rotate <Angle,0,0>
	} // end union
#end
#declare OverheadCabinFace =
	union {
		box { <-OCW,0,0>,<OCW,0.8,2> }
		box { <-OCW,0,0>,<OCW,0.8,2> translate <0,0,8> }
		box { <-OCW,0,0>,<-OCW+2,0.8,10> }
		box { <OCW-2,0,0>,<OCW,0.8,10> }
		texture { CabinCeilingTex }
	} // end union
#declare OverheadCabinUnit =
	union {
		object { OverheadCabinFace rotate <8,0,0> }
		box { // ceiling under box
			<-OCW,0,0>,<OCW,18,1.0>
		}
		difference {
			box { // main ceiling
				<-OCW,18,0>,<OCW,36,8>
			}
			box { // control unit area
				<-6,21,-1>,<6,29,2>
			}
		} // end difference
		box { // oxy flap
			<-4,-2.5,0>,<0,2.5,-0.5>
			rotate <0,-82,0>
			translate <3,29.5,0>
		}
		box { // end light bar
			<-OCW-0.5,0,0>,<OCW+0.5,.31,-4.7>
			rotate <7,0,0>
			translate <0,36,0>
			texture { CabinTex }
		}
		texture { CabinCeilingTex }
	} // end union

#local OCS = 37; // spacing
#local OCO = 25; // offset
#declare OverheadCabins =
	union {
		object { OverheadCabinUnit translate <OCO-OCS*0,0,0> }
		object { OverheadCabinUnit translate <OCO-OCS*1,0,0> }
		object { OverheadCabinUnit translate <OCO-OCS*2,0,0> }
		object { OverheadCabinUnit translate <OCO-OCS*3,0,0> }
		object { OverheadCabinUnit rotate <0,-22,0> translate <OCO-OCS*4,0,-14> }
		object { OverheadDoorOpen(-90) translate <OCO-OCS*0,0,10> }
		object { OverheadDoorClosed    translate <OCO-OCS*1,0,10> }
		object { OverheadDoorOpen(-90) translate <OCO-OCS*2,0,10> }
		object { OverheadDoorOpen(-52) translate <OCO-OCS*3,0,10> }
//		object { OverheadDoorOpen(-70) translate <OCO-OCS*4,0,10> }
	}

#declare OxygenCord =
	height_field {
		gif "OxyCord1.gif"
		smooth
		translate <-0.5,0,-1.0> // origin at top of cord
//		rotate <90,0,0> // Z=up
		water_level .01
		scale <4,10,24>
		texture { OxyCordTex }
	}
#declare OxygenMask =
	cone {
		<0,0,0>,1<0,0,-2>,2
		texture { OxyMaskTex }
	} 
#declare OxyGroup =
	union {
		object { OxygenCord translate <0,0,0> }
		object { OxygenMask rotate <0,20,0> translate <0,0,-24> }
		object { OxygenCord rotate <180,0,40> translate <0,-12,-24> }
		object { OxygenCord translate <-40,0,0> }
		object { OxygenCord rotate <180,0,40> translate <-40,-12,-24> }
		object { OxygenMask rotate <0,12,0> translate <-40,-12,-24> }
		object { OxygenCord rotate <0,-14,0> translate <-80,-12,-24> }
		object { OxygenCord rotate <180,0,40> translate <-120,-12,-24> }
	} // end union

//----------------- Tail -------------------------

#declare TailSectionS = // simple version
	union {
		difference { // fuselage segment
			cylinder {
				<0,0,0>,<8*Feet,0,0>,8*Feet
			}
			cylinder {
				<-1,0,0>,<7.8*Feet,0,0>,7.8*Feet
			}
		} // end difference
		cone { // tail cone
			<8*Feet,0,0>,8*Feet,<30*Feet,0,0>,2*Feet
		}
		box { // rudder
			<0,-6,0>,<12*Feet,6,20*Feet>
			rotate <0,20,0>
			translate <12*Feet,0,8*Feet>
		}
		box { // elevator
			<0,-16*Feet,0>,<12*Feet,16*Feet,0>
			rotate <0,20,0>
			translate <15*Feet,0,13*Feet>
		}
		translate <0,0,8*Feet>
		texture { AlumSkinTex }
	} // end union

#declare TailCutter =
	height_field {
		png "TailCutterHF01.png" // projected from -Z
//		smooth
//		water_level .015
//		translate <-0.085*in,0,-0.008*in> // align to scene origin
//		rotate x*90 // set up for RH coordinate system
//		translate <-0.5,0.5,0>
		rotate z*-90 // orient to tail
		translate <0,0.5,-0.5> // center to tail
		scale <70*Feet,20*Feet,20*Feet> // scale it up, X-scale sets max height
//		translate <0*Feet,0*Feet,0*Feet> //
		texture { AlumSkinTex }
	}
//object { TailCutter rotate z*-0}

#declare FuselageSegment =
	difference {
		cylinder { // outer
			<0,0,0>,<8*Feet,0,0>,8*Feet
			texture { AlumSkinTex }
		}
		cylinder {
			<-1,0,0>,<7.8*Feet,0,0>,7.8*Feet
			texture { CabinTex }
		}
		object { TailCutter }
	} // end difference
#declare Rudder =
	union {
		difference { // rudder
			cone {
				<0,0,0>,12*Feet,<0,0,28*Feet>,8*Feet
				scale <1,.12,1>
				ShearX(4)
			}
			box { // cutoff rear edge
				<0,-4*Feet,-1>,<33*Feet,4*Feet,40*Feet>
				rotate <0,8,0>
				translate <3*Feet,0,0>
			}
		} // end difference
		texture { AlumSkinTex }
	} // end union

#declare Elevator =
	union {
		cone {
			<0,0,0>,12*Feet,<0,28*Feet,4*Feet>,8*Feet
			scale <1,1,.12>
		}
		cone {
			<0,0,0>,12*Feet,<0,-28*Feet,4*Feet>,8*Feet
			scale <1,1,.12>
		}
		texture { AlumSkinTex }
	} // end union

#declare TailSection = // origin at bottom of cut section, extends into +x
	union {
		object { Rudder translate <22*Feet,0,0> }
		object { Elevator translate <22*Feet,0,1*Feet> }
		object { FuselageSegment }
		cone { // tail cone
			<8*Feet,0,0>,8*Feet,<30*Feet,0,0>,2*Feet
		}
/*
		box { // elevator
			<0,-16*Feet,0>,<12*Feet,16*Feet,0>
			rotate <0,20,0>
			translate <15*Feet,0,13*Feet>
		}
*/
		translate <0,0,8*Feet> // set on ground level
		texture { AlumSkinTex }
	} // end union
			


//===============================================
//             Assemblies
//===============================================

#local SeatOffset = -1*Feet;
#local SeatSpacing = 3.6*Feet;
#declare MainGroup =
	union {
		object { MainFuselage translate <0,20,1*Feet> }
		object { Windowshades translate <0,0,1*Feet> }
		object { MainFloor }
		object { MainCeilingGroup translate <0,4*Feet,6*Feet> }
		object { OxyGroup translate <32,16,5.3*Feet> }
		object { OverheadCabins translate <0,34,7*Feet-19> }
		object { BulkheadGroup translate <0,0,1*Feet> }
		object { WindowSeat translate <SeatOffset-SeatSpacing*0,4.5*Feet,0> }
		object { MissingSeat translate <SeatOffset-SeatSpacing*0,4.5*Feet,0> }
		object { DoubleSeat translate <SeatOffset-SeatSpacing*1,4.5*Feet,0> }
		object { DoubleSeat translate <SeatOffset-SeatSpacing*2,4.5*Feet,0> }
		object { DoubleSeat rotate <0,21,9> translate <SeatOffset-SeatSpacing*3,4.5*Feet,0> }
		object { DoubleSeat translate <SeatOffset-SeatSpacing*4,4.5*Feet,0> }

	}
                                

