
// POV-Ray Object File - Miscellaneous Objects
// created 8-Sep-99
// last update 27-Oct-99
// 1999 Glenn McCarter
// This file does not render.  #include "MiscObjects.inc" in another .pov file
// Required #include files: "GShapes.inc"
//
// Objects:
// TelephonePole
// BrokenTelephonePole
// FenceGroup (white split rail fence)
// PoliceChopper
// WheelGroup
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================

//#include "GShapes.inc"


//===============================================
//             Textures
//===============================================


#declare PlainTex =
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .10 specular .65 roughness .125 }
	}

#declare TelephonePoleTex =
	texture {
		pigment { color rgb <0.357,0.322,0.220> }
		finish { ambient .10 specular .25 roughness .125 }
	}

#declare FenceXTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 {color rgb <.987,.682,.343> ]
				[ 0.30 {color rgb <.987,.682,.343> ]
				[ 0.90 {color rgb <.621,.415,.181> ]
				[ 0.99 {color rgb <.170,.214,.073> ]
			}
			scale <10,1,1>
		}
		finish { ambient .10 specular .65 roughness .125 }
	}

#declare ChopperTex =
	texture {
		pigment { color rgb <0.117,0.122,0.220> }
		finish { ambient .10 specular .88 roughness .015 }
	}
#declare RotorTex =
	texture {
		pigment { color rgbt <0.417,0.422,0.420,0.6> }
		finish { ambient .10 metallic specular .88 roughness .015 }
	}
#declare TireTex =
	texture {
		pigment { color rgb <.081,.081,.081> }
		normal { bumps 0.3 scale <3,.4,3> }
		finish { ambient .10 specular .25 roughness .125 }
	}
#declare SteelRimTex =
	texture {
		pigment { color rgb <.71,.67,.71> }
		finish { ambient .10 specular .75 roughness .065 }
	}
#declare DirtySteelTex = // bolts
	texture {
		pigment { color rgb <.27,.24,.11> }
		finish { ambient .10 specular .15 roughness .098 }
	}
#declare StreakySteelTex = // struts
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 color rgb <.71,.67,.71> ]
				[ 1.0 color rgb <.41,.47,.41> ]
			}
			scale <1,1,3>
		}
		finish { ambient .10 specular .75 roughness .065 }
	}
#declare ChromeTex =
	texture {
		pigment { color rgb <.61,.61,.61> }
		finish { ambient .10 specular .97 roughness .0016 reflection 0.75 }
	}


//===============================================
//             Objects
//===============================================

#declare TelephonePole =
	union {
		cone {
			<0,0,-20*Feet>,13.5,<0,0,40*Feet>,4.5
		}
		cylinder {
			<0,-4*Feet,0>,<0,4*Feet,0>,3.3
			translate <0,0,33*Feet>
		}
		cylinder {
			<0,-4*Feet,0>,<0,4*Feet,0>,3.3
			translate <0,0,37*Feet>
		}
		texture { TelephonePoleTex }
	}

#declare BrokenTelephonePoleTop =
	union {
		cone {
			<0,0,0>,6.5,<0,0,33*Feet>,4.5
		}
		cylinder {
			<0,-4*Feet,0>,<0,4*Feet,0>,3.3
			translate <0,0,26*Feet>
		}
		cylinder {
			<0,-4*Feet,0>,<0,4*Feet,0>,3.3
			translate <0,0,30*Feet>
		}
		texture { TelephonePoleTex }
	} // end union
#declare BrokenTelephonePole =
	union {
		cone { // bottom
			<0,0,0>,9.5,<0,0,7*Feet>,6.5
			texture { TelephonePoleTex }
		}
		object { BrokenTelephonePoleTop rotate <0,0,35> rotate <100,0,0> translate <0,0,7*Feet> }
	} // end union

#macro FenceRail(TextureMovement)
	union {
		cylinder {
			<0,0,0>,<10*Feet,0,0>,2.2
			scale <1,.7,1>
		}
		texture { FenceXTex translate <TextureMovement*100,TextureMovement*50,0> }
	}
#end
#macro FencePost(TexMove)
	difference {
		cylinder {
			<0,0,-3*Feet>,<0,0,4*Feet>,3.65
		}
		cylinder { <-6,0,0>,<6,0,0>,1.4 translate <0,0,20> }
		cylinder { <-6,0,0>,<6,0,0>,1.4 translate <0,0,22> }
		cylinder { <-6,0,0>,<6,0,0>,1.4 translate <0,0,36> }
		cylinder { <-6,0,0>,<6,0,0>,1.4 translate <0,0,38> }
		texture { FenceXTex translate <TexMove*80,TexMove*40,0> rotate y*90 }
	} // end difference
#end
#declare FenceGroup =
	union {
		object { FencePost(14) } // nearest
		object { FenceRail(1) translate <0,0,20> }
		object { FenceRail(2) translate <0,0,36> }
		object { FencePost(23) rotate <0,1,2> translate <-10*Feet,0,0> }
		object { FenceRail(3) translate <-10*Feet,0,20> }
		object { FenceRail(4) translate <-10*Feet,0,36> }
		object { FencePost(73) rotate <22,6,5> translate <-20*Feet,0,0> }	
		object { FenceRail(5) rotate <0,0,8> translate <-20*Feet,-8,20> }
		object { FenceRail(6) rotate <0,-18,26> translate <-20*Feet,-42,1> }
		object { FencePost(53) rotate <87,-36,15> translate <-30*Feet,-1*Feet,0> }	
		object { FencePost(22) rotate <7,-16,125> translate <-40*Feet,-1*Feet,0> }	
		object { FencePost(82) rotate <-67,5,15> translate <-50*Feet,-1*Feet,0> }	
	} // end union


//---------------- Helicopter ----------------------

#declare BT = 1.0; // blob threshold
#declare MBRF = 11.0;
#declare BSF = 2.0; // Main Blob Strength Factor
#declare OBRF = 11.0;  // Offset Component Radius Factor
#declare OBSF = 0.8; // Offset Blob Strength Factor
#declare OffsetB = 12.5; // distance between components
#declare ChopperShape =
	union {
		blob {
		threshold BT
			sphere { // main
				<0,0,0>,
				MBRF, BSF*1.0
				scale <1.0,1.0,1.0>
				translate <0,0,0>
			}
			sphere { // pull rear
				<0,0,0>,
				OBRF, OBSF
				scale <1.0,1.0,1.0>
				translate <OffsetB,0,-2>
			}
			sphere { // pull front
				<0,0,0>,
				OBRF, OBSF
				scale <1.0,1.0,1.0>
				translate <-OffsetB,0,-5>
			}
			scale <10,6,6>
		}
		superellipsoid {
			<.5,.5>
			scale <32,11,12>
			translate <2.2*Feet,0,3.5*Feet>
		}
/*
		cone { // boom
			<0,0,0>,14,<20.2*Feet,0,0>,10
			translate <2.0*Feet,0,2.2*Feet>
		}
		box { // tailevator
			<0,-33,0>,<27,33,1.6>
			translate < 20*Feet,0,3*Feet>
		}
		box { // tailfin
			<0,-1,-18>,<22,1,33>
			translate < 20*Feet,30,3*Feet>
		}
		box { // tailfin
			<0,-1,-18>,<22,1,33>
			translate < 20*Feet,-30,3*Feet>
		}
*/
		cone { // boom
			<0,0,0>,13,<20.2*Feet,0,0>,4
			translate <2.0*Feet,0,2.2*Feet>
		}
		box { // tailevator
			<0,-18,0>,<20,18,1.6>
			translate < 20.5*Feet,0,5*Feet>
		}
		box { // tailfin
			<0,-1,-18>,<14,1,33>
			rotate <0,20,0>
			translate < 20*Feet,4,3*Feet>
		}
		cylinder { // tail rotor
			<0,0,0>,<0,1.8,0>,19
			translate <20*Feet,-9,2.6*Feet>
			texture { RotorTex }
		}
		cylinder { // hub
			<0,0,0>,<0,0,2.8*Feet>,4
			translate <0,0,3*Feet>
		}
		cylinder { // hub disk
			<0,0,0>,<0,0,8>,19
			translate <0,0,4.7*Feet>
		}
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*0*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*1*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*2*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*3*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*4*360/5 }
		cylinder { // rotor
			<0,0,0>,<0,0,3.5>,13*Feet
			translate <0,0,5*Feet>
			texture { RotorTex }
		}
		texture { ChopperTex }
	} // end union
#declare Skid =
	union {
		cylinder { // main
			<0,0,0>,<9*Feet,0,0>,3.5
		}
		object { CurveTube(3*Feet,3.5,42) rotate z*180 }
		cylinder { // fore strut
			<0,0,0>,<0,0,4*Feet>,2.5
			scale <1.6,1,1>
			translate <3*Feet,0,0>
		}
		cylinder { // aft strut
			<0,0,0>,<0,0,4*Feet>,2.5
			scale <1.6,1,1>
			translate <6.8*Feet,0,0>
		}
		texture { ChopperTex }
	} // end union
#declare ChopperLight =
	light_source {
		<0,0,0>
		color rgb <.71, .79, .98>*1.4
		fade_distance 30*Feet
		fade_power 1
		spotlight
		point_at <0,0,-20*Feet> // straight down
		radius 8    // degrees fully lit (*2)
		falloff 18   // degrees no lighting (*2)
		tightness 1
		looks_like {
			union {
				sphere {
					<0,0,0>, 4.4
					scale <1,1,.3>
					texture {
						pigment { color rgb<.84,.89,.99>*6 }
						finish { ambient .99 diffuse .2 }
					}
				}
				cylinder {
					<0,0,0.5>,<0,0,1.2*Feet>,0.5*Feet
					texture { ChopperTex }
				}
			} // end union
		}
	}


//---------------- Airplane Wheel ----------------

#declare TireS =
	torus {
		1.64*Feet,11
		texture { TireTex }
	}
#macro TireGroove(Radius)
	difference {
		cylinder { <0,-0.7,0>,<0,0.7,0>,4*Feet }
		cylinder { <0,-0.8,0>,<0,0.8,0>,Radius }
	} // end difference
#end
#declare Tire =
	difference {
		lathe { // around Y-axis
			cubic_spline
			19,
			<10.0,-5.0>,<10.0,-6.5>,<10.4,-7.0>,<12.0,-7.2>,
			<15.0,-7.4>, // peak sidewall
			<17.0,-7.2>,<19.0,-6.2>,<20.5,-4.8>,<21.5,-2.7>, // flat tread to sidewall
			<21.8,0>, // centerline
			<21.5,2.7>,<20.5,4.8>,<19.0,6.2>,<17.0,7.2>, // flat tread to sidewall
			<15.0,7.4>, // peak sidewall
			<12.0,7.2>,<10.4,7.0>,<10.0,6.5>,<10.0,5.0>
		}
		object { TireGroove(21.5) translate <0,1.8,0> }
		object { TireGroove(21.5) translate <0,-1.8,0> }
		object { TireGroove(20.8) translate <0,4.5,0> }
		object { TireGroove(20.8) translate <0,-4.5,0> }
		texture { TireTex }
	} // end difference

#declare Bolt =
	cylinder {
		<0,6,0>,<0,-6,0>,0.6
		texture { DirtySteelTex }
	}
#local BD = 1;
#declare BoltGroup =
	union {
		#while ( BD < 360 )
			object { Bolt translate <0,0,-6> rotate y*BD }
			#declare BD = BD + 20;
		#end
	} // end union
#declare HalfRim =
	union {
		object { BoltGroup }
		torus { // outer rim
			9.7,0.3
			scale <1,0.4,1>
			translate <0,7,0>
		}
		torus { // inner rim
			8.0,0.3
			scale <1,0.4,1>
			translate <0,7,0>
		}
		difference { // outer
			cylinder { <0,-7,0>,<0,7,0>,10 }
			cylinder { <0,-8,0>,<0,8,0>,9.4 }
		} // end difference
		difference { // inner
			cylinder { <0,-7,0>,<0,7,0>,8.3 }
			cylinder { <0,-8,0>,<0,8,0>,7.7 }
		} // end difference
		difference { // keyway
			cylinder { <0,-6,0>,<0,6,0>,10 }
			cylinder { <0,-8,0>,<0,8,0>,8 }
		} // end difference
		cylinder { // main wheel structure
			<0,-3.5,0>,<0,3.5,0>,9
		}
		cylinder { // main axle
			<0,-5,0>,<0,5,0>,1.4
			texture { DirtySteelTex }
		}
		texture { SteelRimTex }
	} // end union

#declare FrontStrutGroup =
	union {
		cylinder { // front strut
			<0,0,0>,<0,0,4.9*Feet>,1.8
			texture { ChromeTex }
		}
		cylinder { // front strut
			<0,0,4.8*Feet>,<0,0,7.3*Feet>,2.5
		}
		cylinder { // top support
			<0,0,0>,<0,0,3>,4.4
			translate <0,0,6.8*Feet>
		}
		cylinder { // top support
			<0,0,0>,<0,0,3>,8.4
			translate <12,0,6.8*Feet>
		}
		cylinder { // wire
			<0,0,0>,<0,0,8.8*Feet>,.4
			translate <7,-4,0>
			texture { SteelRimTex }
		}
		object { CurveTube(3*Feet,0.4,40) translate <7,-4,8.8*Feet> }
		texture { StreakySteelTex }
	} // end union


#declare StrutGroup =
	union {
		object { FrontStrutGroup rotate <1,6,0> translate <-16,0,0> }
		cylinder { // main chrome
			<0,0,0>,<0,0,6*Feet>,4.3
			texture { ChromeTex }
		}
		cylinder { // main upper
			<0,0,4*Feet>,<0,0,8*Feet>,4.9
		}
		cylinder { // trim
			<0,0,4.4*Feet>,<0,0,4.9*Feet>,5.2
		}
		cylinder { // trim
			<0,0,5.4*Feet>,<0,0,5.9*Feet>,5.2
		}
		cylinder { // trim
			<0,0,6.4*Feet>,<0,0,6.9*Feet>,5.2
		}
		cylinder { // trim
			<0,0,7.4*Feet>,<0,0,7.9*Feet>,5.2
		}
		cylinder { // main axle
			<0,-1.2*Feet,0>,<0,1.2*Feet,0>,5.4
		}
		cylinder { // axle trim
			<0,-0.4*Feet,0>,<0,0.4*Feet,0>,7.4
		}
		texture { StreakySteelTex }
	} // end union

//===============================================
//             Assemblies
//===============================================

#declare PoliceChopper = // extends into +x
	union {
		object { ChopperShape }
		object { Skid rotate x*18 translate <-4*Feet,3.0*Feet,-5*Feet> }
		object { Skid rotate x*-18 translate <-4*Feet,-3.0*Feet,-5*Feet> }
		object { ChopperLight rotate <0,42,-7> translate <-4*Feet,0,-3.1*Feet> }
	} // end union

#declare WheelGroupS = // simple version
	union {
		object { TireS}
//		object { Rim }
		object { StrutGroup translate <0,-16,0> }
 		translate <0,0,1.64*Feet+11> 
	} // end union                                

#declare WheelGroup =
	union {
		object { Tire translate <0,-16,0> }
		object { HalfRim translate <0,-16,0> }
		object { StrutGroup translate <0,0,0> }
// 		translate <0,0,1.64*Feet+11> 
	} // end union                                

