
// Glenn's POV-Ray Scene File - Winseat Overlay
// created 23-Sep-99 for the Internet Raytracing Competition (www.irtc.org)
// last update 31-Oct-99
// copyright 1999 Glenn McCarter (gmccarter@hotmail.com)
//
// This adds the colored arrow overlays onto the image.
// and adds a TV-like filter to the image by creating
// alternating dark bands on every other scan line.

                                                   
#include "GIncludeRH.inc"
//#include "GRuler.inc"
#include "Arrows.inc"

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

#declare ImageHeight = 6;                        // height of the image in units (inches)
#declare IH = ImageHeight;
#declare AspectRatio = 4/3;
#declare AR = AspectRatio;
#declare ImageWidth = ImageHeight * AspectRatio;
#declare IW = ImageWidth;

// Setting the image height is useful if you want to place objects
// in front of the image.  If you leave the ImageHeight at 1, the total
// image will be 1 unit tall.  So objects placed in front of the image
// would have to be very small to be visible.

//===============================================
//             Cameras
//===============================================

#declare Ortho_Cam =
	camera {
		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  IH >  // Where Z is up
		right     <IW,      0.0,  0.0>
//	location  <-1, .5, .5>
//	look_at   < 0, .5, .5>
	location  <-1, IW/2, IH/2>
	look_at   < 0, IW/2, IH/2>
}

camera {
	Ortho_Cam
  }

//===============================================
//             Textures
//===============================================

#declare TVTex = // alternating bands
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 rgbt<1.0,1.0,1.0,1.00> ]
				[ 0.25 rgbt<1.0,1.0,1.0,1.00> ]
				[ 0.25 rgbt<0.1,0.1,0.1,0.27> ]
				[ 0.75 rgbt<0.1,0.1,0.1,0.27> ]
				[ 0.75 rgbt<1.0,1.0,1.0,1.00> ]
				[ 1.00 rgbt<1.0,1.0,1.0,1.00> ]
			}
			scale IH/300 // this must be 1/2 of the final rendering height
		}
		finish { ambient 0.05 specular .3 roughness .01 }
	}		             
#declare GrainTex = // noisy fuzz
	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 rgbt<1.0,1.0,1.0,1.00> ]
				[ 0.25 rgbt<1.0,1.0,1.0,1.00> ]
//				[ 0.25 rgbt<0.1,0.1,0.1,0.17> ]
				[ 0.50 rgbt<0.1,0.1,0.1,0.74> ]
//				[ 0.75 rgbt<0.1,0.1,0.1,0.17> ]
				[ 0.75 rgbt<1.0,1.0,1.0,1.00> ]
				[ 1.00 rgbt<1.0,1.0,1.0,1.00> ]
			}
			scale <IH/300,IH/300,IH/300,> // this must be 1/2 of the final rendering height

		}
		finish { ambient 0.05 specular .3 roughness .01 }
	}		             

#declare TVEdgeTex = // a little darker at the sides of the image
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 rgbt<1.0,1.0,1.0,1.00> ]
				[ 0.25 rgbt<1.0,1.0,1.0,1.00> ]
				[ 0.25 rgbt<1.1,1.1,1.1,0.03> ]
				[ 0.75 rgbt<1.1,1.1,1.1,0.03> ]
				[ 0.75 rgbt<1.0,1.0,1.0,1.00> ]
				[ 1.00 rgbt<1.0,1.0,1.0,1.00> ]
			}
			scale IH/300 // this must be 1/2 of the final rendering height
		}
		finish { ambient 0.00 specular .3 roughness .01 }
	}		             
#declare TVEdgeTexT =
	texture {
		pigment { color rgb<1,0,0> }
		finish { ambient 0.95 specular .3 roughness .01 }
	}		             

#declare OverlayRedTex =
	texture {
		pigment { color rgb<1,0,0> }
		finish { ambient 0.95 specular .3 roughness .01 }
	}		             

#declare CopyrightInk =
	texture {
		pigment { color rgbt<1,1,1,0.88> }
		finish { ambient .95 specular .3 roughness .01 }
	}		             

#declare WhiteInk =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 1.5 specular .3 roughness .01 }
	}		             

#declare BlackInk =
	texture {
		pigment { color rgb<.06,.06,.06> }
		finish { ambient .04 specular .3 roughness .01 }
	}		             

           
//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,0*Feet,8*Feet> }
//object {StdBulb60Watt translate <-10*Feet,0*Feet,8*Feet> }

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

//#declare ImageHeight = 1;
//#declare ImageWidth = AspectRatio; 
                          	
#declare ImageBox =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		texture { WhiteInk }
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Winseat.png"
					once
				}
			}
			finish { ambient 1 }
			scale <1,1,1> // the image is initially square
		}
		rotate <90,0,-90> // align to camera
		translate <0,1-.001,-.001> // align to camera (with slight overscan)
		scale <1,ImageWidth*1.005,ImageHeight*1.005> // scale it up to match camera view
	}

#declare Grain =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		rotate <90,0,-90> // align to camera
		translate <0,1,0> // align to camera Y
		scale <1,ImageWidth+1,ImageHeight+1> // scale it up to match camera view
		texture { GrainTex }
	}

#declare TVStripes =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		rotate <90,0,-90> // align to camera
		translate <0,1,0> // align to camera Y
		scale <1,ImageWidth,ImageHeight> // scale it up to match camera view
		texture { TVTex }
	}

#declare TVEdgeStripes =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		rotate <90,0,-90> // align to camera
		translate <0,1,0> // align to camera Y
		scale <1,ImageWidth/120,ImageHeight> // scale it up to match camera view
		translate <0,-ImageWidth/120/2,0> // align to right edge
		texture { TVEdgeTex }
	}

#declare LT = .05; // line thickness

#declare RedBar =
	object { Line(7.5,LT,.05,OverlayRedTex)
		rotate <90,0,-90>
	}		

#declare News =
	text {
		ttf "ARIALBD.TTF",
		"NEWS",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .3
		rotate <90,0,-90>
		texture { WhiteInk }
	}
#declare NewsBox =
	box {
		<0,0,0>,<.01,-1.05,.31>
		translate <0,0.1,-0.05>
		texture { BlackInk }
	}
#declare TV3 =
	text {
		ttf "ARIALBD.TTF",
		"3",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .5
		rotate <90,0,-90>
		texture { BlackInk }
	}
#declare TV3Box =
	box {
		<0,0,0>,<.01,-.45,.42>
		translate <0,.1,-0.03>
		texture { WhiteInk }
	}

#declare Live =
	text {
		ttf "ARIALBI.TTF",
		"LIVE",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .3
		rotate <90,0,-90>
		texture { WhiteInk }
	}
#declare Copyright =
	text {
		ttf "ARIALBD.TTF",
		"1999 Glenn McCarter",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .10
		rotate <90,0,-90>
		texture { CopyrightInk }
	}


//===============================================
//             Object Placement
//===============================================

// Scene Coordinates:
// Camera is in -X direction
// Image is at X=0, extending width into +Y and height into +Z

object { Copyright translate <0.0,5.5,0.26> }
object { TVStripes translate <0.1,0,0> }
object { TVEdgeStripes translate <0.2,0,0> }
object { TVEdgeStripes translate <0.2,ImageWidth,0> }
object { TV3 translate <0.32,7.5,0.48> }
object { TV3Box translate <0.34,7.5,0.48> }
object { News translate <0.32,7.5,0.11> }
object { NewsBox translate <0.34,7.5,0.11> }
object { Live translate <0.3,1.2,0.25> }
object { RedBar translate <0.4,7.75,0.4> }

object { Grain translate <0.45,0,0> } // add fuzzy noise in front of the image
object { ImageBox translate <0.5,0,0> } // put it behind any overlays


