
// POV-Ray Object File - Electrical Transmission Tower
// created 19-Sep-99
// last update 19-Sep-99
// 1999 Glenn McCarter
// This file does not render.  #include "Tower.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Tower
// TowerCutBottom // bottom section only
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

//#include "GIncludeRH.inc" // for testing only


//===============================================
//             Variables
//===============================================

// Tower origin is at center of tower at ground level
// Power lines run along x-axis

#declare SS = 6; // StrutSize, inches

//===============================================
//             Textures
//===============================================


#declare TowerTex =
	texture {
		pigment { color rgb <.478,.451,.451> } // grey
//		pigment { color rgb <.078,.051,.051> } // test black
//		pigment { color rgb <.978,.951,.951> } // test white
		finish { ambient .15 specular .45 roughness .125 }
	}
#declare InsulatorTex =
	texture {
//		pigment { color rgb <.778,.751,.751> } // light grey
		pigment { color rgb <.078,.051,.051> } // test black
		finish { ambient .10 specular .75 roughness .045 }
	}
#declare WireTex =
	texture {
		pigment { color rgb <.032,.041,.061> } // black plastic
		finish { ambient .10 specular .85 roughness .050 }
	}


//===============================================
//             Objects
//===============================================

#macro XBrace(YLength,Height)
	box { <-Height/2,-YLength/2,-Height/2>,<Height/2,YLength/2,Height/2> }
#end
#macro XGroup(Width,StrutHeight)
	union {
		object { XBrace(Width,StrutHeight) texture { TowerTex } }
		object { XBrace(Width*1.414,StrutHeight) texture { TowerTex } rotate < 45,0,0> translate <0,0,Width/2> }
		object { XBrace(Width*1.414,StrutHeight) texture { TowerTex } rotate <-45,0,0> translate <0,0,Width/2> }
	}
#end


#declare LowerSectionQS =
	height_field {
		png "TowerHF01.png" // along XZ axis
//		water_level 0.1
//		scale <1,.02,1>
		translate <-0.5,0,0>
		scale <80*Feet,SS,140*Feet>
		water_level 0.001
		texture { TowerTex }
	}
#declare LowerSectionS = // simple version
	union {
		object { LowerSectionQS rotate x*12 translate <0,40*Feet,0> }
		object { LowerSectionQS rotate x*-12 translate <0,-40*Feet,0> }
		object { LowerSectionQS rotate x*12 rotate z*90 translate <-40*Feet,0,0> }
		object { LowerSectionQS rotate x*-12 rotate z*90 translate <40*Feet,0,0> }
	} // end union
#declare UpperTowerSectionQ =
	union {
		box { <0,0,0>,<SS,SS,80*Feet> translate <0,-10*Feet,0> } // corner post
		object { XGroup(20*Feet,SS) translate <0,0,0> }
		object { XGroup(20*Feet,SS) translate <0,0,20*Feet> }
		object { XGroup(20*Feet,SS) translate <0,0,60*Feet> }
		translate <10*Feet,0,0>
	} // end union

#declare InsulatorGroup =
	union {
		cylinder { <0,0,0>,<0,0,-24>,4.6 texture { TowerTex } }
		#local CN = 1;
		#while ( CN < 16 )
			cone { <0,0,0>,11,<0,0,14>,1 translate <0,0,-CN*1.1*Feet> }
			#local CN = CN + 1;
		#end
		texture { InsulatorTex }
	} // end union
#macro SupportArm(YLength)
	union {
		object { XBrace(YLength,SS) translate <0,YLength/2,0> rotate z*18 translate <0,-YLength,0> }
		object { XBrace(YLength,SS) translate <0,YLength/2,0> rotate z*-18 translate <0,-YLength,0> }
		object { XBrace(YLength,SS) translate <0,YLength/2,0> rotate x*18 translate <0,-YLength,0> }
	} // end union
#end

#declare TowerTop =
	union {
		object { UpperTowerSectionQ rotate <0,0,  0> translate <0,0,140*Feet> }
		object { UpperTowerSectionQ rotate <0,0, 90> translate <0,0,140*Feet> }
		object { UpperTowerSectionQ rotate <0,0,180> translate <0,0,140*Feet> }
		object { UpperTowerSectionQ rotate <0,0,270> translate <0,0,140*Feet> }

		object { SupportArm(30*Feet) translate <0,-10*Feet,160*Feet> }
		object { SupportArm(40*Feet) translate <0,-10*Feet,200*Feet> }
		object { SupportArm(30*Feet) scale <1,-1,1> translate <0,10*Feet,160*Feet> }
		object { SupportArm(40*Feet) scale <1,-1,1> translate <0,10*Feet,200*Feet> }

		object { InsulatorGroup rotate y*45  translate <0,-40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,-40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*45  translate <0,40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*45  translate <0,-50*Feet,200*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,-50*Feet,200*Feet> }
		object { InsulatorGroup rotate y*45  translate <0,50*Feet,200*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,50*Feet,200*Feet> }

		texture { TowerTex }
	} // end union

#declare Wire =
	cone {
		<0,0,0>,2.32,<0,0,-200*Feet>,1.32
//		translate <0,0,-4*Feet>
		texture { WireTex }
	}

#local W1Xang = 70; // to left tower in pic
#local W1Yang = 0;
#local W1Zang = -6;
#local W2Xang = 4; // to right tower not visible
#local W2Yang = -90;
#local W2Zang = -34;
#declare DownTowerTop =
	union {
		object { TowerTop }
		object { Wire
			rotate <W1Xang,W1Yang,W1Zang> // point to next tower
			rotate y*-45 // prepare to attach to insulator
			translate z*-19*Feet // attach to insulator
			rotate y*45 // rotate back to -Z
			translate <0,-40*Feet,160*Feet> // attach to tower
		}
		object { Wire rotate <W2Xang,W2Yang,W2Zang> rotate y*45 translate z*-19*Feet rotate y*-45 translate <0,-40*Feet,160*Feet> }
		object { Wire rotate <W1Xang,W1Yang,W1Zang> rotate y*-45 translate z*-19*Feet rotate y*45 translate <0, 40*Feet,160*Feet> }
		object { Wire rotate <W2Xang,W2Yang,W2Zang> rotate y*45 translate z*-19*Feet rotate y*-45 translate <0, 40*Feet,160*Feet> }

		object { Wire rotate <W2Xang,W1Yang,W1Zang> rotate y*-45 translate z*-19*Feet rotate y*45 translate <0,-50*Feet,200*Feet> }
		object { Wire rotate <W2Xang,W2Yang,W2Zang> rotate y*45 translate z*-19*Feet rotate y*-45 translate <0,-50*Feet,200*Feet> }
		object { Wire rotate <W1Xang,W1Yang,W1Zang> rotate y*-45 translate z*-19*Feet rotate y*45 translate <0, 50*Feet,200*Feet> }
		object { Wire rotate <W2Xang,W2Yang,W2Zang> rotate y*45 translate z*-19*Feet rotate y*-45 translate <0, 50*Feet,200*Feet> }
	} // end union


#declare Tower =
	union {
		object { LowerSectionS }

		object { UpperTowerSectionQ rotate <0,0,  0> translate <0,0,140*Feet> }
		object { UpperTowerSectionQ rotate <0,0, 90> translate <0,0,140*Feet> }
		object { UpperTowerSectionQ rotate <0,0,180> translate <0,0,140*Feet> }
		object { UpperTowerSectionQ rotate <0,0,270> translate <0,0,140*Feet> }

		object { SupportArm(30*Feet) translate <0,-10*Feet,160*Feet> }
		object { SupportArm(40*Feet) translate <0,-10*Feet,200*Feet> }
		object { SupportArm(30*Feet) scale <1,-1,1> translate <0,10*Feet,160*Feet> }
		object { SupportArm(40*Feet) scale <1,-1,1> translate <0,10*Feet,200*Feet> }

		object { InsulatorGroup rotate y*45  translate <0,-40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,-40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*45  translate <0,40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,40*Feet,160*Feet> }
		object { InsulatorGroup rotate y*45  translate <0,-50*Feet,200*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,-50*Feet,200*Feet> }
		object { InsulatorGroup rotate y*45  translate <0,50*Feet,200*Feet> }
		object { InsulatorGroup rotate y*-45 translate <0,50*Feet,200*Feet> }

		texture { TowerTex }
	} // end union

#declare TowerCutBottom =
	object { LowerSectionS clipped_by { sphere { <0,0,0>,80*Feet } } }

//===============================================
//             For Testing Only
//===============================================

/*
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
		location  <4*Feet, -300*Feet, 4.8*Feet>
		look_at <1.4*Feet, 1.4*Feet, 60*Feet>
	}

background { color rgb <0.4, 0.7, 0.9> } // light blue
light_source
{ <10*Feet,-5*Feet,10*Feet>, 2
//	spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 3 }

object { TowerCutBottom rotate z*30 }
object { Tower rotate z*120 translate <-100*Feet,300*Feet,0> }
*/
