
// Glenn's POV-Ray Scene File - Weeds
// first concept 23-May-97 last update 29-Oct-99
// copyright Glenn McCarter 1997-1999
// This file does not render.  #include "Weeds31.inc" in another .pov file
//
// A collection of various weeds
// Weeds1
// Weeds2
// WeedBlades1
// WeedStalks2
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

//===============================================
//             Variable Declarations
//===============================================



//===============================================
//             Textures
//===============================================

#declare GGreen =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.0 color rgbt<.55,.68,.26,.2> ] // actually, pretty tan
					[ 0.5 color rgbt<.42,.72,.17,.2> ] // more greenish
					[ 1.0 color rgbt<.55,.68,.26,.2> ] // actually, pretty tan
				}
		}
		finish { specular .7 roughness .01 }
	}

#declare GTan =
	texture {
		pigment { color rgbt<.69,.76,.36,.2> }
		finish { specular .5 roughness .03 }
	}

//===============================================
//       Objects
//===============================================

#declare BladeShape =
	intersection {
		sphere {
			<0,0,0>,20
			translate <-4,0,0>
			inverse
		}
		sphere {
			<0,0,0>,20
			translate <0,-11.5,0>
		}
		sphere {
			<0,0,0>,20
			translate <0,11.5,0>
		}
		clipped_by {
//			box { <0,-6,0>,<20,6,20> }
			sphere { <20,0,0>,10 scale <1,1,2> translate <0,0,20> }
		}
	translate <-16.5,0,-1.2> // center at base of blade
	scale <1.2,.2,1.0> // make it pretty thin and tall
	rotate z*180 // make it bend into +X
	}

#declare ThinBlade = // base at origin, bends into +X
	object { BladeShape
		texture { GGreen }
	}

#declare ThinStalk =
	torus {
		36,.07
		texture { GTan }
		clipped_by { box { <30,-.5,0>,<37,.5,14> } }
		translate <-36,0,0> // origin at base of stalk
		rotate z*180 // make it bend into +X
	}

#declare SeedHuskShape =
	intersection {
		sphere { <0,0,.05>,.05 scale <1,1,8> }
		box { <0.02,-.1,0>,<1,.1,1> rotate <0,10,0> inverse }
	}
#declare SeedAssy =
	union {
		cylinder { <0,0,0>,<0,0,.2>,.01 } // base
		sphere { <0,0,.2>,.015 }
		object { SeedHuskShape translate z*.2 }
		object { SeedHuskShape rotate z*180 translate z*.2 }
		texture { GTan }
	}
#declare WS = seed(65709); // random number seed
#declare WeedTop =
	union {
		cone { <0,0,0>,.07,<0,0,8>,.01 texture { GTan } } // stem
		#declare SeedCount = 0;
		#while ( SeedCount < 30 )
			object {
				SeedAssy
//				#declare BaseGrey = rand(WS)/2+.2
//				texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
				rotate <rand(WS)*10,rand(WS)*20+5,rand(WS)*360>
				translate <0,0,rand(WS)*6+2>
			}
			#declare SeedCount = SeedCount + 1;
		#end
	}

//===============================================
//       Weed Clumps
//===============================================

#declare Weeds1 =
	union {
		object { ThinStalk scale <1,1,.7> translate <.3,0,0> rotate <0,-9,0> }
		object { WeedTop rotate <0,24,0> translate <1.55,0,10.2> }
		object { ThinBlade }
		object { ThinBlade scale <1,1,1.9> translate <.3,.3,0> rotate <0,0,40> }
		object { ThinBlade scale <1,1,1.7> translate <.4,0,0> rotate <0,0,120> }
		object { ThinBlade scale <1,1,1.5> translate <.3,0,0> rotate <0,4,180> }
		object { ThinBlade scale <1,1,1.0> translate <.2,0,0> rotate <0,6,270> }
		object { ThinBlade scale <1,1,0.7> translate <.1,0,0> rotate <0,12,90> }
		object { ThinBlade scale <1,1,0.5> translate <.2,0,0> rotate <0,20,135> }
		object { ThinBlade scale <1,1,0.4> translate <.2,0,0> rotate <0,30,240> }
	}

#declare Weeds2 =
	union {
		object { ThinStalk scale <1,1,.8> rotate <0,-6,0> } // tall
		object { WeedTop rotate <0,18,0> translate <1.5,0,11.5> }
		object { ThinStalk scale <.8,.8,.7> translate <.3,0,0> rotate <0,-5,35> }
		object { WeedTop rotate <0,28,35> translate <1.5,1.0,9.9> }
		object { ThinBlade }
		object { ThinBlade scale <1,1,1.9> translate <.3,.3,0> rotate <0,-10,40> }
		object { ThinBlade scale <1,1,1.7> translate <.4,0,0> rotate <0,-8,120> }
		object { ThinBlade scale <1,1,1.6> translate <.2,0,0> rotate <0,-5,150> }
		object { ThinBlade scale <1,1,1.3> translate <.1,0,0> rotate <0,0,180> }
		object { ThinBlade scale <1,1,1.2> translate <.4,0,0> rotate <0,0,270> }
		object { ThinBlade scale <1,1,1.0> translate <.1,0,0> rotate <0,2,90> }
		object { ThinBlade scale <1,1,.9> translate <0,0,0> rotate <0,5,110> }
		object { ThinBlade scale <1,1,.6> translate <.2,0,0> rotate <0,15,135> }
		object { ThinBlade scale <1,1,.5> translate <.2,0,0> rotate <0,20,148> }
		object { ThinBlade scale <1,1,.4> translate <.1,0,0> rotate <0,30,240> }
	}
#declare WeedBlades1 =
	union {
		object { ThinBlade scale <1,1,1.3> translate <.3,.3,0> rotate <0,-10,40> }
		object { ThinBlade scale <1,1,1.2> translate <.4,0,0> rotate <0,-8,124> }
		object { ThinBlade scale <1,1,1.15> translate <.2,0,0> rotate <0,-5,142> }
		object { ThinBlade scale <1,1,1.1> translate <.1,0,0> rotate <0,0,188> }
		object { ThinBlade scale <1,1,1.05> translate <.4,0,0> rotate <0,0,277> }
		object { ThinBlade scale <1,1,1.0> translate <.1,0,0> rotate <0,2,90> }
		object { ThinBlade scale <1,1,.9> translate <0,0,0> rotate <0,5,110> }
		object { ThinBlade scale <1,1,.66> translate <.2,0,0> rotate <0,15,130> }
		object { ThinBlade scale <1,1,.55> translate <.2,0,0> rotate <0,20,153> }
		object { ThinBlade scale <1,1,.54> translate <.1,0,0> rotate <0,30,234> }
	}

#declare WeedStalks2 =
	union {
		object { ThinStalk }
		object { WeedTop rotate <0,24,0> translate <2.75,0,13.8> }
		object { ThinStalk scale <1,1,.8> translate <.3,0,0> rotate <0,-7,35> }
		object { WeedTop rotate <0,24,35> translate <1.4,1.0,11.4> }
	}

#declare WeedsTest = // for checking base positions
	union {
//		object { ThinStalk }
//		object { ThinBlade }
		object { ThinBlade scale <1,1,1> translate <0,0,0> rotate <0,0,60> }
		object { ThinBlade scale <1,1,1> translate <0,0,0> rotate <0,0,120> }
		object { ThinBlade scale <1,1,1> translate <0,0,0> rotate <0,0,180> }
		object { ThinBlade scale <1,1,1> translate <0,0,0> rotate <0,0,240> }
		object { ThinBlade scale <1,1,1> translate <0,0,0> rotate <0,0,300> }
//		object { ThinStalk scale <1,1,1> translate <0,0,0> rotate <0,0,60> }
//		object { ThinStalk scale <1,1,1> translate <0,0,0> rotate <0,0,120> }
//		object { ThinStalk scale <1,1,1> translate <0,0,0> rotate <0,0,180> }
//		object { ThinStalk scale <1,1,1> translate <0,0,0> rotate <0,0,240> }
//		object { ThinStalk scale <1,1,1> translate <0,0,0> rotate <0,0,300> }
	}
