
// Glenn's POV-Ray Scene File - Winseat
// created 3-Sep-99 for the Internet Raytracing Competition (www.irtc.org)
// last update 31-Oct-99
// 1999 Glenn McCarter (gmccarter@hotmail.com)

#version 3.1;
global_settings {
	adc_bailout 0.003922
//	ambient_light <1.0,1.0,1.0>
	ambient_light <0.3,0.3,0.3>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}
#include "Colors.inc"
#include "GIncludeRH.inc"
//#include "GRuler.inc"

//===============================================
//             Variables
//===============================================

// Scene origin is under center axis of fuselage
#declare TailLoc = <20*Feet,200*Feet,0>; // tail section location

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
	/* // Focal Blur section: uncomment to enable focal blur
		blur_samples 6
		aperture .5    //lower value = wider range in focus
		focal_point <0,0,0>
	*/ // end focal blur
		angle 50
		location  <8*Feet, -30*Feet, 5.8*Feet> // render view
		look_at <4*Feet, 0*Feet, 6.8*Feet> // 
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
//		location  <8*Feet, -30*Feet, 5.8*Feet> // render view
//		look_at <4*Feet, 0*Feet, 3.8*Feet> // 
//		location  <.4*Feet, -2*Feet, 1.0*Feet> // scene origin
//		look_at <0*Feet, 0*Feet, .3*Feet> // 
//		location  <28*Feet, 0*Feet, 5.8*Feet> // head on
//		look_at <4*Feet, 0*Feet, 5.8*Feet> // 
		location  <.4*Feet, -40*Feet, 18*Feet> // scene overview
		look_at <0*Feet, 0*Feet, 13*Feet> // 
	}

camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================


#declare PlainTex =
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .10 specular .65 roughness .125 }
	}
#declare GroundTex =
	texture {
		pigment { color rgb <0.267,0.333,0.137> }
		finish { ambient .10 specular .35 roughness .125 }
	}

#local GD = 0.6; // grass texture darkness
#declare GrassTex =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.00 color rgb <0.314,0.855,0.402>*GD ]
					[ 0.30 color rgb <0.400,0.910,0.471>*GD ]
					[ 0.32 color rgb <0.00,0.10,0.10>*GD ]
					[ 0.38 color rgb <0.400,0.910,0.471>*GD ]
					[ 1.00 color rgb <0.314,0.855,0.402>*GD ]
				}
				turbulence .26
				octaves 6
				lambda 2.5
				omega 0.75
				scale 3*Feet
			}
		normal { bumps .38 scale 1.5 } 
		finish { ambient .14 specular .17 roughness .07 }
	}

#declare JawboneTex =
	texture {
		pigment { color rgb <1,.981,.930>*1.97 }
		finish { ambient .30 diffuse .24 specular .00 roughness .225 }
	}
#declare Jawbone2Tex =
	texture {
		pigment { color rgb <.969,.942,.971> }
		finish { ambient .13 specular .65 roughness .053 }
	}


//===============================================
//             Lighting
//===============================================

#declare Sun =
	light_source {
		<4000*Feet,-4000*Feet,2000*Feet>
		color rgb <0.680,0.663,0.431>*2.0
		media_interaction off
		fade_distance 1400*Feet
		fade_power 1
	}
//object { Sun }

#declare Moon =
	light_source {
		<4000*Feet,-4000*Feet,2000*Feet>
		color rgb <0.380,0.463,0.631>*0.6
		media_interaction off
		fade_distance 1400*Feet
		fade_power 1
	}
object { Moon }

#declare NearFlashlight =
  light_source {
    <2*Feet,-20*Feet,4*Feet>
    color rgb <1, 1, .94>*1
		fade_distance 30*Feet
		fade_power 1
		media_interaction off
    spotlight
    point_at <0,0,4*Feet>
    radius 9    // degrees fully lit (*2)
    falloff 16   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { NearFlashlight }

#declare TailFlashlight = // illuminates inside of tail section
  light_source {
		TailLoc+<8*Feet,-20*Feet,4*Feet>
		color rgb <1, .96, .84>*.6
		fade_distance 30*Feet
		fade_power 1
		media_interaction off
    spotlight
    point_at TailLoc+<11*Feet,0,12*Feet>
    radius 9    // degrees fully lit (*2)
    falloff 26   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { TailFlashlight }

#declare TailBackLight = // illuminates back of tail section
  light_source {
   TailLoc+<18*Feet,30*Feet,4*Feet> // sunburst ok
    color rgb <1, 1, .33>*1.5
		fade_distance 30*Feet
		fade_power 1
    spotlight
    point_at TailLoc+<12*Feet,8*Feet,17*Feet>
    radius 16    // degrees fully lit (*2)
    falloff 32   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { TailBackLight }

#declare TruckLight = // highlights side of truck
  light_source {
		<60*Feet,120*Feet,4.0*Feet>
    color rgb <1, 1, .42>*.8
		media_interaction off
		fade_distance 30*Feet
		fade_power 1
    spotlight
    point_at <30*Feet,60*Feet,0.0*Feet>
    radius 9    // degrees fully lit (*2)
    falloff 16   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { TruckLight }


//===============================================
//             Environment
//===============================================

background { color rgb <0.002, 0.004, 0.080> } // dark blue

sky_sphere {
	pigment {
		gradient z
		color_map {
			[ 0.03 color rgb <0.038,0.040,0.031> ] // brownish
			[ 0.30 color rgb <0.016,0.018,0.080> ] // this is top of scene
		}
	}
}


fog {
	distance 1500*Feet
	color rgbt<0.33,0.52,0.32,2.6>*.3 // putrid green
//	color rgb <0.430,0.546,0.259>*.3 // camo green
//	color rgb<0.260,0.442,0.532>*.3 // pale cold grey blue
	turbulence 0.2
	turb_depth 0.3
}

media { // atmospheric
//intervals 10 // default
intervals 20
samples 1,1 // default
//samples 1,5
//confidence 0.9 // default
confidence 0.999
variance 1.0/128 // default
//	absorption rgb<0.1,0.1,0.1>
//	scattering { 3, rgb .01 extinction .01 } // thick smoky beams, heavy air 
//	scattering { 3, rgb .001 extinction .01 } // still thick beams, clearer air 
	scattering { 3, rgb .0005 extinction .01 } // perfect
//	scattering { 3, rgb .0001 extinction .01 } // rather too thin
//	density { rgb<1,1,1>*0.001 }
}


#declare BlockerBox =
	box {
		<0,0,0>,<10*Feet,1,10*Feet>
		texture { pigment { rgb<0,0,1> } }
		}
object { BlockerBox translate <14.5*Feet,-10*Feet,0> }

#declare LocalGround =
	height_field {
		png "GroundHF01.png"
		smooth
		translate <-0.5,0,-0.5> // center
		rotate <90,0,0> // Z=up
		scale <40*Feet,40*Feet,2.3*Feet> // scale it up, Z-scale sets max height
		texture { GrassTex }
	}
object { LocalGround translate <0,-6*Feet,0> }

#declare MiddleGround =
	height_field {
		png "GroundHF01.png"
		smooth
		translate <-0.5,0,-0.5> // center
		rotate <90,0,90> // Z=up
		scale <120*Feet,120*Feet,4*Feet> // scale it up, Z-scale sets max height
		texture { GroundTex }
	}
object { MiddleGround rotate y*2 translate <20*Feet,60*Feet,-8> }
object { MiddleGround scale 4 rotate y*4 translate <20*Feet,260*Feet,-3*Feet> }
object { MiddleGround scale <10,10,40> rotate y*8 translate <20*Feet,2600*Feet,-40*Feet> }


//===============================================
//             Objects
//===============================================


#declare Pose = 1;
#declare HPan     = 32;   // head, positive = towards his left
#declare HTiltFwd = 25;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 20;   // twists the hand, positive = palms up
#declare REAng    = 160;  // elbow
#declare RAFwd    = 13;   // total arm
#declare RARot    = 12;   // claps hands
#declare RAOut    = 12;   // opens underarm
#declare RAFwd2   = 8;    // total arm
#declare RARot2   = 0;    // claps hands
#declare RKnee    = 116;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 96;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 20;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 140;  // twists the hand, positive = palms up
#declare LEAng    = 156;   // elbow
#declare LAFwd    = 12;   // total arm
#declare LARot    = 12;   // claps hands
#declare LAOut    = 20;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = -20;  // claps hands
#declare LKnee    = 92;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 103;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle
#include "BlobMan31.inc"

//===============================================
//             Object Placement
//===============================================

object { BlobMan rotate <0,-7,180> translate <3,18,6*Feet-8> }

#include "MiscObjects.inc"
object { PoliceChopper rotate <-4,-6,158> translate <-60*Feet,180*Feet,75*Feet> }
object { WheelGroup rotate <0,102,0> rotate <-20,0,50> translate <7*Feet,12*Feet,28> }
object { FenceGroup rotate <0,0,-80> translate <16*Feet,10*Feet,0> }

#include "Weeds31.inc"
object { Weeds2 scale 2 translate <-3*Feet,-10*Feet,0> } // ok left
object { Weeds2 scale 1.2 rotate <-5,4,80> translate <-3.6*Feet,-10.4*Feet,0> } // ok left
object { Weeds1 scale 2.3 rotate <0,-5,-114> translate <-2*Feet,-10.5*Feet,0> }

object { Weeds1 scale 2.3 rotate <0,6,34> translate <14*Feet,-3*Feet,0> } // ok right
object { Weeds2 scale 1.7 rotate <14,-4,-74> translate <14.6*Feet,-1.3*Feet,0> }
object { Weeds2 scale 2 rotate z*120 translate <15*Feet,-1*Feet,0> }
object { Weeds1 scale 1.5 rotate <0,-5,140> translate <15*Feet,1*Feet,0> }
object { Weeds2 scale 1.8 rotate <7,-1,220> translate <14.5*Feet,1.6*Feet,0> }

#include "LensFlare.inc"
object { Flare(rgb<.91,.91,1>) translate <-60*Feet,180*Feet,75*Feet>+<4*Feet,-4*Feet,-4.2*Feet> } // helicopter
object { Flare(rgb<3,0,0>) translate <30*Feet,60*Feet,7.4*Feet>+<50,14,0> } // near truck
object { Flare(rgb<0,0,3>) translate <30*Feet,60*Feet,7.4*Feet>+<-16,-14,0> } // near truck
object { Flare(rgb<1,1,1>) translate <30*Feet,60*Feet,4*Feet>+<44,14,0> } // near truck
object { Flare(rgb<1,1,1>) translate <30*Feet,60*Feet,4*Feet>+<-22,-14,0> } // near truck
object { Flare(rgb<3,0,0>) translate <32*Feet,120*Feet,8*Feet>+<90,-44,0> } // far truck
object { Flare(rgb<0,0,3>) translate <32*Feet,120*Feet,8*Feet>+<66,44,0> } // far truck

#include "Fuselage.inc"
object { MainGroup rotate <2,0,-6> translate <0*Feet,-5*Feet,2*Feet> }
object { TailSection rotate <-22,6,39> translate TailLoc+<0,0,2*Feet> }

#include "FireTruck.inc"
object { FireTruck rotate <2,0.5,68> translate <30*Feet,60*Feet,1.0*Feet> } // near
object { FireTruck rotate <4,2.5,39> translate <34*Feet,120*Feet,1.2*Feet> } // far

#include "Tower.inc"
object { TowerCutBottom scale 0.6 rotate <0,0,-50> translate <80*Feet,220*Feet,0> }
object { DownTowerTop scale 0.7 rotate <75,-65,-35> translate <140*Feet,260*Feet,0> }
object { Tower scale 0.7 rotate <0,0,-40> translate <-30*Feet,560*Feet,0> }

#include "Debris.inc"
object { JunkGroup }


// TEST OBJECTS -- DO NOT RENDER
//object { TestSphere scale 2 translate <0,-2,1> }
//object { PoliceChopper rotate <-4,-6,158> translate <-6*Feet,10*Feet,5*Feet> }
//object { PoliceChopper rotate <-0,0,140> translate <-0*Feet,10*Feet,7*Feet> }
//object { WheelGroup rotate <-105,14,-72> translate <7*Feet,12*Feet,28> }
//#include "FireTruck.inc"
//object { FireTruck rotate <0,0,76> translate <-1*Feet,1*Feet,2*Feet> }
