//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Gardens
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "Vista"
//    COUNTRY: USA
//    WEBPAGE: http://www.angelfire.com/md2/castlewrks <<<<<<<------- VERY Important.
//             http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  Povray 3.1g
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), 
//                PaintShop Pro (add copyright), FastZip98 (zip)
//    RENDER TIME: about 2 hours, 48 meg
//    HARDWARE USED: Pentium 233
//    IMAGE DESCRIPTION:
//
//    This image is a large garden space with the mansion as a backdrop.  The emphasis on
//    this image is the massive organics associated with the plant materials included in
//    the render.  Using the techniques documented at the angelfire site, this image 
//    represents more than 27,000,000 native POV objects.  It would be impossible to render
//    this image using normal POV parsing and rendering options.
//    
//
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
//    See: http://www.angelfire.com/md2/castlewrks for the complete story.  Before you vote
//    on this image, you are encouraged to first visit the web site and review all the notes
//    that correspond to how this image was created.
//

 global_settings {
                    max_trace_level 80          // default POV setting is 5
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }

#include "kolors.inc"
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc" 

//#declare HillsOff=yes;    // Uncomment to turn off
//#declare FlowersOff=yes;
//#declare VinesOff=yes;
//#declare TreesOff=yes;
//#declare SkyOff=yes;
//#declare MansionOff=yes;

#declare R1=seed(2160);    // seed for randomizing things

//************************* CAMERA ***********************************
camera {
//  right<1200/400,0,0>    // make 1200x400 panorama
//  angle 60
//  panoramic 

   location  <-7.4,-.5,75> look_at <0,1,0>     // (****************IRTC View **************)   
//   location  <-3.5,1.5,-8> look_at <0,1,20>     // view Vista1 
//   location  <-5.5,-.5,4> look_at <0,0,3>     // view side of stairs   
//   location  <-5,1.5,20> look_at <0,1,0>
//   location  <0,-0.5,10> look_at <0,1,0>     // view of stairs...         
//   location  <-8,1.5,68> look_at <0,1,0>     // view of gazebo 
//   location  <-17,-.5,55> look_at <-30,1,0>     // view of pergola 
//   location  <-1.4,-.5,88> look_at <-30,1,0>     // (****************IRTC View?)   
//   location  <2.5,-.5,85> look_at <-20,1,0>     // (****************IRTC View II?)   
//   location  <0,75.5,80> look_at <0,1,0>     // high view                       
//   location  <-35,-.5,75> look_at <0,1,0>     //  view      
}                                                                                                    
//light_source { <0,500,-450 >  color White*2 }
light_source { <-50,500,550 >  color White*2 }  // (*** IRTC Light ***)
//------------------------------------------------------------------------
 
#include "..\med\brick.inc"
                           
#ifndef(SkyOff)
                           
#include "..\med\cloud.inc"       

fog {                                                 // White ground fog
  distance 950
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 30
  fog_alt 4
  turbulence 1.0
  turb_depth 3.0
}
#end // ifndef(SkyOff)

#declare GL=-2; 

#include "99ivista.inc"
                     
box{<-15000,-0.1,-5000><15000,0,0> texture{pigment{image_map { gif "..\graphics\natfl014.gif"} scale .35 rotate<90,0,0>}}}
box{<-15000,GL,0><15000,GL+.001,3500> texture{pigment{image_map { gif "..\graphics\natfl014.gif"} scale .35 rotate<90,0,0>} }}
box{<-150,GL,-.1><150,0,0> texture{T_GrayBrick scale .0325}}
  
object{Steps translate< -3.2,0,0>}
object{Steps translate<  3.2,0,0>}   
object{Steps translate<-21,  0,0>}
object{Steps translate< 21,  0,0>}
object{Steps translate<-39,  0,0>}
object{Steps translate< 39,  0,0>}      

// Walkways 
#declare Bench=union{
   box{<-.2,0,-.6><.2,.4,-.4>}
   box{<-.2,0, .4><.2,.4, .6>}
   box{<-.25,.4,-.75><.25,.45,.75>}
  texture{T_Stone5}
} // bench
#declare BenchPad=union{
   cylinder{<0,0,0><0,.01,0> 2 }  
   object{Bench}
}   

#declare Walks=union{
   box{< -4.1, 0, -40><  4.1,.01, -44>}
   box{< -4.1, 0, -44>< -2,  .01,-100>}
   box{<  4.1, 0, -44><  2,  .01,-100>}
   
   box{< -1,   0, -40><  1,  .01, 60>}   // center walk
//   box{< -5,   0,  10><  5,  .01,  12>}   // South pad
   
   box{<-22,   0,-50><-20,  .01, 60>}
   box{< 20,   0,-50>< 22,  .01, 60>}        
   box{<-40,   0,-50><-38,  .01, 60>}
   box{< 38,   0,-50>< 40,  .01, 60>}         
   
   box{<-40,   0,  -1>< 40,  .01,   1>}
   box{<-40,   0,  20>< 40,  .01,  22>
       texture{pigment{image_map { gif "..\graphics\brick001.gif" } rotate<90,0,0> rotate<0,90,0> scale .5}}
      }
   box{<-40,   0, -20>< 40,  .01, -22>} 
   box{<-40,   0,  40>< 40,  .01,  42>}
   box{<-40,   0, -40>< 40,  .01, -42>}     
   box{<-40,   0,  60>< 40,  .01,  62>} 
    
   object{BenchPad translate<40,0,62>}
   object{BenchPad translate<40,0,41>}
   object{BenchPad translate<40,0,21>}
   object{BenchPad translate<40,0,0>}
   object{BenchPad translate<40,0,-21>}
   object{BenchPad translate<40,0,-42>}

   object{BenchPad translate<-40,0,62>}
   object{BenchPad translate<-40,0,42>}
   object{BenchPad translate<-40,0,21>}
   object{BenchPad translate<-40,0,0>}
   object{BenchPad translate<-40,0,-21>}
   object{BenchPad translate<-40,0,-42>}
   
   object{BenchPad translate<21,0,62>}
   object{BenchPad translate<0,0,62>}
   object{BenchPad translate<-21,0,62>}
   
   cylinder{<0,0,15><0,.01,15> 8}    // walk around fountain
   cylinder{<0,0,-15><0,.01,-15> 8}
   box{<-8,0,-15><8,.01,15> }   

// Special borders for visable walkways
   
   #declare C1=0;
   #declare S9=seed(739);
   #while (C1<90)
       #declare ROY=rand(S9)*10-5;
       #declare ROX=rand(S9)*10-5;
       box{<-.1,-.05,-.05><.1,.011,.05> rotate<ROX,ROY,0> texture{T_Stone5} 
           translate<-8.1,0,0> rotate<0,C1,0> translate<0,0,15>}
       box{<-.1,-.05,-.05><.1,.011,.05> rotate<ROX,ROY,0> texture{T_Stone5}
           translate<-8.1,0,0> rotate<0,C1-90,0> translate<0,0,-15>}    
       #declare C1=C1+.55;
   #end 
   
   #declare C1=-15;
   #while (C1<15)
      #declare ROY=rand(S9)*10-5;
       #declare ROX=rand(S9)*10-5;
       box{<-.1,-.05,-.05><.1,.011,.05> rotate<ROX,ROY,0> texture{T_Stone5} 
           translate<-8.1,0,C1> }
       #declare C1=C1+.11;
   #end 

   #declare C1=-6.5;
   #while (C1>-25)
      #declare ROY=rand(S9)*10-5;
       #declare ROX=rand(S9)*10-5;
       box{<-.05,-.05,-.1><.05,.011,.1> rotate<ROX,ROY,0> texture{T_Stone5} 
           translate<C1,0,19.9> }
       #declare C1=C1-.11;
   #end 
 
#ifndef(FlowersOff)
   #declare C1=9;
   #while (C1<=11)
        #declare C2=2;
        #while (C2<=15)
           #if ((C1-9)*(C1-11)=0)
             #declare ROY=int(rand(R1))*180;
             #declare RX=rand(R1)*.5-.25;
             object{X1 rotate<0,ROY,0> translate<C1+RX,0,C2>} 
             object{X1 rotate<0,ROY,0> translate<-C1+RX-1,0,C2>}
             object{X1 rotate<0,ROY,0> translate<-C1+RX-1,0,-C2>}
             object{X1 rotate<0,ROY,0> translate<C1+RX,0,-C2>}
           #else 
             object{X2 rotate<0,ROY,0> translate<C1+RX,0,C2>}
             object{X2 rotate<0,ROY,0> translate<-C1+RX-1,0,C2>}
             object{X2 rotate<0,ROY,0> translate<-C1+RX-1,0,-C2>}
             object{X2 rotate<0,ROY,0> translate<C1+RX,0,-C2>}
           #end 
           #declare C2=C2+1;
        #end
        #declare C1=C1+1;
   #end
#end // ifndef(FlowersOff)    
   
   texture{pigment{image_map { gif "..\graphics\brick001.gif" } rotate<90,0,0> scale .5}}
}

//object{Urn1 scale .3 translate<-2.22,.92,.30> texture{T_Stone5}}
//object{Urn1 scale .3 translate<-4.18,.92,.30> texture{T_Stone5}}
//object{Urn1 scale .3 translate<2.22,.92,.30> texture{T_Stone5}}
//object{Urn1 scale .3 translate<4.18,.92,.30> texture{T_Stone5}}
//object{Urn2 scale .3 translate<-20.02,.92,.30> texture{T_Stone5}}
//object{Urn2 scale .3 translate<-21.98,.92,.30> texture{T_Stone5}}
//object{Urn2 scale .3 translate<20.02,.92,.30> texture{T_Stone5}}
//object{Urn2 scale .3 translate<21.98,.92,.30> texture{T_Stone5}}

// Front garden  
object{FrontWalks}
object{Rail}                                 
//object{Urn2 scale .3 translate<-1.92,.92,0> texture{T_Stone5}} 
//object{Urn1 scale .3 translate<0.92,.92,0> texture{T_Stone5}}
//object{Urn1 scale .3 translate<-0.92,.92,0> texture{T_Stone5}}
//object{Urn2 scale .3 translate<1.92,.92,0> texture{T_Stone5}}

object{Rail12 translate<-12.25,0,0>} 
object{Rail12 translate<12.25,0,0>}    
object{Rail12 translate<-30.25,0,0>} 
object{Rail12 translate<30.25,0,0>}     
object{Rail12 translate<-48.25,0,0>} 
object{Rail12 translate<48.25,0,0>}
//object{Urn2 scale .3 translate<-1.92-6.25,.92,0> texture{T_Stone5}} 
//object{Urn1 scale .3 translate<0.92-6.25,.92,0> texture{T_Stone5}}
//object{Urn1 scale .3 translate<-0.92-6.25,.92,0> texture{T_Stone5}}
//object{Urn2 scale .3 translate<1.92-6.25,.92,0> texture{T_Stone5}}
                                  
//box{<-2.1,0,-.75><2.1,.01,0> texture{pigment{color DarkBrown} normal{granite .15}}}  // dirt

#ifndef(FlowersOff)
object{X1 scale <.75,.75,1> translate<1.5,0,-.5>}                                        
object{X3 scale <.75,.75,1> translate<1,0,-.5>}                              
object{X1 scale <.75,.75,1> rotate<0,0,0> translate<.5,0,-.6>} 
object{X1 scale <.75,.7,1> rotate<0,0,0> translate<0,0,-.5>}
object{X1 scale <.75,.75,1> translate<-.5,0,-.5>}
object{X3 scale <.75,.8,1> rotate<0,0,0> translate<-1,0,-.6>}
object{X1 scale <.75,.75,1> translate<-1.5,0,-.5>}  
object{X1 scale <.75,.75,1> translate<-2,0,-.5>}  

object{X2 scale <.5,.5,1> translate<1.5,0,-.75>}                                        
object{X2 scale <.5,.5,1> translate<1,0,-.75>}                              
object{X2 scale <.5,.5,1> rotate<0,0,0> translate<.5,0,-.76>} 
object{X2 scale <.5,.7,1> rotate<0,0,0> translate<0,0,-.75>}
object{X2 scale <.5,.75,1> translate<-.5,0,-.75>}
object{X2 scale <.5,.6,1> rotate<0,0,0> translate<-1,0,-.76>}
object{X2 scale <.5,.5,1> translate<-1.5,0,-.75>}  
object{X2 scale <.5,.5,1> translate<-2,0,-.75>}  
#end // ifndef(FlowersOff)

#declare PergolaPost=box{<-.1,0,-.1><.1,3,.1>}
#declare PergolaFrame=union{
     object{PergolaPost translate<-1.5,0,0> texture{T_Wood1}}
     object{PergolaPost translate<1.5,0,0> texture{T_Wood1}} 
     
    
     box{<-1.75,2.7,-.2><1.75,3,0> texture{T_Wood1 rotate<0,90,0>}}
}         
#declare PergolaRail=box{<-.05,3,-2.2><.05,3.1,.2> texture{T_Wood1 }}
#declare Pergola=union{  
     #declare C1=-8;
     #while (C1<=8)
       object{PergolaFrame translate<0,0,C1>}
       #declare C1=C1+2;
     #end
     #declare C1=-6;
     #while (C1<=8)                  
        #ifndef(VinesOff)     
           #declare ScY=rand(R1)*1+3;
           #declare ScX=rand(R1)*1+3;  
//           #declare ScY=3 //rand(R1)*3+1;
//           #declare ScX=3 //rand(R1)*3+1;           
           object{Vine2 rotate<0,0,90> scale <ScX,ScY,1> translate<.25,1.65,C1+.2>}
           #declare ScY=rand(R1)*1+3;
           #declare ScX=rand(R1)*1+3;           
           object{Vine2 rotate<0,0,90> scale <ScX,ScY,1> translate<.25,1.65,C1-.2>}
           #declare ScY=rand(R1)*1+3;
           #declare ScX=rand(R1)*1+3;           
           object{Vine2 rotate<0,0,90> scale <ScX,ScY,1> translate<3,1.65,C1-.2>}
           #declare ScY=rand(R1)*1+3;
           #declare ScX=rand(R1)*1+3;           
           object{Vine2 rotate<0,0,90> scale <ScX,ScY,1> translate<3,1.65,C1+.2>}      
           #declare ScY=rand(R1)*2+2;
           #declare ScX=rand(R1)*3+2;           
           object{Vine2 scale <3,3,1> translate<0,1.7,C1+.15>}      
           object{Vine2 rotate<0,180,0> scale <3,3,1> translate<0,1.35,C1+.1>}                                             
        #end   
        
        object{PergolaRail translate<-1.5,0,C1>}
        object{PergolaRail translate<-1.3,0,C1>}
        object{PergolaRail translate< 1.5,0,C1>}
        object{PergolaRail translate< 1.3,0,C1>}
        object{PergolaRail translate<0,0,C1>}
        object{PergolaRail translate<.75,0,C1>}
        object{PergolaRail translate<-.75,0,C1>}
       #declare C1=C1+2;
     #end     
}


#ifndef(FlowersOff)
#declare FlowerBed1=union{
   #declare C1=-9;
   #while (C1<9)
       #declare ROY=int(rand(R1))*180;  // rotate 0/180
       #declare RX=rand(R1)*.2-.1;      // shift x +-.1
       object{X5 rotate<0,ROY,0> translate<6+RX,0,C1>}
       object{X6 rotate<0,ROY,0> translate<-6+RX,0,C1>}
       #declare C1=C1+1;
   #end
}
#declare FlowerBed2=union{
   #declare C1=-9;
   #while (C1<9)
       #declare ROY=int(rand(R1))*180;  // rotate 0/180
       #declare RY=rand(R1)*.2-.1;      // shift y +-.1
       object{X4 rotate<0,ROY,0> translate<C1,0,6+RY>}
       object{X5 rotate<0,ROY,0> translate<C1,0,5+RY>}
       object{X5 rotate<0,ROY,0> translate<C1,0,-5+RY>}
       object{X4 rotate<0,ROY,0> translate<C1,0,-6+RY>} 
       #declare C1=C1+.75;
   #end
}                
#declare FlowerBed3=union{
   #declare C1=-9;
   #while (C1<9)
       #declare ROY=int(rand(R1))*180;  //0/180
       object{X7 rotate<0,ROY,0> translate<C1,0,6>}
       object{X4 rotate<0,ROY,0> translate<C1,0,5>}
       object{X1 rotate<0,ROY,0> translate<C1,0,-5>}
       object{X2 rotate<0,ROY,0> translate<C1,0,-6>} 
       #declare C1=C1+.75;
   #end
}
#declare FlowerBed4=union{
   #declare C1=-9;
   #while (C1<9)
       object{X7 translate<6,0,C1>}
       object{X2 translate<-6,0,C1>}
       #declare C1=C1+1;
   #end
}
#end // ifndef(FlowersOff)

#ifndef(TreesOff)
#macro Tree(X,Y,Z) 
  #declare T1=int(rand(R1)*8+1);
  #declare ROY=int(rand(R1))*180;  // 180 or 0
  #declare Sc=rand(R1)*.4+.85;
  object{
         #switch (T1)
            #case (1) Tree1  #break     
            #case (2) Tree2  #break    
            #case (3) Tree3  #break    
            #case (4) Tree4  #break
            #case (5) Tree5  #break    
            #case (6) Tree6  #break    
            #case (7) Tree7  #break    
            #case (8) Tree8  #break
            #else Tree8 #break                                                                 
         #end 
        scale Sc   
        rotate<0,ROY,0>
        translate<X,Y,Z>
       }  
#end //macro Tree

#declare TreeRow1=union{
   #declare C1=-9;
   #while (C1<9)
       Tree(8,-.24,C1)
       #declare C1=C1+5;
   #end
}
#declare TreeRow2=union{
   #declare C1=-40;
   #while (C1<40)
       Tree(8,-.24,C1)
       Tree(-8,-.24,C1)
       #declare C1=C1+5;
   #end
}
#declare TreeRow3=union{
   #declare C1=-70;
   #while (C1<=70)
       Tree(C1,-.24,-10)
       Tree(C1+5,-.24,-10.2)
       #declare C1=C1+10;
   #end
}
#end // ifndef(TreesOff)

#ifndef(FlowersOff)
//  object{FlowerBed1 translate<-31,GL,63>}
  object{FlowerBed2 translate<-16.5,GL,63>}
  object{FlowerBed3 translate<-11,GL,88>}

  object{FlowerBed3 translate<16.5,GL,63>}
  object{FlowerBed2 translate<11,GL,88>}
  
  object{Urn3 translate<-5.2,GL+.85,72.2> texture{T_Stone8}}
  object{Urn4 translate<-5.85,GL+.5,72.9> texture{T_Stone8}}
  object{Urn5 translate<-5.85,GL+.5,71.5> texture{T_Stone8}}  
  
  object{Wheelbarrow rotate<0,45,0> translate<-8.7,GL,71>}

 
  object{Shovel rotate<-43,0,0> translate<-8.2,GL,71.5> }     
  
#end  // ifndef(FlowersOff)                   
                   
#ifndef(TreesOff)                   
  object{TreeRow1 translate<-16.5,GL,61>} 
  object{TreeRow1 rotate<0,180,0> translate<16.5,GL,61>}
  object{TreeRow1 translate<-16.5,GL,40>} 
  object{TreeRow1 rotate<0,180,0> translate<16.5,GL,40>}   

  object{TreeRow1 translate<-36.5,GL,61>} 
  object{TreeRow1 rotate<0,180,0> translate<36.5,GL,61>}
  object{TreeRow1 translate<-36.5,GL,40>} 
  object{TreeRow1 rotate<0,180,0> translate<36.5,GL,40>}      

  object{TreeRow2 translate<-45,GL,50>}
  object{TreeRow3 }  // row across top of wall

#end // ifndef(TreesOff)

#ifndef(FlowersOff)   
  object{LowerGardens}
#end
object{Fountain translate<0,GL,50>}   
object{Walks translate<0,GL,50>}
object{Pergola translate<-21,GL,41>}  // on West Side
object{Pergola translate<21,GL,41>}   // on East Side




                                    
//#ifndef(TreesOff)   
//#declare C1=-100;            
//#declare S1=seed(88);
//#while (C1<=100) 
//   #declare Z=rand(S1)*20;
//   #declare Y=int(rand(S1)*1);  
//   #declare T=int(rand(S1)*4+1);
//   #declare Sc=rand(S1)*.75+.5;
//   #switch (T)
//     #case (1)   object{Tree1 rotate<0,Y*180,0> scale <Sc,Sc,1> translate<C1,GL,100+Z>}    #break  
//     #case (2)   object{Tree2 rotate<0,Y*180,0> scale <Sc,Sc,1> translate<C1,GL,100+Z>}    #break
//     #case (3)   object{Tree3 rotate<0,Y*180,0> scale <Sc,Sc,1> translate<C1,GL,100+Z>}    #break
//     #case (4)   object{Tree4 rotate<0,Y*180,0> scale <Sc,Sc,1> translate<C1,GL,100+Z>}    #break               
//   #end
//   #declare C1=C1+rand(S1)*2+1;
//#end   
//#end // ifndef(TreesOff)


#ifndef(HillsOff)
  object {   //   Hills South
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 123, 1600 >   translate < -800, 0, -800>
                 rotate<0,0,0> translate<0,0,-2700>
  }                                          
  object {   //   Hills South
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 123, 1600 >   translate < -800, 0, -800>
                 rotate<0,0,0> translate<-900,0,-2500>
  }          
  object {   //   Hills South
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 123, 1600 >   translate < -800, 0, -800>
                 rotate<0,0,0> translate<890,0,-2500>
  } 
  object {   //   Hills South
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 14, 1600 >   translate < -800, 0, -800>
                 rotate<0,90,0> translate<0,0,-1100>
  }                                          
  object {   //   Hills South
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 14, 1600 >   translate < -800, 0, -800>
                 rotate<0,90,0> translate<-900,0,-1200>
  }          
  object {   //   Hills South
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 14, 1600 >   translate < -800, 0, -800>
                 rotate<0,180,0> translate<890,0,-1150>
  }

  object {   //   Hills West
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 40, 1600 >   translate < -800, 0, -800>
                 rotate<0,180,0> translate<-840,GL,-140>
  }                       

  object {   //   Hills East
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 38, 1600 >   translate < -800, 0, -800>
                 rotate<0,0,0> translate<830,GL,0>
  }  
  
#end // ifndef(HillsOff)                                               

#ifndef(MansionOff)
  #include "..\garden\manor.inc"
           
  object{Main rotate<0,180,0> translate<0,0,-100>}      
#end // ifndef(MansionOff)

                                    

