//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Gardens
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "
//    COUNTRY: USA
//    WEBPAGE: http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  Povray 3.1g.watcom
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), PaintShop Pro (add copyright)
//    RENDER TIME: 
//    HARDWARE USED: Pentium 233
//    IMAGE DESCRIPTION:
//    
//
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:


 global_settings {
                                    max_trace_level 12          // default POV setting is 5
                                    max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                                  }

#include "kolors.inc"    // Ken's kolors file.
#include "textures.inc"
#include "glass.inc"
#include "finish.inc"
#include "stones1.inc"

camera {                                 
//    location <0,.5,-.25> look_at <0,.25,0>  // flower bunch view
//    location <0,1.5,-3> look_at <0,1.5,0>
    location <0,.25,0> look_at<0,0,0>     // flower view
}

//light_source{<0,20,-50> color White*2}  // BIG light
light_source{<0,20,0> color White*2}  // BIG light

#declare S1=seed(48); 
 
#declare Flower1=union{
     sphere{<0,0,0> .015 scale <1,.25,1> texture{pigment{color Yellow}}}
     sphere{<0,0,0> .01 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .01 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.1,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=1;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0025;
       #declare ZR=rand(S1)*90-45;
       #declare XR=rand(S1)*40-25;       
       #declare ZS=rand(S1)*2.5+4;
       cylinder{<0,0,0><0,.0001,0> .005 rotate<0,0,ZR>
                 translate<0,Y1,.005> rotate<XR,0,0>
                 scale <1,1,ZS> rotate<0,Count,0> texture{pigment{color Orange}}}
       #declare Count=Count+rand(S1)*25;
     #end
}
#declare Flower2=union{
     sphere{<0,0,0> .01 scale <1,.25,1> texture{pigment{color Orange}}}
     sphere{<0,0,0> .01 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .01 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.1,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=1;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0025;
       #declare ZS=rand(S1)*1.5+2;
       #declare XR=rand(S1)*-45-20;
       cylinder{<0,0,0><0,.0001,0> .005 translate<0,Y1,.005>
                 scale <.75,1,ZS> rotate<XR,Count,0> texture{pigment{color AliceBlue}}}
       #declare Count=Count+rand(S1)*25;
     #end
}
#declare Flower3=union{
     sphere{<0,0,0> .01 scale <1,.35,1> texture{pigment{color Orange}}}
     sphere{<0,0,0> .01 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .01 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.1,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=0;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0025;
       #declare ZS=rand(S1)*1+2;
       #declare XR=rand(S1)*-45-20;
       cylinder{<0,0,0><0,.0001,0> .005 translate<0,Y1,.005>
                 scale <.5,1,ZS> rotate<XR,Count,0> texture{pigment{color Brown}}}
       #declare Count=Count+rand(S1)*5;
     #end
}
#declare Flower4=union{      // another mum-like flower
     sphere{<0,0,0> .01 scale <1,.35,1> translate<0,.002,0> texture{pigment{color Orange}}}
     sphere{<0,0,0> .009 scale <1,.36,1> translate<0,.0025,0> texture{pigment{color Orange1}}}
     sphere{<0,0,0> .01 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .01 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.1,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=0;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0045;
       #declare ZS=rand(S1)*1+2;
       #declare XS=rand(S1)*.25+.25;  
       #declare ZR=rand(S1)*90-45;
       #declare XR=rand(S1)*-90+40;
       #declare CO=int(rand(S1)*6)+1;
       cylinder{<0,0,0><0,.0001,0> .005 translate<0,Y1,.005>
                 rotate<0,0,ZR>
                 scale <XS,1,ZS> rotate<XR,Count,0> 
                 #switch (CO)
                   #case (1)                 
                     texture{pigment{color MistyRose}}
                   #break
                   #case (2)
                     texture{pigment{color MistyRose1}}
                   #break
                   #case (3)
                     texture{pigment{color MistyRose2}}
                   #break
                   #case (4)
                     texture{pigment{color MistyRose3}}
                   #break
                   #case (5)
                     texture{pigment{color MistyRose4}}
                   #break
                   #case (6)
                     texture{pigment{color MistyRose}}
                   #break                                                         
                 #end
               }  
       #declare Count=Count+rand(S1)*2;
     #end
}
#declare Flower5=union{     // mum-like flower
     sphere{<0,0,0> .01 scale <1,.35,1> translate<0,.002,0> texture{pigment{color Orange}}}
     sphere{<0,0,0> .009 scale <1,.36,1> translate<0,.0025,0> texture{pigment{color Orange1}}}
     sphere{<0,0,0> .01 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .01 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.1,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=0;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0045;
       #declare ZS=rand(S1)*1+2;
       #declare XS=rand(S1)*.25+.25;  
       #declare ZR=rand(S1)*90-45;
       #declare XR=rand(S1)*-90+40;
       #declare CO=int(rand(S1)*6)+1;
       cylinder{<0,0,0><0,.0001,0> .005 translate<0,Y1,.005>
                 rotate<0,0,ZR>
                 scale <XS,1,ZS> rotate<XR,Count,0> 
                 #switch (CO)
                   #case (1)                 
                     texture{pigment{color Brown}}
                   #break
                   #case (2)
                     texture{pigment{color Red}}
                   #break
                   #case (3)
                     texture{pigment{color Brown2}}
                   #break
                   #case (4)
                     texture{pigment{color Brown3}}
                   #break
                   #case (5)
                     texture{pigment{color Brown4}}
                   #break
                   #case (6)
                     texture{pigment{color Orange}}
                   #break                                                         
                 #end
               }  
       #declare Count=Count+rand(S1)*2;
     #end
}
#declare Petal6=union{    // pansy-like flower
     cylinder{<0,0,0><0,.0001,0> .008 translate<-.0025,0,-.0015>}
     cylinder{<0,0,0><0,.0001,0> .008 translate<.0025,0,-.0015>}
     box{<-.0012,0,-.0012><.0012,.0001,.0012> rotate<0,45,0> scale<.75,1,1.5>}
}     
#declare Flower6=union{
//     sphere{<0,0,0> .005 scale <1,.35,1> translate<0,.002,0> texture{pigment{color Orange1}}}
//     sphere{<0,0,0> .0045 scale <1,.36,1> translate<0,.0025,0> texture{pigment{color Brown}}}

     #declare Count=1;
     #while (Count<150)
        #declare ZR=rand(S1)*-45;
        #declare YR=rand(S1)*360;
        #declare X=rand(S1)*.0065;
        union{
            cylinder{<0,0,0><0,.005,0> .0001}
            sphere{<0,.005,0> .0002}
            texture{pigment{color Orange1}}
            rotate<0,0,ZR>  
            translate<X,0,0>  
            rotate<0,YR,0> 
            }
        #declare Count=Count+1;
     #end
     sphere{<0,0,0> .005 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .005 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.051,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=0;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0025;
       #declare ZS=rand(S1)*1+.25;
       #declare XS=rand(S1)*.25+.25;  
       #declare ZR=rand(S1)*25;
       #declare XR=rand(S1)*-50+40;
       #declare CO=int(rand(S1)*6)+1;
       object{Petal6            
                normal {
                  wrinkles .0000050
                }       
           
              translate<0,Y1,-.01>
                 rotate<0,0,ZR>
                 scale <1,1,ZS> rotate<XR,Count,0> 
                 #switch (CO)
                   #case (1)                 
                     texture{pigment{color LightBlue}}
                   #break
                   #case (2)
                     texture{pigment{color LightBlue}}
                   #break
                   #case (3)
                     texture{pigment{color LightBlue1}}
                   #break
                   #case (4)
                     texture{pigment{color LightBlue2}}
                   #break
                   #case (5)
                     texture{pigment{color LightBlue3}}
                   #break
                   #case (6)
                     texture{pigment{color LightBlue4}}
                   #break                                                         
                 #end                                           
               }  
       #declare Count=Count+rand(S1)*10+75;
     #end
}

#declare Flower7=union{     // white lacy flower
     sphere{<0,0,0> .00351 scale <1,.25,1> texture{pigment{color Orange}}}
     sphere{<0,0,0> .00351 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color Khaki}}}
     cone{<0,0,0> .0051 <0,-.018,0> .0035 texture{pigment{color Khaki}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color Khaki}}}
//     cone{<0,-.018,0> .0015 <0,-.1,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=1;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0025;
       #declare ZS=rand(S1)*.75+.5;
       #declare XR=rand(S1)*-25-20; 
       #declare CO=int(rand(S1)*6)+1;       
       cylinder{<0,0,0><0,.0001,0> .005 translate<0,Y1,.005>
                 scale <.1,1,ZS> rotate<XR,Count,0> 
                 #switch (CO)
                   #case (1)                 
                     texture{pigment{color LemonChiffon}}
                   #break
                   #case (2)
                     texture{pigment{color LemonChiffon1}}
                   #break
                   #case (3)
                     texture{pigment{color LemonChiffon2}}
                   #break
                   #case (4)
                     texture{pigment{color LemonChiffon3}}
                   #break
                   #case (5)
                     texture{pigment{color LemonChiffon4}}
                   #break
                   #case (6)
                     texture{pigment{color LemonChiffon}}
                   #break                                                         
                 #end                                           
               }                   
       #declare Count=Count+rand(S1)*1;
     #end
}
  
#declare Flower8=union{    // bachelor button
     sphere{<0,0,0> .00351 scale <1,.25,1> texture{pigment{color DarkBrown}}}
     sphere{<0,0,0> .00351 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .0045 <0,-.006,0> .003 texture{pigment{color DarkGreen}}}
     sphere{<0,-.006,0> .003 texture{pigment{color DarkGreen}}}
//     cone{<0,-.006,0> .001 <0,-.031,0> .0009 texture{pigment{color DarkGreen}}}
     
     #declare Count=1;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0025;
       #declare ZS=rand(S1)*.5+.5;
       #declare XR=rand(S1)*-15-70; 
       #declare CO=int(rand(S1)*6)+1;       
       cylinder{<0,0,0><0,.0001,0> .005 translate<0,Y1,.02>
                 scale <.1,1,ZS> rotate<XR,Count,0>   
                 translate<0,-.008,0>
                 #switch (CO)
                   #case (1)                 
                     texture{pigment{color SkyBlue}}
                   #break
                   #case (2)
                     texture{pigment{color SkyBlue1}}
                   #break
                   #case (3)
                     texture{pigment{color SkyBlue2}}
                   #break
                   #case (4)
                     texture{pigment{color SkyBlue3}}
                   #break
                   #case (5)
                     texture{pigment{color SkyBlue4}}
                   #break
                   #case (6)
                     texture{pigment{color LightSteelBlue}}
                   #break                                                         
                 #end                                           
               }                   
       #declare Count=Count+rand(S1)*5;
     #end
}
#declare Petal9=union{
     cylinder{<0,0,0><0,.0001,0> .01 translate<-.005,0,-.0015>}
     cylinder{<0,0,0><0,.0001,0> .01 translate<.005,0,-.0015>}
     box{<-.0012,0,-.0012><.0012,.0001,.0012> rotate<0,45,0> scale<.75,1,1.5>}
}   
#declare Flower9=union{
     sphere{<0,0,0> .005 scale <1,.35,1> translate<0,.002,0> texture{pigment{color Orange1}}}
     sphere{<0,0,0> .0045 scale <1,.36,1> translate<0,.0025,0> texture{pigment{color Brown}}}
     sphere{<0,0,0> .005 scale <1,.5,1> translate<0,-.005,0> texture{pigment{color DarkGreen}}}
     cone{<0,0,0> .005 <0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
     sphere{<0,-.018,0> .0035 texture{pigment{color DarkGreen}}}
//     cone{<0,-.018,0> .0015 <0,-.051,0> .0014 texture{pigment{color DarkGreen}}}
     
     #declare Count=0;
     #while (Count<360)
       #declare Y1=rand(S1)*-.0045;
       #declare ZS=rand(S1)*1+.5;
       #declare XS=rand(S1)*.25+.25;  
       #declare ZR=rand(S1)*70-35;
       #declare XR=rand(S1)*-90+40;
       #declare CO=int(rand(S1)*6)+1;
       object{Petal9            
                normal {
                  wrinkles .0000050
                }       
           
              translate<0,Y1,-.01>
                 rotate<0,0,ZR>
                 scale <1,1,ZS> rotate<XR,Count,0> 
                 #switch (CO)
                   #case (1)                 
                     texture{pigment{color LightBlue}}
                   #break
                   #case (2)
                     texture{pigment{color LightBlue}}
                   #break
                   #case (3)
                     texture{pigment{color LightBlue1}}
                   #break
                   #case (4)
                     texture{pigment{color LightBlue2}}
                   #break
                   #case (5)
                     texture{pigment{color LightBlue3}}
                   #break
                   #case (6)
                     texture{pigment{color LightBlue4}}
                   #break                                                         
                 #end                                           
               }  
       #declare Count=Count+rand(S1)*45+60;
     #end
}


#declare Leaf1=union{
    triangle{<0,0,0><-.01,.01,0><.01,.01,0> }
    triangle{<0,.008,0><-.012,.02,0><.012,.02,0> }                        
    triangle{<0,.018,0><-.008,.03,0><.008,.03,0> }
    triangle{<0,.028,0><-.004,.04,0><.005,.04,0> }
    triangle{<-.004,.04,0><.005,.04,0><0,.05,.01>}
}

#declare Leaf2=union{
    cylinder{<0,0,0><0,0,.00001> .025 scale <.2,.55,1>}
}

#declare Leaf3=union{
    cylinder{<0,0,0><0,0,.00001> .025  scale <.5,1,1>}
    triangle{<0,-.025,0><-.02,.005,0><.02,.005,0> }
    triangle{<0,.01,0><-.023,-.015,0><.023,-.015,0>}
}

#declare Leaf4=union{ // star pattern leaf
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2>}
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2> rotate<0,0,45>}
    cylinder{<0,0,0><0,0,.00001> .025  scale <.25,1,1.2> rotate<0,0,-45>}
}

#declare Leaf5=union{ // duck foot pattern leaf
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.35,1,1.2>}
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.25,1,1.2> rotate<0,0,25>}
    cylinder{<0,0,0><0,0,.00001> .025 translate<0,.025,0>  scale <.25,1,1.2> rotate<0,0,-25>}
} 

#declare Twig1=union{  // random small branches
    cylinder{<0,0,0><0,.02,0> .005}
    cylinder{<0,.02,0><.04,.05,0> .005}
    cylinder{<.04,.05,0><.02,.075,0> .005}
    cylinder{<.02,.075,0><-.01,.085,0> .005}
}

#macro LeafMass(X1,Y1,Z1,MLC,LEAF)
// X1,Y1,Z1 = dimensions of leaf mass
// MLC = maximum leaf count
// LEAF = leaf definition to use for leaves

     #declare LC=1;
     #while (LC<MLC)
         #declare X=rand(R1)*X1-X1/2;
         #declare Y=rand(R1)*Y1;
         #declare Z=rand(R1)*Z1-Z1/2;
         #declare XOR=rand(R1)*360;
         #declare YOR=rand(R1)*360;
         #declare ZOR=rand(R1)*360;
         #declare Sc=rand(R1)*.75+.5;
         #declare CO=int(rand(R1)*9+1);
         
         object{LEAF
                scale Sc rotate<XOR,YOR,ZOR> translate<X,Y,Z>
                texture{pigment{color
                    #switch (CO)
                      #case (1) DarkOliveGreen  #break
                      #case (2) DarkOliveGreen1 #break
                      #case (3) DarkOliveGreen2 #break
                      #case (4) DarkOliveGreen3 #break
                      #case (5) DarkOliveGreen4 #break 
                      #case (6) DarkOliveGreen5 #break                      
                      #case (7) DarkGreenCopper #break                                                                    
                      #case (8) DarkGreen #break
                      #case (9) DarkGreen1 #break
                    #end // switch
                 }}}
         #declare LC=LC+1;
     #end 
#end // macro LeafMass   

#declare S2=seed(86);
#macro Stem (FLC,Xm,Ym,Ymin,Zm,FLOWER)
// FLC = Flower Count
// Xm,Ym,Zm = size of bed
// FLOWER = Which Flower
//
//#declare Stem1=union{

     #declare Count=1;
     #while (Count<FLC)
        #declare ZR=rand(S2)*-15;
        #declare YR=rand(S2)*360;
        #declare X=rand(S2)*.045; 
        #declare X1=rand(S2)*Xm-Xm/2;
        #declare Z1=rand(S2)*Zm-Zm/2;
        #declare Y=rand(S2)*Ym+Ymin;  // length  
        //#declare F1=int(rand(S2)*8)+1;  // Which Flower?
        
            cylinder{<0,0,0><0,Y,0> .001
            
                     texture{pigment{color Khaki}}
                     
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0>
                     translate<X1,0,Z1> 
                  }
             object{FLOWER
                     translate<0,Y,0>
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0> 
                     translate<X1,0,Z1>
                    }                   
        #declare Count=Count+1;
     #end 
//}  // Stem1
#end //macro Stem


//  Vine2 grouping (Vine2.gif)   a verticle vine grouping
//#declare R1=seed(226);                        
//LeafMass(.65,3.,.1,300,Twig1)
//#declare R1=seed(149);                         
//LeafMass(.65,3.,.1,1200,Leaf5)

//  Vine1 grouping (Vine1.gif)   a verticle vine grouping
//#declare R1=seed(186);                        
//LeafMass(.65,3.,.1,300,Twig1)
//#declare R1=seed(2299);                         
//LeafMass(.65,3.,.1,700,Leaf5)
                               
                               
//  Flower1 grouping (Flowers1.gif)
//#declare S2=seed(86);                        
//Stem(25,.5,.15,.20,.1,Flower5)
//#declare R1=seed(99);                         
//LeafMass(.6,.28,.15,2800,Leaf1)
                         
//  Flower2 grouping (Flowers2.gif)
//#declare S2=seed(86);                        
//Stem(45,.45,.15,.20,.1,Flower8)
//#declare R1=seed(99);                         
//LeafMass(.6,.22,.15,2800,Leaf2)     

//  Flower3 grouping (Flowers3.gif)
//#declare S2=seed(126);                        
//Stem(15,.5,.10,.35,.2,Flower1)
//#declare R1=seed(99);                         
//LeafMass(.6,.35,.25,500,Leaf3)

//  Flower4 grouping (Flowers4.gif)
//#declare S2=seed(312);                        
//Stem(25,.45,.10,.25,.2,Flower2)
//#declare R1=seed(399);                         
//LeafMass(.6,.25,.25,600,Leaf1)

//  Flower5 grouping (Flowers5.gif)
//#declare S2=seed(313);                        
//Stem(35,.45,.10,.25,.2,Flower3)
//#declare R1=seed(399);                         
//LeafMass(.5,.25,.2,2200,Leaf2) 

//  Flower6 grouping (Flowers6.gif)
//#declare S2=seed(186);                        
//Stem(25,.45,.3,.15,.1,Flower9)
//#declare R1=seed(2299);                         
//LeafMass(.5,.32,.15,2200,Leaf2)
                               

//object{Flower9 scale .5 rotate<0,0,0>  translate<0,0,0>}
//object{Flower1 scale .5 rotate<0,0,0> } // translate<-.07,0,0>}
//object{Flower2 scale .5 rotate<0,0,0> } //translate<-.035,0,0>}
//object{Flower3 scale .5 rotate<0,0,0> } // translate<.035,0,0>}
//object{Flower4 scale .5 rotate<0,0,0> } // translate<0,0,.05>}
//object{Flower5 scale .5 rotate<0,0,0> } // translate<-.035,0,.05>}
//object{Flower6 scale .5 rotate<0,0,0> } //translate<.035,0,.05>}
//object{Flower7 scale .5 rotate<0,0,0> } //  translate<.07,0,0>}
//object{Flower8 scale .5 rotate<0,0,0> } // translate<.07,0,.050>}

union{  
object{Leaf1 rotate<90,0,0> translate<-.05,0,-.05>}
object{Leaf2 rotate<90,0,0> translate<-.05,0,.05>}
object{Leaf3 rotate<90,0,0> translate<.05,0,.05>}
object{Leaf4 rotate<90,0,0> translate<.05,0,-.05>} 
object{Leaf5 rotate<90,0,0> translate<0,0,0>}  
texture{pigment{color Green}}
}
  
#declare Segment=cylinder{<-.025,0,0><.025,0,0> .0035 }
#declare Measure=union{
       object{Segment translate<-.025,0,0> texture{pigment{color White}}}
       object{Segment translate<-.075,0,0> texture{pigment{color Red}}}
       object{Segment translate<.025,0,0> texture{pigment{color Red}}} 
       object{Segment translate<.075,0,0> texture{pigment{color White}}}
}

//object{Measure translate<0,0,-.05>}

#declare Stem2=union{

     #declare Count=1;
     #while (Count<35)
        #declare ZR=rand(S2)*-15;
        #declare YR=rand(S2)*360;
        #declare X=rand(S2)*.045; 
        #declare X1=rand(S2)*.5-.25;
        #declare Z1=rand(S2)*.1-.05;
        #declare Y=rand(S2)*.035+.15;  // length  
        #declare F1=int(rand(S2)*8)+1;  // Which Flower?
            cylinder{<0,0,0><0,Y,0> .001
            
                     texture{pigment{color Khaki}}
                     
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0>
                     translate<X1,0,Z1> 
                  }
             object{Flower3 
               //   #switch (F1)
               //      #case (1) Flower7  #break
               //      #case (2) Flower2  #break 
               //      #case (3) Flower3  #break
               //      #case (4) Flower4  #break 
               //      #case (5) Flower5  #break
               //      #case (6) Flower6  #break 
               //      #case (7) Flower7  #break
               //      #case (8) Flower8  #break                                                                 
               //    #end  
                     translate<0,Y,0>
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0> 
                     translate<X1,0,Z1>
                    }                   
        #declare Count=Count+1;
     #end 
}  // Stem2           

#declare Stem3=union{

     #declare Count=1;
     #while (Count<15)
        #declare ZR=rand(S2)*-15;
        #declare YR=rand(S2)*360;
        #declare X=rand(S2)*.045; 
        #declare X1=rand(S2)*.25;
        #declare Z1=rand(S2)*.1-.05;
        #declare Y=rand(S2)*.025+.1;  // length  
        #declare F1=int(rand(S2)*8)+1;  // Which Flower?
            cylinder{<0,0,0><0,Y,0> .001
            
                     texture{pigment{color Khaki}}
                     
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0>
                     translate<X1,0,Z1> 
                  }
             object{Flower4 
               //   #switch (F1)
               //      #case (1) Flower7  #break
               //      #case (2) Flower2  #break 
               //      #case (3) Flower3  #break
               //      #case (4) Flower4  #break 
               //      #case (5) Flower5  #break
               //      #case (6) Flower6  #break 
               //      #case (7) Flower7  #break
               //      #case (8) Flower8  #break                                                                 
               //    #end  
                     translate<0,Y,0>
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0> 
                     translate<X1,0,Z1>
                    }                   
        #declare Count=Count+1;
     #end 
}  // Stem3

#declare Stem4=union{

     #declare Count=1;
     #while (Count<25)
        #declare ZR=rand(S2)*-15;
        #declare YR=rand(S2)*360;
        #declare X=rand(S2)*.045; 
        #declare X1=rand(S2)*-.35;
        #declare Z1=rand(S2)*.1-.05;
        #declare Y=rand(S2)*.025+.1;  // length  
        #declare F1=int(rand(S2)*8)+1;  // Which Flower?
            cylinder{<0,0,0><0,Y,0> .001
            
                     texture{pigment{color Khaki}}
                     
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0>
                     translate<X1,0,Z1> 
                  }
             object{Flower6 
               //   #switch (F1)
               //      #case (1) Flower7  #break
               //      #case (2) Flower2  #break 
               //      #case (3) Flower3  #break
               //      #case (4) Flower4  #break 
               //      #case (5) Flower5  #break
               //      #case (6) Flower6  #break 
               //      #case (7) Flower7  #break
               //      #case (8) Flower8  #break                                                                 
               //    #end  
                     translate<0,Y,0>
                     rotate<0,0,ZR>  
                     translate<X,0,0>  
                     rotate<0,YR,0> 
                     translate<X1,0,Z1>
                    }                   
        #declare Count=Count+1;
     #end 
}  // Stem4