/*
actree.inc version 1.0
Flowering Tree macro by Andrew Clinton (c) 1999-2000
*/

#debug ".actree.inc\n"

//Leaf declarations

#declare leaf2 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
			scale <0.7, 1, 1>
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "leaf2.tga"
				once
			}
		}
		finish {
			ambient 0.2
			diffuse 0.8
		}
		normal {
			bump_map {
				tga "leaf2.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*50
	translate <0, -0.4, 1>
}

//Petal texture declarations

#declare pinkpetal1 = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -0.7>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "pinkpetal1.tga"
				once
			}
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
		}
		normal {
			bump_map {
				tga "pinkpetal1.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare pinkpetal2 = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -0.7>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "pinkpetal2.tga"
				once
			}
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
		}
		normal {
			bump_map {
				tga "pinkpetal2.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare whitepetal1 = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -0.7>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "wpetal1.tga"
				once
			}
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
		}
		normal {
			bump_map {
				tga "wpetal1.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare redpetal1 = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -0.7>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "redpetal.tga"
				once
			}
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
		}
		normal {
			bump_map {
				tga "redpetal.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

//Complete flower declarations

#declare pinkflower1 = union {
	object { pinkpetal1 }
	object { pinkpetal1 rotate y*90 }
	object { pinkpetal1 rotate y*180 }
	object { pinkpetal1 rotate y*270 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.8, 0.8>
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare spinkflower1 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb<0.92,0.48,0.73> }
	finish {
		#if(rad)
		ambient 0.0
		diffuse 0.7
		#else
		ambient 0.5
		diffuse 0.5
		#end
	}
}

#declare pinkflower2 = union {
	object { pinkpetal2 }
	object { pinkpetal2 rotate y*90 }
	object { pinkpetal2 rotate y*180 }
	object { pinkpetal2 rotate y*270 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.8, 0.8>
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare spinkflower2 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb<1,0.7,0.95> }
	finish {
		#if(rad)
		ambient 0.0
		diffuse 0.7
		#else
		ambient 0.5
		diffuse 0.5
		#end
	}
}

#declare whiteflower1 = union {
	object { whitepetal1 }
	object { whitepetal1 rotate y*90 }
	object { whitepetal1 rotate y*180 }
	object { whitepetal1 rotate y*270 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.8, 0.8>
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare swhiteflower1 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb 1 }
	finish {
		#if(rad)
		ambient 0.0
		diffuse 0.7
		#else
		ambient 0.5
		diffuse 0.5
		#end
	}
}

#declare redflower1 = union {
	object { redpetal1 }
	object { redpetal1 rotate y*72 }
	object { redpetal1 rotate y*144 }
	object { redpetal1 rotate y*216 }
	object { redpetal1 rotate y*288 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.8, 0.8>
		}
		finish {
			#if(rad)
			ambient 0.0
			diffuse 0.7
			#else
			ambient 0.5
			diffuse 0.5
			#end
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.85, 0.1, 0.85>, <-0.85, -0.1, -0.85>
		}
	}
}

#declare sredflower1 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb <0.87, 0.34, 0.44> }
	finish {
		#if(rad)
		ambient 0.0
		diffuse 0.7
		#else
		ambient 0.5
		diffuse 0.5
		#end
	}
}

//macro Makeflower

#macro makeflower (transfactor)
	#if(flowertype[0])
	object {
		#switch(flowertype[0])
		#case(pink)
			#if(rand(rv[1])<0.7)
				#if(simplify)
				spinkflower1
				#else
				pinkflower1
				#end
			#else
				#if(simplify)
				spinkflower2
				#else
				pinkflower2
				#end
			#end
		#break;
		#case(white)
			#if(simplify)
			swhiteflower1
			#else
			whiteflower1
			#end
		#break;
		#case(rouge)
			#if(simplify)
			sredflower1
			#else
			redflower1
			#end
		#break;
		#end
		scale flowertype[1]
		rotate <(rand(rv[1])-0.5)*80, (rand(rv[1])-0.5)*80, (rand(rv[1])-0.5)*80>
		translate <0, transfactor, 0>
	}
	#end
#end

//macro Eztwigs

#macro eztwigs (currentlevel)
	#declare counter = 0;
	#declare howmany = rand(rv[0])*10;
	#while (counter < howmany)
	union {
		cone {
			<0, 0, 0>, branchwidth[recursionmax]/1.5,
			<0, branchlength[currentlevel]/4, 0>, branchwidth[recursionmax]/3
			#ifndef(zbuffer)
				texture { stemtexture }
			#end
		}
		makeflower(branchlength[currentlevel]/4)
		rotate x*(10+(rand(rv[0])*20))
		translate z*(branchwidth[currentlevel]/2)
		rotate y*(rand(rv[0])*360)
		translate <0, rand(rv[0])*0.75*branchlength[currentlevel], 0>
	}
	#declare counter = counter + 1;
	#end
	#if(currentlevel=recursionmax)
		makeflower(branchlength[currentlevel])
	#end
#end //End of eztwigs

//macro mkleaves

#macro mkleaves (currentlevel)
	#declare counter = 0;
	#declare howmany = rand(rv[2])*5;
	#while (counter < howmany)
	object { leaf2
		scale leaftype[0]
		rotate x*(rand(rv[2])*50)
		translate z*(branchwidth[currentlevel]/2)
		rotate y*(rand(rv[2])*360)
		translate <0, rand(rv[2])*0.75*branchlength[currentlevel], 0>
	}
	#declare counter = counter + 1;
	#end
#end //End of mkleaves

//Macro Trunk

#macro trunk (currentlevel)
blob {
	threshold 0.6
	//Create the actual trunk
	#declare counter = 0;
	#declare detail = int(branchlength[currentlevel]/(2*branchwidth[currentlevel]));
	#while (counter <= detail)
		#declare newradius = branchwidth[currentlevel]-(branchwidth[currentlevel]-branchwidth[currentlevel+1])*(counter/detail);
		sphere {
			0, newradius, 1
			scale <1, 6, 1>
			#if(!(counter=detail) | !(counter=0))
			translate <(rand(rv[0])-0.5)*newradius, (counter/detail)*branchlength[currentlevel], (rand(rv[0])-0.5)*newradius>
			#else
			translate <0, (counter/detail)*branchlength[currentlevel], 0>
			#end
		}
		#declare counter = counter + 1;
	#end
	//Spreading roots
	#declare counter = 0;
	#declare numroots = 8;
	#while (counter < numroots)
		#declare staticrand = rand(rv[0])*360;
		#declare counter2 = 0;
		#declare detail = 30;
		#while (counter2 < detail)
		sphere {
			<0, 0, branchlength[currentlevel]/4>, (branchwidth[currentlevel]/1.5)-((branchwidth[currentlevel]/1.5)-(branchwidth[currentlevel+1]/1.5))*(counter2/detail), 1
			rotate x*counter2*(80/detail)
			scale <1, 0.7, 1>
			translate <0, 0.1, -branchlength[currentlevel]/4>
			rotate y*staticrand
		}
		#declare counter2 = counter2 + 1;
		#end
	#declare counter = counter + 1;
	#end
	#ifndef(zbuffer)
		texture { trunktexture }
	#end
}
#end

//Macro Branch

#macro branch (currentlevel)
blob {
	threshold 0.6
	#declare counter = 0;
	#declare detail = int(branchlength[currentlevel]/(4*branchwidth[currentlevel]));
	#while (counter <= detail)
	#if(currentlevel = (recursionmax-1))
	#declare newradius = branchwidth[currentlevel]-((branchwidth[currentlevel]-(0.6*branchwidth[currentlevel+1]))*(counter/detail));
	sphere {
		0, newradius, 1
		scale <1, 8, 1>
		#if(!(counter=detail) | !(counter=0))
		translate <(rand(rv[0])-0.5)*newradius, (counter/detail)*branchlength[currentlevel], (rand(rv[0])-0.5)*newradius>
		#else
		translate <0, (counter/detail)*branchlength[currentlevel], 0>
		#end
	}
	#else
	#declare newradius = branchwidth[currentlevel]-((branchwidth[currentlevel]-branchwidth[currentlevel+1])*(counter/detail));
	sphere {
		0, newradius, 1
		scale <1, 8, 1>
		#if(!(counter=detail) | !(counter=0))
		translate <(rand(rv[0])-0.5)*newradius, (counter/detail)*branchlength[currentlevel], (rand(rv[0])-0.5)*newradius>
		#else
		translate <0, (counter/detail)*branchlength[currentlevel], 0>
		#end
	}
	#end
	#declare counter = counter + 1;
	#end
	clipped_by {
		plane {
			y,-newradius*3
			inverse
		}
	}
	#ifndef(zbuffer)
		texture { stemtexture }
	#end
}
#end

//Macro Twig

#macro twig (currentlevel)
cone {
	<0, 0, 0>, branchwidth[currentlevel]*0.6,
	<0, branchlength[currentlevel], 0>, branchwidth[currentlevel+1]*0.6
	#ifndef(zbuffer)
		texture { stemtexture }
	#end
}
#end

//Macro eztree

#macro eztree (currentlevel)
	
	//Make branches/trunks/twigs based on the current recursion level
	
	#switch(currentlevel)
	#case (0)
		trunk(currentlevel)
		#break;
	#range (1,recursionmax-1)
		#if(simplify)
		twig(currentlevel)
		#else
		branch(currentlevel)
		#end
		#break;
	#case (recursionmax)
		twig(currentlevel)
		#break;
	#end
	
	//Here we go...Down a recursion level...
	
	#if (currentlevel < recursionmax)
		#local i = 0;
		#while (i < divisions[currentlevel])
			#if (currentlevel = 0)
				#if (i = 0)
					#local rot = <(rand(rv[0])-0.5)*20,
				#else
					#local rot = <10+(rand(rv[0])*75),
				#end
					((i*360)/divisions[currentlevel])+(rand(rv[0])-0.5), 0>;
			#else
				#if (i = 0)
					#local rot = <(rand(rv[0])-0.5)*10,(rand(rv[0])-0.5)*10,(rand(rv[0])-0.5)*10>;
				#else
					#local rot = <(rand(rv[0])-0.5)*40,(rand(rv[0])-0.5)*40,(rand(rv[0])-0.5)*40>;
				#end
			#end
			union {
				eztree(currentlevel+1)
				eztwigs(currentlevel+1)
				#ifdef(leaftype)
				mkleaves(currentlevel+1)
				#if(currentlevel=recursionmax)
				mkflower(branchlength[currentlevel+1])
				#end
				#end
				#ifndef(branchdeviance)
				rotate rot
				#else
				rotate <(rand(rv[0])-0.5)*branchdeviance[currentlevel],(rand(rv[0])-0.5)*branchdeviance[currentlevel],(rand(rv[0])-0.5)*branchdeviance[currentlevel]>
				#end
				#if(currentlevel = 0)
					translate <0, (branchlength[currentlevel]/2)+((branchlength[currentlevel]/2)*rand(rv[0])), 0>
				#else
					translate <0, ((3*branchlength[currentlevel])/5)+((branchlength[currentlevel]/4)*rand(rv[0])), 0>
				#end
			}
			#local i = i + 1;
		#end
	#end //End #if (down a level)
#end //End of macro!

// End of file