#debug ".dirtmap.inc\n"

#declare dirttexture = texture {
	pigment {
		bozo
		scale 1.5
		pigment_map {
			[ 0
				granite
				turbulence 1
				scale 0.1
				color_map {
					[ 0 color rgb<0.13, 0.12, 0.10> ]
					[ 0.9 color rgb<0.13, 0.12, 0.10> ]
					[ 1 color rgb<0.2, 0.18, 0.15> ]
				}
			]
			[ 0.5
				granite
				turbulence 1
				scale 0.1
				color_map {
					[ 0 color rgb<0.15, 0.13, 0.12> ]
					[ 0.9 color rgb<0.15, 0.13, 0.12> ]
					[ 1 color rgb<0.2, 0.18, 0.15> ]
				}
			]
			[ 1
				granite
				turbulence 1
				scale 0.1
				color_map {
					[ 0 color rgb<0.18, 0.17, 0.15> ]
					[ 0.9 color rgb<0.18, 0.17, 0.15> ]
					[ 1 color rgb<0.22, 0.2, 0.17> ]
				}
			]
		}
	}
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.8
		specular 0.1
		roughness 0.1
	}
	#else
	finish {
		ambient 0.1
		diffuse 1.2
		specular 0.1
		roughness 0.1
	}
	#end
	normal {
		bozo
		scale 2
		normal_map {
			[ 0 crackle -4 scale 0.005 ]
			[ 0.5 crackle -3 scale 0.01 ]
			[ 1 crackle -5 scale 0.02 ]
		}
	}
}

#declare dirtoverlay = texture {
	pigment {
		bozo
		scale 2
		pigment_map {
			[ 0 color rgbt 1 ]
			[ 0.2 color rgbt <0.7, 0.7, 0.7, 1> ]
			[ 0.7 bozo
				scale 0.012
				pigment_map {
					[ 0 color rgbt 1 ]        
					[ 0.6 color rgbt <0.5, 0.5, 0.5, 1> ]
					[ 0.75 bozo
						scale 0.5
						color_map {
							[ 0 rgbt<0.5, 0.5, 0.5, 0.9> ]
							[ 1 rgbt<0.7, 0.7, 0.7, 0.9> ]
						} ]
					[ 0.9 bozo
						scale 0.5
						color_map {
							[ 0 rgbt<0.5, 0.5, 0.5, 0.8> ]
							[ 1 rgbt<0.7, 0.7, 0.7, 0.8> ]
						} ]
				}
			]
			[ 1 bozo
				scale 0.01
				pigment_map {
					[ 0 color rgbt 1 ]
					[ 0.65 color rgbt <0.5, 0.5, 0.5, 1> ]
					[ 0.75 bozo
						scale 0.5
						color_map {
							[ 0 rgbt<0.6, 0.6, 0.6, 0.4> ]
							[ 1 rgbt<0.7, 0.7, 0.7, 0.4> ]
						} ]
					[ 0.85 bozo
						scale 0.5
						color_map {
							[ 0 rgbt<0.6, 0.6, 0.6, 0.3> ]
							[ 1 rgbt<0.7, 0.7, 0.7, 0.3> ]
						} ]
				}
			]
		}
	}
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.8
		specular 0.1
		roughness 0.1
	}
	#else
	finish {
		ambient 0.2
		diffuse 0.8
		specular 0.1
		roughness 0.1
	}
	#end
	normal {
		bozo
		scale 2
		normal_map {
			[ 0 bozo 1
				scale 0.005 ]
			[ 0.5 bozo 2
				scale 0.005 ]
			[ 0.75 bozo 4
				scale 0.005 ]
		}
	}
}

#declare dirterosion = texture {
	pigment {
		image_map {
			tga "dirterosion.tga"
		}
		rotate x*90
		scale <36, 1, 18>
		translate <-18, 0, -18>
	}
	finish {
		ambient 0.0
		diffuse 0.7
	}
}

#declare backerosion = texture {
	pigment {
		image_map {
			tga "backerosion.tga"
		}
		rotate x*90
		scale <72, 1, 36>
		translate <-36, 0, 0>
	}
	finish {
		ambient 0.0
		diffuse 0.7
	}
}

#declare pathmap = texture {
	pigment {
		image_map {
			tga "pathmap.tga"
		}
		rotate x*90
		scale <72, 1, 36>
		translate <-36, 0, 0>
	}
	finish {
		ambient 0.0
		diffuse 0.7
	}
}

union {
height_field {
	tga "dirtmapl.tga"
	scale <18, 1, 18>
	translate <-18, -0.25, -18>
}

height_field {
	tga "dirtmapr.tga"
	scale <18, 1, 18>
	translate <0, -0.25, -18>
}
texture {
	dirttexture
}
texture {
	dirtoverlay
}
texture {
	dirterosion
}
}

height_field {
	tga "backdirt.tga"
	translate <-0.5, -0.502, -0.5>
	scale <72, 10, 36>
	translate <0, 0, 18>
	texture {
		dirttexture
	}
	texture {
		dirtoverlay
	}
	texture {
		backerosion
	}
	texture {
		pathmap
	}
}
