//Temp Test Environment for Effect

#debug ".environment.inc\n"

//Sea and fog to smooth the horizon

#declare seatexture = texture {
	pigment {
		color rgb<0.2, 0.25, 0.4>
	}
	finish {
		ambient 0.8
		diffuse 0.1
		specular 5
		roughness 0.01
		reflection 0.2
	}
	normal {
		wrinkles -3
		scale 50
		turbulence 1
	}
}

plane {
	y, -50
	texture { seatexture }
}

fog
{
	fog_type   2
	distance   2000
	color      rgb <0.95, 0.95, 0.98>
	fog_offset -51
	fog_alt    30
}

//3 calls to a (modified) version of
//Jaime Vives Piqueres' Cloud Generator

//#1: Make fluffy clouds in the foreground

#include "i_stsky.inc"
#declare dark_color=rgb <0.75, 0.75, 0.75>;
#declare light_color=rgb <1.05, 1.05, 1.05>;
#declare height=8000;
#declare cloud_level=.9;
#declare planes=20;
#declare pdist=80;
#declare ppatt=pigment{wrinkles}
#declare pturb=<.4, .4, .4>;
#declare pocta=9;
#declare plamb=3;
#declare pomeg=.5;
#declare tdist=80;
#declare sfactor=<6000, 6000, 6000>;
#declare dfactor=1.1;
#declare border=1;
#declare fstart=.3;
#declare fend=.5;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 5*y
}

//#2: Create high-altitute cirrus clouds at 45 degrees

#include "i_stsky2.inc"
#declare dark_color=rgb <0.99, 0.98, 0.95>;
#declare light_color=rgb <1.05, 1.05, 1.05>;
#declare height=16000;
#declare cloud_level=.7;
#declare planes=5;
#declare pdist=100;
#declare ppatt=pigment{marble}
#declare pturb=<0.8, 0.8, 0.8>;
#declare pocta=8;
#declare plamb=3;
#declare pomeg=.5;
#declare tdist=100;
#declare sfactor=<8000, 8000, 8000>;
#declare dfactor=1.1;
#declare border=1.2;
#declare fstart=.98;
#declare fend=1;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 45*y
}

//#3: Same as above but rotated 30 degrees

#include "i_stsky2.inc"
#declare dark_color=rgb <0.99, 0.98, 0.95>;
#declare light_color=rgb <1.05, 1.05, 1.05>;
#declare height=17000;
#declare cloud_level=.7;
#declare planes=5;
#declare pdist=100;
#declare ppatt=pigment{marble}
#declare pturb=<0.8, 0.8, 0.8>;
#declare pocta=8;
#declare plamb=3;
#declare pomeg=.5;
#declare tdist=100;
#declare sfactor=<8000, 8000, 8000>;
#declare dfactor=1.1;
#declare border=1.2;
#declare fstart=.98;
#declare fend=1;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 30*y
}

//End of File