//Fence Vine Include File

#debug ".fencevines.inc\n"

#declare silvermaple = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "silvermaple.tga"
				once
			}
		}
		finish {
			ambient 0.4
			diffuse 0.6
		}
		normal {
			bump_map {
				tga "silvermaple.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*50
	translate <0, -0.4, 1>
}

#declare blueflower = disc {
	0, z, 1
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "blueflower.tga"
				once
			}
		}
		finish {
			ambient 0.4
			diffuse 0.6
		}
		normal {
			bump_map {
				tga "blueflower.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, 0>
		scale 2
	}
	#end
}

//Macro Vine

#macro vine (vineheight, randomness, startrad)

#local points = int(vineheight*1.5);
#local stemspline = spline {
	cubic_spline
	0, <0, 0, 0>
	#local counter = 1;
	#while (counter <= points)
	counter/points, <0,(vineheight*(counter/points)),0>+<rand(r1)*randomness, rand(r1)*randomness, rand(r1)*randomness>
	#local counter = counter + 1;
	#end
}

blob {
threshold 0.6
#local counter = 0;
#while (counter <= 1)
sphere {
	0, (1.5-counter)*startrad, 1
	scale <1, 5, 1>
	translate stemspline(counter)
}
#local counter = counter + (0.1/points);
#end
#ifndef(zbuffer)
texture { silverstem }
#end
}

#local counter = 0;
#while(counter <= 1)
#if (rand(r1)<0.8)
object {
	silvermaple
	scale 0.4-(counter*0.15)
	rotate x*(rand(r1)-0.5)*40
	rotate y*rand(r1)*360
	translate stemspline(counter)
}
#else
object {
	blueflower
	scale 0.15
	rotate <(rand(r1)-0.5)*60, (rand(r1)-0.5)*60, (rand(r1)-0.5)*60>
	translate stemspline(counter)+<0, 0, -0.05>
}
#end
#local counter = counter + (1/(vineheight*5));
#end

#end

//Create the vines

#declare counter = 5.5;
#while (counter <= 15)
union {
vine(1.5+(rand(r1)*2.5), 0.2+(rand(r1)*0.2), 0.03)
translate <counter+((rand(r1)-0.5)*0.4), -0.05, 2.3>
}
union {
vine(1.5+(rand(r1)*2.5), 0.2+(rand(r1)*0.2), 0.03)
translate <-counter+((rand(r1)-0.5)*0.4), -0.05, 2.3>
}
union {
vine(2+(rand(r1)*2.5), 0.2+(rand(r1)*0.2), 0.03)
translate <counter+((rand(r1)-0.5)*0.4), -0.05, 2.7>
}
union {
vine(2+(rand(r1)*2.5), 0.2+(rand(r1)*0.2), 0.03)
translate <-counter+((rand(r1)-0.5)*0.4), -0.05, 2.7>
}
union {
vine(2+(rand(r1)*2.5), 0.2+(rand(r1)*0.2), 0.03)
translate <counter+((rand(r1)-0.5)*0.4), -0.05, 3.1>
}
union {
vine(2+(rand(r1)*2.5), 0.2+(rand(r1)*0.2), 0.03)
translate <-counter+((rand(r1)-0.5)*0.4), -0.05, 3.1>
}
#declare counter = counter + 0.5;
#end

#declare rot = 30;
#while (rot < 65)
union {
vine(((rot-20)/20)+(rand(r1)*((rot-20)/17)), 0.2+(rand(r1)*0.2), 0.03)
translate z*5.3
rotate y*(rot+(rand(r1)-0.5))
}
union {
vine(((rot-20)/20)+(rand(r1)*((rot-20)/17)), 0.2+(rand(r1)*0.2), 0.03)
translate z*5.3
rotate y*(-rot+(rand(r1)-0.5))
}
union {
vine(((rot-20)/20)+(rand(r1)*((rot-20)/17)), 0.2+(rand(r1)*0.2), 0.03)
translate z*5.7
rotate y*(rot+(rand(r1)-0.5))
}
union {
vine(((rot-20)/20)+(rand(r1)*((rot-20)/17)), 0.2+(rand(r1)*0.2), 0.03)
translate z*5.7
rotate y*(-rot+(rand(r1)-0.5))
}
union {
vine(((rot-20)/20)+(rand(r1)*((rot-20)/17)), 0.2+(rand(r1)*0.2), 0.03)
translate z*6.1
rotate y*(rot+(rand(r1)-0.5))
}
union {
vine(((rot-20)/20)+(rand(r1)*((rot-20)/17)), 0.2+(rand(r1)*0.2), 0.03)
translate z*6.1
rotate y*(-rot+(rand(r1)-0.5))
}
#declare rot = rot + 7;
#end

//EOF