/*
Flower placement file.
Uses the macros defined in makeplant.inc to create an assortment of plants.
*/

#debug ".flowers.inc\n"

//Purple and Yellow beside the main path

#debug "..mainpath\n"

#declare recursionmax = 2;
#declare rv = array[3] {seed(547),seed(2398),seed(8475)}
#declare divisions = array[2] {7,7}
#declare branchdeviance = array[2] {60,40}
#declare branchlength = array[3] {0.2,0.6,0.4}
#declare branchwidth = array[4] {0.015,0.01,0.007,0.003}
#declare leaftype = array[2] {2,0.14}
#declare simplify = false;

#declare number = 0;
#while (number < 4)
union {
#declare flowertype = array[2] {purple,0.06}
makeplant(0)
translate <-2.2+((rand(r1)-0.5)*0.3), -0.2, -12+(2*number)>
}
union {
#declare flowertype = array[2] {purple,0.06}
makeplant(0)
translate <2.2+((rand(r1)-0.5)*0.3), -0.2, -12+(2*number)>
}
union {
#declare flowertype = array[2] {yellow,0.06}
makeplant(0)
translate <-2.2+((rand(r1)-0.5)*0.3), -0.2, -13+(2*number)>
}
union {
#declare flowertype = array[2] {yellow,0.06}
makeplant(0)
translate <2.2+((rand(r1)-0.5)*0.3), -0.2, -13+(2*number)>
}
#declare number = number + 1;
#end

//Purple and white beside secondary paths

#debug "..secondary\n"

#declare simplify = true;

#declare number = 0;
#while (number < 4)
union {
#declare flowertype = array[2] {purple,0.06}
makeplant(0)
translate <-6-(2*number), -0.2, -2.3+((rand(r1)-0.5)*0.3)>
}
union {
#declare flowertype = array[2] {purple,0.06}
makeplant(0)
translate <6+(2*number), -0.2, -2.3+((rand(r1)-0.5)*0.3)>
}
union {
#declare flowertype = array[2] {yellow,0.06}
makeplant(0)
translate <-7-(2*number), -0.2, -2.3+((rand(r1)-0.5)*0.3)>
}
union {
#declare flowertype = array[2] {yellow,0.06}
makeplant(0)
translate <7+(2*number), -0.2, -2.3+((rand(r1)-0.5)*0.3)>
}
#declare number = number + 1;
#end

#undef leaftype
#undef branchdeviance

//End of file