//Flowers 2 - defines the daisy-like blossoms near the fountain

#debug ".flowers2.inc\n"

#declare daisypetal = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.7>, <0, 0, -1.1>, 0.5
			scale <0.25, 1, 1>
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "sunflwrpetal.tga"
				once
			}
		}
		finish {
			ambient 0.5
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "sunflwrpetal.tga"
				once
				bump_size -15
			}
		}
		translate <-0.5, -0.5, -0.5>
		scale <0.25, 1, 1>
	}
	#end
	hollow
	rotate x*30
	translate z*1
	rotate x*60
}

#declare daisyblossom = union {
blob {
	threshold 0.6
	sphere { 0, 0.5, 1
		scale <1, 0.3, 1>
	}
	sphere { 0, 0.2, -2
		scale <1, 0.6, 1>
		translate <0, 0.15, 0>
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			spherical
			color_map {
				[ 0.4  rgb <0.45, 0.35, 0.30>*0.8 ]
				[ 0.7  rgb <0.45, 0.35, 0.30>*0.6 ]
				[ 1  rgb <0.4, 0.37, 0.35>*0.8 ]
			}
		}
		finish {
			ambient 0.2
			diffuse 0.8
			specular 0.3
			roughness 0.1
			metallic
		}
		normal {
			bumps 0.5
			scale 0.05
		}
	}
	#end
}
#declare counter = 0;
#while (counter < 360)
object { daisypetal
	rotate y*(counter+(rand(r1)*15))
}
#declare counter = counter + 30;
#end
bounded_by {
	box {
		<1.2, 0.3, 1.2>, <-1.2, -0.3, -1.2>
	}
}
scale 0.25
}

#declare flowerlevels = 0;
#while (flowerlevels < 15)
#declare rot = 30;
#while (rot < 65)
object { daisyblossom
	rotate <(rand(r1)-0.7)*40, (rand(r1)-0.5)*40, (rand(r1)-0.7)*40>
	translate <5.5+(flowerlevels/4)+((rand(r1)-0.5)*0.4), 0.1+(rand(r1)*0.3), 0>
	rotate y*(rot+((rand(r1)-0.5)*4))
}
object { daisyblossom
	rotate <(rand(r1)-0.7)*40, (rand(r1)-0.5)*40, (rand(r1)-0.7)*40>
	translate <-5.5-(flowerlevels/4)+((rand(r1)-0.5)*0.4), 0.1+(rand(r1)*0.3), 0>
	rotate y*(-rot+((rand(r1)-0.5)*4))
}
#declare rot = rot + 3;
#end
#declare flowerlevels = flowerlevels + 1;
#end

//EOF