//Rocky Texture for Walkway Stones

#debug ".gardenwalkway.inc\n"

#declare rock1texture = texture {
	pigment {
		image_map {
			tga "rock1.tga"
			map_type 0
		}
		scale 3
		rotate x*90
	}
	#if(rad)
	finish {
		diffuse 0.8
		ambient 0.0
		specular 5
		roughness 0.02
	}
	#else
	finish {
		diffuse 0.9
		ambient 0.3
		specular 2.5
		roughness 0.01
	}
	#end
	normal {
		average
		normal_map {
			/*
			[ 1 granite 0.7 scale 0.05 ]
			[ 1 bozo 1 scale 0.15 ]
			*/
			#declare counter = 1;
			#while (counter <= 10)
			[ 1 bozo 5 scale 0.1/counter ]
			#declare counter = counter + 1;
			#end
		}
	}
}

//Define the Bricks

#declare smallbrick = union {
	box {
		<0.1, 0.0125, 0.1>, <-0.1, -0.0125, -0.1>
	}
	cylinder {
		<0.1, 0, 0.1>, <-0.1, 0, 0.1>, 0.0125
	}
	cylinder {
		<0.1, 0, -0.1>, <-0.1, 0, -0.1>, 0.0125
	}
	cylinder {
		<0.1, 0, 0.1>, <0.1, 0, -0.1>, 0.0125
	}
	cylinder {
		<-0.1, 0, 0.1>, <-0.1, 0, -0.1>, 0.0125
	}
	sphere {
		<0.1, 0, 0.1>, 0.0125
	}
	sphere {
		<-0.1, 0, 0.1>, 0.0125
	}
	sphere {
		<0.1, 0, -0.1>, 0.0125
	}
	sphere {
		<-0.1, 0, -0.1>, 0.0125
	}
}

/*
#declare smallbrick = isosurface { 
	function { "rounded_box", <0.0125> }
	all_intersections
	sign 1
	bounded_by {
		box {
			<-0.1125, -0.0125, -0.1125>, <0.1125, 0.0125, 0.1125>
		}
	}
}
*/

//Define a Straight Stretch of Walkway

#declare straightstretch = union {
#declare rows = 0;
#while (rows < 16)
#declare staticrand = rand(r1);
#declare number = 0;
#while (number <= 10)
difference {
object {
	smallbrick
	scale <1.00+(rand(r1)*0.05), 0.8+(rand(r1)*0.3), 1.00+(rand(r1)*0.05)>
	rotate y*((rand(r1)*6)-3)
	rotate x*((rand(r1)*6)-3)
	rotate z*((rand(r1)*6)-3)
}
cylinder {
	<0, 0.02, 0>, <0, -0.02, 0>, 5.05
	translate <1.875-(rows/4), 0, (4+number-(staticrand/2))>
}
texture { rock1texture translate <0.25+(rand(r1)*2.25), 0, 0.25+(rand(r1)*2.25)> }
#if ((rows < 4) | (rows > 11))
texture {
	pigment {
		#if (((rows = 0) | (rows = 15)) | (((rows = 1) | (rows = 14)) & (mod(number, 0.5) = 0)))
		color rgbt <0.4, 0.3, 0.3, 0.4>
		#end
		#if (((rows = 1) | (rows = 2) | (rows = 13) | (rows = 14)) & (mod(number, 0.5) = 0.25))
		color rgbt <0.4, 0.4, 0.3, 0.4>
		#end
		#if (((rows = 3) | (rows = 12)) | (((rows = 2) | (rows = 13)) & (mod(number, 0.5) = 0)))
		color rgbt <0.4, 0.3, 0.3, 0.7>
		#end
    }
	finish {
		diffuse 0.8
		#if(rad)
		ambient 0.0
		#else
		ambient 0.3
		#end
		specular 1.5
		roughness 0.01
	}
}
#end
translate <-1.875+(rows/4), rand(r1)*0.03, (-4-number+(staticrand/2))>
}
#declare number = number + 0.25;
#end
#declare rows = rows + 1;
#end
}

//3 Straight Stretches at 90 degrees

object { straightstretch }

object { straightstretch rotate y*90 }

object { straightstretch rotate y*-90 }

//A Circular Center Flagstone Area

#declare radiusdist = 5;
#while (radiusdist > 2)
union {
#declare intcount = 0;
#declare number = 0;
#while (number < 360)
object {
	smallbrick
	scale <1.00+(rand(r1)*0.05), 0.8+(rand(r1)*0.3), 1.00+(rand(r1)*0.05)>
	rotate y*((rand(r1)*6)-3)
	rotate x*((rand(r1)*6)-3)
	rotate z*((rand(r1)*6)-3)
	texture { rock1texture translate <0.25+(rand(r1)*2.25), 0, 0.75+(rand(r1)*0.75)> }
	#if (radiusdist > 4)
	texture {
		pigment {
			#if ((radiusdist = 5) | ((radiusdist = 4.75) & (mod(intcount, 2) = 0)))
			color rgbt <0.4, 0.3, 0.3, 0.4>
			#end
			#if (((radiusdist = 4.75) | (radiusdist = 4.5)) & (mod(intcount, 2) = 1))
			color rgbt <0.4, 0.4, 0.3, 0.4>
			#end
			#if ((radiusdist = 4.25) | ((radiusdist = 4.5) & (mod(intcount, 2) = 0)))
			color rgbt <0.4, 0.3, 0.3, 0.7>
			#end
		}
		finish {
			diffuse 0.8
			#if(rad)
			ambient 0.0
			#else
			ambient 0.3
			#end
			specular 1.5
			roughness 0.01
		}
	}
	#end
	#if ((number<20) | (number>340) | ((number<110) & (number>70)) | ((number<200) & (number>160)) | ((number<290) & (number>250)))
	texture {
		pigment {
			color rgbt <0.5, 0.5, 0.3, 0.5>
		}
		finish {
			diffuse 0.8
			#if(rad)
			ambient 0.0
			#else
			ambient 0.3
			#end
			specular 1.5
			roughness 0.01
		}
	}
	#end
	rotate y*90
	translate <0, rand(r1)*0.03, (radiusdist-0.125)>
	rotate y*number
}
#declare number = number + 50/((radiusdist-0.25)*pi);
#declare intcount = intcount + 1;
#end
rotate y*(rand(r1)-0.5)*3
}
#declare radiusdist = radiusdist - 0.25;
#end


#declare radiusdist = 1.875;
#while (radiusdist > 1.125)
union {
#declare number = 0;
#while (number < 360)
object {
	smallbrick
	scale <1.00+(rand(r1)*0.05), 0.8+(rand(r1)*0.3), 1.00+(rand(r1)*0.05)>
	rotate y*((rand(r1)*6)-3)
	rotate x*((rand(r1)*6)-3)
	rotate z*((rand(r1)*6)-3)
	texture { rock1texture translate <0.25+(rand(r1)*2.25), 0, 0.75+(rand(r1)*0.75)> }
	texture {
		pigment {
			color rgbt <0.5, 0.4, 0.2, 0.2>
		}
		finish {
			diffuse 0.8
			#if(rad)
			ambient 0.0
			#else
			ambient 0.3
			#end
			specular 1.5
			roughness 0.01
		}
	}
	rotate y*90
	translate <0, rand(r1)*0.03, (radiusdist-0.0125)>
	rotate y*number
}
#declare number = number + 50/((radiusdist-0.0125)*pi);
#end
rotate y*(-(radiusdist-2))*10
}
#declare radiusdist = radiusdist - 0.25;
#end

//Edging

#declare edgeobject = superellipsoid {
	<0.3, 0.3>
	scale <0.07, 0.04, 0.95>
	translate z*1
	texture {
		pigment {
			bozo
			color_map {
				[ 0 rgb 0.62 ]
				[ 1 rgb 0.55 ]
			}
			scale 0.5
		}
		#if(rad)
		finish {
			diffuse 0.8
			ambient 0.0
			specular 2.5
			roughness 0.01
		}
		#else
		finish {
			diffuse 0.85
			ambient 0.3
			specular 2.5
			roughness 0.01
		}
		#end
		normal {
			average
			normal_map {
				[ 1 granite 1.2 scale 0.1 ]
				[ 1 bozo 1.2 scale 0.2 ]
			}
		}
	}
}

#declare counter = -14.8;
#while (counter <= -6.8)
object {
	edgeobject
	translate <-2.1, 0, counter>
}
object {
	edgeobject
	translate <2.1, 0, counter>
}
#declare counter = counter + 2;
#end

//End of file