/*
Makeplant.inc version 1.2
This file defines the macros that are used to create the flowered plants in the scene.

Version History:
1.2 - Begin using clipped_by to speed up rendering of leaves and petals
1.1 - Rearanged code, allowed for bounding (which more than doubles speed!)
1.0 - Original Version
*/

#debug ".mkplant.inc\n"

//Leaf declarations

#declare leaf = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.8>, <0, 0, -1.01>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "leaf1.tga"
				once
			}
		}
		#if(rad)
		finish {
			ambient 0.0
			diffuse 0.7
		}
		#else
		finish {
			ambient 0.2
			diffuse 0.8
		}
		#end
		normal {
			bump_map {
				tga "leaf1.tga"
				once
				bump_size -15
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	#end
	hollow
	rotate x*50
	translate <-0.03, -0.35, 0.90>
}

//Petal texture declarations

#declare purplepetal1 = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.5>, <0, 0, -0.71>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "ppetal1.tga"
				once
			}
			translate <-0.5, -0.5, -0.5>
		}
		#if(rad)
		finish {
			ambient 0.0
			diffuse 0.7
		}
		#else
		finish {
			ambient 0.5
			diffuse 0.5
		}
		#end
		normal {
			bump_map {
				tga "ppetal1.tga"
				once
				bump_size -10
			}
			translate <-0.5, -0.5, -0.5>
		}
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare purplepetal2 = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.5>, <0, 0, -0.71>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "ppetal2.tga"
				once
			}
			translate <-0.5, -0.5, -0.5>
		}
		#if(rad)
		finish {
			ambient 0.0
			diffuse 0.7
		}
		#else
		finish {
			ambient 0.5
			diffuse 0.5
		}
		#end
		normal {
			bump_map {
				tga "ppetal2.tga"
				once
				bump_size -10
			}
			translate <-0.5, -0.5, -0.5>
		}
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare yellowpetal1 = sphere {
	0, 0.65
	scale <1.5, 1, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.4>, <0, 0, -0.66>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "ypetal1.tga"
				once
			}
			translate <-0.5, -0.5, -0.5>
		}
		#if(rad)
		finish {
			ambient 0.0
			diffuse 0.7
		}
		#else
		finish {
			ambient 0.3
			diffuse 0.5
		}
		#end
		normal {
			bump_map {
				tga "ypetal1.tga"
				once
				bump_size -15
			}
			translate <-0.5, -0.5, -0.5>
		}
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare yellowpetal2 = sphere {
	0, 0.65
	scale <1.5, 1, 1>
	clipped_by {
		cylinder {
			<0, 0, -0.4>, <0, 0, -0.66>, 0.5
		}
	}
	#ifndef(zbuffer)
	texture {
		pigment {
			image_map {
				tga "ypetal2.tga"
				once
			}
			translate <-0.5, -0.5, -0.5>
		}
		#if(rad)
		finish {
			ambient 0.0
			diffuse 0.7
		}
		#else
		finish {
			ambient 0.3
			diffuse 0.5
		}
		#end
		normal {
			bump_map {
				tga "ypetal2.tga"
				once
				bump_size -15
			}
			translate <-0.5, -0.5, -0.5>
		}
	}
	#end
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

//Flower declarations


#declare purpleflower1 = union {
	object { purplepetal1 }
	object { purplepetal1 rotate y*90 }
	object { purplepetal1 rotate y*180 }
	object { purplepetal1 rotate y*270 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.8, 0.6>
		}
		finish {
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare spurpleflower1 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb<0.7,0.36,0.9> }
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.7
	}
	#else
	finish {
		ambient 0.5
		diffuse 0.5
	}
	#end
}


#declare purpleflower2 = union {
	object { purplepetal2 }
	object { purplepetal2 rotate y*90 }
	object { purplepetal2 rotate y*180 }
	object { purplepetal2 rotate y*270 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.8, 0.6>
		}
		finish {
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare spurpleflower2 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb<0.83,0.59,0.93> }
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.7
	}
	#else
	finish {
		ambient 0.5
		diffuse 0.5
	}
	#end
}

#declare yellowflower1 = union {
	object { yellowpetal1 }
	object { yellowpetal1 rotate y*72 }
	object { yellowpetal1 rotate y*144 }
	object { yellowpetal1 rotate y*216 }
	object { yellowpetal1 rotate y*288 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.6, 0.4>
		}
		finish {
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare syellowflower1 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb<0.98,0.99,0.62> }
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.7
	}
	#else
	finish {
		ambient 0.5
		diffuse 0.5
	}
	#end
}

#declare yellowflower2 = union {
	object { yellowpetal2 }
	object { yellowpetal2 rotate y*72 }
	object { yellowpetal2 rotate y*144 }
	object { yellowpetal2 rotate y*216 }
	object { yellowpetal2 rotate y*288 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		#ifndef(zbuffer)
		pigment {
			color rgb <0.8, 0.6, 0.4>
		}
		finish {
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
		#end
	}
	bounded_by {
		box {
			<0.9, 0.1, 0.9>, <-0.9, -0.15, -0.9>
		}
	}
}

#declare syellowflower2 = sphere {
	0,0.8
	scale <1, 0.2, 1>
	pigment { color rgb<0.97,0.99,0.7> }
	#if(rad)
	finish {
		ambient 0.0
		diffuse 0.7
	}
	#else
	finish {
		ambient 0.5
		diffuse 0.5
	}
	#end
}

//Macro makeflower

#macro makeflower (transfactor)
	#if(flowertype[0])
	object {
		#switch(flowertype[0])
		#case(yellow)
			#if(rand(rv[1])<0.7)
				#if(simplify)
				syellowflower1
				#else
				yellowflower1
				#end
			#else
				#if(simplify)
				syellowflower2
				#else
				yellowflower2
				#end
			#end
		#break;
		#case(purple)
			#if(rand(rv[1])<0.7)
				#if(simplify)
				spurpleflower1
				#else
				purpleflower1
				#end
			#else
				#if(simplify)
				spurpleflower2
				#else
				purpleflower2
				#end
			#end
		#break;
		#end
		scale flowertype[1]
		rotate <(rand(rv[1])-0.5)*60, (rand(rv[1])-0.5)*60, (rand(rv[1])-0.5)*60>
		translate <0, transfactor, 0>
	}
	#end
#end


//macro Leaves

#macro leaves (currentlevel)
#declare counter = 0;
#while (counter < (rand(rv[2])*leaftype[0]))
object {
	leaf
	scale leaftype[1]
	rotate y*rand(rv[2])*360
	translate <0, ((rand(rv[2])/1.3)*branchlength[currentlevel]), 0>
}
#declare counter = counter + 1;
#end
#end

//Macro Makeplant

#macro makeplant (currentlevel)

	//Make a plant stem
	
	cone {
		<0, 0, 0>, branchwidth[currentlevel],
		<0, branchlength[currentlevel], 0>, branchwidth[currentlevel+1]
		#ifndef(zbuffer)
			texture { stemtexture }
		#end
	}
		
	//Here we go...Down a recursion level...
	
	#if (currentlevel < recursionmax)
		#local i = 0;
		#while (i < divisions[currentlevel])
			#if (i = 0)
				#local rot = <(rand(rv[0])-0.5)*10,(rand(rv[0])-0.5)*10,
				(rand(rv[0])-0.5)*10>;
			#else
				#local rot = <(rand(rv[0])-0.5)*branchdeviance[currentlevel],
				(rand(rv[0])-0.5)*branchdeviance[currentlevel],
				(rand(rv[0])-0.5)*branchdeviance[currentlevel]>;
			#end
			union {
				makeplant(currentlevel+1)
				leaves(currentlevel+1)
				#if (currentlevel = (recursionmax-1))
					makeflower(branchlength[currentlevel+1])
				#end
				rotate rot
				translate <0, ((4*branchlength[currentlevel])/5)+((branchlength[currentlevel]/5)*rand(rv[0])), 0>
			}
			#local i = i + 1;
		#end
	#end //End #if (down a level)
#end //End of macro!


/* End of file */