//these declarations are only the bodies of the leaves below
#declare BODY=
height_field
{
	tga "LEAF.tga"
	water_level .05
	smooth
	scale <1,.5,1>
	translate <0,0,-0.5>
}
#declare BLOS_BODY=
height_field
{
	tga "BLOS.tga"
	water_level .05
	smooth
	translate <-.5,0,-0.5>
}
#declare CUT1=
union
{
	#declare A=0;
	#while (A<201)
		intersection
		{
			cylinder
			{
				<0,-1,0>,<0,2,0>,.6
				translate <0.5,0,.35>
			} 
			cylinder
			{
				<0,-1,0>,<0,2,0>,.6
				translate <0.5,0,-.35>
			}
			scale <.8*sin(pi/6+(pi*A/300)),1,.8*sin(pi/6+(pi*A/300))>
			rotate <0,-100+A,0>
		}               
	#declare A=A+50;
	#end
	translate <.2,0,0>
}
#declare CUT2=
union
{ 
	#declare A=0;
	#while (A<201)
	intersection
	{
		cylinder
		{
			<0,-1,0>,<0,5,0>,.6
			translate <0.,0,.25>
			scale <1,1,1>
		} 
		cylinder
		{
			<0,-1,0>,<0,5,0>,.6
			translate <0.,0,-.25>
			scale <1,1,1>
		}
		translate <0,0,0.>
		scale <.675,1,1.35>
		translate <0.375,0,0.>
		
		scale <.5/(sin(pi/3+pi*A/600)*sin(pi/3+pi*A/600)),.5*.5/(sin(pi/4+pi*A/400)*sin(pi/4+pi*A/400)),.25*.5/(sin(pi/4+pi*A/400)*sin(pi/4+pi*A/400))>
		rotate <0,-110+A*1.1,0>
		#if (A<100)
		translate <A/144.15,0,0>
		#else
		translate <1.39-A/144.15,0,0>
		#end
	}
	#declare A=A+20;
	#end
	scale <3/4,1,1>
	translate <.19,0,0>
}

//XXXXXXXXXXXXX L E A V E S XXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//Simple leaves
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//TESTLEAF - leaf for a good and faster preview and for small simple leaf-shapes 
#declare TESTLEAF=
sphere
{ 
	<.5,0,0>,.5
}
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//LEAF - for small simple leaf-shapes; with concave underside; needs more memory than TESTLEAF
#declare LEAF=
sphere
{ 
	<.5,0,0>,.5
	clipped_by
	{
		cylinder
		{
			<.5,0,0>,<.5,1.1,0>,.5
			scale <1,1,2/3>
		}
	}
	scale <1,1,3/2>
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//Better height-field-leaves
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_LEAF1 - with natural outline; good for many leaf-types
#declare HF_LEAF1=
object
{
	BODY
	clipped_by
	{ 
		sphere
		{
			<0,0,0>,.5
			scale <.995,.85,1.225>
			translate <.5,0,0>
			inverse
		}
	} 	
	scale <1,2,1>
	translate <0,-.05,0>
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_LEAF2 - with torn outline; for longish leaves
#declare HF_LEAF2=
object
{
	BODY
	clipped_by
	{ 
		sphere
		{
			<0,0,0>,.5
			scale <.995,.85,4>
			translate <.5,0,0>
			inverse
		}
	} 	
	scale <1,2,1.8>
	translate <0,-.05,0>
}  

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_PALMLEAF - with even outline; for very longish leaves
#declare HF_PALMLEAF=
object
{
	HF_LEAF1	
	clipped_by
	{
		cylinder
		{
			<0.5,-1,0>,<0.5,2,0>,.5
			scale <1,1,.2>
		}
	}
	scale <1,1,5>
}      

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_LEAF3 - like ivy-leaf; needs more memory because of clipped_by five shapes
#declare HF_LEAF3= 
object{HF_LEAF1 clipped_by{CUT1}}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_LEAF4 - is made of 10 small leaves; needs more memory because of clipped_by ten shapes
#declare HF_LEAF4= 
object{HF_LEAF1 clipped_by{CUT2}} 


//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//Some blossoms
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_BLOS1 - with six round small leaves 
#declare HF_BLOS1=
object
{
	BLOS_BODY
	scale <1,.5,1>
	clipped_by
	{ 
		torus
		{
			.27,.24
			scale <1,1.55,1>
			inverse
		} 
	}
	scale <1,2,1>
	translate <0,-.05,0>
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_BLOS2 - with six slim small leaves 
#declare HF_BLOS2=
object
{
	BLOS_BODY
	scale <1,.5,1>
	clipped_by
	{ 
		torus
		{
			.27,.24
			scale <1,1.7,1>
			inverse
		} 
	}
	scale <1,2,1>
	translate <0,-.05,0>
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//HF_BLOS1 - with six very slim small leaves 
#declare HF_BLOS3=
object
{
	BLOS_BODY
	scale <1,.5,1>
	clipped_by
	{ 
		torus
		{
			.27,.24
			scale <1,1.85,1>
			inverse
		} 
	}
	scale <1,2,1>
	translate <0,-.05,0>
}

