// Arbres by Jean-Laurent PRADEL Mai 1998 (pidou@club-internet.fr)
// POV-Ray 3.0
// You can use this file as you want, just remember to quote me
//if you distribute it some where. :-)

#ifndef (nb1)             #declare nb1 = 6                       #end
#ifndef (nb2)             #declare nb2 = nb1                     #end
#ifndef (nb3)             #declare nb3 = nb1                     #end
#ifndef (nb_feuille)      #declare nb_feuille = 50               #end
#ifndef (taille_feuille)  #declare taille_feuille = 1            #end
#ifndef (angle_moyen)     #declare angle_moyen = 45              #end
#ifndef (angle_ecart)     #declare angle_ecart = angle_moyen/5   #end
#ifndef (angle_feuille)   #declare angle_feuille= angle_moyen    #end
#ifndef (taille)          #declare taille = 20                   #end
#ifndef (reduction)       #declare reduction = 2/3               #end
#ifndef (position_min)    #declare position_min = taille/3       #end
#ifndef (position_max)    #declare position_max = 2*taille/3     #end
#ifndef (Alea)            #declare Alea = seed (0)               #end
#ifndef (allure)          #declare allure = 1                    #end

#if (position_max>taille)         #declare position_max = taille         #end
#if (position_max<position_min)   #declare position_min = position_max   #end

#declare Text_Feuille =
texture {
  pigment { color rgb <0.5,0.9,0>}
  finish {
    ambient 0.05
    diffuse 0.70
  }
}

#declare Feuille =
disc { <0,0,1>, <0,1,0>, 1
  texture {Text_Feuille}
  scale <0.5,1,1>*taille_feuille
}

#declare Branche =
union {
  cone { <0,0,0>, 0.5, <0,taille,0>, 0
    pigment {color rgb <0.2,0.2,0>}}
  #declare o = 0
  #while (o < nb_feuille)
    object {Feuille
      rotate -90*x
      rotate x*(angle_feuille*(1+(1/2-rand(Alea))/3))
      rotate y*((360/nb_feuille)*o+(360/nb_feuille/3)*(1/2-rand(Alea)))
      translate y*taille/2*(1+rand(Alea))}
    #declare o = o+1
  #end
}

#declare Branche2 =
union {
  cone { <0,0,0>, 0.5, <0,taille,0>, 0
    pigment {color rgb <0.2,0.2,0>}}
  #declare o = 0
  #while (o < nb_feuille)
    object {Feuille
      scale 1/reduction
      rotate -90*x
      rotate x*(angle_feuille*(1+(1/2-rand(Alea))/3))
      rotate y*((360/nb_feuille)*o+(360/nb_feuille/3)*(1/2-rand(Alea)))
      translate y*taille*rand(Alea)}
    #declare o = o+1
  #end
}

#declare Branche3 =
union {
  cone { <0,0,0>, 0.5, <0,taille,0>, 0
    pigment {color rgb <0.2,0.2,0>}}
  #declare o = 0
  #while (o < nb_feuille)
    object {Feuille
      scale 1/(reduction*reduction)
      rotate -90*x
      rotate x*(angle_feuille*(1+(1/2-rand(Alea))/3))
      rotate y*((360/nb_feuille)*o+(360/nb_feuille/3)*(1/2-rand(Alea)))
      translate y*taille*rand(Alea)}
    #declare o = o+1
  #end
}

#declare Branche4 =
union {
  cone { <0,0,0>, 0.5, <0,taille,0>, 0
    pigment {color rgb <0.2,0.2,0>}}
  #declare o = 0
  #while (o < nb_feuille)
    object {Feuille
      scale 1/(reduction*reduction*reduction)
      rotate -90*x
      rotate x*(angle_feuille*(1+(1/2-rand(Alea))/3))
      rotate y*((360/nb_feuille)*o+(360/nb_feuille/3)*(1/2-rand(Alea)))
      translate y*taille*rand(Alea)}
    #declare o = o+1
  #end
}

#declare Arbre =
union {
  object {Branche}
  #declare n = 0
  #while (n < nb1)
  union {
    object {Branche2}
    #declare m = 0
    #while (m < nb2)
    union {
      object {Branche3}
      #declare p = 0
      #while (p < nb3)
        object {Branche4
        scale reduction
        rotate x*(angle_moyen+angle_ecart*(1/2-rand(Alea)))
        #if (allure=1)
          rotate y*((360/nb3)*p+(360/nb3/3)*(1/2-rand(Alea)))
        #else
          rotate y*(180+(180/nb3)*p+(180/nb3/3)*(1/2-rand(Alea)))
        #end
        translate y*(position_min+(position_max-position_min)*rand(Alea))
        }
        #declare p = p+1
      #end
      scale reduction
      rotate x*(angle_moyen+angle_ecart*(1/2-rand(Alea)))
      #if (allure=1)
        rotate y*((360/nb2)*m+(360/nb2/3)*(1/2-rand(Alea)))
      #else
        rotate y*(90+(180/nb2)*m+(180/nb2/3)*(1/2-rand(Alea)))
      #end
      translate y*(position_min+(position_max-position_min)*rand(Alea))
      }
      #declare m = m+1
    #end
    scale reduction
    rotate x*(angle_moyen+angle_ecart*(1/2-rand(Alea)))
    rotate y*((360/nb1)*n+(360/nb1/3)*(1/2-rand(Alea)))
    translate y*(position_min+(position_max-position_min)*rand(Alea))
    }
  #declare n = n+1
#end
}
