#version 3
#include "colors.inc"
#include "stones1.inc"

global_settings { assumed_gamma 1.35 } // never get it quite right...

#declare Q=20; // Quality: 20 highest, 0 lowest (10 and higher only differ in maximum # of rays taken for focal blur)

#switch (Q)
  range (0,2) #declare draft=1 #declare preview=2 #break
  range (3,8) #declare preview=1 #break
#end

camera
{
  location  <0.0, 2.0, -7.8> // position of camera
  direction 2.0*z            // some "zoom"
  up        y                // left hand system; y is up
  right     4/3*x            // aspect ratio 4:3
  look_at   <0.0, 1.4,  0.0> // point center of view at this point <X Y Z>

#if (Q>=7)      // more than just a quick draft?
  #switch (Q)   // if yes, apply focal blur
     #range (7,8) aperture .1 blur_samples 2 #break
     #range (9,10) aperture .1 blur_samples 3 #break
     #range (11,11) aperture .1 blur_samples 4 #break
     #range (12,12)  aperture .1 blur_samples 5 #break
     #range (13,13)  aperture .1 blur_samples 8 #break
     #range (14,14)  aperture .1 blur_samples 10 #break
     #range (15,16)  aperture .1 blur_samples (Q-10)*2 + 5  #break
     #range (17,20)  aperture .1 confidence 0.99 blur_samples (Q-16) * 32 variance 1/256 #break
  #end
  focal_point <0,1,0>
#end
}


// Only one light source to keep things fast... ;-)
light_source {
  0*x
  color rgb 0.7
  translate <3, 10, -4>
  //translate <5, 10, -18>
}

plane {y,0 texture {
  hexagon texture{T_Stone18 scale 1},
          texture{T_Stone21 scale 1}
          texture{T_Stone6 scale 1}
  scale 3
} }


#declare Rod = difference {
  cylinder { <-.6,0,0> <.6,0,0> .1 }
  plane {x,0 rotate <0,-45,0> translate <-.5,0,0> }
  plane {-x,0 rotate <0,45,0> translate <.5,0,0> }
}

#declare T_Ground=texture {
  pigment { wrinkles turbulence .2 color_map {
    [0.00 color rgb <.5,.4,.2>]
    [0.30 color rgb <.4,.2,0>]
    [0.50 color rgb <.55,.35,.1>]
    [0.60 color rgb <.3,.2,.1>]
    [0.70 color rgb <.5,.45,.25>]
    [1.00 color rgb <.45,.35,.3>]
  } scale .3 rotate <15,30,45> }
}

#declare Container=object {union {         // Cointainer
  object {Rod translate <0,0,.5>}
  object {Rod rotate <0,180,0> translate <0,0,-.5>}
  object {Rod rotate <0,90,0> translate <.5,0,0>}
  object {Rod rotate <0,270,0> translate <-.5,0,0>}
} texture{T_Stone3} scale 2}

#declare TreeContainer = union {object{Container}
box {<-.5,0.001,-.5> <.5,0,.5> texture {T_Ground} scale 2}
// (visible only for first tree)
}

union {          // CENTER Tree
     #ifndef (draft)  object {        // TREE
       #declare SD1=seed(24)
       #if (Q<=5) 
         #declare BaseLen=.17
       #declare BarkTexture=2
       #declare LeafShape=3
       #declare LeafTexture=3
       #declare MinXDeg=25
       #declare MaxXDeg=60
       #declare MinSplits=3
       #declare MaxSplits=4
       #declare LengthInc=1.25
         #include "trees.inc" // preview using birch-like tree
       #else
         #include "tomleaf.inc"
         //#include "palm.inc"
         // Palm tree settings for tomtree.inc (Modification of settings in example file palm.inc) 
//LEAF
#declare LEAF_TYPE=HF_PALMLEAF //see TOMLEAF.inc
#declare LEAF_LENGTH=100; #declare LEAF_BREADTH=20; #declare LEAF_THICKNESS=25;
#declare MAX_LEAF_TILT=10; #declare MAX_LEAF_TURN=10; #declare MAX_LEAF_INCLINATION=10;
//BLOSSOM
#declare BLOSSOM=HF_BLOS2
#declare BLOSSOM_LENGTH=15; #declare BLOSSOM_WIDTH=30;
#declare BLOSSOM_INCLINATION=0;
#declare BLOSSOM_COLOR=<1,1,1>;
//BUNCH
#declare BUNCH_MAJOR_RADIUS=0; #declare BUNCH_MINOR_RADIUS=0;
#declare HORIZONTAL_BUNCH_FUNNEL=5; #declare VERTICAL_BUNCH_FUNNEL=5;
#declare HORIZONTAL_BUNCH_INCLINATION=1; #declare VERTICAL_BUNCH_INCLINATION=-40;
#declare HORIZONTAL_BUNCH_INCLINATION_SCOPE=5; #declare VERTICAL_BUNCH_INCLINATION_SCOPE=10;
#declare BUNCH_TURN_SWITCH=0;//turn off (0) the rotation of the bunch around the twig 
#declare BUNCH_ALTERNATE_SWITCH=0; #declare BUNCH_INCLINATION_SWITCH=0;
#declare VERTICAL_BUNCH_INCLINTION_SWITCH=1;
#declare BUNCH_TAPER_OFF_AT_BRANCH=.3; #declare BUNCH_TAPER_OFF_AT_TREE=.3;
#declare BUNCH_DEFORM=<1,1,1>;//no scale of the whole bunch
//TWIG
#declare BUNCH_START_AT_TWIG=1;
#declare TWIG_LENGTH=0; #declare TWIG_STRENGTH=.0; #declare TWIG_THICKNESS_CHANGE=.9;
#declare HORIZONTAL_TWIG_INCLINATION=80; #declare VERTICAL_TWIG_INCLINATION=-70; 
#declare HORIZONTAL_TWIG_INCLINATION_SCOPE=10; #declare VERTICAL_TWIG_INCLINATION_SCOPE=10;
#declare TWIG_INCLINATION_SWITCH=1; #declare VERTICAL_TWIG_INCLINATION_SWITCH=0;
#declare TWIG_TURN_SWITCH=0;//turn off (0) the rotation of the twig around its longitudinal axis
#declare TWIG_ALTERNATE_SWITCH=1; #declare TWIG_CURVE_ADJUSTMENT=.5;
//BRANCH
#declare TWIG_START_AT_BRANCH=100; #declare TWIG_RANGE_AT_BRANCH=300;
#declare BRANCH_THICKNESS_CHANGE=.5; #declare BRANCH_STRENGTH=.75;
#declare BRANCH_BEND=150; #declare BRANCH_BEND_FREQUENCY=.8;
#declare HORIZONTAL_BRANCH_BEND_SWITCH=0;
#declare BRANCH_CURVE=3; #declare BRANCH_CURVE_FREQUENCY=3;
#declare HORIZONTAL_BRANCH_CURVE_SWITCH=1;
#declare BRANCH_LONGITUDINAL_CURVE=1;
#declare BRANCH_SNAG=3; #declare BRANCH_SNAG_FREQUENCY=5;
#declare BRANCH_REDUCTION=0.3; #declare BRANCH_TAPER_OFF=1; #declare BRANCH_END=1;
#declare BRANCH_TURN_SWITCH=0;//turn off (0) the turn of the branches around its longitudinal axis
#declare BRANCH_ALTERNATE_SWITCH=0; #declare BRANCH_SPIRAL=0; #declare BRANCH_INCLINATION=-30;
//TRUNK
#declare BRANCH_START_AT_TRUNK=700; #declare BRANCH_RANGE_AT_TRUNK=50;
#declare TRUNK_RADIUS=25; #declare TRUNK_STRENGTH=1;
#declare TRUNK_BEND_X=-20; #declare TRUNK_BEND_Z=20;
#declare TRUNK_BEND_X_FREQUENCY=1.5;//Frequency of x-bend
#declare TRUNK_BEND_Z_FREQUENCY=1.5;//Frequency of z-bend
#declare TRUNK_CURVE=5;//Width of inner bend (fit into bend) of the trunk
#declare TRUNK_CURVE_FREQUENCY=3;//Frequency of inner bend
#declare TRUNK_SNAG=0;//Width of innermost bend of the trunk (fit into the inner bend)
#declare TRUNK_SNAG_FREQUENCY=10;//Frequency of the innermost bend
#declare TRUNK_SPIRAL=30;//Additional spiral of the trunk in degrees (360 = turn around once)
#declare TRUNK_TAPER_OFF=.6;//How fast the thickness of the trunk decreases towards the top of the tree (1=no thickness at top of tree; 0=same thickness at bottom and top)
#declare TRUNK_LENGTHENING=0;//To make the trunk longer(cm); 0 means that the trunk ends at the highest branch;
#declare PALM_TRUNK=.9;//Makes a trunk with more heavy, regular knots, like a trunk of a palm (look at palm.inc);
//ROOT
#declare ROOT_THICKNESS_CHANGE=.75;//Change the thickness of the root that normally depends on the thickness of the trunk;
#declare ROOT_STRENGTH=.5;//Strength of the roots; decrease this value to save parsingtime or increase it if the root falls in piesces; 
#declare ROOT_TURN_SWITCH=1;//Switch on (1) or off (0) the turn around the root around its longitudinal axis
#declare ROOT_LENGTH=300;//Length of the root
#declare ROOT_INCLINATION=70;//The inclination of the uppermost root to the trunk in degree; starts(0) at horizontale, increase downwards;
#declare ROOT_BEND=40;//Width of the bend of the root 
#declare ROOT_BEND_FREQUENCY=-1.5;//Frequency of the bend
#declare ROOT_SNAG=5;//Width of the inner bend of the root 
#declare ROOT_SNAG_FREQUENCY=5;//Frequency of the inner bend
#declare ROOT_START_AT_TRUNK=150;//Height(cm) of the uppermost root at the trunk
//BARK
#declare TRUNK_COLOR_1=<-.2,-.1,0>;//First color of the bark representing its "valleys"; value lower than 0 for more deep and width
#declare TRUNK_COLOR_2=<0.5,0.3,0>;//Second color of the bark representing its "ridges" and seems to be the color of the trunk 
#declare TRUNK_SCAR_WIDTH=45;//Width of grain of bark(cm)  
#declare TRUNK_SCAR_HEIGHT=10;//Height of grain of bark(cm)
#declare SCAR_DEPTH=1;//Depth of gnarled bark (it's a value for normal{})
#declare BARK_PROFILE=.6;//This is a "real" bark; similar to "PALM_TRUNK" but vertical;
#declare BRANCH_BARK_PROFILE_CHANGE=.3;//Here you can change the "BARK_PROFILE" for the branches (1=same as trunk; 0=no "BARK_PROFILE")
#declare ROOT_BARK_PROFILE_CHANGE=.7;//The same for the roots; branches and roots fall in pieces if their bark_profile is too high;
//FOLIAGECOLOR
#declare BOTTOM_COLOR_1=<0.5,0.4,0>;//First color of the lower leaves
#declare BOTTOM_COLOR_2=<0.4,0.5,0>;//Second color of the lower leaves
#declare TOP_COLOR_1=<0.5,0.5,0>;//First color of the upper leaves
#declare TOP_COLOR_2=<0.2,.8,0>;//Second color of the upper leaves
#declare COLOR_TURB=3.5;//Turbulence of these colors
#declare TRANSITION_BOTTOM_TOP=0.5;//Where the changing of these colors should start in vertical direction; it's relative to the height of the tree (0.5 = height_of_tree/2)
#declare TRANSITION_TURB=.5;//Turbulence in this changing of colors
#declare FOLIAGE_GLOSS=0.25;//If you want glossy leaves, set the value higher than 0 (like phong)
//TREE
#declare BRANCH_NUMBER=30;//The quantity of all branches at the tree
#declare TWIG_NUMBER=1500;//The quantity of all twigs at the tree (the quantity of twigs at the branch is ZWEIGZAHL/ASTZAHL)
#declare BUNCH_NUMBER=1500;//The quantity of all bunches at the tree (the quantity of bunches at the twig is STAUDENZAHL/ZWEIGZAHL)
#declare LEAF_NUMBER=1500;//The quantity of all leaves at the tree
#declare BLOSSOM_NUMBER=0;//The quantity of all blossoms at the tree
#declare ROOT_NUMBER=4;//The quantity of all roots at the tree
#declare BRANCH_RANDOM=2132.3424//1432.718//3597.3797;//Each value results in a new variation/arrangement of the equal branches and twigs/bunches - play with it! 
#declare ROOT_RANDOM=173;//The same for the roots
         #include "TOMTREE.inc" object { TREE scale 3.5 } // palmtree
       #end
}
     #end
  object{TreeContainer}
}

// olive tree on the rocky ground
#if (Q>=7) 

        //#include "olive.inc" 
        #include "tomleaf.inc"
        // Settings for olive tree (Modification of TomTree's example file olive.inc)
//LEAF
#declare LEAF_TYPE=TESTLEAF//Name of leaf, you find in TOMLEAF.inc: Simple leaves or take better HF-leaves - or - create your own
#declare LEAF_LENGTH=10;//Length of leaf (I recommend, you imagine a tree with real dimensions, in cm);
#declare LEAF_BREADTH=2;//Width of leaf (I recommend, you imagine a tree with real dimensions, in cm);
#declare LEAF_THICKNESS=.5;//Height of leaf (in cm; normally a leaf is very thin; but at leaves like a palmleaf it means the height of arch; 
#declare MAX_LEAF_TILT=25;//Tilt of leaf (in degree; this is the amplitude, I have build in a scope);
#declare MAX_LEAF_TURN=25;//Turn of leaf (in degree; this is the amplitude, I have build in a scope);
#declare MAX_LEAF_INCLINATION=25;//Inclination of leaf (in degree; this is the amplitude, I have build in a scope);
//BLOSSOM
#declare BLOSSOM=TESTLEAF//Name of blossom;
#declare BLOSSOM_LENGTH=10;//Length of blossom
#declare BLOSSOM_WIDTH=7;//Width of blossom
#declare BLOSSOM_INCLINATION=0;//Inclination of blossom
#declare BLOSSOM_COLOR=<1,1,1>;//Color of blossom
//BUNCH
#declare BUNCH_MAJOR_RADIUS=5;//Inner radius of bunches in cm; distance of the innermost leaf of a bunch from the twig
#declare BUNCH_MINOR_RADIUS=30;//Outer radius of bunches in cm; distance of the innermost leaf from the outermost leaf of a bunch
#declare HORIZONTAL_BUNCH_FUNNEL=120;//Horizontal opening of bunch in degree
#declare VERTICAL_BUNCH_FUNNEL=120;//Vertical opening of bunch in degree
#declare HORIZONTAL_BUNCH_INCLINATION=100;//Horizontal inclination of whole bunch from twig alignment in degree;
#declare VERTICAL_BUNCH_INCLINATION=100;//Vertical inclination of whole bunch from twig alignment in degree;
#declare HORIZONTAL_BUNCH_INCLINATION_SCOPE=30;//Scope of horizontal inclination in degree 
#declare VERTICAL_BUNCH_INCLINATION_SCOPE=30;//Scope of vertical inclination in degree
#declare BUNCH_TURN_SWITCH=1;//To turn on (1) or turn off (0) the rotation of the bunch around the twig 
#declare BUNCH_ALTERNATE_SWITCH=0;//Here you can decide if bunches should alternate reciprocal at the twig (1=yes;0=no)
#declare BUNCH_INCLINATION_SWITCH=1;//To align (1) or not (0) the bunch with the twig to the end of the twig; horizontal... 
#declare VERTICAL_BUNCH_INCLINTION_SWITCH=1;//...and vertical 
#declare BUNCH_TAPER_OFF_AT_BRANCH=.4;//Adjustment to decrease the size of the outer bunches/twigs at the branch
#declare BUNCH_TAPER_OFF_AT_TREE=0.0;//Adjustment to decrease the size of the bunches at the top of the tree
#declare BUNCH_DEFORM=<1,1,1>;//Simple scale of the whole bunch
//TWIG
#declare BUNCH_START_AT_TWIG=50;//Distance from the branch to the first bunch at the twig
#declare TWIG_LENGTH=80;//The length of the twig;
#declare TWIG_STRENGTH=.6;//Strength of twig; 0=no twig; decrease this value for saving parsingtime or increase it if the twig falls in pieces 
#declare TWIG_THICKNESS_CHANGE=.6;//Use this factor to change the thickness of the twig, that normally(1) depends on the thickness of the branch
#declare HORIZONTAL_TWIG_INCLINATION=50;//Horizontal inclination of twig with bunches to the branch in degree
#declare VERTICAL_TWIG_INCLINATION=60;//Vertical inclination of twig with bunches to the branch in degree
#declare HORIZONTAL_TWIG_INCLINATION_SCOPE=10;//Scope of horizontal inclination in degree  
#declare VERTICAL_TWIG_INCLINATION_SCOPE=10;//Scope of vertical inclination in degree
#declare TWIG_INCLINATION_SWITCH=.8;//To align(1) or not(0) the twig/bunches with the branch to the end of the branch horizontal...
#declare VERTICAL_TWIG_INCLINATION_SWITCH=.8;//...and vertical 
#declare TWIG_TURN_SWITCH=1;//To turn on (1) or turn off (0) the rotation of the twig around its longitudinal axis
#declare TWIG_ALTERNATE_SWITCH=0;//here you can decide if twigs should alternate reciprocal at the branch (1=yes;0=no) and don't turn aroung the branch
#declare TWIG_CURVE_ADJUSTMENT=1;//Here you can reduce (or increase) the curves of the twig which normally(1) depends on the curves of the branch
//BRANCH
#declare TWIG_START_AT_BRANCH=70;//Distance from the first/innermost twig at the branch to the trunk
#declare TWIG_RANGE_AT_BRANCH=150;//Distance from the innermost to the outermost twig at the branch
#declare BRANCH_THICKNESS_CHANGE=.7;//Factor for changing the thickness of the branch that normally(1) depends on the thickness of the trunk 
#declare BRANCH_STRENGTH=1;//decrease this strength of branch to save parsingtime or increase it if the branch falls in pieces; 
#declare BRANCH_BEND=70;//Width of the outer bend of the branch
#declare BRANCH_BEND_FREQUENCY=.8;//Frequency of the outer bend of the branch
#declare HORIZONTAL_BRANCH_BEND_SWITCH=1;//switch on (1) or off (0) the horizontal outer bend 
#declare BRANCH_CURVE=20;//Width of the inner bend that fit into the outer bend of the branch
#declare BRANCH_CURVE_FREQUENCY=5;//Frequency of the inner bend of the branch 
#declare HORIZONTAL_BRANCH_CURVE_SWITCH=.75;//switch on (1) or off (0) the horizontal inner bend 
#declare BRANCH_LONGITUDINAL_CURVE=.5;//To adjust the curves along the longitudinal axis of the branch; 0=no inner bend in longitudinal direction; 1=equal to lateral direction
#declare BRANCH_SNAG=3;//Width of the innermost bend (knots, gnarled) of the branch - fit into inner bend
#declare BRANCH_SNAG_FREQUENCY=20;//Frequency of the innermost bend
#declare BRANCH_REDUCTION=.3;//This reduces the length of branches towards the top of the trunk (1=highest branch is 0 cm)(0=same length of highest and lowest branch) 
#declare BRANCH_TAPER_OFF=1;//Adjustment, how fast the thickness of the branch goes to 0 towards its end
#declare BRANCH_END=1;//If you want that the branch ends at the outermost twig than set to 0; if you set it to 1, the branch ends one twiglength after the last twig 
#declare BRANCH_TURN_SWITCH=1;//Switch on (1) or off (0) the turn of the branches around its longitudinal axis
#declare BRANCH_ALTERNATE_SWITCH=0;//Here you decide, that branches alternate reciprocal at the trunk and don't turn around the trunk
#declare BRANCH_SPIRAL=50;//Additional spiral in the branch (in degree: 360 = turn around once) 
#declare BRANCH_INCLINATION=10;//Inclination of the lowest branch to the trunk (upwards the branches will align with the trunk automatically)
//TRUNK
#declare BRANCH_START_AT_TRUNK=150;//Distance from the ground to the first/lowest branch at the trunk
#declare BRANCH_RANGE_AT_TRUNK=100;//Distance from the first/lowest to the last/highest branch at the trunk
#declare TRUNK_RADIUS=18;//Radius of the trunkthickness
#declare TRUNK_STRENGTH=1.;//Strength of the trunk; you can increase the value if the trunk falls in pieces to close the line
#declare TRUNK_BEND_X=20;//Width of bend in x-direction
#declare TRUNK_BEND_Z=20;//Width of bend in z-direction
#declare TRUNK_BEND_X_FREQUENCY=1.5;//Frequency of x-bend
#declare TRUNK_BEND_Z_FREQUENCY=1.5;//Frequency of z-bend
#declare TRUNK_CURVE=10;//Width of inner bend (fit into bend) of the trunk
#declare TRUNK_CURVE_FREQUENCY=3;//Frequency of inner bend
#declare TRUNK_SNAG=3;//Width of innermost bend of the trunk (fit into the inner bend)
#declare TRUNK_SNAG_FREQUENCY=15;//Frequency of the innermost bend
#declare TRUNK_SPIRAL=80;//Additional spiral of the trunk in degrees (360 = turn around once)
#declare TRUNK_TAPER_OFF=1;//How fast the thickness of the trunk decreases towards the top of the tree (1=no thickness at top of tree; 0=same thickness at bottom and top)
#declare TRUNK_LENGTHENING=0;//To make the trunk longer(cm); 0 means that the trunk ends at the highest branch;
#declare PALM_TRUNK=.0;//Makes a trunk with more heavy, regular knots, like a trunk of a palm (look at palm.inc);
//ROOT
#declare ROOT_THICKNESS_CHANGE=.5;//Change the thickness of the root that normally depends on the thickness of the trunk;
#declare ROOT_STRENGTH=1.;//Strength of the roots; decrease this value to save parsingtime or increase it if the root falls in piesces; 
#declare ROOT_TURN_SWITCH=1;//Switch on (1) or off (0) the turn around the root around its longitudinal axis
#declare ROOT_LENGTH=200;//Length of the root
#declare ROOT_INCLINATION=30;//The inclination of the uppermost root to the trunk in degree; starts(0) at horizontale, increase downwards;
#declare ROOT_BEND=50;//Width of the bend of the root 
#declare ROOT_BEND_FREQUENCY=2;//Frequency of the bend
#declare ROOT_SNAG=1;//Width of the inner bend of the root 
#declare ROOT_SNAG_FREQUENCY=10;//Frequency of the inner bend
#declare ROOT_START_AT_TRUNK=50;//Height(cm) of the uppermost root at the trunk
//BARK
#declare TRUNK_COLOR_1=<-.2,-.2,-.2>;//First color of the bark representing its "valleys"; value lower than 0 for more deep and width
#declare TRUNK_COLOR_2=<.6,.4,.0>;//Second color of the bark representing its "ridges" and seems to be the color of the trunk 
#declare TRUNK_SCAR_WIDTH=15;//Width of grain of bark(cm)  
#declare TRUNK_SCAR_HEIGHT=75;//Height of grain of bark(cm)
#declare SCAR_DEPTH=-1;//Depth of gnarled bark (it's a value for normal{})
#declare BARK_PROFILE=.9;//This is a "real" bark; similar to "PALM_TRUNK" but vertical;
#declare BRANCH_BARK_PROFILE_CHANGE=.3;//Here you can change the "BARK_PROFILE" for the branches (1=same as trunk; 0=no "BARK_PROFILE")
#declare ROOT_BARK_PROFILE_CHANGE=.5;//The same for the roots; branches and roots fall in pieces if their bark_profile is too high;
//FOLIAGECOLOR
#declare BOTTOM_COLOR_1=<0.6,0.4,0.1>;//First color of the lower leaves
#declare BOTTOM_COLOR_2=<0.4,0.5,0>;//Second color of the lower leaves
#declare TOP_COLOR_1=<0.5,0.5,0>;//First color of the upper leaves
#declare TOP_COLOR_2=<0.2,.8,0>;//Second color of the upper leaves
#declare COLOR_TURB=.5;//Turbulence of these colors
#declare TRANSITION_BOTTOM_TOP=0.3;//Where the changing of these colors should start in vertical direction; it's relative to the height of the tree (0.5 = height_of_tree/2)
#declare TRANSITION_TURB=.5;//Turbulence in this changing of colors
#declare FOLIAGE_GLOSS=0.5;//If you want glossy leaves, set the value higher than 0 (like phong)
//TREE
#declare BRANCH_NUMBER=14;//The quantity of all branches at the tree
#declare TWIG_NUMBER=80;//The quantity of all twigs at the tree (the quantity of twigs at the branch is ZWEIGZAHL/ASTZAHL)
#declare BUNCH_NUMBER=300;//The quantity of all bunches at the tree (the quantity of bunches at the twig is STAUDENZAHL/ZWEIGZAHL)
#declare LEAF_NUMBER=0;//The quantity of all leaves at the tree
#declare BLOSSOM_NUMBER=0;//The quantity of all blossoms at the tree
#declare ROOT_NUMBER=1;//4;//The quantity of all roots at the tree
#declare BRANCH_RANDOM=1917.7975;//2434.3137//1917.7975;//Each value results in a new variation/arrangement of the equal branches and twigs/bunches - play with it! 
#declare ROOT_RANDOM=13;//The same for the roots        
        #include "TOMTREE.inc" 
                
   object { TREE scale 1.5 translate<2,-0.3,1> } // dried-out olive tree in the right, very close
   
  #declare BRANCH_RANDOM=5431.2316; // different variation
  #declare TRUNK_SCAR_WIDTH=4;//Width of grain of bark(cm)  
  #declare TRUNK_SCAR_HEIGHT=15;//Height of grain of bark(cm)
  
   object { TREE scale 2.5 translate<-1.5,-0.15,5> } // another dried-out olive tree, this one a bit on the left side, less close
#end

#declare VDT = union {// Very Distant Tree (simplest tree you can imagine...)
                      //           ... just trunk, 2 branches + green sphere
                  object {union {cylinder {<0,0,0>,<0,1.5,0>, .1 }
                                 cylinder {<0,1.5,0>,<.6,2,0.1>, .05 }
                                 cylinder {<0,1.5,0>,<-.3,2.3,-.4>, .05 }
                          }
                          pigment { color rgb <.7,.5,.2> }
                  }
                  sphere {<0,10,0>,6
                   texture {pigment{granite turbulence .5 color_map {
                    [0 color rgbt <.1,1,.2,0>]
                    [.15 color rgbt <0,.8,.7,.5>]
                    [.3 color rgbt <0,1,0,0>]
                    [.45 color rgbt <.1,.9,.2,0>]
                    [.6 color rgbt <.3,1,0,.5>]
                    [.7 color rgbt <0,1,0,1>]
                    [.95 color rgbt <.6,.35,.1,1>]
                    [.96 color rgbt <.4,.3,.1,0>]
                    [.97 color rgbt <.4,.3,.1,0>]
                    [.98 color rgbt <.4,.3,.2,1>]
                    [.99 color rgbt <.4,.3,.1,0>]
                    [1 color rgbt <.4,.3,.1,0>]
                  }}} scale .2}


  object{Container}
}

#declare DistTree= union {
  object{  
          // tree using trees.inc
           #include "defaults.inc"
           #declare BaseLen=.17
           #declare BarkTexture=0
           #declare IncSplits=1
           #declare MinSplits=2
           #declare MaxSplits=3
           #declare IncXDeg=2
           #declare LeafNum=1
           #declare LeafShape=1
           #declare Leave=object {
                  sphere {<0,0,0>,2}
                  texture {pigment{bozo color_map {
                    [0 color rgbt <.1,1,.2,0>]
                    [1 color rgbt <0,.8,0,1>]
                  }}} scale 1}
         #include "trees.inc"
  }
  object{Container}
}

#declare MidTree= object {
           #include "defaults.inc"
           #declare SD1=seed(5)
           #declare BaseLen=.17
           #declare BarkTexture=0
           #declare IncSplits=1.1
           #declare MinSplits=2.4
           #declare MaxSplits=3
           #declare IncXDeg=10
           #declare LengthInc=1.25
           #declare LeafNum=1
           #declare LeafShape=1
           #declare Leave=object {
                  sphere {<0,0,0>,2}
                  texture {pigment{bozo color_map {
                    [0 color rgbt <.1,1,.2,0>]
                    [.5 color rgbt <0,.8,0,1>]
                    [1 color rgbt <0,0,0,1>]
                  }}} scale .5}
         #include "trees.inc"
       }

object {union {
  #ifndef (preview) object {
         #include "defaults.inc"
         #declare BaseLen=.17
         #declare BarkTexture=0
         #declare IncSplits=1.1
         #declare IncXDeg=2
         #declare LeafShape=1
         #declare Leave=object {
                  sphere {<0,0,0>,.2}
                  scale <.75,.1,1.5>}
         #include "trees.inc" rotate -60*y //120*y
         texture {
           pigment {
             bozo
             color_map {
               [0 color Yellow]
               [1 color Red]
           } }
           finish { ambient .3 }
         scale <3,3,3>
         }
       }
    #end
  object{Container}
} translate <-4,0,8>}

object {union {
  object{MidTree}
  object{Container}
} translate <4,0,8>}

object {VDT translate <0,0,16>}
object {DistTree translate <8,0,16>}
object {DistTree translate <-4,0,24>}
object {DistTree translate <4,0,24>}
/*
object {VDT translate <-8,0,32>}
object {VDT translate <+8,0,32>}
object {VDT translate <-16,0,32>}
object {VDT translate <+16,0,32>}
object {VDT translate <-4,0,40>}
object {VDT translate <+4,0,40>}
object {VDT translate <-12,0,40>}
object {VDT translate <+12,0,40>}
object {VDT translate <-20,0,40>}
object {VDT translate <+20,0,40>}
*/

#declare zp = 32;
#while (zp <= 48)
   #declare twidth = - 6 * 4;
   
   #declare xp = -twidth
   #while (xp <= +twidth)
        
        object { VDT translate <xp,0,zp> }
        
        #declare xp = xp + 4
   #end
   
   #declare zp = zp + 8
#end


// ------- pool

#declare H=1.5/2
#declare V=3

#declare RodH = difference {
  cylinder { <-.5*H-.1,0,0> <.5*H+.1,0,0> .1 }
  plane {x,0 rotate <0,-45,0> translate <-.5*H,0,0> }
  plane {-x,0 rotate <0,45,0> translate <.5*H,0,0> }
}

#declare RodV = difference {
  cylinder { <-.5*V-.1,0,0> <.5*V+.1,0,0> .1 }
  plane {x,0 rotate <0,-45,0> translate <-.5*V,0,0> }
  plane {-x,0 rotate <0,45,0> translate <.5*V,0,0> }
}

object {union {
  object {union {         // Cointainer
    object {RodH translate <0,0,.5*V>}
    object {RodH rotate <0,180,0> translate <0,0,-.5*V>}
    object {RodV rotate <0,90,0> translate <.5*H,0,0>}
    object {RodV rotate <0,270,0> translate <-.5*H,0,0>}
  } texture{T_Stone3} scale 2}

  box {<-.5,0.001,-.5> <.5,0,.5>
    texture {
      pigment {color rgb <0,.15,.8>}
      normal {ripples .2}
      finish {reflection .55 diffuse .33 ambient .07
         phong .5 phong_size .3 }
    } scale 2*<H,1,V>}
    
  object { // right waterplant (small one)
        #declare taille=20
       #declare taille_feuille=20/15
       #declare nb_feuille=Q
       #declare nb1 =3
       #declare nb2 =3
       #declare nb3 =2
       
       #include "arbres.inc"
       object { Arbre scale 1/20 rotate 10*y translate <0.4,-0.5,0.7> }
  }
  
  object { // right waterplant (slightly bigger one)
        #declare taille=25
       #declare taille_feuille=20/15
       #declare nb_feuille=Q
       #declare nb1 =4
       #declare nb2 =3
       #declare nb3 =2
       
       #include "arbres.inc"
       object { Arbre scale 1/20 rotate <10,0,-15> translate <-0.45,-0.35,-1.3> }
  }

}  translate <-H-1.5,0,V-1> }

object { // plant on the right side, very close
        #declare taille=25
       #declare taille_feuille=0.65
       #declare nb_feuille=4*Q
       #declare nb1 =4
       #declare nb2 =3
       #declare nb3 =2
       
       #include "arbres.inc"
       object { Arbre scale 1/10 rotate <00,0,38> translate <3.3,0.8,0> }
  }
  
  
// Brilliant to shine instead of a flower...
#include "brilliant.inc"
object {
  brilliant 
  hollow on 
  texture { pigment {rgbft<0,0.7,1,0.7,0.7>} }
  finish {reflection <0.3,0.45,0.5> ambient .2 diffuse 0.3 roughness .001 }  
  // intentionally blueish to contrast to the reddish background
  interior { ior 2.42 }  // optical density like diamond
  scale 0.35
  rotate <-85,-20,0>
  translate <-1.7,2.8,0>    
}
  

// Lightning
#if (Q>1)
  #declare Silver = color rgb <1,1,0.35>; // Color of Lightning, not "silver", but rather yellowish for greater effect
  
  #declare LX = 1
  #declare LY = 0
  #declare LZ = 4
  #declare LightningSeed = 0726
  #declare LSegments = 100
  #declare LightningLength = -5
  //#declare LightningScale = <1,1,1> * 5
  #version 3.0
  #declare Luminous = finish { ambient 1.0 }
  #include "lightning.inc"
#end

// --- Hanging leaves, etc.

#declare leaf=object{difference{
    sphere {<0,0,0>,1}
    sphere {<.3,0,-.1>,1.1}
    sphere {<-.3,0,-.1>,1.1}
    plane {-y,0}
//    rotate <0,180,0>
  }
  texture {
    //pigment {color rgb <0,.7,.15>}
    pigment {color rgb <0.4,0.65,0.1>}
    finish {diffuse .8 phong .2 ambient .08}
  }
  no_shadow
}

object{leaf rotate <0, -15, 0> translate <.5,3.75,-1>}
object{leaf rotate <0, 15, 0> translate <-.7,3.35,-3>}
object{leaf rotate <0, -13, 0> translate <1.9,3.45,-1.5>}
object{leaf rotate <0, -30, 0> translate <2.5,3.3,-2>}
object{leaf rotate <0, -18, 0> scale <1.2,1.8,1.2> translate <1.2,3.1,-2.5>}
object{leaf rotate <0, 15, 0> translate <-1.85,3.2,-3>}
object{leaf rotate <0, -17, 30> translate <-1.3,3.75,-1>}

// ------------- FOGs, Atmosphere
/*
fog{
  fog_type   2
//  distance   30
  distance   30 /5
  //up -z
  up -<0.6,0,0.9>
  color      rgbt <1,.75,.8,0.3>
  fog_offset -12 +14.5
  fog_alt    2 -1
  turbulence 100
}  */


plane {
   <0,-1,-0.01>, - 100
   
   hollow  
   
   texture { pigment { color rgb <0.8,0.6,0.7> } finish { ambient 1 refraction 0 reflection 0 }  }
   
   texture {pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb 1
                   color rgb 0.9 ]
          [0.1 0.3 color rgb 0.9
                   color rgb 1 ]
          [0.3 0.6 color rgb 1
                   color rgbt <1, 1, 1, 1>]
          [0.6 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale 70
     rotate 20*x
    } finish { ambient 1 refraction 0 reflection 0 } }
}
