// ***********************************************************
// * Lightning Include File For Persistance Of Vision 3.x    *
// *                                                         *
// * Created by      Jeffry J. Brickley                      *
// * Current Version 1.0.0                                   *
// * Last Update     04 April 1998                           *
// * Modification History:                                   *
// ***********************************************************
// * 1998-03-19 * V0.9.0 * Created First workable version    *
// *            *        * an iterative approach.            *
// ***********************************************************
// * 1998-04-04 * V1.0.0 * Recursive approach completed      *
// *            *        * First Public release              *
// ***********************************************************
// * Note: Only the LightningFlash generates a "halo" which  *
// * is considered an experimental feature in V3.02.  Should *
// * a new version of POV be released that does not support  *
// * halos or supports them in a different syntax, this area *
// * will have to be modified.                               *
// ***********************************************************
// CHECK VARIABLES AND ASSIGN DEFAULTS
// ***********************************************************

// slightly altered by Bjrn Stein on December 27th 1999:
//  - adjusted to Pov-Ray Version 3.1 (no halos supported)

#ifndef (recurse_level) #declare recurse_level = 0 #end
// Maximum recursion depth set here!
#ifndef (recurse_depth) #declare recurse_depth = 3 #end
#ifndef (LightningSeed) #declare LightningSeed = 0 #end
#ifndef (debug_options) #declare debug_options = true #end
#ifndef (LightningFlash) #declare LightningFlash = true #end
#ifndef (LSegments) #declare LSegments = 100 #end
#ifndef (LightningLength) #declare LightningLength = 10 #end
#ifndef (LightningWidth) #declare LightningWidth = 0.050 #end
#if (recurse_level = 0)
   #declare LRand = seed(LightningSeed)
   #declare MainWidth = LightningWidth
#end
#ifndef (LX) #declare LX = 0 #end
#ifndef (LY) #declare LY = 0 #end
#ifndef (LZ) #declare LZ = 0 #end
#ifndef (LightningRotation) #declare LightningRotation = <0,0,0> #end
#ifndef (LightningScale) #declare LightningScale = <1,1,1> #end
#ifndef (XShift) #declare XShift = 0.5 #end
#ifndef (ZShift) #declare ZShift = 0.5 #end
#ifndef (BranchFrequency) #declare BranchFrequency = 0.10 #end
#declare LastX = LX
#declare LastY = LY
#declare LastZ = LZ
#if (recurse_level=0)
   #if (debug_options != false)
      #debug concat("// LIGHTNING INCLUDE FILE OPTIONS (LightningSeed = ", str(LightningSeed, 0, 0), ")\r\n")
      #debug concat("   #declare LSegments = ", str(LSegments, 0, 0), "\r\n")
      #debug concat("   #declare LightningLength = ", str(LightningLength, 0, 3), "\r\n")
      #debug concat("   #declare LightningWidth = ", str(LightningWidth, 0, 3), "\r\n")
      #debug concat("   #declare BranchFrequency = ", str(BranchFrequency, 0, 3), "\r\n")
      #debug concat("   #declare LightningRotation = <", str(LightningRotation.x, 0, 3), ", ", str(LightningRotation.y, 0, 3), ", ", str(LightningRotation.z, 0, 3), ">\r\n")
      #debug concat("   #declare LightningScale = <", str(LightningScale.x, 0, 3), ", ", str(LightningScale.y, 0, 3), ", ", str(LightningScale.z, 0, 3), ">\r\n")
      #debug "   #declare LightningFlash = " #if (LightningFlash = false) #debug "false" #else #debug "true" #end #debug "\r\n"
      #debug concat("   #declare XShift = ", str(XShift, 0, 3), "\r\n")
      #debug concat("   #declare ZShift = ", str(ZShift, 0, 3), "\r\n")
      #debug concat("   #declare LX = ", str(LX, 0, 3), "\r\n")
      #debug concat("   #declare LY = ", str(LY, 0, 3), "\r\n")
      #debug concat("   #declare LZ = ", str(LZ, 0, 3), "\r\n")
      #debug "\r\n\r\n"
   #end
#end
#if (0)
#declare _Flash_baseZobj  = disc {0, z, 0.999 finish {ambient 1 diffuse 0 reflection 0 refraction 0 phong 0 specular 0 crand 0}}
#declare _Flash_baseXobj  = disc {0, x, 0.999 finish {ambient 1 diffuse 0 reflection 0 refraction 0 phong 0 specular 0 crand 0}}
#else
#declare _Flash_baseobj  = cone {<0,0,0>, LightningWidth, <0,1,0>, 2 finish {ambient 1 diffuse 0 reflection 0 refraction 0 phong 0 specular 0 crand 0}}
 // by Bjrn Stein: using Pov-Ray 3.1: no halo support
#declare _Flash_halo = texture { } /*halo {
      attenuating
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 1, 1, 1> ]
        [ 1 color rgbt <1, 1, 1, -1> ]
      }
      samples 10
    }*/
#end
#if (recurse_level = 0)
#declare LightningUnits = LightningLength / LSegments
#end
#declare tempSegments = LSegments
#declare iteration = 0
object { union {
#while (tempSegments>0)
   #declare LX = LX+(rand(LRand)-XShift)*0.25
   #declare LY = LY-LightningUnits
   #declare LZ = LZ+(rand(LRand)-ZShift)*0.1
   #if ((recurse_level=0) | (LightningWidth<MainWidth*0.1))
   cylinder{<LX,LY,LZ>, <LastX, LastY, LastZ> ,LightningWidth}
   #else
   cone { <LX,LY,LZ>, LightningWidth*0.95, <LastX,LastY,LastZ>,LightningWidth}
   #end
   #if (iteration>1)
   intersection {
     #declare DX = LX - LastX
     #declare DY = LY - LastY
     #declare DZ = LZ - LastZ
     cylinder {<LastX,LastY,LastZ>,<LastX-DX,LastY-DY,LastZ-DZ>,LightningWidth}
     #declare DX = LastX - PriorX
     #declare DY = LastY - PriorY
     #declare DZ = LastZ - PriorZ
     cylinder {<LastX,LastY,LastZ>,<LastX+DX,LastY+DY,LastZ+DZ>,LightningWidth}
   }
   #end
   #if ((recurse_level>0) & (LightningWidth>MainWidth*0.1))
     #declare LightningWidth = LightningWidth*0.95
   #end
   #declare PriorX = LastX
   #declare PriorY = LastY
   #declare PriorZ = LastZ
   #declare LastX = LX
   #declare LastY = LY
   #declare LastZ = LZ
   #declare iteration = iteration +1
   #if ((recurse_level < recurse_depth) & (rand(LRand)<BranchFrequency))
      #declare recurse_level = recurse_level + 1
      #switch (recurse_level)
      #case (1)
         #declare t1ZShift = ZShift
         #declare t1XShift = XShift
         #declare t1LastX = LastX
         #declare t1LastY = LastY
         #declare t1LastZ = LastZ
         #declare t1PriorX = PriorX
         #declare t1PriorY = PriorY
         #declare t1PriorZ = PriorZ
         #declare t1Segments = tempSegments
         #declare t1LSegments = LSegments
         #declare t1Width = LightningWidth
         #declare t1iteration = iteration
         #declare t1BFreq = BranchFrequency
      #break
      #case (2)
         #declare t2ZShift = ZShift
         #declare t2XShift = XShift
         #declare t2LastX = LastX
         #declare t2LastY = LastY
         #declare t2LastZ = LastZ
         #declare t2PriorX = PriorX
         #declare t2PriorY = PriorY
         #declare t2PriorZ = PriorZ
         #declare t2Segments = tempSegments
         #declare t2LSegments = LSegments
         #declare t2Width = LightningWidth
         #declare t2iteration = iteration
         #declare t2BFreq = BranchFrequency
      #break
      #case (3)
         #declare t3ZShift = ZShift
         #declare t3XShift = XShift
         #declare t3LastX = LastX
         #declare t3LastY = LastY
         #declare t3LastZ = LastZ
         #declare t3PriorX = PriorX
         #declare t3PriorY = PriorY
         #declare t3PriorZ = PriorZ
         #declare t3Segments = tempSegments
         #declare t3LSegments = LSegments
         #declare t3Width = LightningWidth
         #declare t3iteration = iteration
         #declare t3BFreq = BranchFrequency
      #break
      #end
      #if (rand(LRand)<0.5)
        #declare XShift = XShift -rand(LRand)*0.5
      #else
        #declare XShift = XShift +rand(LRand)*0.5
      #end
      #declare LSegments = tempSegments - tempSegments*(rand(LRand)*0.25+0.25)
      #declare LightningWidth = LightningWidth*(rand(LRand)*0.25+0.25)
      #declare BranchFrequency = BranchFrequency*0.75
      #include "lightning.inc"
      #declare recurse_level = recurse_level - 1
      #switch (recurse_level)
      #case (0)
         #declare ZShift = t1ZShift
         #declare XShift = t1XShift
         #declare LastX = t1LastX
         #declare LastY = t1LastY
         #declare LastZ = t1LastZ
         #declare PriorX = t1PriorX
         #declare PriorY = t1PriorY
         #declare PriorZ = t1PriorZ
         #declare tempSegments = t1Segments
         #declare LSegments = t1LSegments
         #declare LightningWidth = t1Width
         #declare iteration = t1iteration
         #declare BranchFrequency = t1BFreq
      #break
      #case (1)
         #declare ZShift = t2ZShift
         #declare XShift = t2XShift
         #declare LastX = t2LastX
         #declare LastY = t2LastY
         #declare LastZ = t2LastZ
         #declare PriorX = t2PriorX
         #declare PriorY = t2PriorY
         #declare PriorZ = t2PriorZ
         #declare tempSegments = t2Segments
         #declare LSegments = t2LSegments
         #declare LightningWidth = t2Width
         #declare iteration = t2iteration
         #declare BranchFrequency = t2BFreq
      #break
      #case (2)
         #declare ZShift = t3ZShift
         #declare XShift = t3XShift
         #declare LastX = t3LastX
         #declare LastY = t3LastY
         #declare LastZ = t3LastZ
         #declare PriorX = t3PriorX
         #declare PriorY = t3PriorY
         #declare PriorZ = t3PriorZ
         #declare tempSegments = t3Segments
         #declare LSegments = t3LSegments
         #declare LightningWidth = t3Width
         #declare iteration = t3iteration
         #declare BranchFrequency = t3BFreq
      #break
      #end
      #declare LX = LastX
      #declare LY = LastY
      #declare LZ = LastZ
   #end
   #declare tempSegments = tempSegments - 1
#end

   texture{pigment{Silver} finish{Luminous}}
   }
   #if (recurse_level = 0)
   rotate LightningRotation
   scale LightningScale
   #end
   no_shadow
}
#if ((LightningFlash = true) & (recurse_level = 0))
   light_source { <LX, LY+LY/100, LZ> color White}
   object {_Flash_baseobj
     pigment { color rgbt <1, 1, 1, 1> }
     //halo { _Flash_halo }
     hollow
     no_shadow
     translate <LX,LY,LZ>
   }
#debug concat("Lightning Strike at location: <", str(LX, 0, 3), ", ", str(LY, 0, 3), ", ", str(LZ, 0, 3), ">\r\n")
#end

