// IRTC Gardens - Monet
// David Morgan-Mar

//#include "branches.inc"

// development switches
#declare Monet = 1;
#declare Blur = 0;
#declare YellowSpots = 1;
#declare Bright = 1.1;
#declare SpotBright = 1.6;
#declare Ambient = 1.2;
#declare Dark = 0;

// parameters
#declare Rseed1 = seed(647);
#declare NumIrises = 1000; // 1000
#declare NumLeaves = 700; // 700

camera {
    location <0,1.8,1>
    look_at  <-1,1.5,0>
    //look_at  <-1,1.5,1>
    #if (Monet)
        normal { bozo 0.005
            scale 0.02
            turbulence 1
            lambda 4.0
            omega 0.5
        }
    #end
    #if (Blur)
        aperture 0.1
        blur_samples 10
        focal_point <0,-1,0>
    #end
}

background { <0.3,0.6,1> }

#if (!Dark)
global_settings { ambient_light <Ambient,Ambient,Ambient> }

light_source { <-10,20,-5> rgb <Bright,Bright,Bright> }
light_source { <2,2,2> rgb <Bright,Bright,Bright> }
#end // (!Dark)
light_source { <-3,2.5,1>
    rgb <SpotBright,SpotBright,SpotBright>
    spotlight
    radius 20
    falloff 30
    point_at <-4,0,-2.5>
}
light_source { <-1,2.5,1>
    rgb <SpotBright,SpotBright,SpotBright>
    spotlight
    radius 20
    falloff 30
    point_at <-2,0,-2.5>
}

// ground plane
#declare TopSoil = 1;
plane { y 0
    texture {
        pigment { gradient x
            sine_wave
            colour_map {
                [0.0 rgb <1.0,0.7,0.3>]
                [0.3 rgb <0.8,0.4,0.1>]
                //[0.8 rgb <0.5,0.2,0>]
                [1.0 rgb <0.3,0.1,0>]
            }
            turbulence 0.5
            lambda 3.0
            omega 0.6
            scale 1
        }
    }
    #if (TopSoil)
    texture {
        pigment { cylindrical
            colour_map {
                [0.0 rgbt <1,1,1,1>]
                [0.3 rgbt <0.8,0.4,0.1,0.5>]
                //[0.8 rgb <0.5,0.2,0>]
                [1.0 rgbt <0.3,0.1,0,0>]
            }
            scale 5
        }
    }
    #end
}

// back wall plane
plane { <1,0,1>, -13
    texture {
        pigment { brick
            rgb <0.2,0.8,1>,
            rgb <1,0.4,0.2>
            brick_size <3,1.5,2.5>
            mortar 0.7
            turbulence 0.3
            lambda 3.5
            omega 0.6
        }
    }
    texture {
        pigment { gradient y
            colour_map {
                [0.0 rgbt <0,0.4,0,0>]
                [0.2 rgbt <0,1,0,0>]
                [0.5 rgbt <0,1,0,0>]
                [0.7 rgbt <1,0.4,0.2,1>]
                [1.0 rgbt <1,0.4,0.2,1>]
            }
            triangle_wave
            scale 2
            turbulence 0.5
            lambda 4.0
            omega 0.8
            translate <0,3,0>
        }
    }
}
// right wall plane
plane { x, -13
    texture {
        pigment { brick
            rgb <0.2,0.8,1>,
            rgb <1,0.4,0.2>
            brick_size <3,1.5,2.5>
            mortar 0.3
            turbulence 0.3
            lambda 3.5
            omega 0.6
        }
    }
    texture {
        pigment { gradient y
            colour_map {
                [0.0 rgbt <0,0.4,0,0>]
                [0.2 rgbt <0,1,0,0>]
                [0.6 rgbt <0,1,0,0>]
                [0.8 rgbt <1,0.4,0.2,1>]
                [1.0 rgbt <1,0.4,0.2,1>]
            }
            triangle_wave
            scale 2
            turbulence 0.5
            lambda 4.0
            omega 0.8
            translate <0,-0.5,0>
        }
    }
}
// left wall plane
plane { z, -10
    texture {
        pigment { brick
            rgb <0.2,0.8,1>,
            rgb <1,0.4,0.2>
            brick_size <3,1.5,2.5>
            mortar 0.3
            turbulence 0.3
            lambda 3.5
            omega 0.6
        }
    }
    texture {
        pigment { gradient y
            colour_map {
                [0.0 rgbt <0,1,0,0>]
                [0.4 rgbt <0,1,0,0>]
                [0.6 rgbt <1,0.4,0.2,1>]
                [1.0 rgbt <1,0.4,0.2,1>]
            }
            triangle_wave
            scale 2
            turbulence 0.5
            lambda 4.0
            omega 0.8
        }
    }
}
// right yellowspot box
#if (YellowSpots)
box { <-8,1,-6> <-8.01,4,0>
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgbt <1,1,0,0>]
                [0.01 rgbt <1,1,0,0>]
                [0.01 rgbt <1,1,1,1>]
                [1.0 rgbt <1,1,1,1>]
            }
            scale <0.05,0.5,0.05>
            turbulence 0.5
        }
        finish {
            ambient 0.8
        }
    }
}
#end

// iris macro
#declare IrisStalk = 0.02; // radius of Iris stalk
#declare IrisPetal = 0.03; // radius of iris petal
#declare IrisSepal = IrisPetal * 2; // offset of sepals from stalk
#macro Iris(x1,y1,z1)
    #local x2 = (rand(Rseed1)-0.5)*0.3;
    #local y2 = 0.3 + rand(Rseed1)*0.3;
    #local z2 = (rand(Rseed1)-0.5)*0.3;
    union {
        cylinder { <0,0,0>, <x2,y2,z2> IrisStalk
            texture {
                pigment { rgb <0,1,0> }
            }
        }
        #local j = 0;
        #while (j < 3)
            #local x3 = x2 + (rand(Rseed1)-0.5)*IrisSepal;
            #local y3 = y2 + (rand(Rseed1)-0.5)*IrisSepal;
            #local z3 = z2 + (rand(Rseed1)-0.5)*IrisSepal;
            sphere { <x3,y3,z3> IrisPetal
                texture {
                    #switch (j)
                        #case (0)
                        pigment { rgb <1,0.2,1> }
                        #break
                        #case (1)
                        pigment { rgb <0.3,0,0.6> }
                        #break
                        #case (2)
                        pigment { bozo
                            colour_map {
                                [0.0 rgb <0.3,0.9,1>]
                                [0.7 rgb <0.3,0.9,1>]
                                [0.7 rgb <1,1,1>]
                                [1.0 rgb <1,1,1>]
                            }
                            scale IrisPetal
                        }
                        #break
                    #end
                    finish { phong 1.0 phong_size 30 }
                }
            }
            #local j = j + 1;
        #end
        translate <x1,y1,z1>
    }
#end // macro Iris

// garden beds
union {
    box { <0,0,-1> <-10,0.001,-3> }
    box { <0,0,0> <-10,0.001,1> }
    box { <0,0,-4> <-10,0.001,-27> }
    texture {
        pigment { crackle
            colour_map {
                [0.0 rgb <0,0.5,0>]
                [1.0 rgb <0,1.0,0>]
            }
            scale 3
        }
    }
}

// irises      
#declare i = 0;
#while (i < NumIrises)
    Iris(-5 + (rand(Rseed1)-0.5)*10,
         0,
         -1.7 + (rand(Rseed1)-0.5)*2)
    #declare i = i + 1;
#end
#declare NumIrises = NumIrises / 2;
#declare i = 0;
#while (i < NumIrises)
    Iris(-5 + (rand(Rseed1)-0.5)*10,
         0,
         0.5 + (rand(Rseed1)-0.5)*1)
    Iris(-5 + (rand(Rseed1)-0.5)*10,
         0,
         -6.5 + (rand(Rseed1)-0.5)*1)
    #declare i = i + 1;
#end

// roses
#declare RoseSize = 0.05;
#declare NumRoses = 100;
#declare Rose = union {
    #declare i = 0;
    #while (i < NumRoses)
        sphere { <(rand(Rseed1)-0.5),rand(Rseed1)*0.4,(rand(Rseed1)-0.5)> RoseSize
        }
        #declare i = i + 1;
    #end
}
union {
    object { Rose
        translate <-2,0,-5.5>
    }
    object { Rose
        translate <-4,0,-5.5>
    }
    object { Rose
        translate <-6,0,-5.5>
    }
    object { Rose
        translate <-8,0,-5.5>
    }
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgb <1,1,1>]
                [0.5 rgb <1,1,1>]
                [0.5 rgb <1,0,0>]
                [1.0 rgb <1,0,0>]
            }
            scale 0.12
        }
    }
}

// trees
#declare TreeHeight = 3.2;
#declare TreeTrunk = 0.12;
#declare TreeBranch = 0.06;
#declare TreeX1 = -3;
#declare TreeZ1 = -6;
#declare TreeX2 = -8;
#declare TreeZ2 = -6;
#declare TreeX3 = -10;
#declare TreeZ3 = -4;
union {
    // tree1
    cylinder { <TreeX1,0,TreeZ1>, <TreeX1,TreeHeight,TreeZ1>, TreeTrunk }
    cylinder { <TreeX1,2,TreeZ1>, <-1,3,-6>, TreeBranch }
    cylinder { <TreeX1,1.5,TreeZ1>, <-5,2,-6>, TreeBranch }
    cylinder { <TreeX1,3,TreeZ1>, <-2,3.5,-7>, TreeBranch }
    // tree2
    cylinder { <TreeX2,0,TreeZ2>, <TreeX2,TreeHeight,TreeZ2>, TreeTrunk }
    cylinder { <TreeX2,2,TreeZ2>, <-6,3,-6>, TreeBranch }
    cylinder { <TreeX2,3,TreeZ2>, <-10,3,-6>, TreeBranch }
    // tree3
    cylinder { <TreeX3,0,TreeZ3>, <TreeX3,TreeHeight,TreeZ3>, TreeTrunk }
    // tree trunk texture
    texture {
        pigment { rgb <0.8,0.4,0.1> }
    }
    no_shadow
}
// tree leaves
#macro TreeLeaf(x1,y1,z1)
    cone { <x1,y1,z1>, 0, <x1,y1+0.4,z1> 0.04
        #if (rand(Rseed1) < 0.1)
        texture {
            pigment { rgb <1.2,1.2,0.5> }
            finish { ambient 0.7 }
        }
        #else
        texture {
            pigment { rgb <0,0.7,0.2> }
        }
        #end
    }
#end // macro TreeLeaf
#declare i = 0;
#while (i < NumLeaves)
    TreeLeaf(TreeX1 + (rand(Rseed1)-0.5)*3,
             TreeHeight + (rand(Rseed1)-0.5)*4,
             TreeZ1 + (rand(Rseed1)-0.5)*3)
    TreeLeaf(TreeX2 + (rand(Rseed1)-0.5)*3,
             TreeHeight + (rand(Rseed1)-0.5)*4,
             TreeZ2 + (rand(Rseed1)-0.5)*3)
    TreeLeaf(TreeX3 + (rand(Rseed1)-0.5)*3,
             TreeHeight + (rand(Rseed1)-0.5)*4,
             TreeZ3 + (rand(Rseed1)-0.5)*3)
    #declare i = i + 1;
#end
#declare NumLeaves = NumLeaves / 10;
#declare i = 0;
#while (i < NumLeaves)
    TreeLeaf(TreeX1 + (rand(Rseed1)-0.5)*1.2,
             0.7 + (rand(Rseed1)-0.5)*0.8,
             TreeZ1 + (rand(Rseed1)-0.5)*1.2)
    TreeLeaf(TreeX2 + (rand(Rseed1)-0.5)*1.2,
             0.7 + (rand(Rseed1)-0.5)*0.8,
             TreeZ2 + (rand(Rseed1)-0.5)*1.2)
    TreeLeaf(TreeX3 + (rand(Rseed1)-0.5)*1.2,
             0.7 + (rand(Rseed1)-0.5)*0.8,
             TreeZ3 + (rand(Rseed1)-0.5)*1.2)
    #declare i = i + 1;
#end
