// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g
// Desc: Basic Scene Example
// Date: 99/12/7
// Matt Giwer
//

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

/*
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
} */

light_source
{
  0*x // light's position (translated below)
  color red .8  green .8  blue .8  // light's color
  translate <-30, 30, -30> *20
}

light_source
{
  0*x // light's position (translated below)
  color red .5  green .5  blue .5  // light's color
  translate <30, 30, -30> *20
  shadowless
}

// ----------------------------------------
plane { y, -10 pigment {color rgb <0.1,0.7,0.3>} normal {dents -.5
          turbulence 100 octaves 2 omega 2 lambda 1
            frequency 500  }normal { dents -2 scale <20,10,10>} }// normal { crackle 2 scale <20,10,10>}}

#declare Grey_Phong = texture {
	pigment { color rgb <.5,0.5,0.55> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
} 

 
#declare Blue_Phong = texture {
	pigment { color rgb <.2,0.1,1> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
}

#declare Orange_Phong = texture {
	pigment { color rgb <1,0.5,0.1> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
}


#declare Gold_Phong = texture {
	pigment { color rgb <1.0,0.84,0.0> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
}

/*#declare EPSILON = 1e-10;
#declare xmin  = 0;
#declare xmax  = 6.283185307179586232;
#declare ymin  = -0.35;
#declare ymax  = 3.141592653589793116;
#declare xiter = 21;
#declare yiter = 31;
#declare ix    = (xmax-xmin)/(xiter-1.0);
#declare iy    = (ymax-ymin)/(yiter-1.0);
#declare deltax = (xmax-xmin)/((xiter-1.0)*4.0);
#declare deltay = (ymax-ymin)/((yiter-1.0)*4.0);
#macro point(xx,yy)
#local T  = xx;
#local P  = yy;
#local R  = 0;
#local ro  = (1-cos(P))*(P>0)-sin(max(P,-0.25))*(P<=0);
#local theta  = T;
#local phi  = P*(P>-0.35);
    #declare zzz=-ro*sin(phi)*cos(theta);
    #declare xxx=ro*sin(phi)*sin(theta);
    #declare yyy=ro*cos(phi);
#end
#macro surface(xx,yy)
    point(xx,yy)
    #local xn=xxx;
    #local yn=yyy;
    #local zn=zzz;
    #declare xx=xx+deltax;
    point(xx,yy)
    #local xp=xxx;
    #local yp=yyy;
    #local zp=zzz;
    #declare xx=xx-deltax;
    #declare yy=yy+deltay;
    point(xx,yy)
    #local xq=xxx;
    #local yq=yyy;
    #local zq=zzz;
    #declare yy=yy-deltay;
    #local vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>);
    #declare nn=vnormalize(vn);
    #declare pp=<xn,yn,zn>;
#end 

#declare eureka_apple = mesh {
  #declare xx = xmin;
  #while (xx<xmax)                        //outer loop
    #declare yy = ymin;
    #while (yy<ymax)                      //inner loop
//POINTS
    surface(xx,yy)
    #declare n1=nn;
    #declare p1=pp;

    #declare yy=yy+iy;
    surface(xx,yy)
    #declare n2=nn;
    #declare p2=pp;

    #declare xx=xx+ix;
    surface(xx,yy)
    #declare n3=nn;
    #declare p3=pp;

    #declare yy=yy-iy;
    surface(xx,yy)
    #declare n4=nn;
    #declare p4=pp;

    #declare xx=xx-ix;
#if(!(p1.x=p2.x&p1.y=p2.y&p1.z=p2.z)|(p2.x=p3.x&p2.y=p3.y&p2.z=p3.z)|(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z))
        smooth_triangle {
          p1,n1,
          p2,n2,
          p3,n3
         }

#end
#if(!(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z)|(p3.x=p4.x&p3.y=p4.y&p3.z=p4.z)|(p1.x=p4.x&p1.y=p4.y&p1.z=p4.z))
        smooth_triangle{
          p1,n1,
          p3,n3,
          p4,n4
         }
#end

      #declare yy = yy+iy;
   #end                 //inner loop
   #declare xx = xx+ix;
 #end                   //outer loop
	translate <0,0.875,0>
	scale 1.0/2.59808
}

object {
	eureka_apple
 //no_shadow
 texture { Gold_Phong }
 rotate <0,36*clock,0>  scale 10
 }

*/


#declare boy = poly { 6 <
-729.0000000000001, 0, 1374.615582626648, 0, -2187., 
  0, 0, -810., 324., 0, 0, -2749.231165253297, 0, 0, 
  0, 0, -305.4701294725886, 0, 0, 0, -2187., 0, 0, 
  -1620., 648., 0, 1832.820776835531, 
  -1832.820776835531, 0, 0, 324., 0, -144., 0, 0, 0, 
  -4123.846747879946, 0, 0, 0, 0, 916.410388417766, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  -729.0000000000001, 0, 0, -810., 324., 0, 
  -610.9402589451772, 610.9402589451772, 0, 0, 324., 
  0, -144., 0, 0, 0, 0, 0, 0, 0, 0, -216., 
  432.0000000000001, -288., 64.00000000000001, 0, 0, 
  0
>

   scale < 3.4,3.4,3.4>
   texture {
      pigment {Green }
      finish {
	 phong 1.0
	 phong_size 10
	 ambient 0.3
	 diffuse 0.4
         reflection 0 // 0.2    
      }

   }
rotate<-50,0,0>
translate <0,-1,0>
}
                

#declare flower =

#declare a=1;
#declare b=0.2;
#declare umin  = 0;            //endpoints in the
#declare umax  = 4*pi;             //parametric rectangle
#declare vmin  = 0.001;  
#declare vmax  =  2;
#declare uiter = 40;            //number of steps
#declare viter = 40;
#declare iu    = (umax-umin)/uiter;    //increment per step
#declare iv    = (vmax-vmin)/viter; 

union{
  #declare uu = umin;    
  #while (uu<=umax)                        //outer loop
    #declare vv = vmin;
    #while (vv<=vmax)                      //inner loop
//POINTS      
      #declare x1=a*cos(uu)*sin(vv); //Calculate the
      #declare y1=a*sin(uu)*sin(vv); //four points in
      #declare z1=a*(cos(vv)+log(tan((vv/2))))+b*uu;  //the rectangle defined
      #declare uu=uu+iu;                    //by uu,uu+iu,vv,vv+iv
      #declare x2=a*cos(uu)*sin(vv);//Uses uu and vv because
      #declare y2=a*sin(uu)*sin(vv); //u and v are built in
      #declare z2=a*(cos(vv)+log(tan((vv/2))))+b*uu;              //constants.
      #declare vv=vv+iv;  
      #declare x3=a*cos(uu)*sin(vv);
      #declare y3=a*sin(uu)*sin(vv);
      #declare z3=a*(cos(vv)+log(tan(vv/2)))+b*uu;
      #declare uu=uu-iu;
      #declare x4=a*cos(uu)*sin(vv);
      #declare y4=a*sin(uu)*sin(vv);
      #declare z4=a*(cos(vv)+log(tan(vv/2)))+b*uu;
      #declare vv=vv-iv;
//NORMALS   
      #declare uu=uu+2*iu;                   //Calculate surface normals
      #declare nx1=a*cos(uu)*sin(vv);//to the nine rectangles in
      #declare ny1=a*sin(uu)*sin(vv); //the immediate neighbourhood 
      #declare nz1=a*(cos(vv)+log(tan(vv/2)))+b*uu;
      #declare uu=uu-2*iu; 
      #declare vv=vv+2*iv;
      #declare nx2=a*cos(uu)*sin(vv);
      #declare ny2=a*sin(uu)*sin(vv);
      #declare nz2=a*(cos(vv)+log(tan(vv/2)))+b*uu;
      #declare vv=vv-2*iv; 
      #declare uu=uu-iu;
      #declare nx3=a*cos(uu)*sin(vv);
      #declare ny3=a*sin(uu)*sin(vv);
      #declare nz3=a*(cos(vv)+log(tan(vv/2)))+b*uu;
      #declare uu=uu+iu; 
      #declare vv=vv-iv;
      #declare nx4=a*cos(uu)*sin(vv);
      #declare ny4=a*sin(uu)*sin(vv);
      #declare nz4=a*(cos(vv)+log(abs(tan(vv/2))))+b*uu;
      #declare vv=vv+iv; 
      #declare n1=vcross(<nx2-x4,ny2-y4,nz2-z4>,<nx1-x2,ny1-y2,nz1-z2>);
      #declare n2=vcross(<x4-x3,y4-y3,z4-z3>,<nx2-x4,ny2-y4,nz2-z4>);   
      #declare n3=vcross(<nx3-x1,ny3-y1,nz3-z1>,<nx2-x4,ny2-y4,nz2-z4>);
      #declare n4=vcross(<x3-x2,y3-y2,z3-z2>,<nx1-x2,ny1-y2,nz1-z2>); 
      #declare n5=vcross(<x1-x2,y1-y2,z1-z2>,<x3-x2,y3-y2,z3-z2>); 
      #declare n6=vcross(<nx3-x1,ny3-y1,nz3-z1>,<x4-x1,y4-y1,z4-z1>) ;
      #declare n7=vcross(<nx1-x2,ny1-y2,nz1-z2>,<nx4-x1,ny4-y1,nz4-z1>) ;
      #declare n8=vcross(<nx4-x1,ny4-y1,nz4-z1>,<x1-x2,y1-y2,z1-z2>);   
      #declare n9=vcross(<nx4-x1,ny4-y1,nz4-z1>,<nx3-x1,ny3-y1,nz3-z1>)  ;
//CURVATURE  as difference between normals    
//      #declare ucur = vlength(vnormalize(n6)-vnormalize(n5))/2
//      #declare vcur = vlength(vnormalize(n2)-vnormalize(n5))/2 
//TRIANGLES      
      object{
        smooth_triangle{
          <x1,y1,z1>,n5+n6+n8+n9,
          <x2,y2,z2>,n4+n5+n7+n8,
          <x3,y3,z3>,n1+n2+n4+n5
         }
          texture{ 
          pigment {color rgb   <1,0.1,0.2>
//Fiddle colors for better result             
//             <0.5+ucur*vcur*200,0.5-ucur*vcur*200,ucur/vcur-0.4>
                  }
          finish { ambient 0.2 specular 0.7 roughness 0.05 }
            }
          }
      object{
        smooth_triangle{
          <x1,y1,z1>, n5+n6+n8+n9,  
          <x3,y3,z3>, n1+n2+n4+n5   
          <x4,y4,z4>, n2+n3+n5+n6  
         }
          texture{
        pigment{ color rgb  <1,0.1,0.2> 
//           <0.5+ucur*vcur*200,0.5-ucur*vcur*200 , ucur/vcur-0.4>
               }
        finish { ambient 0.2 specular 0.7 roughness 0.05 }
         }
        }    
    
      #declare vv = vv+iv;
   #end                 //inner loop
   #declare uu = uu+iu;
 #end                   //outer loop
rotate <-90,0,0>     //This is just changing the
rotate <0,90,0>     //coordinate system.
scale 2
} 

#declare i = 0 ;
#declare j = 0 ;
#while (i < 20) 
object {flower 
translate <i*sin(i*pi/4),0,i*cos(i*pi/4)>}
#declare j = 0;
#while (j < 5)
object {boy scale 0.5 rotate<0,j*30,0> 
translate <0, -2-j*2,0> 
translate <i*sin(i*pi/4),0,i*cos(i*pi/4)>}
#declare j = j + 1;
#end
#declare i = i + 1; 
#end               
   

/*
#declare i = 0 ;

#while (i < 20) 

cylinder{-10*y, 0*y, .1 texture { pigment{White}} translate <i*sin(i*pi/4),0,i*cos(i*pi/4)>}

#declare i = i + 1; 
#end */

#declare r1 = seed(2314) ;

#declare inc2 = 46 ;
#declare i = 0 ;
#declare r1 = seed(35) ;

#while (i<inc2) 
  superellipsoid { <.2, .2>
    texture {pigment { White } normal {dents -.5
          turbulence 100 octaves 2 omega 2 lambda rand(r1)
            frequency 500  
    scale <rand(r1)/2,rand(r1)/2,rand(r1)/2>} } // dents crackle
    scale <5/3,1,1>
    translate <0,-9,0>
    rotate <0,i*360/inc2+rand(r1)*5,0>
    translate < 23*sin(2*pi*(i/inc2)), 0, 23*cos(2*pi*(i/inc2))>
  }
  
    superellipsoid { <.2, .2>
    texture {pigment { White } normal {dents -.5  
          turbulence 100 octaves 2 omega 2 lambda rand(r1)
            frequency 500
    scale <rand(r1)/2,rand(r1)/2,rand(r1)/2>} } // dents crackle
    scale <5/3,1,1>
    translate <0,-7,0>
    rotate <0,((i+.5)*360/inc2)+rand(r1)*5,0>
    translate < 23*sin(2*pi*((i+.5)/inc2)), 0, 23*cos(2*pi*((i+.5)/inc2))>
  }
#declare i = i + 1 ;
#end

cylinder // the dirt
{
  0*y,  .1*y, 23 texture { pigment {Brown} normal {bumps .5}}
  translate <0,-10,0>
}
  
//jefferson

#declare jefferson = union {

cylinder {-1*y, 1*y 26
    texture {pigment { White } normal {dents -.5  
          turbulence 100 octaves 2 omega 2 lambda rand(r1)
            frequency 500
    scale <rand(r1)/2,rand(r1)/2,rand(r1)/2>} }
    translate <0,-9,0>
}

cylinder {-1*y, 1*y 24
    texture {pigment { White } normal {dents -.5  
          turbulence 100 octaves 2 omega 2 lambda rand(r1)
            frequency 500
    scale <rand(r1)/2,rand(r1)/2,rand(r1)/2>} }
    translate <0,-7,0>
}

#declare i = 0 ;    
#declare inc3 = 360/13 ;

#while (i < 13)
cylinder {-9*y, 40*y 1.75
    texture {pigment { White } normal {dents -.5  
          turbulence 100 octaves 2 omega 2 lambda rand(r1)
            frequency 500
    scale <rand(r1)/2,rand(r1)/2,rand(r1)/2>} }
    translate < 21*sin(2*2*pi*(i/inc3)), 0, 21*cos(2*2*pi*(i/inc3))>
}

#declare i = i + 1 ;               
#end                     

// create a sphere shape
sphere
{
  <0, 0, 0> 23       
     clipped_by {plane {-y, 0}}
    texture {pigment { White } normal {dents -.5  
          turbulence 100 octaves 2 omega 2 lambda rand(r1)
            frequency 500
    scale <rand(r1)/2,rand(r1)/2,rand(r1)/2>} }     
    translate 40*y
}

// set clipping shape for parent object.
// (parent shape will not extend beyond ClipShape bounds)
//clipped_by { sphere { 0*x, 1.0 } }
               
} // end jefferson

object { jefferson scale <1.6,1.2,1.6>*1.3 translate <0,8,900>}  

#declare Gold_Phong = texture {
	pigment { color rgb <1.0,0.84,0.0> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
}

#declare EPSILON = 1e-10;
#declare xmin  = 0;
#declare xmax  = 6.283185307179586232;
#declare ymin  = 0;
#declare ymax  = 3.141592653589793116;
#declare xiter = 31;
#declare yiter = 31;
#declare ix    = (xmax-xmin)/(xiter-1.0);
#declare iy    = (ymax-ymin)/(yiter-1.0);
#declare deltax = (xmax-xmin)/((xiter-1.0)*4.0);
#declare deltay = (ymax-ymin)/((yiter-1.0)*4.0);
#macro point(xx,yy)
#local T  = xx;
#local P  = yy;
#local R  = 0;
#local ro  = 2.5-sqrt((1+pow(sin(2*P),2))*(1+pow(sin(3*T),2)));
#local theta  = T;
#local phi  = P;
    #declare zzz=-ro*sin(phi)*cos(theta);
    #declare xxx=ro*sin(phi)*sin(theta);
    #declare yyy=ro*cos(phi);
#end
#macro surface(xx,yy)
    point(xx,yy)
    #local xn=xxx;
    #local yn=yyy;
    #local zn=zzz;
    #declare xx=xx+deltax;
    point(xx,yy)
    #local xp=xxx;
    #local yp=yyy;
    #local zp=zzz;
    #declare xx=xx-deltax;
    #declare yy=yy+deltay;
    point(xx,yy)
    #local xq=xxx;
    #local yq=yyy;
    #local zq=zzz;
    #declare yy=yy-deltay;
    #local vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>);
    #declare nn=vnormalize(vn);
    #declare pp=<xn,yn,zn>;
#end
#declare eureka_bubble = mesh {
  #declare xx = xmin;
  #while (xx<xmax)                        //outer loop
    #declare yy = ymin;
    #while (yy<ymax)                      //inner loop
//POINTS
    surface(xx,yy)
    #declare n1=nn;
    #declare p1=pp;

    #declare yy=yy+iy;
    surface(xx,yy)
    #declare n2=nn;
    #declare p2=pp;

    #declare xx=xx+ix;
    surface(xx,yy)
    #declare n3=nn;
    #declare p3=pp;

    #declare yy=yy-iy;
    surface(xx,yy)
    #declare n4=nn;
    #declare p4=pp;

    #declare xx=xx-ix;
#if(!(p1.x=p2.x&p1.y=p2.y&p1.z=p2.z)|(p2.x=p3.x&p2.y=p3.y&p2.z=p3.z)|(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z))
        smooth_triangle {
          p1,n1,
          p2,n2,
          p3,n3
         }

#end
#if(!(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z)|(p3.x=p4.x&p3.y=p4.y&p3.z=p4.z)|(p1.x=p4.x&p1.y=p4.y&p1.z=p4.z))
        smooth_triangle{
          p1,n1,
          p3,n3,
          p4,n4
         }
#end

      #declare yy = yy+iy;
   #end                 //inner loop
   #declare xx = xx+ix;
 #end                   //outer loop
	translate <0,0,0>
	scale 1.0/3
}

  
#declare stalk = union {
#declare i = -200;
#while (i < 0 )

sphere
{
  <0,0,0> 1 
  texture {pigment {radial frequency 8} finish{specular 1}} 
  scale .5
  translate < 0,.125*i, 0>  
}
#declare i = i + 1 ;
#end

#declare i = 0 ;
#while (i < 135)         
sphere
{
  <0,0,0> 1 
  texture {pigment {radial frequency 8} finish{specular 1}} 
  scale .5-i/400
  translate <3* cos(2*pi*i/360) ,5* sin(2*pi*i/360), 0>
  translate -3*x
}
#declare i = i + 1 ;
#end                    
}   



#declare leaf2 =
poly { 10<
0, 0, 0, 0, -54.8328, 0, 0, 375.83, 0, 11.0902, 0, 
 0, 0, 0, 0, 0, 0, 0, 0, 0, 485.495, 0, 0, -3209.97, 
 0, 44.3607, 0, 0, 0, 0, -806.492, 0, 44.3607, 0, 
 -30.6525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, -806.492, 0, 0, 4814.95, 0, 
 66.541, 0, 0, 0, 0, 4814.95, 0, 133.082, 0, 
 -91.9574, 0, 0, 0, 0, 0, 0, 485.495, 0, 66.541, 0, 
 -91.9574, 0, 29.6525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, 0, 0, 375.83, 0, 0, -3209.97, 
 0, 44.3607, 0, 0, 0, 0, 4814.95, 0, 133.082, 0, 
 -91.9574, 0, 0, 0, 0, 0, 0, -3209.97, 0, 133.082, 0, 
 -183.915, 0, 59.305, 0, 0, 0, 0, 0, 0, 0, 0, 
 -54.8328, 0, 44.3607, 0, -91.9574, 0, 59.305, 0, 
 -11.7082, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -54.8328, 0, 11.0902, 
 0, 0, 0, 0, 485.495, 0, 44.3607, 0, -30.6525, 0, 0, 
 0, 0, 0, 0, -806.492, 0, 66.541, 0, -91.9574, 0, 
 29.6525, 0, 0, 0, 0, 0, 0, 0, 0, 375.83, 0, 44.3607, 
 0, -91.9574, 0, 59.305, 0, -11.7082, 0, 0, 0, 0, 0, 
 0, 0, 0, 0, 0, 0, 0, 11.0902, 0, -30.6525, 0, 
 29.6525, 0, -11.7082, 0, 1.61803
 >

   scale < 18,18,18>
   texture {
      pigment {color<1,.4,1> }
      finish {
	 phong 1.0
	 phong_size 10
	 ambient 0.4
	 diffuse 0.4
         reflection 0.2    
      }

   }
clipped_by{sphere{<0,0,0>40}}
rotate<0,0,0>
} 



#declare leaf3 =
poly { 3<
        0, -5, -5, 0, -5, 0, 2, -5, 2, 0, 0, -5, 0, -5, 2, 
        0, 0, 0, 0, 0>




   scale < 20,20,20>
   texture {
      pigment {color rgb<0.1,0.8,0.3> }
      finish {
	 phong 1.0
	 phong_size 10
	 ambient 0.4
	 diffuse 0.4
         reflection 0.2    
      }

   }
clipped_by{sphere{<0,0,0>40}}
rotate<0,0,0>
}


#declare branch = union {
object {stalk rotate 0*y}
object {leaf3 
        scale <2,.5,2>/15}
object {eureka_bubble  
 texture { Gold_Phong }
 rotate <0,36*clock,0>  scale 3
  translate <3* cos(2*pi*135/360) ,5* sin(2*pi*135/360), 0>
  translate -3*x translate -1.5*y
  }
}
  
#declare tree = union {

object {branch translate <0,-4,0>}
object {branch rotate y*1*360/5 translate <0,0,0> }
object {branch rotate y*2*360/5 translate <0,4,0> }
object {branch rotate y*3*360/5 translate <0,8,0> }
object {branch rotate y*4*360/5 translate <0,12,0>}

}
  
//tree

#declare i = 0 ;
#declare j = 0 ;
#while (j < 5) 
#while ( i < 15 )
object {tree 
        translate <-40 -25*j +3*i,0, -40+25*i>
}        
#declare i = i + 1 ;
#end
#declare i = 0 ;
#declare j = j + 1 ;
#end

/*
#declare i = 0 ;
#declare j = 0 ;
#while (j < 5) 
#while ( i < 15 )
cylinder{-10*y, 10*y, .1 texture { pigment{White}}  
        translate <-40 -25*j +3*i,0, -40+25*i>
}        
#declare i = i + 1 ;
#end
#declare i = 0 ;
#declare j = j + 1 ;
#end
  */
  
#declare disp =<21,0,-30> ;

#declare stalk2 = union {
#declare i = -10 ;
#while (i<15)
superellipsoid
{
  < .5, .25> texture {pigment{Yellow} normal {bumps 1}} rotate 15*i*y translate <0,i*1.9,0>
}
superellipsoid
{
  < .5, .25> texture {pigment{Yellow} normal {bumps 2}} rotate 15*i*y rotate 60*y translate <0,i*1.9,0>
}
superellipsoid
{
  < .5, .25> texture {pigment{Yellow} normal {bumps 3}} rotate 15*i*y rotate 120*y translate <0,i*1.9,0>
}

#declare i = i + 1;
#end

}

/*

poly { 5 <
-0.2406003820030181, 0, 0.3717480344601841, 1, 
  2.406003820030182, 0, 0, 0, 0, 0, 0, 
  0.7434960689203692, 2, 0, 0, 0, -8.0157448362892, 
  3.854101966249685, 1.662507751109813, -2, 
  -1.203001910015091, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0.3717480344601846, 1, 0, 0, 0, 
  -8.0157448362892, 3.854101966249685, 
  1.662507751109813, -2., 0, 0, 0, 0, 0, 
  0.7627236552150887, 3.713525491562422, 
  3.203737196228837, -3.854101966249685, 
  -0.831253875554907, 1>

 rotate<90,15,0>
   scale < 11,11,11>
   texture {
      pigment {//  Plum }
       gradient y       //this is the PATTERN_TYPE
       color_map {
        [0.0  color Blue]
        [0.3  color Yellow]
      //  [0.6  color Blue]
      //  [0.6  color Green]
        [1.0  color Red]
                  }
           }
       finish {
	 phong 1.0
	 phong_size 10
	 ambient 0.4
	 diffuse 0.4
         reflection 0.2    
           }
  scale 40
   }
clipped_by{sphere{<0,0,0>36}}

}  
  
*/

#declare root = poly { 5
<
-0.2406003820030181, 0, 0.3717480344601841, 1, 
  2.406003820030182, 0, 0, 0, 0, 0, 0, 
  0.7434960689203692, 2, 0, 0, 0, -8.0157448362892, 
  3.854101966249685, 1.662507751109813, -2, 
  -1.203001910015091, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0.3717480344601846, 1, 0, 0, 0, 
  -8.0157448362892, 3.854101966249685, 
  1.662507751109813, -2., 0, 0, 0, 0, 0, 
  0.7627236552150887, 3.713525491562422, 
  3.203737196228837, -3.854101966249685, 
  -0.831253875554907, 1
>

 rotate<90,15,0>
   scale < 11,11,11>
   texture {
      pigment {//  Plum }
       gradient y       //this is the PATTERN_TYPE
       color_map {
        [0.0  color <.9,.2,.9>]
        [0.3  color <.9,.8,.1>]
        [1.0  color Red]
                  }
           } normal { bumps 1} */
       finish {
	 phong 1.0
	 phong_size 10
           }
  scale 40
   }
clipped_by{sphere{<0,0,0>36}}

} 

object { root scale <1/10,1/7,1/10> translate -8.1*y translate disp }

object {stalk2 scale <.7, 5/3, .7> translate disp }

// cylinder { -10*y, 20*y, .5 texture {pigment{White}}
//     translate disp
//}  

  
object {leaf2 scale 1/10 scale <3,.75,3> rotate 20*y
     translate disp   translate 20*y
}

object {leaf2 scale 1/10 scale <3,.75,3> rotate 40*y
     translate disp   translate 15*y
}

object {leaf2 scale 1/10 scale <3,.75,3> rotate 60*y
     translate disp   translate 10*y
}

object {leaf2 scale 1/10 scale <3,.75,3> rotate 80*y
     translate disp   translate 5*y
}

object {leaf2 scale 1/10 scale <3,.75,3> rotate 100*y
     translate disp   translate 0*y
}



  
#declare shroom = union {
cone
{
  0*y,  0.4,
  -1*y, 1.0
texture {Grey_Phong} scale <1,4,1> translate 0*y
}

// File exported by Eureka 2.12. Designed by Archimedium 1999
#version 3.1;
#declare Gold_Phong = texture {
	pigment { color rgb <1.0,0.84,0.0> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
}

#declare EPSILON = 1e-10;
#declare xmin  = 0;
#declare xmax  = 6.283185307179586232;
#declare ymin  = 0;
#declare ymax  = 3.141592653589793116;
#declare xiter = 21;
#declare yiter = 31;
#declare ix    = (xmax-xmin)/(xiter-1.0);
#declare iy    = (ymax-ymin)/(yiter-1.0);
#declare deltax = (xmax-xmin)/((xiter-1.0)*4.0);
#declare deltay = (ymax-ymin)/((yiter-1.0)*4.0);
#macro point(xx,yy)
#local T  = xx;
#local P  = yy;
#local R  = 0;
#local ro  = (1+sin(P))*sqrt(1+pow(cos(5*T),2));
#local theta  = T;
#local phi  = P;
    #declare zzz=-ro*sin(phi)*cos(theta);
    #declare xxx=ro*sin(phi)*sin(theta);
    #declare yyy=ro*cos(phi);
#end
#macro surface(xx,yy)
    point(xx,yy)
    #local xn=xxx;
    #local yn=yyy;
    #local zn=zzz;
    #declare xx=xx+deltax;
    point(xx,yy)
    #local xp=xxx;
    #local yp=yyy;
    #local zp=zzz;
    #declare xx=xx-deltax;
    #declare yy=yy+deltay;
    point(xx,yy)
    #local xq=xxx;
    #local yq=yyy;
    #local zq=zzz;
    #declare yy=yy-deltay;
    #local vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>);
    #declare nn=vnormalize(vn);
    #declare pp=<xn,yn,zn>;
#end
#declare eureka_pump = mesh {
  #declare xx = xmin;
  #while (xx<xmax)                        //outer loop
    #declare yy = ymin;
    #while (yy<ymax)                      //inner loop
//POINTS
    surface(xx,yy)
    #declare n1=nn;
    #declare p1=pp;

    #declare yy=yy+iy;
    surface(xx,yy)
    #declare n2=nn;
    #declare p2=pp;

    #declare xx=xx+ix;
    surface(xx,yy)
    #declare n3=nn;
    #declare p3=pp;

    #declare yy=yy-iy;
    surface(xx,yy)
    #declare n4=nn;
    #declare p4=pp;

    #declare xx=xx-ix;
#if(!(p1.x=p2.x&p1.y=p2.y&p1.z=p2.z)|(p2.x=p3.x&p2.y=p3.y&p2.z=p3.z)|(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z))
        smooth_triangle {
          p1,n1,
          p2,n2,
          p3,n3
         }

#end
#if(!(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z)|(p3.x=p4.x&p3.y=p4.y&p3.z=p4.z)|(p1.x=p4.x&p1.y=p4.y&p1.z=p4.z))
        smooth_triangle{
          p1,n1,
          p3,n3,
          p4,n4
         }
#end

      #declare yy = yy+iy;
   #end                 //inner loop
   #declare xx = xx+ix;
 #end                   //outer loop
	translate <0,0,0>
	scale 1.0/5.65686
}

object {
	eureka_pump
 //no_shadow
 texture { Orange_Phong }
 rotate <0,36*clock,0> scale 5
 }
 }

#declare inc3 = 10 ;
#declare i = 0 ;
#while (i<inc3) 
object {shroom
    translate <0,-7,0>
    rotate <0,i*360/inc3,0>
    translate < 28*sin(2*pi*(i/inc3)), 0, 28*cos(2*pi*(i/inc3))>
  }
object {shroom
    translate <0,-7,0>
    rotate <0,(i+.5)*360/inc3,0>
    translate < 32*sin(2*pi*((i+.5)/inc3)), 0, 32*cos(2*pi*((i+.5)/inc3))>
  }
#declare i = i + 1 ;
#end



// File exported by Eureka 2.12. Designed by Archimedium 1999
#version 3.1;
#declare Green_Phong = texture {
	pigment { color rgb <.1,1,0.2> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 10.0 }
}

#declare EPSILON = 1e-10;
#declare xmin  = 0;
#declare xmax  = 3.141592653589793116;
#declare ymin  = 0;
#declare ymax  = 6.283185307179586232;
#declare xiter = 11;
#declare yiter = 61;
#declare ix    = (xmax-xmin)/(xiter-1.0);
#declare iy    = (ymax-ymin)/(yiter-1.0);
#declare deltax = (xmax-xmin)/((xiter-1.0)*4.0);
#declare deltay = (ymax-ymin)/((yiter-1.0)*4.0);
#macro point(xx,yy)
#local X  = xx;
#local Y  = yy;
#local R  = sqrt(X*X+Y*Y);
#if(abs(X)>EPSILON&abs(Y)>EPSILON)
#local T  = atan2(Y,X);
#else
#local T  = 0;
#end
#local absc  = abs((3+cos(Y)*cos(X))*cos(Y));
#local ordo  = (3+cos(Y)*cos(X))*sin(Y);
#local cote  = cos(Y)*sin(X);
    #declare zzz=-absc;
    #declare xxx=ordo;
    #declare yyy=cote;
#end
#macro surface(xx,yy)
    point(xx,yy)
    #local xn=xxx;
    #local yn=yyy;
    #local zn=zzz;
    #declare xx=xx+deltax;
    point(xx,yy)
    #local xp=xxx;
    #local yp=yyy;
    #local zp=zzz;
    #declare xx=xx-deltax;
    #declare yy=yy+deltay;
    point(xx,yy)
    #local xq=xxx;
    #local yq=yyy;
    #local zq=zzz;
    #declare yy=yy-deltay;
    #local vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>);
    #declare nn=vnormalize(vn);
    #declare pp=<xn,yn,zn>;
#end
#declare eureka_croiss = mesh {
  #declare xx = xmin;
  #while (xx<xmax)                        //outer loop
    #declare yy = ymin;
    #while (yy<ymax)                      //inner loop
//POINTS
    surface(xx,yy)
    #declare n1=nn;
    #declare p1=pp;

    #declare yy=yy+iy;
    surface(xx,yy)
    #declare n2=nn;
    #declare p2=pp;

    #declare xx=xx+ix;
    surface(xx,yy)
    #declare n3=nn;
    #declare p3=pp;

    #declare yy=yy-iy;
    surface(xx,yy)
    #declare n4=nn;
    #declare p4=pp;

    #declare xx=xx-ix;
#if(!(p1.x=p2.x&p1.y=p2.y&p1.z=p2.z)|(p2.x=p3.x&p2.y=p3.y&p2.z=p3.z)|(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z))
        smooth_triangle {
          p1,n1,
          p2,n2,
          p3,n3
         }

#end
#if(!(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z)|(p3.x=p4.x&p3.y=p4.y&p3.z=p4.z)|(p1.x=p4.x&p1.y=p4.y&p1.z=p4.z))
        smooth_triangle{
          p1,n1,
          p3,n3,
          p4,n4
         }
#end

      #declare yy = yy+iy;
   #end                 //inner loop
   #declare xx = xx+ix;
 #end                   //outer loop
	translate <0,0,2>
	scale 1.0/6.29412
}

#declare caldon = union {
object {
	eureka_croiss
 texture { Green_Phong }
 scale 10  
 rotate 90*y
 rotate 90*x 
 translate 2*x
 }

object {
	eureka_croiss
 texture { Green_Phong }
 scale 10
 rotate 90*y
 rotate 90*x 
 translate 2*x
 rotate 180*y
 }

}

#declare caldon4 = union {

#declare caldon3 = union {
object {caldon rotate 0*y}
object {caldon rotate 60*y}
object {caldon rotate 120*y}
}

object {caldon3 scale <1.5,1,1.5> translate -8.8*y}

#declare i = 0 ;
#while (i<1000)

sphere { 0, .3 texture {Green_Phong} translate <0, -10+i*.03 , 0> }

#declare i = i + 1 ;
#end

#declare thing = 
poly { 4<
    0, 25, 25, 0, 50, -125, 0, 50, 0, 0, 25, -125, 0, 
   -125, 60, -4, 25, 0, -4, 0, 0, 25, 0, 50, 0, 0, 25, 
    0, -4, 0, 0, 0, 0, 0, 0>


   scale < 20,20,20>
   texture {
      pigment { color <0,0,1> }
	normal { ripples 0.5 scale 0.1 }      
      finish {
	 phong 1.0
	 phong_size 10
      }

   }
clipped_by{sphere{<0,0,0>60}}
rotate<0,70,0>
}                

object {thing scale 1/9 translate 20*y}

}

#declare i = 0 ;
#declare j = 0 ;

#while (j < 5)
#while (i < 13)


object {caldon4 scale .8 translate <40 + 45*j,0,-25+45*i> }

//cylinder{-10*y, 20*y, 1 texture{pigment{color White}} translate <40 + 45*j,0,-25+45*i>}

#declare i = i + 1 ;
#end // i
#declare i = 0 ;
#declare j = j + 1 ;
#end // j

#declare r1 = seed(21) ;
#declare i = 0 ;
#while (i < 300)

sphere {0, 10 translate<0 + (rand(r1)-.5)*10000, 50 + rand(r1)*1000,5000+rand(r1)*5000> 
texture{pigment{color <.5+rand(r1),.5+rand(r1),.5+rand(r1)>}}}

#declare i = i + 1 ;
#end

camera
{
  location <0,.5,-4>*20 // <4.0, 0.5, -2.0>*10     // 0,.5,-4  *20
  direction 1.5*z
  right     16/9*x // 4/3*x
  look_at   <0.0, 0.0,  0.0>
}