//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// basket bin
#include "enter"

#ifndef (BASKET_INC)
  #declare BASKET_INC = 1 ;
  
  #include "metrics.inc"
  #include "jbgtext.inc"
  
  #declare Basket = union {
    union {
      union {
	sphere { 1*m*x, 7*cm scale <1, 0.5, 1> translate 2.3*m*y }
	cylinder { 0, 2.3*m*y, 7*cm translate 1*m*x }
	difference {
	  torus {
	    1*m, 7*cm
	    rotate 90*x
	  }
	  plane { -y, 0 }
	  plane { y, 0 rotate -10*z }
	}
	rotate 10*z
	translate -1*m*x+1*m*y
      }
      cylinder { 0, 1*m*y, 7*cm }
      rotate 110*y
      texture { TGrid }
    }
    box {
      <6, -60, -90>*cm, <10, 70, 90>*cm      
      translate 2.3*m*y+1*m*x
      rotate 10*z
      translate -1*m*x+1*m*y
      rotate 110*y
      
      texture { TPanel }
    }
    union {
      torus { 30*cm, 1*cm }
      box { -<35, 1, 5>*cm, <-30, 1, 5>*cm }
      translate 34*cm*x
      rotate -40*z
      rotate 20*x
      translate 1.9*m*y+1.06*m*x
      rotate 10*z
      translate -1*m*x+1*m*y
      rotate 110*y
      
      texture { TRing }
    }
  }

  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      location <0, 2, -7>*m
      look_at  <0, 2, 0>*m
      angle 40
      //rotate 70*y
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object { Basket }
  #end
#end
#include "leave"