//
// grid object for Concrete Garden
// (c) 1999 by J. Berger
//
#include "enter"
#ifndef (GRID_INC)
  #declare GRID_INC = 1 ;

  #include "metrics.inc"
  //#include "bw.inc"
  #include "jbgtext.inc"
  
  #local Panel = union {
    cylinder { <-0.68, 2, 0>*m, <0.68, 2, 0>*m, 3*cm }
    cylinder { <-0.68, 0.05, 0>*m, <0.68, 0.05, 0>*m, 3*cm }
    cylinder { <-0.68, 0.05, 0>*m, <-0.68, 2, 0>*m, 3*cm }
    cylinder { <0.68, 0.05, 0>*m, <0.68, 2, 0>*m, 3*cm }
    sphere { <-0.68, 2, 0>*m, 3*cm }
    sphere { <0.68, 2, 0>*m, 3*cm }
    sphere { <-0.68, 0.05, 0>*m, 3*cm }
    sphere { <0.68, 0.05, 0>*m, 3*cm }
    
    intersection {
      union {
	#local i = -0.68*m ;
	#while (i < 2.68*m)
	  cylinder { <i, 0, -2*mm>, <i - 2*m, 2*m, -2*mm>, 2*mm }
	  cylinder { <i - 2*m, 0, 2*mm>, <i, 2*m, 2*mm>, 2*mm }
	  #local i = i + 7.16*cm ;
	#end
      }
      box { <-0.68*m, 5*cm, -4*mm>, <0.68*m, 2*m, 4*mm> }
      bounded_by { box { <-0.68*m, 5*cm, -4*mm>, <0.68*m, 2*m, 4*mm> } }
    }
  }

  #local Right = union {
    cylinder { <-5, 2, 0>*m, <8, 2, 0>*m, 3*cm }
    sphere   { <-5, 2, 0>*m, 3*cm }
    #local i = -5 ;
    #while (i < 8)
      cylinder { <i, 0, 0>*m, <i, 2, 0>*m, 3*cm }
      #local i = i + 2 ;
    #end
    
    intersection {
      union {
	#local i = -5*m ;
	#while (i < 10*m)
	  cylinder { <i, 0, -2*mm>, <i - 2*m, 2*m, -2*mm>, 2*mm }
	  cylinder { <i - 2*m, 0, 2*mm>, <i, 2*m, 2*mm>, 2*mm }
	  #local i = i + 7*cm ;
	#end
      }
      box { <-5*m, 0, -4*mm>, <8*m, 2*m, 4*mm> }
      bounded_by { box { <-5*m, 0, -4*mm>, <8*m, 2*m, 4*mm> } }
    }
  }
  
  #local Left = union {
    cylinder { <-8, 2, 0>*m, <-6.5, 2, 0>*m, 3*cm }
    sphere   { <-6.5, 2, 0>*m, 3*cm }
    #local i = -6.5 ;
    #while (i > -8)
      cylinder { <i, 0, 0>*m, <i, 2, 0>*m, 3*cm }
      #local i = i - 2 ;
    #end
    
    intersection {
      union {
	#local i = -4.5*m ;
	#while (i > -8*m)
	  cylinder { <i, 0, -2*mm>, <i - 2*m, 2*m, -2*mm>, 2*mm }
	  cylinder { <i - 2*m, 0, 2*mm>, <i, 2*m, 2*mm>, 2*mm }
	  #local i = i - 7*cm ;
	#end
      }
      box { <-6.5*m, 0, -4*mm>, <-8*m, 2*m, 4*mm> }
      bounded_by { box { <-6.5*m, 0, -4*mm>, <-8*m, 2*m, 4*mm> } }
    }
  }
  
  #declare Grid = union {
    object { Right }
    object { Left }
    object {
      Panel
      translate -2/3*m*y+0.75*m*x
      rotate -10*x
      rotate 30*y
      translate 2/3*m*y-6.5*m*x
    }
    
    //pigment { color bw(<0.5, 0.5, 0.5>) }
    texture { TGrid }
  }
  
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      location <0, 1, -15>*m
      look_at  <0, 1, 0>*m
      angle 40
      rotate 70*y
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object { Grid }
  #end
#end
#include "leave"
