//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// gorund texture
#include "enter"

#ifndef (GROUND_INC)
  #declare GROUND_INC = 1 ;
  
  #include "metrics.inc"
  #include "bw.inc"

  #declare NBumps = normal {
    granite 2
    slope_map {
      [ 0.0 <0.0, 0.0> ]
      [ 0.2 <0.0, 0.0> ]
      [ 1.0 <1.0, 0.0> ]
    }
    scale 1*cm
  }
  
  #declare NBranch = normal {
    planar
    normal_map {
      [ 0.5 bumps 0 ]
      [ 0.5 
	gradient x
	slope_map {
	  [ 0.00 <0.0, 0.0> ]
	  [ 0.02 <1.0, 2.0> ]
	  [ 0.02 <1.0,-2.0> ]
	  [ 0.50 <0.0, 0.0> ]
	}
	triangle_wave
	turbulence 0.05 octaves 9 lambda 1.5 omega 0.9
	translate 1*y
	rotate -90*z
      ]
    }
    scale 1*m
    rotate 90*z
    rotate 90*y
  }

  #macro MBranch (l)
    cylindrical
    normal_map {
      [ 0.0 bumps 0.0 ]
      [ 0.5 NBranch scale 1/l ]
    }
    scale l
  #end
  
  #declare NStar = normal {
    radial
    normal_map {
      [ 0.000 MBranch (80*cm) ]
      [ 0.050 MBranch (80*cm) ]
      [ 0.117 MBranch (50*cm) rotate 60*y ]
      [ 0.217 MBranch (50*cm) rotate 60*y ]
      [ 0.283 MBranch (75*cm) rotate 120*y ]
      [ 0.383 MBranch (75*cm) rotate 120*y ]
      [ 0.450 MBranch (40*cm) ]
      [ 0.550 MBranch (40*cm) ]
      [ 0.617 MBranch (75*cm) rotate 60*y ]
      [ 0.717 MBranch (75*cm) rotate 60*y ]
      [ 0.783 MBranch (45*cm) rotate 120*y ]
      [ 0.883 MBranch (45*cm) rotate 120*y ]
      [ 0.950 MBranch (80*cm) ]
    }
  }
  
  #declare NHoles = normal {
    bozo 1
    slope_map {
      [ 0.00 <0.0, 0> ]
      [ 0.03 <0.0, 0> ]
      [ 0.03 <0.0, 4> ]
      [ 0.18 <1.0, 0> ]
      [ 0.50 <0.5, 0> ]
      [ 1.00 <1.0, 0> ]
    }
    turbulence 0.3
    scale 50*cm
    translate -x*1.5*m
  }
  
  #declare NGlobal = normal {
    cylindrical
    normal_map {
      [ 0.00 NHoles scale 1/(80*cm) ]
      [ 0.00 NStar scale 1/(80*cm) ]
      [ 0.92 NStar scale 1/(80*cm) ]
      [ 0.92 cylindrical -10 ]
    }
    scale 80*cm
  }
  
  #declare NGround = normal {
    average
    normal_map {
      [ 3.0 NGlobal ]
      [ 1.0 NBumps ]
    }
  }
  
  #declare CMMacadam = color_map {
    [ 0.0 color bwcol (<0.9, 0.9, 0.7>) transmit 0.9 ]
    [ 0.1 color bwcol (<0.9, 0.9, 0.7>/2) transmit 0.9 ]
    [ 1.0 color rgbt <0, 0, 0, 1> ]
  }
  
  #declare CMMacadam2 = color_map {
    [ 0.0 color bwcol (<0.9, 0.9, 0.7>) transmit 0.9 ]
    [ 0.2 color bwcol (<0.9, 0.9, 0.7>/2) transmit 0.95 ]
    [ 1.0 color rgbt <0, 0, 0, 1> ]
  }
  
  #declare TMacadam = texture {
    pigment { color bwcol (<0.05, 0.06, 0.1>) }
    normal { NGround }
    finish { specular 0.25 diffuse 0.6 ambient 0.4 }
  }
  texture {
    pigment {
      bozo 
      color_map { CMMacadam }
      turbulence 1 omega 0.25 lambda 1.5 octaves 5
      scale 1*m
    }
    normal { NGround }
    finish { specular 0.1 }
  }
  texture {
    pigment {
      granite
      color_map { CMMacadam2 }
      turbulence 1 omega 0.25 lambda 1.5 octaves 5
      scale 50*cm
    }
    normal { NGround }
    finish { specular 0.1 }
  }
  
  #declare CMHoles = color_map {
    [ 0.0 color bwcol(<0.05, 0.06, 0.10>) transmit 0.4 ]
    [ 1.0 color bwcol(<0.09, 0.10, 0.11>) transmit 0.8 ]
  }
  
  #declare THoles = texture {
    pigment {
      granite
      color_map {
	[ 0.0 color bwcol (<0.70, 0.50, 0.5>) ]
	[ 0.1 color bwcol (<0.70, 0.70, 0.6>) ]
	[ 0.7 color bwcol (<0.50, 0.50, 0.1>) ]
	[ 1.0 color bwcol (<0.05, 0.06, 0.1>) ]
      }
    }
    normal { granite 0.5 }
    finish { specular 0.1 }
    scale 0.5*cm
  }
  texture {
    pigment {
      bozo
      color_map { CMHoles }
    }
    normal { granite 0.5 scale 0.1 }
    scale 5*cm
  }
  
  #declare TGround = texture {
    cylindrical
    texture_map {
      [ 0.00
	bozo
	texture_map {
	  [ 0.03 THoles   ]
	  [ 0.03 TMacadam ]
	}
	turbulence 0.3
	scale 50*cm
	translate -x*1.5*m
	warp { reset_children }
      ]
      [ 0.01 TMacadam ]
    }
    scale 80*cm
    warp { reset_children }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      location <1, 0.5, -2.7>*m
      look_at  <-13, 1.3, 22.8>*m
      angle 40
      //rotate 70*y
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    plane {
      y, 0
      texture { TGround }
    }
  #end
#end
#include "leave"
