//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// houses
#include "enter"

#ifndef (HOUSE3_INC)
  #declare HOUSE3_INC = 1 ;
  
  #include "metrics.inc"
  #include "bw.inc"
  #include "jbgtext.inc"
  #include "mwindow.pov"
  
  #declare House3 = union {
    difference {
      box { -<6.5, 1, 12.5>*m, <6.5, 15.5, 12.5>*m }
      box { -<6, 2, 12>*m, <6, 15, 12>*m texture { TInside } }

      #local i=0 ;					    // front windows
      #while (i<6)
        #local j=0 ;    
        #while (j<4)
          box { <-5.75+j*3, 0.7+i*2.5, -13>*m, <-3.25+j*3, 2.1+i*2.5, -11>*m }
          #local j = j + 1 ;
        #end
      #local i = i + 1 ;
      #end

      #local i=0 ;					    // side windows
      #while (i<6)
        #local j=0 ;    
        #while (j<8)
          box { <-5, 0.7+i*2.5, -11.75+j*3>*m, <-7, 2.1+i*2.5, -9.25+j*3>*m }
          #local j = j + 1 ;
        #end
      #local i = i + 1 ;
      #end
    }
    
    union {						    // floors
      #local i = 1 ;
      #while (i < 6)
	box { -<6.2, 0.1, 12.2>*m, <6.2, 0.0, 12.2>*m translate 2.5*m*i*y }
	#local i = i + 1 ;
      #end
      box {						    // inside walls
	-<6.2, 1.0, 9.02>*m, <6.2, 15.2, -8.98>*m
      }
      box { -<3.02, 1.0, 12.2>*m, <-2.98, 15.2, 12.2>*m }
      texture { TInside }
    }
    
    box {						    // roof
      <-6.6, 15.4, -12.6>*m, <6.6, 15.7, 12.6>*m
    }

    #local mySeed = seed (1234) ;			    // front windows
    #local xL = 1.25*m ;
    #local yL = 1.4*m ;
    #local i=0 ;
    #while (i<6)
      union {
	#local j=0 ;    
	#while (j<4)
	  union {
	    object { mWindow (3,xL,yL,4*cm,10*cm,4*cm,1*cm,0,0,rand(mySeed)/2,0,0.5,0.1,txtFen1,txtFen2,txtVit1) translate 20*cm*z } 
	    object { mBalcony (1,xL+5*cm,yL/3,20*cm,3*cm,12*cm,0,3,txtBalcon1) }
	    object { mShutter (6, xL*0.9, yL, (rand (mySeed)*0.8+0.1)*yL, 4*cm, 0, 0, 0, 0, 0, 0, mySeed, 1*cm, txtV2) }
	    object { mWindowCase (4,    xL, yL, 10*cm, 10*cm, 5*cm,   10*cm, 0,     0,     15*cm,   13*cm,   TGrayStone, TSlate) }
	    //                    type, xF, yF, zF,    eF,    zRelief, eF2,   yToit, eToit, yBalcon, zBalcon, ... 
	    bounded_by { box { <-xL-15*cm, -10*cm, -22*cm> <xL+15*cm, yL+10*cm, 30*cm> } }
	    translate <-5.75+j*3+xL/m, 0.7+i*2.5, -12.5>*m
	  }
	  #local j = j + 1 ;
	#end
	bounded_by { box { <-5.9, 0.6+i*2.5, -12.72>*m, <5.9, 2.2+i*2.5, -12.2>*m } }
      }
    #local i = i + 1 ;
    #end
    
                                			    // side windows
    #local xL = 1.25*m ;
    #local yL = 1.4*m ;
    #local i=0 ;
    #while (i<6)
      union {
	#local j=0 ;    
	#while (j<8)
	  union {
	    object { mWindow (3,xL,yL,4*cm,10*cm,4*cm,1*cm,0,0,rand(mySeed)/2,0,0.5,0.1,txtFen1,txtFen2,txtVit1) translate 20*cm*z } 
	    object { mBalcony (1,xL+5*cm,yL/3,20*cm,3*cm,12*cm,0,3,txtBalcon1) }
	    object { mWindowCase (4,    xL, yL, 10*cm, 10*cm, 5*cm,   10*cm, 0,     0,     15*cm,   13*cm,   TGrayStone, TSlate) }
	    //                    type, xF, yF, zF,    eF,    zRelief, eF2,   yToit, eToit, yBalcon, zBalcon, ... 
	    object { mShutter (6, xL*0.9, yL, (rand (mySeed)*0.8+0.1)*yL, 4*cm, 0, 0, 0, 0, 0, 0, mySeed, 1*cm, txtV2) }
	    bounded_by { box { <-xL-15*cm, -10*cm, -22*cm> <xL+15*cm, yL+10*cm, 30*cm> } }
	    translate <-11.75+j*3+xL/m, 0.7+i*2.5, -6.5>*m
	    rotate 90*y
	  }
	  #local j = j + 1 ;
	#end
	bounded_by { box { <-6.72, 0.6+i*2.5, 11.9>*m, <-6.2, 2.2+i*2.5, -11.9>*m } }
      }
    #local i = i + 1 ;
    #end
    
    texture { TPaint }
  }
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    background { color bwcol (Blue/2+White/2) }
    camera {
      location <0, 6, -50>*m
      look_at  <0, 6, 0>*m
      angle 40
      rotate 40*y
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, 1000>*m
      color rgb 1/4
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object {
      House3
    }
  #end
#end

#include "leave"