//
// Concrete garden: entry for the irtc, november-december 1999
// (c) 1999 by J. Berger
//
// street lamp
#include "enter"

#ifndef (LAMP_INC)
  #declare LAMP_INC = 1 ;
  
  #include "metrics.inc"
  #include "bw.inc"
  #include "jbgtext.inc"

  #declare StreetLamp = union {
    cylinder { 0, 4*y*m, 5*cm }
    intersection {
      torus { 1.5*m, 5*cm }
      box { -5*cm, <1.55*m, 5*cm, 1.55*m> }
      rotate -90*x
      scale <1, 1/1.5, 1>
      translate <-1.5, 4, 0>*m
    }
    /*sphere {
      0, 40*cm
      scale <1, 0.2, 0.5>
      translate <-1.5, 5.05-0.2*0.4, 0>*m
    }*/
    intersection {
      cylinder { -y*m, y*m, 1*m translate -10*cm*x+85*cm*z }
      cylinder { -y*m, y*m, 1*m translate -10*cm*x-85*cm*z }
      cylinder { -y*m, y*m, 40*cm translate 0*cm*x }
      sphere { -2.92*m*y, 3*m scale <1, 1, 0.3> translate -10*cm*x }
      box { -<41, 6, 16>*cm, <40, 8, 16>*cm }
      bounded_by { box { -<40, 6, 15>*cm, <40, 8, 15>*cm } }
      translate <-1.5, 5.05-0.2*0.4, 0>*m
    }
    //pigment { color rgb 0.8 }   
    texture { TStreetLamp }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    background { color bwcol (Blue/2+White/2) }
    camera {
      location <0, 0, -15>*m
      look_at  <0, 0, 0>*m
      angle 40
      //rotate 90*y
      //rotate 89*x
      //translate <-1.5, 5, 0>*m
      translate 2*y*m
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, 1000>*m
      color rgb 1/4
    }
    plane {
      y, 0
      pigment { color rgb <0, 1, 0> }
    }
    object {
      StreetLamp
    }
  #end
#end

#include "leave"
