// Globals and General Includes

global_settings { ambient_light <1.65,1.65,1.65> }
#include "colors.inc"
#include "textures.inc"

// galaxy general options
#declare galaxy_seed = 14121998; 
#declare galaxy_distance = 10000;
#declare galaxy_colour1 = <0.4, 0.3, 0.4>;
#declare galaxy_colour2 = <0.3, 0.2, 0.3>;
#declare galaxy_colour3 = <0.1, 0.0, 0.1>;
#declare galaxy_rotate = <-15,-35,0>;

//bg options
#declare galaxy_bgstars = false;
#declare galaxy_bgnebula = 4;

// sf options
#declare galaxy_starfield = true;
#declare star_count = 5000;
#declare star_type = 2;
#declare star_scale = 0.25;

// Materials

//start of shelltextures
#declare texscale = 0.1;

#declare nor1  = normal{bozo -2 scale 1 turbulence 0.25}
#declare nor1b = normal{bozo -1 scale 1 turbulence 0.25}
#declare nor2  = normal{granite 3 scale 0.01 turbulence 0.25}

#declare tex1 =
texture{
  pigment{
    granite scale 0.01 turbulence 0.25
    pigment_map{
      [0 rgbf <0.20, 0.20, 0.30>]
      [1 rgbf <0.30, 0.15, 0.10, 0.20>]
    }
  }
  finish {
    ambient 0.4
    diffuse 0.7
    specular 0.3
    roughness 0.1
  }
}

#declare tex1b =
texture{
  pigment{
    average scale 0.01 turbulence 0.25
    pigment_map{
      [rgbf <0.20, 0.20, 0.30>]
      [rgbf <0.30, 0.15, 0.10, 0.20>]
    }
  }
  finish {
    ambient 0.5
    diffuse 0.7
  }
}

#declare tex2 =
texture{
  pigment { rgb <0.35, 0.25, 0.25> }
  finish {
    ambient 0.4
    diffuse 0.7
  }
}

#declare shellTexture =
texture{
  wrinkles scale texscale turbulence 0.25
  texture_map{
    [0.0 tex1 normal{nor1}]
    [0.3 tex1 normal{nor1}]
    [1.0 tex2 normal{nor2}]
  }
}
// end of shelltextures


#declare I_Glass =
interior {ior 1.5 caustics 0.5}
  
#declare F_Glass1 =
finish {
  specular 1
  roughness 0.001
  ambient 0
  diffuse 0
  reflection 0.10 // was 0.05
}   

#declare T_Glass1 =
texture {
  pigment { color rgbf<1.0, 1.0, 1.0, 0.9> } //f was 0.97
  finish  { F_Glass1 }
}

// Grass materials
#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;

// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =
pigment{
  spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =
pigment{
  spotted
  color_map {
    [0 color Tan*0.3]
    [0.6 color Tan*0.3]
    [0.6 color Green1*0.4]
    [1   color Green1*0.4]
  }
}

#declare pigGreen=pigment{Green2*1.3}

#declare txtGrass=
texture {                  
  pigment {
    gradient y
    turbulence 0.2
    pigment_map {                                
      [0.0 pigEarth]
      [0.3 pigGreen]
      [0.9 pigSpotted]
      [1.00 pigEarth]
    }
  }
  finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
  scale <0.001,1,0.001>
}

// Objects

// desert
#if (doDesert)
  #declare Desert =
  height_field{
    png
    "dmap.png"
    #if (!QuickDesert)
      smooth
    #end
    scale <1000.0, 25.0, 1000.0>
  }

  #declare Hollow =
  sphere{<0, 0, 0> 0.5101}
#end

//globe glass
#if (doGlobe)
  #declare GlobeGlass =
  difference{
    sphere{<0, 0, 0> 0.50}
    sphere{<0, 0, 0> 0.4801}
    interior{ I_Glass}
    texture{T_Glass1}
  }
#end

// Grass
# if (doGrass)
  #if (!QuickGrass)
    #include "mgrass.inc"
    // Common parameters
    // Patch
    #declare lPatch=0.05;               // size of patch
    #declare nBlade=5;                // number of blades per line (there will be nBlade x nBlade blades)
    #declare lBlade = 0.05;             // length of blade
    #declare wBlade = 0.004;            // width of blade at start
    #declare wBladeEnd = 0.0015;         // width of blade at the end
    #declare stdposBlade = .005;         // standard deviation of blade position 0..1
    // Prairie
    #declare nxPrairie=24;             // number of patches for the first line
    #declare addPatches=0;            // number of patches to add at each line
    #declare nzPrairie=24;             // number of lines of patches
    
    // --------------------------------------
    // Create the patch and the prairie
    // --------------------------------------
    
    #if (dofile=true) // if the patch is already created, turn off the next line
      MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
    #end        
    #declare objectPatch=object{#include fname}
  #end
  
  #declare GlobeLawn =
  object{
    #if (QuickGrass)
      box
      {
        <-0.6, -0.2, -0.6>  // one corner position <X1 Y1 Z1>
        < 0.6, -0.3, 0.6>  // other corner position <X2 Y2 Z2>
        texture{txtGrass scale 0.1}
      }
    #else
      object
      {
        MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
        texture{txtGrass scale 0.1}
        scale <1, 0.5, 1>
        translate <0, -0.2, -0.6>
      }
    #end
    #if (clipGrass)
      clipped_by{
        sphere{
          <0, 0, 0>
          0.48
        }
      }
    #end
  }
#end

// Earth
#declare GlobeEarth =
intersection{
  box{
    <-1, -1, -1>
    <1 ,-0.2, 1>
  }
  sphere{
    <0, 0, 0>
    0.48  
  }
  pigment{rgb<0.25, 0.15, 0.0>}
}

// Globe Shell

//inner shell sections

#declare twoshells =
difference{
  difference{sphere{<0,0,0>, 0.51} sphere{<0,0,0>, 0.5001}}
  box{<-1,-0.20,-1>,<1,0.30,1>}
}

//triangular, lower seg

#declare trialeft =
difference{
  difference{
    difference{sphere{<0,0,0>, 0.5102 scale <1.1,1,1.1>} sphere{<0,0,0>, 0.5101}} // whole shell
    box{<-1,-2.00,-1>,<1,0.30,1>} // remove lower half
  }
  box{<0,-2,-2>,<2,2,2>}
  box{<-2,-2,0>,<2,2,2> rotate <0,45,0>}

  difference{
    box{<0,-2,-2>,<2,2,2>}
    cylinder{-2*y,  2*y,  0.25}
    rotate <0,65,0>
  }    
  rotate <0,-25,0>
}


#declare triaright =
difference{
  difference{
    difference{sphere{<0,0,0>, 0.5102 scale <1.1,1,1.1>} sphere{<0,0,0>, 0.5101}} // whole shell
    box{<-1,-2.00,-1>,<1,0.30,1>} // remove lower half
  }
  box{<0,-2,-2>,<2,2,2>}
  box{<-2,-2,0>,<2,2,2> rotate <0,45,0>}

  difference{
    cylinder{-2*y,  2*y,  0.25}
    box{<0,-2,-2>,<2,2,2>}
    rotate <0,100,0>
  }
  rotate <0,160,0>    
}
//central cylinder
#declare centre =
  sphere{
    0.50*y, 0.03
    scale<5,1,5>
  }

//inner light

// create a regular point light source
#declare globelight =
light_source
{
  0*x // light's position (translated below)
  color rgb<2.95, 2.95, 2.50>  // light's color
  spotlight
  point_at <0,-0.55,0>
  radius 32
  falloff 65
  tightness 4
  fade_distance 2.5
  fade_power 1
  translate <0, 0.46, 0>
}

#declare globePlaque =
union{
  cylinder
  {
    <-2.00,0.00,0.00>,  <-1.75,0.00,0.00>,  1
    scale <1,1.5,0.75>
  }
  
  cylinder
  {
    <2.00,0.00,0.00>,  <1.75,0.00,0.00>,  1
    scale <1,1.5,0.75>
  }
  box
  {
    <-1.90, -0.90, -0.20>  // one corner position <X1 Y1 Z1>
    < 1.90,  0.90,  0.50>  // other corner position <X2 Y2 Z2>
    texture{tex1b normal{nor1b}}
  }

   light_source{
    <0,0,0>                     // light's position (translated below)
    color rgb <4,4,4>       // light's color
    spotlight               // this kind of light source
    translate <1.65,0.00,-0.50> // <x y z> position of light
    point_at <1, 0, 0>      // direction of spotlight
    radius 45                // hotspot (inner, in degrees)
    tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 55               // intensity falloff radius (outer, in degrees)
    looks_like {
      sphere{
        0*x, 0.1
        pigment{color rgb <2,2,1>}
        finish{ambient 1}
      }
    }
  }

   light_source{
    <0,0,0>                     // light's position (translated below)
    color rgb <4,4,4>       // light's color
    spotlight               // this kind of light source
    translate <-1.65,0.00,-0.50> // <x y z> position of light
    point_at <-1, 0, 0>      // direction of spotlight
    radius 45                // hotspot (inner, in degrees)
    tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 55               // intensity falloff radius (outer, in degrees)
    looks_like {
      sphere{
        0*x, 0.1
        pigment{color rgb <2,2,1>}
        finish{ambient 1}
      }
    }
  }
    
  text
  {
    ttf             // font type (only TrueType format for now)
    "engravd.ttf",  // Microsoft Windows-format TrueType font file name
    "MARTHA",      // the string to create
    0.5,              // the extrusion depth
    0               // inter-character spacing
    scale 0.50
    translate <-1.25, 0.05, -0.21>
    pigment {color rgb <0,0,0>}
  }
  
  text
  {
    ttf             // font type (only TrueType format for now)
    "engravd.ttf",  // Microsoft Windows-format TrueType font file name
    "In Eternal Memory",      // the string to create
    0.5,              // the extrusion depth
    0               // inter-character spacing
    scale 0.25
    translate <-1.55, -0.35, -0.21>
    pigment {color rgb <0,0,0>}
  }
  scale 0.05
}

#declare GlobeShell = 
union{
  object{twoshells}
  object{trialeft}  
  object{triaright}  
  object{centre}  
  object{globelight}
  object{globePlaque translate <0.0,0.0,-0.51> rotate <50,-15,0>}
  texture{shellTexture}
}

#if (doSpace)
  #include "GALAXY.BG" 
  #include "GALAXY.SF" 
#end