// Entry for IRTC "Gardens"
// copywrite: Tom Melly 1999
// I agree to submit to the IRTC rules

#declare globeCenter  = <1.25, 0.45, -1.50>;

#declare dofile       = false; // true creates a mesh file

#declare QuickDesert  = false; //false;
#declare QuickGrass   = false; //false;
#declare QuickBush    = false; //false;

#declare clipGrass    = true;  //true;

#declare doDesert     = true;  //true;
#declare doSpace      = true;  //true;
#declare doGlobe      = true;  //true;
#declare doShell      = true;  //true;
#declare doGrass      = true;  //true;
#declare doBush       = true;  //true;

#include "lastgard.inc"

camera{
  location <1.75, 1.50, -4.00>
  look_at  <-0.75, 0.50,  0.25>
}

light_source
{
  <0,0,0>
  color rgb <0.40,0.40,0.40>
  translate <-400.0, 300.0, -100.0>
}

// Main Scene

// desert
#if (doDesert)
  // mountains
  object {Desert
    scale <3,10,1>
    translate <-2000,-90,1000>
    texture{
      pigment{rgb<0.9,0.9,1.3>}
      finish{ambient 0.10 diffuse 0.85}
      
    }
  }

  // plain
  difference{
    object {Desert translate <-500,-9.0,-100>}
    object {Hollow translate globeCenter} // scoop out for globe
    texture{
      normal {bumps 0.1 scale 0.2}
      pigment{rgb<0.9,0.9,1.3>}
      finish{ambient 0.10 diffuse 0.85}
    }
  }
#end


// full globe
union{
  // globe
  #if (doGlobe)
    object {GlobeGlass}
  #end
  
  // grass and earth
  #if (doGrass)
    object {GlobeLawn}
    object {GlobeEarth}
  #end

  //bush
  #if (doBush)
    #declare BLOSSOM_COLOR=<0.7,0.0,0.3>;//Color of blossom
    #declare BRANCH_GAME=1917.3797;
    #include "makebush.inc"
    #declare GlobeBush = object{TREE scale 0.2}
    object {GlobeBush translate <-0.25,-0.2,0>}

    #declare BLOSSOM_COLOR=<0.5,0.5,0.0>;//Color of blossom
    #declare BRANCH_GAME=1762.3797;
    #include "makebush.inc"
    #declare GlobeBush = object{TREE scale 0.2}
    object {GlobeBush translate <0.25,-0.2,0>}

    #declare BLOSSOM_COLOR=<0.5,0.0,0.5>;//Color of blossom
    #declare BRANCH_GAME=1999.3797;
    #include "makebush.inc"
    #declare GlobeBush = object{TREE scale 0.2}
    object {GlobeBush translate <0.0,-0.2,-0.25>}

    #declare BLOSSOM_COLOR=<0.3,0.0,0.7>;//Color of blossom
    #declare BRANCH_GAME=1803.3797;
    #include "makebush.inc"
    #declare GlobeBush = object{TREE scale 0.2}
    object {GlobeBush translate <0,-0.2,0.25>}

    #declare BLOSSOM_COLOR=<0.7,0.0,0.0>;//Color of blossom
    #declare BRANCH_GAME=2104.3797;
    #include "makebush.inc"
    #declare GlobeBush = object{TREE scale <0.2, 0.35, 0.2>}
    object {GlobeBush translate <0,-0.2,0>}

  #end

  // shell
  #if (doShell)
    object{GlobeShell}
  #end
  
  rotate <-5, 25, -15>
  translate globeCenter
}
