global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc" 
#include "glass.inc"


camera {
  location <0, 50, -120>
  right <4/3, 0, 0>
  up <0, 1, 0> 
  direction 0.8
  sky <0, 1, 0>
  look_at <0, 15, 30>
}

light_source { <50, 200, -100> colour Gray70 }
light_source { <-80, 160, -80> colour Gray70 }
light_source { <100, 80, -200> colour Gray70 }

background { color SlateBlue }

plane { y, 0 
        pigment{color Gray}
   normal{crackle 0.5 turbulence 0.5}

}


#declare petal1 =
polygon
{7,<-0.5, 0>, <-1.5, 5>, <-0.6, 7>, <0.6, 7>, <1.5, 5>, <0.5, 0>, <-0.5, 0>}

//Flower #1 -- sunflower

#declare petalcount = 0
#while (petalcount < 18)
  object
  {petal1 scale <0.7, 2, 1> rotate -5*x rotate petalcount*20*z+2 translate 35*y
   pigment {color Yellow}}
 
  #declare petalcount = petalcount+1
#end       

#declare petalcount = 0
#while (petalcount < 18)
  object
  {petal1 scale <0.7, 2, 1> rotate -4*x rotate petalcount*20*z+12 translate 35*y
   pigment {color Yellow}}
  #declare petalcount = petalcount+1
#end   
              
//center of flower1
#declare center1 = intersection { 

sphere{ <0, 0, 98.2>  100  }
cone{<0, 0, 0>,  0.0, <0, 0, 3*tan(40)>, 3.0}  
scale 3.5
} 

object {center1 pigment {color Brown} normal {spiral2 5 scale 4} translate 35*y }


//stem of flower1
union {cylinder {<0, 0, 0>, <0, 25, 0>, 0.6}
 cone {<0, 25, 0>, 0.6, <0, 35, 0>, 0}
 pigment {color DarkGreen}}

//leaf of flower1

polygon {7, <0, 0>, <-3, 3>, <-1, 7>, <0.5, 9>, <2, 6.5>, <3, 3>, <0, 0> scale 1.7
 pigment {color DarkGreen}
 rotate 85*z translate <0, 17, 0>}

//smaller 5-petaled flower
#declare flower2 = union {

object {petal1 rotate -5*x rotate 0*z}
object {petal1 rotate -5*x rotate 72*z}
object {petal1 rotate -5*x rotate 144*z}
object {petal1 rotate -5*x rotate 216*z}
object {petal1 rotate -5*x rotate 298*z}

}  

object {flower2 pigment { color Red } scale 1.2 rotate <15, 0, 5>  translate <5, 8, 15> } 
object {flower2 pigment { color Blue } rotate <45, -25, -15>  translate <15, 10, 4>} 
object {flower2 pigment { color Blue } rotate <20, 20, 20>  translate <3, 10, -14>}
object {flower2 pigment { color Orange } rotate <15, 0, 12>  translate <10, 8, -20> } 
object {flower2 pigment { color Red } scale 0.9 rotate <40, 25, 20>  translate <-12, 10, -12>}
object {flower2 pigment { color Magenta } rotate <25, 0, 7>  translate <-8, 8, 9> }  
  
//stems for various flower2's
union {cylinder{<5, 0, 15>,  <5, 6, 15>, 0.4} cone{<5, 8, 15>, 0, <5, 6, 15>, 0.4}
 pigment {color Green}} 
union {cylinder{<15, 0, 4>,  <15, 8, 4>,  0.4} cone{<15, 10, 4>, 0, <15, 8, 4>, 0.4}
 pigment {color Green}}
union {cylinder{<3, 0, -14>,  <3, 8, -14>,  0.4} cone{<3, 10, -14>, 0, <3, 8, -14>, 0.4}
 pigment {color Green}}
union {cylinder{<10, 0, -20>,  <10, 6, -20>,  0.4} cone{<10, 8, -20>, 0, <10, 6, -20>, 0.4}
 pigment {color Green}}
union {cylinder{<-12, 0, -12>,  <-12, 8, -12>,  0.4} cone{<-12, 10, -12>, 0, <-12, 8, -12>, 0.4}
 pigment {color Green}}
union {cylinder{<-8, 0, 9>,  <-8, 6, 9>,  0.4} cone{<-8, 8, 9>, 0, <-8, 6, 9>, 0.4}
 pigment {color Green}}

//centers of flowers
sphere{<5, 8, 15> 0.7 pigment {color Yellow}}  
sphere{<15, 10, 4> 0.7 pigment {color Yellow}}
sphere{<3, 10, -14> 0.7 pigment {color Yellow}}
sphere{<10, 8, -20> 0.7 pigment {color Yellow}}
sphere{<-12, 10, -12> 0.7 pigment {color Yellow}}
sphere{<-8, 8, 9> 0.7 pigment {color Yellow}}

difference {
cylinder {<0, 0, 0>, <0, 2.5, 0>, 33}      
cylinder {<0, -0.2, 0>, <0, 2.7, 0>, 28} 
pigment {color SpringGreen}
}  

#declare glasstex = texture { T_Glass3 }

cylinder {<0, 0, 0>, <0, 0.01, 0>, 7 
   pigment {hexagon color DarkTan color NewTan color Green} scale 4 finish {ambient 0.2 diffuse 0.8}}
   
difference {
sphere {<0, 0, 0>, 28 }
sphere {<0, 0, 0>, 27.9}

scale <1, 2, 1> texture{glasstex} interior{I_Glass}}